let mix = require('laravel-mix')

/*
 |--------------------------------------------------------------------------
 | Mix Asset Management
 |--------------------------------------------------------------------------
 |
 | Mix provides a clean, fluent API for defining some Webpack build steps
 | for your Laravel application. By default, we are compiling the Sass
 | file for the application as well as bundling up all the JS files.
 |
 */

mix
  .js('resources/assets/js/app.js', 'public/js')
  .sass('resources/assets/sass/app.scss', 'public/css')

mix.styles(
  [
    'public/css/plugins/pace/pace-theme-flash.css',
    'public/css/bootstrap.min.css',
    'public/css/plugins/select2/select2.min.css',
    'public/css/plugins/datapicker/datepicker3.css',
    'public/css/animate.css',
    'public/css/style.css',
    'public/css/plugins/iCheck/custom.css',
    'public/css/plugins/jasny/jasny-bootstrap.min.css',
    'public/css/plugins/dataTables/datatables.min.css',
    'public/css/plugins/morris/morris-0.4.3.min.css'
  ],
  'public/css/all.css'
)

mix.scripts(
  [
    'public/js/plugins/pace/pace.min.js',
    'public/js/jquery-3.1.1.min.js',
    'public/js/bootstrap.min.js',
    'public/js/plugins/slimscroll/jquery.slimscroll.min.js',
    'public/js/plugins/sparkline/jquery.sparkline.min.js',
    'public/js/script.js',
    'public/js/plugins/pwstrength/pwstrength-bootstrap.min.js',
    'public/js/plugins/pwstrength/zxcvbn.js',
    'public/js/plugins/datepicker/bootstrap-datepicker.js',
    'public/js/plugins/select2/select2.full.min.js',
    'public/js/plugins/footable/footable.all.min.js',
    'public/js/plugins/iCheck/icheck.min.js',
    'public/js/plugins/jasny/jasny-bootstrap.min.js',
    'public/js/plugins/cookie/jquery.cookie.min.js'
  ],
  'public/js/all.js'
)
