<?php

namespace Tests\Unit;

use Tests\TestCase;
use App\Services\Integrations\Tickets\Zendesk\ZendeskIntegration;

/**
 * @test
 * @cover \App\Services\Integrations\Tickets\Zendesk\ZendeskIntegration
 */
class ZendeskIntegrationTest extends TestCase
{

    public function setUp(): void
    {
        parent::setUp();
        $this->service =  new ZendeskIntegration();
    }

    public function tearDown(): void
    {
        parent::tearDown();
    }

    /**
     * @test
     * @cover \App\Services\Integrations\Zendesk\ZendeskIntegration::createTicket()
     */
    public function test_create_ticket()
    {
        $ticketData = [
            'description' => 'Test Case Description',
            'summary' => 'Test Case Summary',
        ];

        $result = $this->service->createTicket($ticketData);
        // dd($result);
        $this->assertIsArray($result);
    }

    /**
     * @test
     * @cover \App\Services\Integrations\Zendesk\ZendeskIntegration::getTicket()
     */
    public function test_get_ticket()
    {
        $requestId = 6;

        $result = $this->service->getTicket($requestId);
        // dd($result);

        $this->assertIsArray($result);
    }

    /**
     * @test
     * @cover \App\Services\Integrations\Zendesk\ZendeskIntegration::addCommentToTicket()
     */
    public function test_add_message_to_ticket()
    {
        $requestId = 7;
        $message = 'Test **message** with testing';
        $userId = 123;

        $result = $this->service->addCommentToTicket($requestId, $message, $userId);
        // dd($result);
        $this->assertTrue($result);
    }


    /**
     * @test
     * @cover \App\Services\Integrations\Zendesk\ZendeskIntegration::addCommentToTicket()
     */
    public function test_add_attachment_to_ticket()
    {
        $requestId = 16;
        $message = 'Test message with testing';
        $userId = 123;
        $attachmentFile = '/home/user/Documents/to-do.txt';

        $result = $this->service->addAttachmentToTicket($requestId, $message, $userId, $attachmentFile, 'file.txt');
        // dd($result);
        $this->assertNotNull($result);
    }
}
