<?php

namespace Tests\Unit;

use Tests\TestCase;
use Illuminate\Foundation\Testing\WithFaker;
use Illuminate\Foundation\Testing\RefreshDatabase;
use App\Models\ApiCredential;
use App\Services\Integrations\Tickets\Jira\JiraIntegration;
use Facades\App\Services\Integrations\Tickets\Jira\OAuthWrapper;
use Facades\App\Services\JiraService;
use App\User;
use Facades\App\Services\JiraClosedTicketHistoryService;

class JiraTest extends TestCase
{

    public function setUp(): void
    {
        parent::setUp();
        $this->service =  new JiraIntegration();
    }

    public function tearDown(): void
    {
        parent::tearDown();
    }


    /**
     * Update the assignee of Jira issue
     */
    /** @test */
    public function it_can_update_assignee()
    {
        $jiraCredential = ApiCredential::where('slug', 'jira')->first();
        $jiraToken = [
            'oauth_token' => $jiraCredential->project,
            'oauth_token_secret' => $jiraCredential->key
        ];
        $updateAssignee = OAuthWrapper::updateIssueAssignee($jiraToken, 'TEQ-31', 'Teqtivity');
        $this->assertEquals(1, $updateAssignee);
    }

    /**
     * Take the current issue status
     */
    /** @test */
    public function get_current_issue_status()
    {
        $jiraCredential = ApiCredential::where('slug', 'jira')->first();
        $jiraToken = [
            'oauth_token' => $jiraCredential->project,
            'oauth_token_secret' => $jiraCredential->key
        ];
        $respose = OAuthWrapper::getIssueCurrentStatus($jiraToken, 'TEQ-23');
        // print_r($respose);
        $this->assertTrue(true);
    }

    /**
     * Take the issue by using Users Email
     */
    /** @test */
    public function check_issue_by_user_email_and_component()
    {
        $issueDetails = JiraService::getIssueByUserEmailAndComponent('rcottesfoxrd1@microsoft.com');
        // print_r($issueDetails);
        // die;
        $issueCount = $issueDetails['issues'] ? 1 : 0;
        $this->assertEquals(1, $issueCount);
    }


    /**
     * @test
     * @cover \App\Services\Integrations\Jira\JiraIntegration::createTicket()
     */
    public function test_create_ticket()
    {
        $ticketData = [
            'description' => 'Test Case Description',
            'summary' => 'Test Case Summary',
        ];


        // $ticketInegrationClassName = config('ticket-integration.service', null);
        // $htmlEntityStart = config('ticket-integration.' . $ticketInegrationClassName . '.html_entity_start') ?? '';
        // $htmlEntityEnd = config('ticket-integration.' . $ticketInegrationClassName . '.html_entity_end') ?? '';

        // $lineBreak = PHP_EOL;
        // $boldStart = config('ticket-integration.' . $ticketInegrationClassName . '.bold_text_start') ?? '*';
        // $boldEnd = config('ticket-integration.' . $ticketInegrationClassName . '.bold_text_end') ?? '*';
        // $ticketData = [
        //     'description' => $htmlEntityStart . $boldStart . "User :" . $boldEnd . ":username - :useremail" . $lineBreak . $boldStart . "Work Location :" . $boldEnd . ":location" . $lineBreak . $boldStart . "Termination Date :" . $boldEnd . ":date" . $lineBreak . $boldStart . "Assets to Collect :" . $boldEnd . $lineBreak . "Serial # - Asset Tag # - Hardware Standard - Tech Specs" . $lineBreak . " :assets" . $htmlEntityEnd,
        //     'summary' => 'Test Case Summary',
        // ];
        $result = $this->service->createTicket($ticketData);
        // dd($result);
        $this->assertIsArray($result);
    }

    /**
     * @test
     * @cover \App\Services\Integrations\Jira\JiraIntegration::getTicket()
     */
    public function test_get_ticket()
    {
        $requestId = 'TEQ-28';

        $result = $this->service->getTicket($requestId);

        $this->assertIsArray($result);
    }

    /**
     * @test
     * @cover \App\Services\Integrations\Jira\JiraIntegration::addCommentToTicket()
     */
    public function test_add_message_to_ticket()
    {
        $lineBreak = '\\n';
        $requestId = 'TEQ-2';
        $message = "Test message with " . $lineBreak . " testing";
        $userId = 123;

        $result = $this->service->addCommentToTicket($requestId, $message, $userId);
        // dd($result);
        $this->assertTrue($result);
    }


    /**
     * @test
     * @cover \App\Services\Integrations\Jira\JiraIntegration::addCommentToTicket()
     */
    public function test_add_attachment_to_ticket()
    {
        $requestId = 'TEQ-2';
        $message = 'Test message with testing attachment';
        $userId = 123;
        $file = '/home/user/Documents/EOD2022/AugustToday.txt';

        $result = $this->service->addAttachmentToTicket($requestId, $message, $userId, $file, 'AugustToday.txt');
        // dd($result);
        $this->assertTrue($result);
    }
}
