<?php

namespace Tests\Unit;

use Tests\TestCase;
use App\Services\Integrations\Tickets\FreshService\FreshServiceIntegration;

/**
 * @test
 * @cover \App\Services\Integrations\Tickets\FreshService\FreshServiceIntegration
 */
class FreshServiceIntegrationTest extends TestCase
{

    public function setUp(): void
    {
        parent::setUp();
        $this->service =  new FreshServiceIntegration();
    }

    public function tearDown(): void
    {
        parent::tearDown();
    }

    /**
     * @test
     * @cover \App\Services\Integrations\FreshService\FreshServiceIntegration::createTicket()
     */
    public function test_create_ticket()
    {
        $ticketData = [
            'description' => 'Test Case Description',
            'summary' => 'Test Case Summary',
            'attachments' => '/home/user/Pictures/termimg.png'
        ];

        $result = $this->service->createTicket($ticketData);

        $this->assertIsBool($result);
    }

    /**
     * @test
     * @cover \App\Services\Integrations\FreshService\FreshServiceIntegration::getTicket()
     */
    public function test_get_ticket()
    {
        $requestId = 4;

        $result = $this->service->getTicket($requestId);
        $this->assertIsBool($result);
    }

    /**
     * @test
     * @cover \App\Services\Integrations\FreshService\FreshServiceIntegration::addCommentToTicket()
     */
    public function test_add_message_to_ticket()
    {
        $requestId = 4;
        $message = 'Test message with testing';
        $userId = 123;

        $result = $this->service->addCommentToTicket($requestId, $message, $userId);

        $this->assertEmpty($result);
    }

    public function test_add_attachemnt_to_ticket()
    {
        $requestId = 4;
        $message = 'Test message with test';
        $userId = 123;
        $result = $this->service->addAttachmentToTicket($requestId, $message, $userId, '/home/user/Documents/AugustToday.txt', 'Newfile.txt');

        $this->assertIsBool($result);
    }
}
