<?php

namespace Tests\Feature;

use App\Models\Location;
use App\Rules\StorageLocation;
use Database\Seeders\DatabaseSeeder;
use Illuminate\Foundation\Testing\RefreshDatabase;
use Illuminate\Foundation\Testing\WithFaker;
use Tests\TestCase;

class LocationRuleTest extends TestCase
{

    /** @test */
    public function it_passes_when_location_is_storage()
    {
        // Arrange
        $location = Location::find(1);

        $rule = new StorageLocation(1); // Replace 1 with the appropriate count

        // Act
        $result = $this->app['validator']->make(
            ['location_id' => $location->id],
            ['location_id' => $rule]
        )->passes();

        // Assert
        $this->assertTrue($result);
    }

    /** @test */
    public function it_fails_when_location_is_not_storage()
    {
        // Arrange
        $location = Location::find(1);

        $rule = new StorageLocation(1); // Replace 1 with the appropriate count

        // Act
        $result = $this->app['validator']->make(
            ['location' => $location->id],
            ['location' => $rule]
        )->passes();

        // Assert
        $this->assertFalse($result);
    }
}
