<script>
$(document).ready(function(){
	$("#asset_type").change(function(){
		filterHardwareStandards();
		filterTechnicalSpecs();
	});

	$("#manufacturer").change(function() {
		filterHardwareStandards();
		filterTechnicalSpecs();
	});

	$("#make_and_model").change(function(){
		filterTechnicalSpecs();
	});
});

function filterHardwareStandards()
{
	if ($('#make_and_model').val() != undefined) {
		$.ajax({
			type: "POST",
			data: {
				asset_type: ($('#asset_type').val() == undefined) ? '' : $('#asset_type').val(),
				manufacturer: ($('#manufacturer').val() == undefined) ? '' : $('#manufacturer').val(),
			},
			url: "<?php echo e(route('filter-field.get-hardware-standards')); ?>",
			success: function(data) {
				$('#make_and_model').empty();
				$("#make_and_model").select2();
				$.each(data,function (key,value) {
					$('#make_and_model').append($('<option>', {
						value: value.id,
						text:  value.name
					}));
				});
				$("#make_and_model").trigger('change');
			},
		});
	}
}

function filterTechnicalSpecs()
{
	if ($('#technical_spec').val() != undefined) {
		$.ajax({
			type: "POST",
			data:{
				asset_type: ($('#asset_type').val() == undefined) ? '' : $('#asset_type').val(),
				manufacturer: ($('#manufacturer').val() == undefined) ? '' : $('#manufacturer').val(),
				make_and_model:($("#make_and_model").val() == undefined) ? '' : $("#make_and_model").val(),
			},
			url: "<?php echo e(route('filter-field.get-technical-specs')); ?>",
			success: function(data) {
				$('#technical_spec').empty();
				$("#technical_spec").select2();
				$.each(data,function (key,value) {
					$('#technical_spec').append($('<option>', {
						value: value.id,
						text: value.name
					}));
				});
				$("#technical_spec").trigger('change');
			},
		});
	}
}
</script><?php /**PATH /var/www/html/nebius/resources/views/reports/scripts/filter-options-with-ajax.blade.php ENDPATH**/ ?>