<script>
  $(document).ready(function (){
    $('[data-role="ui-data-table"]').each(function() {
      _bindDataTable( $(this) );
    });

    function _bindDataTable( $table ) {
      var columns = [];
      var order = [];
      var length = $table.find('thead th').length;
      var def = $.Deferred();
      var pageLength = $table.data('page-size');
      var fixedHeaderColumns = $table.data('fixed-header-columns-left');
      var filterForm = $table.data('filter-form');

      pageLength = (pageLength == undefined) ? 10 : pageLength;
      fixedHeaderColumns = (fixedHeaderColumns == undefined) ? 0 : fixedHeaderColumns;
      filterForm = (filterForm == undefined) ? "#search-form" : filterForm;

      $table.find('thead th').each(function(index) {
        var _cname  = $(this).data('col-name');
        var _cwidth = $(this).data('col-width');
        var _cidx = parseInt(index);
        if ( typeof _cname == 'undefined' || _cname == '' ) {
          def.reject();

          return;
        } else {
          var _c = {'data': _cname};
          if ( typeof _cwidth !== 'undefined' ) {
            _c['width'] = _cwidth;
          }
          columns.push(_c);
        }
        if ( length == (_cidx+1)) {
          def.resolve();
        }
      });

      if ( typeof $table.data('table-order') !== 'undefined' ) {
        var order = eval($table.data('table-order'));
      } else {
        order = [[ 0, 'asc' ]];
      }

      def.done(function() {
        window.dataTable = $table.DataTable( {
          fixedHeader:true,
          "scrollX": true,
          fixedColumns: {
            left: fixedHeaderColumns
          },
          processing: true,
          serverSide: true,
          bAutoWidth: false,
          ajax: {
            headers: { 'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')},
            url: $table.data('url'),
            type: 'POST',
            data: function(data) {
              data.form = $(filterForm).serializeObject();
            },
            error: function(reason) {
              if(reason.status == 419) {
                window.location.reload();
              }
            }
          },
          aLengthMenu: [
          [25, 50, 100,200],
          [25, 50, 100,200]
          ],
          iDisplayLength: pageLength,
          order: order,
          columns: columns,
          fnDrawCallback: function(oSettings) {
            if (oSettings._iRecordsDisplay == 0) {
              $("#export-csv").hide();
            } else {
              $("#export-csv").show();
            }
          }
        });
      });
    };

    // Data table filter submit
    $('body').on('submit', '#search-form', function(e) {
      e.preventDefault();
      window.dataTable.draw();
    });

    // Data table column toggle
    $(document).on('click', 'span.col-toggle', function (e) {
      e.preventDefault();
      $(this).toggleClass('col-hidden');
      // Get the column API object
      var column = window.dataTable.column($(this).attr('data-column'));

      // Toggle the visibility
      column.visible(!column.visible());
    });

    // Export to CSV
    $('#export-csv').on('click', function (e) {
      e.preventDefault();
      var pageUrl = $(this).data('url');
      var fileName = $(this).data('file-name');
      var form = $(this).data('filter-form');

      form = (form == undefined) ? "#search-form" : form;
      fileName = (fileName == undefined) ? 'report' : fileName;

      $('.ajax-loader').show();
      $.ajax({
        type: "POST",
        url: pageUrl,
        data: $(form).serializeObject(),
        dataType: 'text',
        success: function (result) {
          var blob = new Blob([result]);
          if (window.navigator.msSaveOrOpenBlob)  // IE hack; see http://msdn.microsoft.com/en-us/library/ie/hh779016.aspx
          window.navigator.msSaveBlob(blob, fileName + ".csv");
          else {
            var a = window.document.createElement("a");
            a.href = window.URL.createObjectURL(blob, { type: "text/plain" });
            a.download = fileName + ".csv";
            document.body.appendChild(a);
            a.click();  // IE: "Access is denied"; see: https://connect.microsoft.com/IE/feedback/details/797361/ie-10-treats-blob-url-as-cross-origin-and-denies-access
            document.body.removeChild(a);
          }
          $('.ajax-loader').hide();
        }
      })
    });
  });
</script><?php /**PATH /var/www/html/nebius/resources/views/reports/scripts/datatable.blade.php ENDPATH**/ ?>