<div id="sidebar-wrapper" class="active">
<ul class="sidebar-header">
<li>
    <img src="/img/logo.webp" alt="logo" height="25">
</li>
<li>
    <a id="menu-toggle" class="hamburger" href="#">
        <i class="icon icon-menu-8 icon-lg"></i>
    </a>
</li>
</ul>

<ul class="sidebar-nav" id="sidebar">
<?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('Dashboard View')): ?>
<li>
    <a href="/" data-tooltip="tooltip" data-placement="right" title="Dashboard">
        <i class="icon icon-f-dashboard icon-lg"></i> Dashboard
    </a>
</li>
<?php endif; ?>

<?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('Assets Health View')): ?>
    <li <?php if(count(array_intersect(["permission:Assets Health View"], Route::getCurrentRoute()->middleware()))): ?> class="active"
        <?php endif; ?>>
        <a href="/asset-health" data-tooltip="tooltip" data-placement="right" title="Asset Health">
            <i class="icon icon-bag-50 icon-lg"></i>Asset Health
        </a>
    </li>
<?php endif; ?>

<?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check(['IT Assets View'])): ?>
<li>
    <a href="/assets" data-tooltip="tooltip" data-placement="right" title="IT Assets">
        <i class="icon icon-laptop-1 icon-lg"></i> IT Assets
    </a>
</li>
<?php endif; ?>

<?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('AV Assets View')): ?>
<li><a href="<?php echo e(route('av-assets.index')); ?>" data-tooltip="tooltip" data-placement="right" title="AV Assets">AV Assets</a></li>
<?php endif; ?>

<?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('Mobile Assets View')): ?>
<li>
    <a href="<?php echo e(route('assets.mobile')); ?>" data-tooltip="tooltip" data-placement="right" title="Mobile Assets">
        <i class="icon icon-phone-camera-back icon-lg"></i> Mobile Assets</a>
    </li>
    <?php endif; ?>

    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('Software Assets View')): ?>
    <li>
        <a href="/software-assets" data-tooltip="tooltip" data-placement="right" title="Software Assets">
            <i class="icon icon-window-delete icon-lg"></i>Software Assets
        </a>
    </li>
    <?php endif; ?>

    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('Network Assets View')): ?>
    <li><a href="/search-network-assets" data-tooltip="tooltip" data-placement="right" title="Network Assets">Network Assets</a></li>
    <?php endif; ?>

    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('Cloud Assets View')): ?>
    <li <?php if(in_array(Route::getFacadeRoot()->current()->uri(), ['cloud-assets'])): ?> class="active" <?php endif; ?>>
        <a href="<?php echo e(route('cloud-assets.index')); ?>"><i class="icon icon-laptop-1"></i>Cloud Assets</a>
    </li>
    <?php endif; ?>

    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('Accessories View')): ?>
    <li>
        <a href="/accessories" data-tooltip="tooltip" data-placement="right" title="Accessories">
            <i class="icon icon-headphones-3 icon-lg"></i>Accessories
        </a>
    </li>
    <?php endif; ?>

    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('Research Assets View')): ?>
    <li><a href="/research-assets/search" data-tooltip="tooltip" data-placement="right" title="Research Assets">Research Assets</a></li>
    <?php endif; ?>

    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('Locations View')): ?>
    <li>
        <a href="/location" data-tooltip="tooltip" data-placement="right" title="Locations">
            <i class="icon icon-position-pin icon-lg"></i>Locations
        </a>
    </li>
    <?php endif; ?>

    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('People View')): ?>
    <li>
        <a href="/users" data-tooltip="tooltip" data-placement="right" title="Users">
            <i class="icon icon-contact-list icon-lg"></i>Users</a>
        </li>
        <?php endif; ?>

        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('New Hire')): ?>
        <li class="panel">
            <a href="#new-hire-collapse" class="dropdown" data-toggle="collapse" data-parent="#sidebar" data-tooltip="tooltip" data-placement="right" title="New Hire">
                <i class="icon icon-user-create icon-lg"></i> New Hire
                <span class="caret"></span>
            </a>
            <ul class="nav-sidemenu collapse" id="new-hire-collapse">
                <li><a href="/new-hire">New Hire</a></li>
                <li><a href="/new-hire/forecasting">Forecasting</a></li>
                
                <li><a href="<?php echo e(route('average-deployment-time')); ?>">Average Deployment Time</a></li>
            </ul>
        </li>
        <?php endif; ?>

        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('Terminations')): ?>
        <li class="panel">
            <a href="#terminations-collapse" class="dropdown" data-toggle="collapse" data-parent="#sidebar" data-tooltip="tooltip" data-placement="right" title="Terminations">
                <i class="icon icon-user-delete-line icon-lg"></i>Terminations
                <span class="caret"></span>
            </a>
            <ul class="nav-sidemenu collapse" id="terminations-collapse">
                <li><a href="/terms-report">Terminations Report</a></li>
                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('HR Collections Report')): ?>
                <li><a href="<?php echo e(route ('collection-statistics')); ?>">HR Collections Report</a></li>
                <?php endif; ?>
                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('Retriever Report')): ?>
                
                <?php endif; ?>
            </ul>
        </li>
        <?php endif; ?>

        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('Inventory Control View')): ?>
        <li class="panel">
            <a href="#inventory-control-collapse" class="dropdown" data-toggle="collapse" data-parent="#sidebar" data-tooltip="tooltip" data-placement="right" title="Inventory Control">
                <i class="icon icon-storage-unit icon-lg"></i>Inventory Control
                <span class="caret"></span>
            </a>
            <ul class="nav-sidemenu collapse" id="inventory-control-collapse">
                <li><a href="/inventory-control/in-stock-computers">In Stock Computers</a></li>
                <li><a href="/inventory-control/available-stock">Available Stock</a></li>
                <li><a href="<?php echo e(route('consumption-report.index')); ?>">Consumption Report</a></li>
                <li><a href="<?php echo e(route('users-to-asset-ratio')); ?>">Users to Asset Ratio</a></li>
                
                <li><a href="/inventory-control/fleet-age">Fleet Age</a></li>
                <li><a href="/inventory-control/cycle-count">Cycle Count</a></li>
                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('ASN - Assets View')): ?>
                
                
                
                <li><a href="/asn-presidio">ASN - Presidio</a></li>
                
                
                <?php endif; ?>
            </ul>
        </li>
        <?php endif; ?>

        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('Discovery Tools')): ?>
        <li class="panel">

            <a href="#discovery-tools-collapse" class="dropdown" data-toggle="collapse" data-parent="#sidebar" data-tooltip="tooltip" data-placement="right" title="Discovery Tools">
                <i class="icon icon-l-search icon-lg"></i> Discovery Tools
                <span class="caret"></span>
            </a>
            <ul id="discovery-tools-collapse" class="nav-sidemenu collapse">
                
                
                <li><a href="/discovery-tools/intune/all-report">Intune</a></li>
                
                
                
                
                <li><a href="/discovery-tools/zoom/all-report">Zoom</a></li>
            </ul>
        </li>
        <?php endif; ?>
        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('Security Tools View')): ?>
        <li class="panel">

            <a href="#security-collapse" class="dropdown" data-toggle="collapse" data-parent="#sidebar" data-tooltip="tooltip" data-placement="right" title="Security">
                <i class="icon icon-l-security icon-lg"></i> Security
                <span class="caret"></span>
            </a>
            <ul id="security-collapse" class="nav-sidemenu collapse">
                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('Crowdstrike Reports View')): ?>
                <li><a href="/crowdstrike/sensor-detection">Sensor Detection</a></li>
                <li><a href="/crowdstrike/sensor-vulnerabilities">Sensor Vulnerabilities</a></li>
                <li><a href="/crowdstrike/active-cves">Active CVEs</a></li>
                <?php endif; ?>
            </ul>
        </li>
        <?php endif; ?>



        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('Employee Landing Page')): ?>
        <li>
            <a href="/my-teq-assets" data-tooltip="tooltip" data-placement="right" title="My TeQ Assets">
                <i class="icon icon-user-check icon-lg"></i>My TeQ Assets
            </a>
        </li>
        <?php endif; ?>

        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('Reports View')): ?>
        <li>
            <a href="/report" data-tooltip="tooltip" data-placement="right" title="Reports">
                <i class="icon icon-folder-chart-pie icon-lg"></i>Reports
            </a>
        </li>
        <?php endif; ?>

        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('Report Generator View')): ?>
        <li>
            <a href="/report/generator" data-tooltip="tooltip" data-placement="right" title="Report Generator">
                <i class="icon icon-edit-curves icon-lg"></i>Report Generator
            </a>
        </li>
        <?php endif; ?>

    </ul>

</div>
<?php /**PATH /var/www/html/nebius/resources/views/partials/sidebar-nav.blade.php ENDPATH**/ ?>