<?php

use App\Http\Controllers\AccessoriesController;
use App\Http\Controllers\AdminLoginController;
use App\Http\Controllers\AdminUserController;
use App\Http\Controllers\FilterFieldController;
use App\Http\Controllers\ToolBox\ApiUserController;
use App\Http\Controllers\Asn\Cdw\CdwAccessoriesMappingController;
use App\Http\Controllers\Asn\Cdw\CdwAssetsController;
use App\Http\Controllers\Asn\Cdw\CdwHardwareMappingController;
use App\Http\Controllers\Asn\Cdw\CdwUnwantedPartsController;
use App\Http\Controllers\Asn\Connection\ConnectionAccessoriesMappingController;
use App\Http\Controllers\Asn\Connection\ConnectionAssetsController;
use App\Http\Controllers\Asn\Connection\ConnectionHardwareMappingController;
use App\Http\Controllers\Asn\Connection\ConnectionUnwantedPartsController;
use App\Http\Controllers\Asn\Insight\InsightAccessoriesMappingController;
use App\Http\Controllers\Asn\Insight\InsightHardwareMappingController;
use App\Http\Controllers\Asn\Insight\InsightAssetsController;
use App\Http\Controllers\Asn\Insight\InsightUnwantedPartsController;
use App\Http\Controllers\Asn\Presidio\PresidioAssetsController;
use App\Http\Controllers\Asn\Shi\ShiAccessoriesMappingController;
use App\Http\Controllers\Asn\Shi\ShiAssetsController;
use App\Http\Controllers\Asn\Shi\ShiHardwareMappingController;
use App\Http\Controllers\Asn\Shi\ShiUnwantedPartsController;
use App\Http\Controllers\Assets\AssetDetailsHistoryController;
use App\Http\Controllers\Assets\AssetTrackingController;
use App\Http\Controllers\Assets\CreateController;
use App\Http\Controllers\Assets\IndexController;
use App\Http\Controllers\Assets\LinkController;
use App\Http\Controllers\Assets\MoveController;
use App\Http\Controllers\Assets\ProdAssetController;
use App\Http\Controllers\Assets\ResearchAssetController;
use App\Http\Controllers\Assets\ReturnController;
use App\Http\Controllers\Assets\SearchAssetController;
use App\Http\Controllers\Assets\SearchController;
use App\Http\Controllers\Assets\Settings\AccessLevelsController;
use App\Http\Controllers\Assets\Settings\JiraCredentialsController;
use App\Http\Controllers\Assets\Settings\AssetTypeController;
use App\Http\Controllers\Assets\Settings\AttributesController;
use App\Http\Controllers\Assets\Settings\BulkAssetAttributeUpdateController;
use App\Http\Controllers\Assets\Settings\BulkAssignController;
use App\Http\Controllers\Assets\Settings\BulkCertificatesUploadController;
use App\Http\Controllers\Assets\Settings\BulkCreatedDateChangeController;
use App\Http\Controllers\Assets\Settings\BulkCreateLinkMobileController;
use App\Http\Controllers\Assets\Settings\BulkDamageController;
use App\Http\Controllers\Assets\Settings\BulkHardwareStandardsController;
use App\Http\Controllers\Assets\Settings\BulkHoldController;
use App\Http\Controllers\Assets\Settings\BulkInstallController;
use App\Http\Controllers\Assets\Settings\BulkLinkController;
use App\Http\Controllers\Assets\Settings\BulkLoansController;
use App\Http\Controllers\Assets\Settings\BulkLostStolenController;
use App\Http\Controllers\Assets\Settings\BulkMoveController;
use App\Http\Controllers\Assets\Settings\BulkReturnController;
use App\Http\Controllers\Assets\Settings\BulkStatusUpdateController;
use App\Http\Controllers\Assets\Settings\BulkTechnicalSpecsController;
use App\Http\Controllers\Assets\Settings\CarrierController;
use App\Http\Controllers\Assets\Settings\DiscoveryTools\ChromeBookController;
use App\Http\Controllers\Assets\Settings\HardwarekitController;
use App\Http\Controllers\Assets\Settings\DiscoveryToolsHardwareMappingController;
use App\Http\Controllers\Assets\Settings\EolCertificatesController;
use App\Http\Controllers\LoginController;
use App\Http\Controllers\Assets\Settings\FailedTicketController;
use App\Http\Controllers\Assets\Settings\FedexTrackingController;
use App\Http\Controllers\Assets\Settings\HardwareStandardController;
use App\Http\Controllers\Assets\Settings\DiscoveryTools\IntuneController;
use App\Http\Controllers\Assets\Settings\DiscoveryTools\JamfController;
use App\Http\Controllers\Assets\Settings\DiscoveryTools\KandjiController;
use App\Http\Controllers\Assets\Settings\LocationTypeController;
use App\Http\Controllers\Assets\Settings\ManufacturerController;
use App\Http\Controllers\Assets\Settings\DiscoveryTools\MobileIronController;
use App\Http\Controllers\Assets\Settings\OktaDirectoryController;
use App\Http\Controllers\Assets\Settings\PurgeAssetController;
use App\Http\Controllers\Settings\History\PurgedAssetHistoryController;
use App\Http\Controllers\Assets\Settings\RegionController;
use App\Http\Controllers\Assets\Settings\SiteCodeController;
use App\Http\Controllers\Assets\Settings\StateController;
use App\Http\Controllers\Assets\Settings\TechnicalSpecsController;
use App\Http\Controllers\Assets\Settings\UpsTrackingController;
use App\Http\Controllers\Assets\Settings\VendorController;
use App\Http\Controllers\Settings\VendorCategoriesController;
use App\Http\Controllers\Assets\ValidationsController;
use App\Http\Controllers\Auth\OktaLoginController;
use App\Http\Controllers\DiscoveryTools\WorkspaceOne\AllWorkspaceOneController;
use App\Http\Controllers\DiscoveryTools\WorkspaceOne\MobileNumberController;
use App\Http\Controllers\DiscoveryTools\ChromeBook\AllChromeBookController;
use App\Http\Controllers\DiscoveryTools\ChromeBook\NotCheckingInManagedController;
use App\Http\Controllers\DiscoveryTools\ChromeBook\NotCheckingInNotManagedController;
use App\Http\Controllers\DiscoveryTools\ChromeBook\CheckingInNotCreatedController;
use App\Http\Controllers\DiscoveryTools\ChromeBook\CheckingInOnHandController;
use App\Http\Controllers\DiscoveryTools\ChromeBook\CheckingInUserDiscrepancyController;
use App\Http\Controllers\DiscoveryTools\Intune\AllIntuneController;
use App\Http\Controllers\DiscoveryTools\Intune\NotCheckingInManagedController as IntuneDevicesNotActiveController;
use App\Http\Controllers\DiscoveryTools\Intune\NotCheckingInNotManagedController as IntuneDevicesNotManagedController;
use App\Http\Controllers\DiscoveryTools\Intune\CheckInNotCreatedController as IntuneDevicesNotCreatedController;
use App\Http\Controllers\DiscoveryTools\Intune\CheckingInOnHandController as IntuneCheckingInOnHandController;
use App\Http\Controllers\DiscoveryTools\Intune\IndexController as IntuneIndexController;
use App\Http\Controllers\DiscoveryTools\Intune\CheckingInUserDiscrepancyController as IntuneUserDiscrepancyController;
use App\Http\Controllers\DiscoveryTools\Jamf\AllJamfController;
use App\Http\Controllers\DiscoveryTools\Jamf\NotCheckingInManagedController as JamfDevicesNotActiveController;
use App\Http\Controllers\DiscoveryTools\Jamf\CheckingInNotCreatedController as JamfDevicesNotCreatedController;
use App\Http\Controllers\DiscoveryTools\Jamf\CheckingInOnHandController as JamfDevicesOnHandCheckedInController;
use App\Http\Controllers\DiscoveryTools\Jamf\IndexController as JamfIndexController;
use App\Http\Controllers\DiscoveryTools\Jamf\CheckingInUserDiscrepancyController as JamfUserDiscrepancyController;
use App\Http\Controllers\DiscoveryTools\Jamf\NotCheckingInNotManagedController as JamfDevicesNotManagedController;
use App\Http\Controllers\DiscoveryTools\Kandji\AllKandjiController;
use App\Http\Controllers\DiscoveryTools\Kandji\NotCheckingInManagedController as KandjiDevicesNotActiveController;
use App\Http\Controllers\DiscoveryTools\Kandji\CheckingInNotCreatedController as KandjiDevicesNotCreatedController;
use App\Http\Controllers\DiscoveryTools\Kandji\NotCheckingInNotManagedController as KandjiDevicesNotManagedController;
use App\Http\Controllers\DiscoveryTools\Kandji\CheckingInOnHandController as KandjiDevicesOnHandCheckingInController;
use App\Http\Controllers\DiscoveryTools\Kandji\IndexController as KandjiIndexController;
use App\Http\Controllers\DiscoveryTools\Kandji\CheckingInUserDiscrepancyController as KandjiUserDiscrepancyController;
use App\Http\Controllers\DiscoveryTools\MobileIron\AllMobileIronController;
use App\Http\Controllers\DiscoveryTools\MobileIron\NotCheckingInManagedController as MobileIronDevicesNotActiveController;
use App\Http\Controllers\DiscoveryTools\MobileIron\CheckingInNotCreatedController as MobileIronDevicesNotCreatedController;
use App\Http\Controllers\DiscoveryTools\MobileIron\CheckingInOnHandController as MobileIronDevicesOnHandCheckingInController;
use App\Http\Controllers\DiscoveryTools\MobileIron\IndexController as MobileIronIndexController;
use App\Http\Controllers\DiscoveryTools\MobileIron\NotCheckingInNotManagedController as MobileIronDevicesNotManagedController;
use App\Http\Controllers\DiscoveryTools\MobileIron\MobileNumberController as MobileIronMobileNumberController;
use App\Http\Controllers\DiscoveryTools\MobileIron\CheckingInUserDiscrepancyController as MobileIronUserDiscrepancyController;
use App\Http\Controllers\DiscoveryTools\WorkspaceOne\NotCheckingInManagedDeployedController as WorkspaceOneDevicesNotActiveController;
use App\Http\Controllers\DiscoveryTools\WorkspaceOne\CheckingInNotCreatedController as WorkspaceOneCheckingInNotCreatedController;
use App\Http\Controllers\DiscoveryTools\WorkspaceOne\NotCheckingInNotManagedController as WorkspaceOneDevicesNotManagedController;
use App\Http\Controllers\DiscoveryTools\WorkspaceOne\CheckedInOnHandController as WorkspaceOneDevicesOnHandCheckedInController;
use App\Http\Controllers\DiscoveryTools\WorkspaceOne\CheckingInUserDiscrepancyController as WorkspaceOneUserDiscrepancyController;
use App\Http\Controllers\EmployeeLandingController;
use App\Http\Controllers\FileController;
use App\Http\Controllers\HelpController;
use App\Http\Controllers\ThemeSwitchController;
use App\Http\Controllers\Dashboard\HomeController;
use App\Http\Controllers\Location\LocationController;
use App\Http\Controllers\Location\LocationAssetsController;
use App\Http\Controllers\Location\LocationAccessoriesController;
use App\Http\Controllers\MobileManagementController;
use App\Http\Controllers\NotificationController;
use App\Http\Controllers\Reports\IndexController as ReportIndexController;
use App\Http\Controllers\Reports\ActiveUsersController;
use App\Http\Controllers\Reports\OnHandAssetAgeController;
use App\Http\Controllers\Reports\WarrantyExpirationDateController;
use App\Http\Controllers\Reports\AgedOutController;
use App\Http\Controllers\Reports\AssetByWarrantyController;
use App\Http\Controllers\Reports\AssetRecoveryValueController;
use App\Http\Controllers\Reports\AssetsCreatedController;
use App\Http\Controllers\Reports\BrandNewAssignedToContractorController;
use App\Http\Controllers\Reports\InStockComputersController;
use App\Http\Controllers\Reports\DamagedTrendsController;
use App\Http\Controllers\Reports\AssetsByDepartmentController;
use App\Http\Controllers\Reports\DepreciationValueController;
use App\Http\Controllers\ExportManagementController;
use App\Http\Controllers\Reports\FleetAgeController;
use App\Http\Controllers\Reports\GeneratorController;
use App\Http\Controllers\Reports\LinkedDevicesController;
use App\Http\Controllers\Reports\LostOrStolenValueController;
use App\Http\Controllers\Reports\NewHire\NewHireEmployeesController;
use App\Http\Controllers\Reports\NewHire\NewHireForecastingController;
use App\Http\Controllers\Reports\NewHire\NewHireForecastingToolController;
use App\Http\Controllers\Reports\RepairAndRecoveryController;
use App\Http\Controllers\Reports\ShareReportController;
use App\Http\Controllers\Terminations\TermsReport\TermsReportController;
use App\Http\Controllers\Reports\UnrepairableController;
use App\Http\Controllers\Reports\UpcomingRefreshController;
use App\Http\Controllers\Reports\CycleCount\CycleCountController;
use App\Http\Controllers\User\UserController;
use App\Http\Controllers\User\UserUploadController;
use App\Http\Controllers\SoftwareLicense\SoftwareLicenseCategoryController;
use App\Http\Controllers\SoftwareLicense\SoftwareLicenseManufacturerController;
use App\Http\Controllers\SoftwareLicense\SoftwareLicenseController;
use App\Http\Controllers\SoftwareLicense\SoftwareLicenseUserController;
use App\Http\Controllers\SoftwareLicense\SoftwareLicenseDocumentController;
use App\Http\Controllers\SoftwareLicense\SoftwareLicenseBulkUploadController;
use App\Http\Controllers\SoftwareLicense\SoftwareLicenseKeyController;
use App\Http\Controllers\SoftwareLicense\SoftwareLicenseSubscriptionController;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\Assets\Settings\DropboxCredentialsController;
use App\Http\Controllers\Settings\History\UserLoginHistoryController;
use App\Http\Controllers\Assets\Settings\SlackCredentialsController;
use App\Http\Controllers\Assets\Settings\TeqtivityUserController;
use App\Http\Controllers\Settings\SystemSettings\DocumentationController;
use App\Http\Controllers\Assets\Settings\ZoomCredentialsController;
use App\Http\Controllers\Security\Crowdstrike\CrowdstrikeCredentialsController;
use App\Http\Controllers\Reports\CycleCount\CycleCountHistoryController;
use App\Http\Controllers\Assets\Settings\OperatingSystemComplianceController;
use App\Http\Controllers\Dashboard\ComplianceDashboardController;
use App\Http\Controllers\Dashboard\HrDashboardController;
use App\Http\Controllers\Dashboard\InventoryDashboardController;
use App\Http\Controllers\Reports\DuplicateAssetsController;
use App\Http\Controllers\Reports\OperatingSystemCompliance\AndroidComplianceReportController;
use App\Http\Controllers\Reports\OperatingSystemCompliance\AppleComplianceReportController;
use App\Http\Controllers\Reports\OperatingSystemCompliance\AppleMobileComplianceReportController;
use App\Http\Controllers\Reports\OperatingSystemCompliance\ChromeComplianceReportController;
use App\Http\Controllers\Reports\OperatingSystemCompliance\WindowsComplianceReportController;
use App\Http\Controllers\Assets\Settings\OktaScimController;
use App\Http\Controllers\Assets\Settings\PresidioController;
use App\Http\Controllers\Assets\Settings\RetrieverCredentialsController;
use App\Http\Controllers\Assets\Settings\SlackNotificationCredentialsController;
use App\Http\Controllers\Assets\UpdateAssetAttributeController;
use App\Http\Controllers\Assets\UpdateAssetStatusController;
use App\Http\Controllers\CloudAssets\CloudAssetsController;
use App\Http\Controllers\DiscoveryTools\Jamf\PreStageDevicesController;
use App\Http\Controllers\InventoryConsumption\ConsumptionReportController;
use App\Http\Controllers\InventoryConsumption\ConsumptionTrendsController;
use App\Http\Controllers\NetworkAssetController;
use App\Http\Controllers\Reports\AssetRecoveryController;
use App\Http\Controllers\Reports\AssetsAssignedByMonthController;
use App\Http\Controllers\Reports\AvailableStockController;
use App\Http\Controllers\Reports\AverageTimeInBrandNewController;
use App\Http\Controllers\Reports\BrandNewToAssignedController;
use App\Http\Controllers\Reports\ComputerDeployedController;
use App\Http\Controllers\Terminations\HrCollection\CollectionStatisticsReportController;
use App\Http\Controllers\Terminations\HrCollection\RetrievalStatisticsReportController;
use App\Http\Controllers\Terminations\HrCollection\UserStatisticsGraphController;
use App\Http\Controllers\Reports\NewHire\AverageDeploymentTimeController;
use App\Http\Controllers\Reports\UsersToAssetsRatioController;
use App\Http\Controllers\Reports\UseTaxController;
use App\Http\Controllers\Revivn\RevivnAssetsController;
use App\Http\Controllers\Revivn\RevivnAssetsManagementController;
use App\Http\Controllers\Revivn\RevivnDevicesAutoCreatedController;
use App\Http\Controllers\Revivn\RevivnPickupController;
use App\Http\Controllers\SendMailController;
use App\Http\Controllers\Security\Crowdstrike\Reports\ActiveCveReportController;
use App\Http\Controllers\Security\Crowdstrike\Reports\CrowdstrikeReportController;
use App\Http\Controllers\Security\Crowdstrike\Reports\SensorDetectionReportController;
use App\Http\Controllers\Security\Crowdstrike\Reports\SensorVulnerabilityReportController;
use App\Http\Controllers\Security\Crowdstrike\ActiveCveController;
use App\Http\Controllers\Settings\CloudAssets\AwsCloudAssetsController;
use App\Http\Controllers\Settings\History\SystemHistoryController;
use App\Http\Controllers\Settings\History\UserHistoryController;
use App\Http\Controllers\Settings\SystemSettings\SupportSettingsController;
use App\Http\Controllers\Settings\History\ApiBlockedIpsController;
use App\Http\Controllers\Settings\History\ApiRequestHistoryController;
use App\Http\Controllers\Settings\History\SoftwareAssetHistoryController;
use App\Http\Controllers\SoftwareLicense\Zoom\ZoomMeetingController;
use App\Http\Controllers\SupportPageController;
use App\Http\Controllers\Terminations\Retriever\RetrieverReportController;
use App\Http\Controllers\Terminations\Retriever\RetrieverShipmentController;
use App\Http\Controllers\Auth\ForgotPasswordController;
use App\Http\Controllers\Auth\ResetPasswordController;
use App\Http\Controllers\Location\LocationFilterFieldsController;
use App\Http\Controllers\Settings\GoogleWorkspace\GoogleDirectoryController;
use App\Http\Controllers\Settings\GoogleWorkspace\GsuiteLocationsController;
use App\Http\Controllers\Settings\History\LocationHistoryController;
use App\Http\Controllers\Settings\History\UserRoleChangeHistoryController;
use App\Http\Controllers\Settings\SlackNotifications\SlackChannelsConfigController;
use App\Http\Controllers\Settings\SlackNotifications\SlackNotificationsController;
use App\Http\Controllers\User\UserFilterFieldController;
use App\Http\Controllers\DiscoveryTools\JumpCloud\AllJumpCloudController;
use App\Http\Controllers\DiscoveryTools\JumpCloud\CheckingInNotCreatedController as JumpCloudNotCreatedController;
use App\Http\Controllers\DiscoveryTools\JumpCloud\CheckingInOnHandController as JumpCloudOnHandCheckingInController;
use App\Http\Controllers\DiscoveryTools\JumpCloud\CheckingInUserDiscrepancyController as JumpCloudUserDiscrepancyController;
use App\Http\Controllers\DiscoveryTools\JumpCloud\NotCheckingInManagedController as JumpCloudNotActiveController;
use App\Http\Controllers\DiscoveryTools\JumpCloud\NotCheckingInNotManagedController as JumpCloudNotManagedController;
use App\Http\Controllers\DiscoveryTools\JumpCloud\JumpCloudController;
use App\Http\Controllers\Settings\AzureDirectoryCredentialController;

Route::group(['middleware' => 'web'], function () {
    Route::group(['middleware' => 'auth'], function () {
        Route::group(['middleware' => ['permission:Dashboard View']], function () {
            Route::get('/', [HomeController::class, 'index'])->name('dashboard');
            Route::get('/inventory-dashboard', [InventoryDashboardController::class, 'index'])->name('inventory-dashboard');
            Route::get('/hr-dashboard', [HrDashboardController::class, 'index'])->name('hr-dashboard');
            Route::post('/hr-dashboard/onboarding-summary', [HrDashboardController::class, 'onboardingSummary'])->name('hr-dashboard-onboarding-summary');
            Route::post('/hr-dashboard/termination-summary', [HrDashboardController::class, 'terminationSummary'])->name('hr-dashboard-termination-summary');
            Route::get('/hr-dashboard-refresh', [HrDashboardController::class, 'refreshActiveUsersCount'])->name('hr-dashboard-refresh');
            // Route::get('/get-terminated-user-assets-graph-data', 'HomeController@getTerminatedUserAssetsGraphData')->name('get-terminated-user-assets-graph-data');
            // Route::get('/get-terminated-user-assets-graph-data', 'HomeController@getTerminatedUserAssetsGraphData')->name('get-terminated-user-assets-graph-data');
            Route::get('/compliance-dashboard', [ComplianceDashboardController::class, 'index'])->name('compliance-dashboard');
            Route::get('/compliance-dashboard-refresh', [ComplianceDashboardController::class, 'refreshAssetsCount'])->name('compliance-dashboard-refresh');
            Route::get('/compliance-dashboard-vulnerability-refresh', [ComplianceDashboardController::class, 'refreshVulnerabilityCount'])->name('compliance-dashboard-vulnerability-refresh');
        });

        Route::post('assets-create/listHardware', [FilterFieldController::class, 'listHardwareCreate'])->name('assets-create.listhardware');
        Route::post('assets-create/listtechnics', [FilterFieldController::class, 'listTechnicalSpecCreate'])->name('assets-create.listtechnics');

        Route::post('assets/check-unique', [ValidationsController::class, 'checkUnique']);
        Route::post('assets/check-exists', [ValidationsController::class, 'checkExists']);
        Route::post('assets/check-parent', [ValidationsController::class, 'checkParent']);
        Route::post('assets/check-child', [ValidationsController::class, 'checkChild']);

        Route::get('/notifications', [NotificationController::class, 'getNotifications']);
        Route::get('/refresh-notifications', [NotificationController::class, 'refresh']);
        Route::post('/notifications', [NotificationController::class, 'getNotifications']);
        Route::post('/notification-data', [NotificationController::class, 'data'])->name('notification-data');

        Route::group(['middleware' => ['permission:IT Assets View']], function () {

            Route::resource('assets', '\App\Http\Controllers\Assets\IndexController');
            Route::post('/assets-data', [IndexController::class, 'data'])->name('assets-data');
            Route::post('/get-lock-code', [IndexController::class, 'getLockCode'])->name('assets-get-lock-code');

            Route::get('/it-assets', [SearchAssetController::class, 'index'])->name('it-assets');
            Route::post('/assets-search', [SearchController::class, 'search'])->name('assets-search');
            Route::get('/get-search-fields', [SearchAssetController::class, 'getSearchFields']);
            Route::get('/get-search-serial-tag-fields', [SearchAssetController::class, 'getSearchSerialAndAssetTagFields']);

            Route::post('/assets-history-data', [AssetDetailsHistoryController::class, 'data'])->name('asset-history-data');

            Route::post('/assets/get-links', [LinkController::class, 'getLinks'])->name('assets.get-links');
            Route::post('/search-assets/get-user', [SearchAssetController::class, 'getAssetUser'])->name('search-assets.get-user');
            Route::post('/get-original-value-total', [SearchAssetController::class, 'getOriginalValueTotal'])->name('search-assets.get-original-value-total');
            Route::post('/get-original-value-total-location', [SearchAssetController::class, 'getOriginalValueLocationTotal']);
            Route::post('/get-original-value-total-software', [SearchAssetController::class, 'getOriginalValueSoftwareTotal'])->name('search-assets.get-original-value-total-software');
        });

        Route::group(['middleware' => ['permission:IT Assets Create']], function () {
            Route::resource('assets/create', '\App\Http\Controllers\Assets\CreateController')->names('assets-create');
            Route::post('assets/create/add', [CreateController::class, 'add'])->name('assets-create.updateRows');

            Route::post('asset/create/advanced-upload', [CreateController::class, 'advancedItUpload'])->name('assets-create.advanced-upload');
            Route::post('asset/create/bulk-upload', [CreateController::class, 'bulkUpload'])->name('assets-create.bulk-upload');
        });

        Route::group(['middleware' => ['permission:IT Assets Edit']], function () {
            Route::post('asset/create/list-additional-attributes', [CreateController::class, 'listAdditionalAttributes'])->name('assets-create.list-additional-attributes');

            Route::get('asset/move', [MoveController::class, 'index'])->name('assets-move.index');
            Route::get('asset/link', [LinkController::class, 'index'])->name('assets-link.index');
            Route::get('asset/return', [ReturnController::class, 'index'])->name('assets-return.index');

            Route::post('/update-asset-condition', [IndexController::class, 'updateAssetCondition'])->name('update-asset-condition');
            Route::post('/update-asset-attribute', [UpdateAssetAttributeController::class, 'UpdateAttribute'])->name('update-asset-attribute')->middleware('validate_referer');
            Route::post('/update-asset-assignee', [UpdateAssetAttributeController::class, 'updateAssignee'])->name('update-asset-assignee')->middleware('validate_referer');
            Route::post('/update-hardware-specs', [UpdateAssetAttributeController::class, 'updateHardwareAndSpecs'])->name('update-hardware-specs');

            Route::post('/update-asset-status', [UpdateAssetStatusController::class, 'updateStatus'])->middleware('validate_referer');

            Route::post('/add-comment/{id}', [IndexController::class, 'addComment']);

            Route::post('assets-move-store', [MoveController::class, 'store'])->name('assets-move.store');
            Route::post('assets-move', [MoveController::class, 'updateRows'])->name('assets-move.updateRows');
            Route::post('assets-link', [LinkController::class, 'updateRows'])->name('assets-link.updateRows');
            Route::post('assets-link-store', [LinkController::class, 'store'])->name('assets-link.store');
            Route::post('assets-return', [ReturnController::class, 'updateRows'])->name('assets-return.updateRows');
            Route::post('assets-return-store', [ReturnController::class, 'store'])->name('assets-return.store');

            Route::post('/single-assets-link', [LinkController::class, 'storeLinkFromDetailsPage'])->name('single-asset-link.store')->middleware('validate_referer');
            Route::post('/assets-move-single', [MoveController::class, 'moveSingleAsset'])->name('assets-move-single.store')->middleware('validate_referer');
            Route::post('/assets-return-single', [ReturnController::class, 'returnSingleAsset'])->name('assets-return-single.store')->middleware('validate_referer');

            Route::post('/assets/remove-links', [LinkController::class, 'removeLinks'])->name('assets.remove-links')->middleware('validate_referer');
            Route::post('/search-assets/update-hardware-techspec', [SearchAssetController::class, 'updateHardwareTechspec'])->name('search-assets.update-hardware-techspec')->middleware('validate_referer');
        });

        Route::group(['middleware' => ['permission:AV Assets View']], function () {
            Route::resource('av-assets', '\App\Http\Controllers\Assets\ProdAssetController', ['only' => 'index', 'show']);
            Route::get('/av-assets/search', [ProdAssetController::class, 'search'])->name('av-assets-search');
            Route::post('/prod-assets/search', [SearchController::class, 'prodSearch'])->name('prod-assets-search');
            Route::post('/assets-server-data', [ProdAssetController::class, 'data'])->name('assets-server-data');
        });

        Route::group(['middleware' => ['permission:AV Assets Create']], function () {
            Route::resource('av-assets', '\App\Http\Controllers\Assets\ProdAssetController', ['except' => 'index', 'show']);
            Route::post('av-assets/add', [ProdAssetController::class, 'add'])->name('av-assets.updateRows');
            Route::post('av-assets/upload', [ProdAssetController::class, 'upload']);
        });

        Route::group(['middleware' => ['permission:AV Assets Edit']], function () {
            Route::get('/av-asset/move', [MoveController::class, 'av'])->name('assets-move.server');
            Route::get('/av-asset/link', [LinkController::class, 'av'])->name('assets-link.server');
            Route::get('/av-asset/return', [ReturnController::class, 'av'])->name('assets-return.av');
        });

        Route::group(['middleware' => ['permission:Mobile Assets View']], function () {
            Route::get('/mobile-assets/search', [MobileManagementController::class, 'index'])->name('mobile-assets.index');
            Route::get('/mobile-assets/{id}', [MobileManagementController::class, 'show'])->name('mobile-assets.show');
            Route::get('/mobile-assets', [IndexController::class, 'mobileAsset'])->name('assets.mobile');
        });

        Route::group(['middleware' => ['permission:Mobile Assets Create']], function () {
            Route::get('/mobile-asset/create', [CreateController::class, 'mobile'])->name('assets-create.mobile');
            Route::post('/mobile-asset/create/advanced-upload', [CreateController::class, 'advancedMobileUpload'])->name('assets-create.mobile.advanced-upload');
        });

        Route::group(['middleware' => ['permission:Mobile Assets Edit']], function () {
            Route::get('/mobile-asset/move', [MoveController::class, 'mobile'])->name('assets-move.mobile');
            Route::get('/mobile-asset/link', [LinkController::class, 'mobile'])->name('assets-link.mobile');
            Route::get('/mobile-asset/return', [ReturnController::class, 'mobile'])->name('assets-return.mobile');
            Route::post('mobile-management/update-carrier', [MobileManagementController::class, 'updateCarrier'])->middleware('validate_referer');
        });

        Route::group(['middleware' => ['permission:Network Assets View']], function () {
            Route::get('/search-network-assets', [NetworkAssetController::class, 'search'])->name('search-network-assets');
            Route::resource('network-assets', '\App\Http\Controllers\NetworkAssetController', ['only' => 'index', 'show']);
            Route::post('/assets-network-data', [NetworkAssetController::class, 'data'])->name('assets-network-data');
            Route::get('/get-filter-fields-network', [FilterFieldController::class, 'getFilterNetworkFields']);
            Route::get('assets-link/network', [LinkController::class, 'network'])->name('assets-link.network');
        });

        Route::group(['middleware' => ['permission:Network Assets Create']], function () {
            Route::post('network-assets/add', [NetworkAssetController::class, 'add'])->name('network-assets.updateRows');
            Route::post('network-assets/upload', [NetworkAssetController::class, 'upload']);
            Route::resource('network-assets', '\App\Http\Controllers\NetworkAssetController', ['except' => 'index', 'show']);
        });

        Route::group(['middleware' => ['permission:Network Assets Edit']], function () {
            Route::get('assets-move/network', [MoveController::class, 'network'])->name('assets-move.network');
            Route::get('assets-return/network', [ReturnController::class, 'network'])->name('assets-return.network');
        });


        Route::group(['middleware' => ['permission:Accessories View']], function () {
            Route::resource('/accessories', '\App\Http\Controllers\AccessoriesController', ['only' => 'index']);
            Route::get('/get-search-accessories', [AccessoriesController::class, 'getSearchAccessories']);
            Route::post('/accessories-filter', [AccessoriesController::class, 'filter']);
            Route::post('/accessories/technical-specs', [AccessoriesController::class, 'listTechnicalSpec']);
            Route::post('/save-search', [AccessoriesController::class, 'saveSearch']);
            Route::post('/update-search', [AccessoriesController::class, 'updateSearch']);
            Route::post('/delete-search', [AccessoriesController::class, 'deleteSearch']);
            Route::post('/accessories-data', [AccessoriesController::class, 'data'])->name('accessories-data');
            Route::post('accessories-move/{id}', [AccessoriesController::class, 'move']);
            Route::post('accessories-add/{id}', [AccessoriesController::class, 'add']);
            Route::post('accessories-use/{id}', [AccessoriesController::class, 'use']);
            Route::post('accessories-update/{id}', [AccessoriesController::class, 'updateQuantity']);
        });

        Route::group(['middleware' => ['permission:Accessories Edit']], function () {
            Route::resource('/accessories', '\App\Http\Controllers\AccessoriesController', ['except' => 'index']);
        });

        Route::group(['middleware' => ['permission:Locations View']], function () {
            Route::resource('/location', '\App\Http\Controllers\Location\LocationController', ['only' => 'index', 'show']);
            Route::get('/location/filter/{type}', [LocationController::class, 'index'])->name('location-filter');
            Route::post('/location/site-code', [SiteCodeController::class, 'getSiteCodeDetails']);
            Route::post('/location/location-export', [LocationController::class, 'export'])->name('location-export');
            Route::post('/location-data', [LocationController::class, 'data'])->name('location-data');
            Route::post('/location-asset-data', [LocationAssetsController::class, 'data'])->name('location-asset-data');
            Route::post('/location-accessories-data', [LocationAccessoriesController::class, 'data'])->name('location-accessories-data');
            Route::post('/location-detail-asset-value/{id}', [LocationAssetsController::class, 'assetValue']);
            Route::post('/location-zoom-data', 'App\Http\Controllers\Location\LocationZoomDeviceController@data')->name('location-zoom-data');
        });

        Route::group(['middleware' => ['permission:Locations Edit']], function () {
            Route::resource('/location', '\App\Http\Controllers\Location\LocationController', ['except' => 'index', 'show']);
        });

        Route::group(['middleware' => ['permission:People View']], function () {
            Route::get('/users/active', [UserController::class, 'index'])->name('users-active');
            Route::get('/users/inactive', [UserController::class, 'index'])->name('users-inactive');
            Route::post('/users-data', [UserController::class, 'data'])->name('users-data');
            Route::resource('/users', '\App\Http\Controllers\User\UserController', ['only' => 'index', 'show']);
        });

        Route::group(['middleware' => ['permission:People Edit']], function () {
            Route::resource('/users', '\App\Http\Controllers\User\UserController', ['except' => 'index', 'show']);
            Route::post('/users/create/add', [UserController::class, 'add'])->name('user-create.updateRows');
            Route::post('/users/active-directory-upload', [UserController::class, 'uploadActiveDirectoryUsers']);
            Route::get('/active-directory-integration', [UserController::class, 'integrateActiveDirectory']);
            Route::post('/user-export', [UserController::class, 'export'])->name('user-export');
            Route::post('/users/create/upload', [UserUploadController::class, 'upload']);
        });

        Route::group(['middleware' => ['permission:Employee Landing Page']], function () {
            Route::get('/my-teq-assets', [EmployeeLandingController::class, 'index'])->name('my-teq-assets');
            Route::post('/employee-landing/get_assets', [EmployeeLandingController::class, 'getAssets']);
            Route::post('/employee-landing/send_dispute', [EmployeeLandingController::class, 'sendDispute']);
            Route::post('/employee-landing/send_common_dispute', [EmployeeLandingController::class, 'sendDisputeCommon']);
            Route::get('/employee-landing/export_active_team', [EmployeeLandingController::class, 'exportActiveTeam']);
            Route::get('/employee-landing/export_in_active_team', [EmployeeLandingController::class, 'exportInActiveTeam']);
            Route::post('/employees-active-data', [EmployeeLandingController::class, 'activeData'])->name('employees-active-data');
            Route::post('/employees-inactive-data', [EmployeeLandingController::class, 'inactiveData'])->name('employees-inactive-data');
        });

        Route::group(['middleware' => ['permission:API Users View']], function () {
            Route::resource('/api-users', '\App\Http\Controllers\ToolBox\ApiUserController', ['only' => 'index']);
        });

        Route::group(['middleware' => ['permission:API Users Manage']], function () {
            Route::post('/api-users/refresh-token/{id}', [ApiUserController::class, 'refreshToken'])->name('refresh-token');
            Route::resource('/api-users', '\App\Http\Controllers\ToolBox\ApiUserController', ['except' => 'index']);

            Route::post('/apiusers-ajax', [ApiUserController::class, 'ajax']);
            Route::post('/set-apiuser-scopes', [ApiUserController::class, 'setTokenScopes'])->name('set-apiuser-scopes');
            Route::post('/create-apiuser-scopes', [ApiUserController::class, 'createApiScopes'])->name('create-apiuser-scopes');
        });


        Route::group(['middleware' => ['permission:Inventory Control View']], function () {

            Route::group(['prefix' => 'inventory-control'], function () {

                Route::get('/cycle-count', [CycleCountController::class, 'index'])->name('cycle-count.index');
                Route::post('/cycle-count', [CycleCountController::class, 'updateRows'])->name('cycle-count.updateRows');
                Route::get('/cycle-count/merge/{locationId?}/{assetTypeId?}', [CycleCountController::class, 'mergeData'])->name('cycle-count.merge');
                Route::post('/cycle-count-report', [CycleCountController::class, 'generate'])->name('cycle-count.generate');

                Route::post('/cycle-count.scanned-assets', [CycleCountController::class, 'scannedAssets']);
                Route::post('/cycle-count-report-history', [CycleCountController::class, 'history'])->name('cycle-count.history');
                Route::post('/cycle-count/check-scanned-assets', [CycleCountController::class, 'checkScannedAssets']);
                Route::post('/cycle-count/check-scanned-assetstype', [CycleCountController::class, 'checkScannedAssetType']);

                Route::post('/get-location-status', [CycleCountController::class, 'getLocationFreezeStatus']);
                Route::post('/freeze-unfreeze-location', [CycleCountController::class, 'changeLocationFreezeStatus']);
                Route::get('/download-cycle-count-report/{id}', [CycleCountController::class, 'downloadReport'])->name('cycle-count.report.download');
                Route::post('/cycle-count-delete', [CycleCountController::class, 'deleteScannedAssets'])->name('cycle-count.assets.delete');

                Route::get('/inventory-report', [CycleCountHistoryController::class, 'index']);
                Route::post('/inventory-report-data', [CycleCountHistoryController::class, 'cycleCountHistoryData'])->name('cycle-count.history.data');
                Route::get('/inventory-report-details/{id}', [CycleCountHistoryController::class, 'cycleCountHistoryDetails'])->name('cycle-count.history.details');

                //On Hand Asset Age
                // Route::get('/on-hand-asset-age', [OnHandAssetAgeController::class, 'index']);
                // Route::post('/on-hand-asset-age-data', [OnHandAssetAgeController::class, 'data'])->name('on-hand-asset-age-data');
                // Route::post('/on-hand-asset-age-export', [OnHandAssetAgeController::class, 'export'])->name('on-hand-asset-age-export');

                //fleet age
                Route::get('/fleet-age', [FleetAgeController::class, 'index'])->name('fleet-age');
                Route::post('/fleet-age', [FleetAgeController::class, 'index'])->name('fleet-age-search');

                // Users to Asset Ratio
                Route::get('/users-to-asset-ratio', [UsersToAssetsRatioController::class, 'index'])->name('users-to-asset-ratio');
                Route::post('/users-to-asset-ratio-graph-data', [UsersToAssetsRatioController::class, 'graphData'])->name('users-to-asset-ratio-graph-data');
                Route::post('/users-to-asset-ratio-data', [UsersToAssetsRatioController::class, 'data'])->name('users-to-asset-ratio-data');
                Route::post('/users-to-asset-ratio-export', [UsersToAssetsRatioController::class, 'exportGraphWithListData'])->name('users-to-asset-ratio-export');


                //In stock computers
                Route::get('/in-stock-computers', [InStockComputersController::class, 'index'])->name('instock-computers-report');
                Route::post('/in-stock-computers', [InStockComputersController::class, 'data'])->name('instock-report-data');
                Route::post('/in-stock-computers/export', [InStockComputersController::class, 'export'])->name('instock-computers-export');

                //Available stock
                Route::get('/available-stock', [AvailableStockController::class, 'index'])->name('available-stock');
                Route::post('/available-stock', [AvailableStockController::class, 'data'])->name('available-stock-data');
                Route::post('/available-stock-export', [AvailableStockController::class, 'export'])->name('available-stock-export');

                //Consumption Reports
                Route::group(['middleware' => ['permission:Consumption Reports']], function () {
                    Route::get('/consumption-report', [ConsumptionReportController::class, 'index'])->name('consumption-report.index');
                    Route::post('/consumption-report/data', [ConsumptionReportController::class, 'data'])->name('consumption-report.data');
                    Route::post('/consumption-report/export', [ConsumptionReportController::class, 'export'])->name('consumption-report.export');
                    Route::get('/consumption-trends', [ConsumptionTrendsController::class, 'index'])->name('consumption-trends');
                    Route::post('/consumption-trends-graph-data', [ConsumptionTrendsController::class, 'graphData'])->name('consumption-trends-graph-data');
                    Route::post('/consumption-trends-data', [ConsumptionTrendsController::class, 'data'])->name('consumption-trends-data');
                });


                Route::get('/revivn-assets', [RevivnAssetsController::class, 'index'])->name('revivn-assets.index');
                Route::post('/revivn-assets', [RevivnAssetsController::class, 'data'])->name('revivn-assets-data');
                Route::post('/revivn-assets/export', [RevivnAssetsController::class, 'export'])->name('revivn-assets-export');

                Route::get('/revivn-pickups', [RevivnPickupController::class, 'index'])->name('revivn-pickups');
                Route::post('/revivn-pickups', [RevivnPickupController::class, 'data'])->name('revivn-pickups-data');
                Route::post('/revivn-pickups/export', [RevivnPickupController::class, 'export'])->name('revivn-pickups-export');

                Route::get('/revivn-assets-auto-created', [RevivnDevicesAutoCreatedController::class, 'index'])->name('revivn-assets-auto-created');
                Route::post('/revivn-assets-auto-created', [RevivnDevicesAutoCreatedController::class, 'data'])->name('revivn-assets-auto-created-data');
                Route::post('/revivn-assets-auto-created/export', [RevivnDevicesAutoCreatedController::class, 'export'])->name('revivn-assets-auto-created-export');
                Route::post('/revivn-asset-get/{id}', [RevivnAssetsManagementController::class, 'getAsset']);
                Route::post('/revivn-asset-get-hardware', [RevivnAssetsManagementController::class, 'getHardware']);
                Route::post('/revivn-asset-get-tech-spec', [RevivnAssetsManagementController::class, 'getTechSpech']);
                Route::post('/revivn-asset-update', [RevivnAssetsManagementController::class, 'updateAsset']);
                Route::get('/revivn-assets/get-filter-fields', [RevivnAssetsManagementController::class, 'getFilterFields']);
            });

            Route::group(['middleware' => ['permission:ASN Hardware Mapping']], function () {
                Route::resource('/presidio-hardware-mapping', 'Asn\Presidio\PresidioHardwareMappingController');
                Route::post('/presidio-hardware-mapping/bulk-upload', 'Asn\Presidio\PresidioHardwareMappingController@bulkUpload');
                Route::get('/presidio-hardware-mapping-resync', 'Asn\Presidio\PresidioHardwareMappingController@resync')->name('presidio.resync');
                Route::post('/presidio-hardware-mapping-search', 'Asn\Presidio\PresidioHardwareMappingController@search')->name('presidio-mapping-search');
                Route::post('/presidio-hardware-mapping-ajax', 'Asn\Presidio\PresidioHardwareMappingController@ajax');
                Route::post('/presidio-hardware-mapping-store', 'Asn\Presidio\PresidioHardwareMappingController@store')->name('presidio-hardware-mapping-store');
            });

            Route::group(['middleware' => ['permission:ASN Accessories Mapping']], function () {
                Route::resource('/presidio-accessories-mapping', 'Asn\Presidio\PresidioAccessoriesMappingController');
                Route::post('/presidio-accessories-mapping/bulk-upload', 'Asn\Presidio\PresidioAccessoriesMappingController@bulkUpload');
                Route::post('/presidio-accessories-mapping-ajax', 'Asn\Presidio\PresidioAccessoriesMappingController@ajax');
                Route::post('/presidio-accessories-mapping-search', 'Asn\Presidio\PresidioAccessoriesMappingController@search')->name('presidio.accessories-mapping.search');
                Route::get('/presidio-accessories-mapping-resync', 'Asn\Presidio\PresidioAccessoriesMappingController@resync')->name('presidio.accessories-mapping.resync');
            });

            Route::group(['middleware' => ['permission:ASN Unwanted Parts Mapping']], function () {
                Route::resource('/presidio-unwanted-parts', 'Asn\Presidio\PresidioUnwantedPartsController');
                Route::post('/presidio-unwanted-parts/bulk-upload', 'Asn\Presidio\PresidioUnwantedPartsController@bulkUpload');
                Route::post('/presidio-unwanted-parts-ajax', 'Asn\Presidio\PresidioUnwantedPartsController@ajax');
                Route::post('/presidio-unwanted-parts-search', 'Asn\Presidio\PresidioUnwantedPartsController@search')->name('presidio.unwanted-parts.search');
                Route::get('/presidio-unwanted-parts-resync', 'Asn\Presidio\PresidioUnwantedPartsController@resync')->name('presidio.unwanted-parts.resync');
            });

            Route::group(['middleware' => ['permission:ASN - Assets View']], function () {
                Route::resource('/asn-presidio', 'Asn\Presidio\PresidioAssetsController');
                Route::post('/receive-presidio-asset-search', 'Asn\Presidio\PresidioAssetsController@search')->name('receive-presidio-asset-search');
                Route::post('/receive-presidio-assets-ajax', 'Asn\Presidio\PresidioAssetsController@ajax');
                Route::post('/receive-presidio-asset/mark-as-received', 'Asn\Presidio\PresidioAssetsController@markReceived');
                Route::post('/presidio-asset-export', 'Asn\Presidio\PresidioAssetsController@export')->name('presidio-asset-export');
                Route::post('/receive-presidio-asset/bulk-update', 'Asn\Presidio\PresidioAssetsController@bulkUpdate');
                Route::post('/presidio-asset-get-hardware', 'Asn\Presidio\PresidioAssetsController@getHardware');
                Route::post('/presidio-asset-get-tech-spec', 'Asn\Presidio\PresidioAssetsController@getTechSpech');
                Route::post('/presidio-asset-sync', 'Asn\Presidio\PresidioAssetsController@manualSync');
                Route::post('/presidio-data', 'Asn\Presidio\PresidioAssetsController@data')->name('presidio-data');
                Route::post('/presidio-asset-get/{id}', 'Asn\Presidio\PresidioAssetsController@getAssetDetails');
                Route::post('/presidio-asset-update', 'Asn\Presidio\PresidioAssetsController@updateAsset');
                Route::post('/presidio-asset-delete/{id}', 'Asn\Presidio\PresidioAssetsController@deleteAsset');
                Route::post('/presidio-asset-receive', 'Asn\Presidio\PresidioAssetsController@markReceived')->name('presidio-asset-receive');
                Route::post('/presidio-single-item-receive', 'Asn\Presidio\PresidioAssetsController@markSingleItemReceived');
                Route::post('/receive-presidio-asset/bulk-update-po', 'Asn\Presidio\PresidioAssetsController@bulkUpdatePo');
                Route::post('/presidio-asset-mapping', 'Asn\Presidio\PresidioAssetsController@addAssetHardwareMapping');
            });

            /*
            Route::group(['middleware' => ['permission:ASN - Assets View']], function () {
                Route::resource('/asn-cdw', '\App\Http\Controllers\Asn\Cdw\CdwAssetsController');
                Route::post('/cdw-data', [CdwAssetsController::class, 'data'])->name('cdw-data');
                Route::post('/cdw-asset-export', [CdwAssetsController::class, 'export'])->name('cdw-asset-export');
                Route::post('/cdw-asset-sync', [CdwAssetsController::class, 'manualSync']);
                Route::post('/cdw-asset-get/{id}', [CdwAssetsController::class, 'getAsset']);
                Route::post('/cdw-asset-get-hardware', [CdwAssetsController::class, 'getHardware']);
                Route::post('/cdw-asset-get-tech-spec', [CdwAssetsController::class, 'getTechSpech']);
                Route::post('/cdw-asset-update', [CdwAssetsController::class, 'updateAsset']);
                Route::post('/cdw-asset-delete/{id}', [CdwAssetsController::class, 'deleteAsset']);
                Route::post('/cdw-asset-receive', [CdwAssetsController::class, 'markReceived'])->name('cdw-asset-receive');
                Route::post('/cdw-single-item-receive', [CdwAssetsController::class, 'markSingleItemReceived']);
            });

            Route::group(['middleware' => ['permission:ASN Hardware Mapping']], function () {
                Route::resource('/cdw-hardware-mapping', '\App\Http\Controllers\Asn\Cdw\CdwHardwareMappingController');
                Route::post('/cdw-hardware-mapping/bulk-upload', [CdwHardwareMappingController::class, 'bulkUpload']);
                Route::get('/cdw-hardware-mapping-resync', [CdwHardwareMappingController::class, 'resync'])->name('cdw.resync');
                Route::post('/cdw-hardware-mapping-search', [CdwHardwareMappingController::class, 'search'])->name('cdw-mapping-search');
                Route::post('/cdw-hardware-mapping-ajax', [CdwHardwareMappingController::class, 'ajax']);
                Route::post('/cdw-hardware-mapping-store', [CdwHardwareMappingController::class, 'store'])->name('asn.hardware-mapping.store');
            });

            Route::group(['middleware' => ['permission:ASN Accessories Mapping']], function () {
                Route::resource('/cdw-accessories-mapping', '\App\Http\Controllers\Asn\Cdw\CdwAccessoriesMappingController');
                Route::post('/cdw-accessories-mapping/bulk-upload', [CdwAccessoriesMappingController::class, 'bulkUpload']);
                Route::post('/cdw-accessories-mapping-ajax', [CdwAccessoriesMappingController::class, 'ajax']);
                Route::post('/cdw-accessories-mapping-search', [CdwAccessoriesMappingController::class, 'search'])->name('cdw.accessories-mapping.search');
                Route::get('/cdw-accessories-mapping-resync', [CdwAccessoriesMappingController::class, 'resync'])->name('cdw.accessories-mapping.resync');
            });

            Route::group(['middleware' => ['permission:ASN Unwanted Parts Mapping']], function () {
                Route::resource('/cdw-unwanted-parts', '\App\Http\Controllers\Asn\Cdw\CdwUnwantedPartsController');
                Route::post('/cdw-unwanted-parts/bulk-upload', [CdwUnwantedPartsController::class, 'bulkUpload']);
                Route::post('/cdw-unwanted-parts-ajax', [CdwUnwantedPartsController::class, 'ajax']);
                Route::post('/cdw-unwanted-parts-search', [CdwUnwantedPartsController::class, 'search'])->name('cdw.unwanted-parts.search');
                Route::get('/cdw-unwanted-parts-resync', [CdwUnwantedPartsController::class, 'resync'])->name('cdw.unwanted-parts.resync');
            });


            Route::group(['middleware' => ['permission:ASN - Assets View']], function () {
                Route::resource('/asn-insight', '\App\Http\Controllers\Asn\Insight\InsightAssetsController');
                Route::post('/receive-insight-asset-search', [InsightAssetsController::class, 'search'])->name('receive-insight-asset-search');
                Route::post('/receive-insight-asset/mark-as-received', [InsightAssetsController::class, 'markReceived']);
                Route::post('/receive-insight-asset/single-item-receive', [InsightAssetsController::class, 'markSingleItemReceived'])->name('asn-insight-single-item-receive');
                Route::post('/insight-asset-export', [InsightAssetsController::class, 'export'])->name('insight-asset-export');
                Route::post('/insight-asset-get-hardware', [InsightAssetsController::class, 'getHardware']);
                Route::post('/insight-asset-get-tech-spec', [InsightAssetsController::class, 'getTechSpech']);
                Route::post('/insight-data', [InsightAssetsController::class, 'data'])->name('insight-data');
                Route::post('/insight-asset-get/{id}', [InsightAssetsController::class, 'getAsset']);
                Route::post('/insight-asset-update', [InsightAssetsController::class, 'updateAsset']);
                Route::post('/insight-asset-delete/{id}', [InsightAssetsController::class, 'deleteAsset']);
            });

            Route::group(['middleware' => ['permission:ASN Hardware Mapping']], function () {
                Route::resource('/insight-hardware-mapping', '\App\Http\Controllers\Asn\Insight\InsightHardwareMappingController');
                Route::post('/insight-hardware-mapping-store', [InsightHardwareMappingController::class, 'store']);
                Route::post('/insight-hardware-mapping/bulk-upload', [InsightHardwareMappingController::class, 'bulkUpload']);
                Route::get('/insight-hardware-mapping-resync', [InsightHardwareMappingController::class, 'resync'])->name('insight.resync');
                Route::post('/insight-hardware-mapping-search', [InsightHardwareMappingController::class, 'search'])->name('insight-mapping-search');
                Route::post('/insight-hardware-mapping-ajax', [InsightHardwareMappingController::class, 'ajax']);
            });

            Route::group(['middleware' => ['permission:ASN Accessories Mapping']], function () {
                Route::resource('/insight-accessories-mapping', '\App\Http\Controllers\Asn\Insight\InsightAccessoriesMappingController');
                Route::post('/insight-accessories-mapping/bulk-upload', [InsightAccessoriesMappingController::class, 'bulkUpload']);
                Route::post('/insight-accessories-mapping-ajax', [InsightAccessoriesMappingController::class, 'ajax']);
                Route::post('/insight-accessories-mapping-search', [InsightAccessoriesMappingController::class, 'search'])->name('insight-accessories-mapping-search');
                Route::get('/insight-accessories-mapping-resync', [InsightAccessoriesMappingController::class, 'resync'])->name('insight.accessories.resync');
                Route::post('/insight-asset-sync', [InsightAssetsController::class, 'sync']);
            });

            Route::group(['middleware' => ['permission:ASN Unwanted Parts Mapping']], function () {
                Route::resource('/insight-unwanted-parts', '\App\Http\Controllers\Asn\Insight\InsightUnwantedPartsController');
                Route::post('/insight-unwanted-parts/bulk-upload', [InsightUnwantedPartsController::class, 'bulkUpload']);
                Route::post('/insight-unwanted-parts-ajax', [InsightUnwantedPartsController::class, 'ajax']);
                Route::post('/insight-unwanted-parts-search', [InsightUnwantedPartsController::class, 'search'])->name('insight.unwanted-parts.search');
                Route::get('/insight-unwanted-parts-resync', [InsightUnwantedPartsController::class, 'resync'])->name('insight.unwanted-parts.resync');
            });

            Route::group(['middleware' => ['permission:ASN - Assets View']], function () {
                Route::resource('/asn-connection', '\App\Http\Controllers\Asn\Connection\ConnectionAssetsController');
                // Route::post('/receive-connection-asset-search', [ConnectionAssetsController:class,'search')->name('receive-connection-asset-search');
                Route::post('/receive-connection-assets-ajax', [ConnectionAssetsController::class, 'ajax']);
                Route::post('/receive-connection-asset/mark-as-received', [ConnectionAssetsController::class, 'markReceived']);
                Route::post('/connection-asset-export', [ConnectionAssetsController::class, 'export'])->name('connection-asset-export');
                Route::post('/receive-connection-asset/bulk-update', [ConnectionAssetsController::class, 'bulkUpdate']);
                Route::post('/connection-asset-get-hardware', [ConnectionAssetsController::class, 'getHardware']);
                Route::post('/connection-asset-get-tech-spec', [ConnectionAssetsController::class, 'getTechSpech']);
                Route::post('/connection-asset-sync', [ConnectionAssetsController::class, 'manualSync']);
                Route::post('/connection-data', [ConnectionAssetsController::class, 'data'])->name('connection-data');
                Route::post('/connection-asset-get/{id}', [ConnectionAssetsController::class, 'getAsset']);
                Route::post('/connection-asset-update', [ConnectionAssetsController::class, 'updateAsset']);
                Route::post('/connection-asset-delete/{id}', [ConnectionAssetsController::class, 'deleteAsset']);
                Route::post('/receive-connection-asset/single-item-receive', [ConnectionAssetsController::class, 'markSingleItemReceived'])->name('asn-connection-single-item-receive');
            });


            Route::group(['middleware' => ['permission:ASN Hardware Mapping']], function () {
                Route::resource('/connection-hardware-mapping', '\App\Http\Controllers\Asn\Connection\ConnectionHardwareMappingController');
                Route::post('/connection-hardware-mapping/bulk-upload', [ConnectionHardwareMappingController::class, 'bulkUpload']);
                Route::get('/connection-hardware-mapping-resync', [ConnectionHardwareMappingController::class, 'resync'])->name('connection.resync');
                Route::post('/connection-hardware-mapping-search', [ConnectionHardwareMappingController::class, 'search'])->name('connection-mapping-search');
                Route::post('/connection-hardware-mapping-ajax', [ConnectionHardwareMappingController::class, 'ajax']);
            });

            Route::group(['middleware' => ['permission:ASN Accessories Mapping']], function () {
                Route::resource('/connection-accessories-mapping', '\App\Http\Controllers\Asn\Connection\ConnectionAccessoriesMappingController');
                Route::post('/connection-accessories-mapping/bulk-upload', [ConnectionAccessoriesMappingController::class, 'bulkUpload']);
                Route::post('/connection-accessories-mapping-ajax', [ConnectionAccessoriesMappingController::class, 'ajax']);
                Route::post('/connection-accessories-mapping-search', [ConnectionAccessoriesMappingController::class, 'search'])->name('connection-accessories-mapping-search');
                Route::get('/connection-accessories-mapping-resync', [ConnectionAccessoriesMappingController::class, 'resync'])->name('connection.accessories.resync');
                Route::post('/connection-hardware-mapping-store', [ConnectionHardwareMappingController::class, 'store']);
            });

            Route::group(['middleware' => ['permission:ASN Unwanted Parts Mapping']], function () {
                Route::resource('/connection-unwanted-parts', '\App\Http\Controllers\Asn\Connection\ConnectionUnwantedPartsController');
                Route::post('/connection-unwanted-parts/bulk-upload', [ConnectionUnwantedPartsController::class, 'bulkUpload']);
                Route::post('/connection-unwanted-parts-ajax', [ConnectionUnwantedPartsController::class, 'ajax']);
                Route::post('/connection-unwanted-parts-search', [ConnectionUnwantedPartsController::class, 'search'])->name('connection-unwanted-parts-search');
                Route::get('/connection-unwanted-parts-resync', [ConnectionUnwantedPartsController::class, 'resync'])->name('connection.unwanted-parts.resync');
            });

            Route::group(['middleware' => ['permission:ASN - Assets View']], function () {
                Route::resource('/asn-shi', '\App\Http\Controllers\Asn\Shi\ShiAssetsController');
                Route::post('/shi-data', [ShiAssetsController::class, 'data'])->name('shi-data');
                Route::post('/shi-asset-export', [ShiAssetsController::class, 'export'])->name('shi-asset-export');
                Route::post('/shi-asset-sync', [ShiAssetsController::class, 'manualSync']);
                Route::post('/shi-asset-get/{id}', [ShiAssetsController::class, 'getAsset']);
                Route::post('/shi-asset-get-hardware', [ShiAssetsController::class, 'getHardware']);
                Route::post('/shi-asset-get-tech-spec', [ShiAssetsController::class, 'getTechSpech']);
                Route::post('/shi-asset-update', [ShiAssetsController::class, 'updateAsset']);
                Route::post('/shi-asset-delete/{id}', [ShiAssetsController::class, 'deleteAsset']);
                Route::post('/shi-asset-receive', [ShiAssetsController::class, 'markReceived'])->name('shi.asset-receive');
                Route::post('/shi-single-item-receive', [ShiAssetsController::class, 'markSingleItemReceived']);
            });


            Route::group(['middleware' => ['permission:ASN Hardware Mapping']], function () {
                Route::resource('/shi-hardware-mapping', '\App\Http\Controllers\Asn\Shi\ShiHardwareMappingController');
                Route::post('/shi-hardware-mapping/bulk-upload', [ShiHardwareMappingController::class, 'bulkUpload']);
                Route::post('/shi-hardware-mapping-ajax', [ShiHardwareMappingController::class, 'ajax']);
                Route::post('/shi-hardware-mapping-search', [ShiHardwareMappingController::class, 'search'])->name('shi.hardware-mapping.search');
                Route::get('/shi-hardware-mapping-resync', [ShiHardwareMappingController::class, 'resync'])->name('shi.hardware-mapping.resync');
                Route::post('/shi-hardware-mapping-store', [ShiHardwareMappingController::class, 'store'])->name('shi.hardware-mapping.store');
            });

            Route::group(['middleware' => ['permission:ASN Accessories Mapping']], function () {
                Route::resource('/shi-accessories-mapping', '\App\Http\Controllers\Asn\Shi\ShiAccessoriesMappingController');
                Route::post('/shi-accessories-mapping/bulk-upload', [ShiAccessoriesMappingController::class, 'bulkUpload']);
                Route::post('/shi-accessories-mapping-ajax', [ShiAccessoriesMappingController::class, 'ajax']);
                Route::post('/shi-accessories-mapping-search', [ShiAccessoriesMappingController::class, 'search'])->name('shi.accessories-mapping.search');
                Route::get('/shi-accessories-mapping-resync', [ShiAccessoriesMappingController::class, 'resync'])->name('shi.accessories-mapping.resync');
            });

            Route::group(['middleware' => ['permission:ASN Unwanted Parts Mapping']], function () {
                Route::resource('/shi-unwanted-parts', '\App\Http\Controllers\Asn\Shi\ShiUnwantedPartsController');
                Route::post('/shi-unwanted-parts/bulk-upload', [ShiUnwantedPartsController::class, 'bulkUpload']);
                Route::post('/shi-unwanted-parts-ajax', [ShiUnwantedPartsController::class, 'ajax']);
                Route::post('/shi-unwanted-parts-search', [ShiUnwantedPartsController::class, 'search'])->name('shi.unwanted-parts.search');
                Route::get('/shi-unwanted-parts-resync', [ShiUnwantedPartsController::class, 'resync'])->name('shi.unwanted-parts.resync');
            });
            */
        });


        Route::group(['prefix' => 'discovery-tools'], function () {
            Route::group(['middleware' => ['permission:Discovery Tools']], function () {
                /*
                Route::group(['prefix' => 'workspace-one'], function () {
                    Route::get('all-workspace-one-report', [AllWorkspaceOneController::class, 'index']);
                    Route::post('all-workspace-one-report', [AllWorkspaceOneController::class, 'data'])->name('all-workspace-one-report-data');
                    Route::post('/all-workspace-one/export', [AllWorkspaceOneController::class, 'export'])->name('all-workspace-one-report-export');

                    Route::get('checking-in-not-created', [WorkspaceOneCheckingInNotCreatedController::class, 'index']);
                    Route::post('checking-in-not-created', [WorkspaceOneCheckingInNotCreatedController::class, 'data'])->name('workspace-one-assets-not-created-data');
                    Route::post('/checking-in-not-created/export', [WorkspaceOneCheckingInNotCreatedController::class, 'export'])->name('devicesNotCreatedExport');
                    Route::post('/create-workspace-one-asset', [WorkspaceOneCheckingInNotCreatedController::class, 'create'])->name('workspace-one-assets-create');


                    Route::get('user-discrepancy', [WorkspaceOneUserDiscrepancyController::class, 'index']);
                    Route::post('user-discrepancy', [WorkspaceOneUserDiscrepancyController::class, 'data'])->name('user-discrepancy-data');
                    Route::post('user-mismatch/export', [WorkspaceOneUserDiscrepancyController::class, 'export'])->name('userMismatchExport');

                    Route::get('not-checking-in-managed', [WorkspaceOneDevicesNotActiveController::class, 'index']);
                    Route::post('not-checking-in-managed', [WorkspaceOneDevicesNotActiveController::class, 'data'])->name('not-checking-in-managed');
                    Route::post('/not-checking-in-managed/export', [WorkspaceOneDevicesNotActiveController::class, 'export'])->name('devicesInactiveExport');

                    Route::get('not-checking-in-not-managed', [WorkspaceOneDevicesNotManagedController::class, 'index'])->name('not-checking-in-not-managed');
                    Route::post('not-checking-in-not-managed', [WorkspaceOneDevicesNotManagedController::class, 'data'])->name('not-checking-in-not-managed-data');
                    Route::post('/not-checking-in-not-managed/export', [WorkspaceOneDevicesNotManagedController::class, 'export'])->name('not-checking-in-not-managed-export');

                    Route::get('devices-on-hand-checking-in', [WorkspaceOneDevicesOnHandCheckedInController::class, 'index'])->name('devices-on-hand-checked-in');
                    Route::post('devices-on-hand-checking-in', [WorkspaceOneDevicesOnHandCheckedInController::class, 'data'])->name('devices-on-hand-checked-in-data');
                    Route::post('/devices-on-hand-checking-in/export', [WorkspaceOneDevicesOnHandCheckedInController::class, 'export'])->name('devices-on-hand-checked-in-export');

                    Route::get('mobile-number', [MobileNumberController::class, 'index'])->name('workspace-one-mobile-number');
                    Route::post('mobile-number', [MobileNumberController::class, 'data'])->name('workspace-one-mobile-number-data');
                    Route::post('/mobile-number/export', [MobileNumberController::class, 'export'])->name('workspace-one-mobile-number-export');
                });

                Route::group(['prefix' => 'chrome-devices'], function () {

                    Route::get('all-chrome-devices-report', [AllChromeBookController::class, 'index']);
                    Route::post('all-chrome-devices-report', [AllChromeBookController::class, 'data'])->name('all-chrome-devices-report-data');
                    Route::post('/all-chrome-devices/export', [AllChromeBookController::class, 'export'])->name('all-chrome-devices-report-export');

                    Route::get('checking-in-not-created', [CheckingInNotCreatedController::class, 'index']);
                    Route::post('checking-in-not-created', [CheckingInNotCreatedController::class, 'data'])->name('chrome-devices-checking-in-not-created-data');
                    Route::post('/chrome-devices-checking-in-not-created/export', [CheckingInNotCreatedController::class, 'export'])->name('chrome-devices-checking-in-not-created-export');
                    Route::post('/create-chrome-devices-asset', [CheckingInNotCreatedController::class, 'create'])->name('chrome-devices-assets-create');

                    Route::get('user-discrepancy', [CheckingInUserDiscrepancyController::class, 'index']);
                    Route::post('user-discrepancy', [CheckingInUserDiscrepancyController::class, 'data'])->name('chrombook-user-discrepancy-data');
                    Route::post('user-mismatch/export', [CheckingInUserDiscrepancyController::class, 'export'])->name('chrome-devices-user-mismatch-export');

                    Route::get('not-checking-in-managed', [NotCheckingInManagedController::class, 'index']);
                    Route::post('not-checking-in-managed', [NotCheckingInManagedController::class, 'data'])->name('chrome-devices-not-checking-in-managed');
                    Route::post('/not-checking-in-managed/export', [NotCheckingInManagedController::class, 'export'])->name('chrome-devices-not-checking-in-managed-export');

                    Route::get('not-checking-in-not-managed', [NotCheckingInNotManagedController::class, 'index'])->name('chrome-devices-not-checking-in-not-managed');
                    Route::post('not-checking-in-not-managed', [NotCheckingInNotManagedController::class, 'data'])->name('chrome-devices-not-checking-in-not-managed-data');
                    Route::post('/not-checking-in-not-managed/export', [NotCheckingInNotManagedController::class, 'export'])->name('chrome-devices-not-checking-in-not-managed-export');

                    Route::get('chrome-devices-checking-in-on-hand', [CheckingInOnHandController::class, 'index'])->name('chrome-devices-checking-in-on-hand');
                    Route::post('chrome-devices-checking-in-on-hand', [CheckingInOnHandController::class, 'data'])->name('chrome-devices-checking-in-on-hand-data');
                    Route::post('/chrome-devices-checking-in-on-hand/export', [CheckingInOnHandController::class, 'export'])->name('chrome-devices-checking-in-on-hand-export');
                });
                */


                Route::group(['prefix' => 'intune'], function () {
                    Route::get('checking-in-not-created', [IntuneDevicesNotCreatedController::class, 'index']);
                    Route::post('checking-in-not-created', [IntuneDevicesNotCreatedController::class, 'data'])->name('intune-assets-not-created-data');
                    Route::post('/checking-in-not-created/export', [IntuneDevicesNotCreatedController::class, 'export'])->name('intune-assets-not-created-export');
                    Route::get('/get-filter-fields-intune', [IntuneIndexController::class, 'getFilterFields']);
                    Route::post('/create-intune-asset', [IntuneDevicesNotCreatedController::class, 'create'])->name('intune-assets-create');

                    Route::get('user-discrepancy', [IntuneUserDiscrepancyController::class, 'index']);
                    Route::post('user-discrepancy', [IntuneUserDiscrepancyController::class, 'data'])->name('intune-user-discrepancy');
                    Route::post('/intune-user-discrepancy/export', [IntuneUserDiscrepancyController::class, 'export'])->name('intune-user-discrepancy-export');

                    Route::get('not-checking-in-managed', [IntuneDevicesNotActiveController::class, 'index']);
                    Route::post('not-checking-in-managed', [IntuneDevicesNotActiveController::class, 'data'])->name('not-checking-in-managed-data');
                    Route::post('/not-checking-in-managed/export', [IntuneDevicesNotActiveController::class, 'export'])->name('not-checking-in-managed-export');

                    Route::get('checking-in-on-hand', [IntuneCheckingInOnHandController::class, 'index']);
                    Route::post('checking-in-on-hand', [IntuneCheckingInOnHandController::class, 'data'])->name('intune-checking-in-on-hand-data');
                    Route::post('checking-in-on-hand/export', [IntuneCheckingInOnHandController::class, 'export'])->name('intune-checking-in-on-hand-export');

                    Route::get('all-report', [AllIntuneController::class, 'index']);
                    Route::post('all-report', [AllIntuneController::class, 'data'])->name('all-intune-report-data');
                    Route::post('/all-report/export', [AllIntuneController::class, 'export'])->name('all-intune-report-export');

                    Route::get('not-checking-in-not-managed', [IntuneDevicesNotManagedController::class, 'index'])->name('intune-not-checking-in-not-managed');
                    Route::post('not-checking-in-not-managed', [IntuneDevicesNotManagedController::class, 'data'])->name('intune-not-checking-in-not-managed-data');
                    Route::post('/not-checking-in-not-managed/export', [IntuneDevicesNotManagedController::class, 'export'])->name('intune-not-checking-in-not-managed-export');
                });

                /*
                Route::group(['prefix' => 'jamf'], function () {
                    Route::get('checking-in-not-created', [JamfDevicesNotCreatedController::class, 'index']);
                    Route::post('checking-in-not-created', [JamfDevicesNotCreatedController::class, 'data'])->name('jamf-checking-in-not-created-data');
                    Route::post('/checking-in-not-created/export', [JamfDevicesNotCreatedController::class, 'export'])->name('jamf-checking-in-not-created-export');
                    Route::get('/get-filter-fields-jamf', [JamfIndexController::class, 'getFilterFields']);
                    Route::post('/create-jamf-asset', [JamfDevicesNotCreatedController::class, 'create'])->name('jamf-assets-create');

                    Route::get('checking-in-user-discrepancy', [JamfUserDiscrepancyController::class, 'index']);
                    Route::post('checking-in-user-discrepancy', [JamfUserDiscrepancyController::class, 'data'])->name('jamf-checking-in-user-discrepancy');
                    Route::post('/jamf-checking-in-user-discrepancy/export', [JamfUserDiscrepancyController::class, 'export'])->name('jamf-checking-in-user-discrepancy-export');

                    Route::get('not-checking-in-managed', [JamfDevicesNotActiveController::class, 'index']);
                    Route::post('not-checking-in-managed', [JamfDevicesNotActiveController::class, 'data'])->name('jamf-not-checking-in-managed-data');
                    Route::post('/not-checking-in-managed/export', [JamfDevicesNotActiveController::class, 'export'])->name('jamf-not-checking-in-managed-export');

                    Route::get('checking-in-on-hand', [JamfDevicesOnHandCheckedInController::class, 'index']);
                    Route::post('checking-in-on-hand', [JamfDevicesOnHandCheckedInController::class, 'data'])->name('jamf-checking-in-on-hand-data');
                    Route::post('checking-in-on-hand/export', [JamfDevicesOnHandCheckedInController::class, 'export'])->name('jamf-devices-checking-in-on-hand-export');

                    Route::get('all-report', [AllJamfController::class, 'index']);
                    Route::post('all-report', [AllJamfController::class, 'data'])->name('all-jamf-report-data');
                    Route::post('/all-report/export', [AllJamfController::class, 'export'])->name('all-jamf-report-export');

                    Route::get('not-checking-in-not-managed', [JamfDevicesNotManagedController::class, 'index'])->name('jamf-not-checking-in-not-managed');
                    Route::post('not-checking-in-not-managed', [JamfDevicesNotManagedController::class, 'data'])->name('jamf-not-checking-in-not-managed-data');
                    Route::post('/not-checking-in-not-managed/export', [JamfDevicesNotManagedController::class, 'export'])->name('jamf-not-checking-in-not-managed-export');

                    Route::get('prestage-devices', [PreStageDevicesController::class, 'index'])->name('jamf-prestage-devices');
                    Route::post('prestage-devices', [PreStageDevicesController::class, 'data'])->name('jamf-prestage-devices-data');
                    Route::post('/prestage-devices/export', [PreStageDevicesController::class, 'export'])->name('jamf-prestage-devices-export');
                });

                Route::group(['prefix' => 'kandji'], function () {
                    Route::get('all-report', [AllKandjiController::class, 'index'])->name('kandji-all-report');
                    Route::post('all-report', [AllKandjiController::class, 'data'])->name('kandji-all-report-data');
                    Route::post('/all-report/export', [AllKandjiController::class, 'export'])->name('kandji-all-report-export');

                    Route::get('checking-in-not-created', [KandjiDevicesNotCreatedController::class, 'index'])->name('kandji-checking-in-not-created');
                    Route::post('checking-in-not-created', [KandjiDevicesNotCreatedController::class, 'data'])->name('kandji-checking-in-not-created-data');
                    Route::post('/checking-in-not-created/export', [KandjiDevicesNotCreatedController::class, 'export'])->name('kandji-checking-in-not-created-export');
                    Route::post('/create-kandji-asset', [KandjiDevicesNotCreatedController::class, 'create'])->name('kandji-assets-create');

                    Route::get('checking-in-user-discrepancy', [KandjiUserDiscrepancyController::class, 'index'])->name('kandji-checking-in-user-discrepancy');
                    Route::post('checking-in-user-discrepancy', [KandjiUserDiscrepancyController::class, 'data'])->name('kandji-checking-in-user-discrepancy-data');
                    Route::post('checking-in-user-discrepancy/export', [KandjiUserDiscrepancyController::class, 'export'])->name('kandji-checking-in-user-discrepancy-export');

                    Route::get('not-checking-in-managed', [KandjiDevicesNotActiveController::class, 'index'])->name('kandji-not-checking-in-managed');
                    Route::post('not-checking-in-managed', [KandjiDevicesNotActiveController::class, 'data'])->name('kandji-not-checking-in-managed-data');
                    Route::post('/not-checking-in-managed/export', [KandjiDevicesNotActiveController::class, 'export'])->name('kandji-not-checking-in-managed-export');

                    Route::get('checking-in-on-hand', [KandjiDevicesOnHandCheckingInController::class, 'index'])->name('kandji-checking-in-on-hand');
                    Route::post('checking-in-on-hand', [KandjiDevicesOnHandCheckingInController::class, 'data'])->name('kandji-checking-in-on-hand-data');
                    Route::post('/checking-in-on-hand/export', [KandjiDevicesOnHandCheckingInController::class, 'export'])->name('kandji-checking-in-on-hand-export');

                    Route::get('not-checking-in-not-managed', [KandjiDevicesNotManagedController::class, 'index'])->name('kandji-not-checking-in-not-managed');
                    Route::post('not-checking-in-not-managed', [KandjiDevicesNotManagedController::class, 'data'])->name('kandji-not-checking-in-not-managed-data');
                    Route::post('/not-checking-in-not-managed/export', [KandjiDevicesNotManagedController::class, 'export'])->name('kandji-not-checking-in-not-managed-export');

                    Route::get('/get-filter-fields-kandji', [KandjiIndexController::class, 'getFilterFields']);
                });

                Route::group(['prefix' => 'mobileiron'], function () {
                    Route::get('all-report', [AllMobileIronController::class, 'index'])->name('all-mobileiron-report');
                    Route::post('all-report', [AllMobileIronController::class, 'data'])->name('all-mobileiron-report-data');
                    Route::post('/all-report/export', [AllMobileIronController::class, 'export'])->name('all-mobileiron-report-export');

                    Route::get('checking-in-not-created', [MobileIronDevicesNotCreatedController::class, 'index'])->name('mobileiron-checking-in-not-created');
                    Route::post('checking-in-not-created', [MobileIronDevicesNotCreatedController::class, 'data'])->name('mobileiron-checking-in-not-created-data');
                    Route::post('/checking-in-not-created/export', [MobileIronDevicesNotCreatedController::class, 'export'])->name('mobileiron-checking-in-not-created-export');
                    Route::post('/create-mobile-iron-asset', [MobileIronDevicesNotCreatedController::class, 'create'])->name('mobile-iron-assets-create');

                    Route::get('checking-in-user-discrepancy', [MobileIronUserDiscrepancyController::class, 'index'])->name('mobileiron-checking-in-user-discrepancy');
                    Route::post('checking-in-user-discrepancy', [MobileIronUserDiscrepancyController::class, 'data'])->name('mobileiron-checking-in-user-discrepancy-data');
                    Route::post('checking-in-user-discrepancy/export', [MobileIronUserDiscrepancyController::class, 'export'])->name('mobileiron-checking-in-user-discrepancy-export');

                    Route::get('not-checking-in-managed', [MobileIronDevicesNotActiveController::class, 'index'])->name('mobileiron-not-checking-in-managed');
                    Route::post('not-checking-in-managed', [MobileIronDevicesNotActiveController::class, 'data'])->name('mobileiron-not-checking-in-managed-data');
                    Route::post('/not-checking-in-managed/export', [MobileIronDevicesNotActiveController::class, 'export'])->name('mobileiron-not-checking-in-managed-export');

                    Route::get('checking-in-on-hand', [MobileIronDevicesOnHandCheckingInController::class, 'index'])->name('mobileiron-checking-in-on-hand');
                    Route::post('checking-in-on-hand', [MobileIronDevicesOnHandCheckingInController::class, 'data'])->name('mobileiron-checking-in-on-hand-data');
                    Route::post('/checking-in-on-hand/export', [MobileIronDevicesOnHandCheckingInController::class, 'export'])->name('mobileiron-checking-in-on-hand-export');

                    Route::get('not-checking-in-not-managed', [MobileIronDevicesNotManagedController::class, 'index'])->name('mobileiron-not-checking-in-not-managed');
                    Route::post('not-checking-in-not-managed', [MobileIronDevicesNotManagedController::class, 'data'])->name('mobileiron-not-checking-in-not-managed-data');
                    Route::post('/not-checking-in-not-managed/export', [MobileIronDevicesNotManagedController::class, 'export'])->name('mobileiron-not-checking-in-not-managed-export');

                    Route::get('mobile-number', [MobileIronMobileNumberController::class, 'index'])->name('mobileiron-mobile-number');
                    Route::post('mobile-number', [MobileIronMobileNumberController::class, 'data'])->name('mobileiron-mobile-number-data');
                    Route::post('/mobile-number/export', [MobileIronMobileNumberController::class, 'export'])->name('mobileiron-mobile-number-export');

                    Route::get('/get-filter-fields-mobile-iron', [MobileIronIndexController::class, 'getFilterFields']);
                });

                Route::group(['prefix' => 'jumpcloud'], function () {
                    Route::get('all-report', [AllJumpCloudController::class, 'index'])->name('all-jumpcloud-report');
                    Route::post('all-report', [AllJumpCloudController::class, 'data'])->name('all-jumpcloud-report-data');
                    Route::post('/all-report/export', [AllJumpCloudController::class, 'export'])->name('all-jumpcloud-report-export');

                    Route::get('checking-in-not-created', [JumpCloudNotCreatedController::class, 'index'])->name('jumpcloud-checking-in-not-created');
                    Route::post('checking-in-not-created', [JumpCloudNotCreatedController::class, 'data'])->name('jumpcloud-checking-in-not-created-data');
                    Route::post('/checking-in-not-created/export', [JumpCloudNotCreatedController::class, 'export'])->name('jumpcloud-checking-in-not-created-export');
                    Route::post('/create-jumpcloud-asset', [JumpCloudNotCreatedController::class, 'create'])->name('jumpcloud-assets-create');

                    Route::get('checking-in-user-discrepancy', [JumpCloudUserDiscrepancyController::class, 'index'])->name('jumpcloud-checking-in-user-discrepancy');
                    Route::post('checking-in-user-discrepancy', [JumpCloudUserDiscrepancyController::class, 'data'])->name('jumpcloud-checking-in-user-discrepancy-data');
                    Route::post('checking-in-user-discrepancy/export', [JumpCloudUserDiscrepancyController::class, 'export'])->name('jumpcloud-checking-in-user-discrepancy-export');

                    Route::get('not-checking-in-managed', [JumpCloudNotActiveController::class, 'index'])->name('jumpcloud-not-checking-in-managed');
                    Route::post('not-checking-in-managed', [JumpCloudNotActiveController::class, 'data'])->name('jumpcloud-not-checking-in-managed-data');
                    Route::post('/not-checking-in-managed/export', [JumpCloudNotActiveController::class, 'export'])->name('jumpcloud-not-checking-in-managed-export');

                    Route::get('checking-in-on-hand', [JumpCloudOnHandCheckingInController::class, 'index'])->name('jumpcloud-checking-in-on-hand');
                    Route::post('checking-in-on-hand', [JumpCloudOnHandCheckingInController::class, 'data'])->name('jumpcloud-checking-in-on-hand-data');
                    Route::post('/checking-in-on-hand/export', [JumpCloudOnHandCheckingInController::class, 'export'])->name('jumpcloud-checking-in-on-hand-export');

                    Route::get('not-checking-in-not-managed', [JumpCloudNotManagedController::class, 'index'])->name('jumpcloud-not-checking-in-not-managed');
                    Route::post('not-checking-in-not-managed', [JumpCloudNotManagedController::class, 'data'])->name('jumpcloud-not-checking-in-not-managed-data');
                    Route::post('/not-checking-in-not-managed/export', [JumpCloudNotManagedController::class, 'export'])->name('jumpcloud-not-checking-in-not-managed-export');

                    Route::get('/get-filter-fields-jumpcloud', [JumpCloudController::class, 'getFilterFields']);
                });
                */

                Route::group(['prefix' => 'zoom'], function () {
                    Route::get('/get-filter-fields', 'DiscoveryTools\Zoom\IndexController@getFilterFields');
                    Route::post('/get-issue-detail/{id}', 'DiscoveryTools\Zoom\IndexController@getIssueDetail');
                    Route::post('/get-av-detail/{id}', 'DiscoveryTools\Zoom\IndexController@getAvDetail');
                    //ALL REPORT
                    Route::get('all-report', 'DiscoveryTools\Zoom\AllReportController@index');
                    Route::post('all-report', 'DiscoveryTools\Zoom\AllReportController@data')->name('zoom-all-report-data');
                    Route::post('/all-report/export', 'DiscoveryTools\Zoom\AllReportController@export')->name('zoom-all-report-export');
                    //Devices Not Created
                    Route::get('devices-not-created', 'DiscoveryTools\Zoom\DevicesNotCreatedController@index');
                    Route::post('devices-not-created', 'DiscoveryTools\Zoom\DevicesNotCreatedController@data')->name('zoom-assets-not-created-data');
                    Route::post('/devices-not-created/export', 'DiscoveryTools\Zoom\DevicesNotCreatedController@export')->name('zoom-assets-not-created-export');
                    //Devices Not Active
                    Route::get('devices-not-active', 'DiscoveryTools\Zoom\DevicesNotActiveController@index');
                    Route::post('devices-not-active', 'DiscoveryTools\Zoom\DevicesNotActiveController@data')->name('zoom-assets-not-active-data');
                    Route::post('/devices-not-active/export', 'DiscoveryTools\Zoom\DevicesNotActiveController@export')->name('zoom-assets-not-active-export');
                    //DevicesOnHand
                    Route::get('devices-on-hand-checking-in', 'DiscoveryTools\Zoom\DevicesOnHandController@index')->name('zoom-devices-on-hand-checked-in');
                    Route::post('devices-on-hand-checking-in', 'DiscoveryTools\Zoom\DevicesOnHandController@data')->name('zoom-devices-on-hand-checked-in-data');
                    Route::post('/devices-on-hand-checking-in/export', 'DiscoveryTools\Zoom\DevicesOnHandController@export')->name('zoom-devices-on-hand-checked-in-export');
                    //DevicesNotManaged
                    Route::get('location-discrepancy', 'DiscoveryTools\Zoom\DevicesLocationDiscrepancyController@index')->name('zoom-location-discrepancy');
                    Route::post('location-discrepancy', 'DiscoveryTools\Zoom\DevicesLocationDiscrepancyController@data')->name('zoom-location-discrepancy-data');
                    Route::post('/location-discrepancy/export', 'DiscoveryTools\Zoom\DevicesLocationDiscrepancyController@export')->name('zoom-location-discrepancy-export');
                });
            });
        });

        Route::group(['middleware' => ['permission:Crowdstrike Reports View']], function () {
            Route::get('/crowdstrike/sensor-detection', [SensorDetectionReportController::class, 'index']);
            Route::post('/crowdstrike/sensor-detection-data', [SensorDetectionReportController::class, 'data'])->name('sensor-detection-data');
            Route::post('/crowdstrike/sensor-detection/export', [SensorDetectionReportController::class, 'export'])->name('sensor-detection-export');

            Route::get('/crowdstrike/sensor-vulnerabilities', [SensorVulnerabilityReportController::class, 'index']);
            Route::post('/crowdstrike/sensor-vulnerability-data', [SensorVulnerabilityReportController::class, 'data'])->name('sensor-vulnerability-data');
            Route::post('/crowdstrike/sensor-vulnerability/export', [SensorVulnerabilityReportController::class, 'export'])->name('sensor-vulnerability-export');


            Route::get('/crowdstrike/active-cves', [ActiveCveReportController::class, 'index']);
            Route::post('/crowdstrike/active-cve-data', [ActiveCveReportController::class, 'data'])->name('active-cves-data');
            Route::post('/crowdstrike/active-cve-export', [ActiveCveReportController::class, 'export'])->name('active-cves-export');

            Route::get('/crowdstrike/active-cve/{id}', [ActiveCveController::class, 'getSingleActiveCveDetails'])->name('active-cve.details');
        });

        Route::group(['middleware' => ['permission:Toolbox View']], function () {
            Route::view('/toolbox', 'toolbox.index')->name('toolbox');
        });

        Route::group(['middleware' => ['permission:Software Assets Category View']], function () {
            Route::resource('/software-assets-categories', '\App\Http\Controllers\SoftwareLicense\SoftwareLicenseCategoryController', ['only' => 'index']);
            Route::post('/software-assets-category-search', [SoftwareLicenseCategoryController::class, 'search'])->name('software-assets-category-search');
        });

        Route::group(['middleware' => ['permission:Software Assets Category Manage']], function () {
            Route::resource('/software-assets-categories', '\App\Http\Controllers\SoftwareLicense\SoftwareLicenseCategoryController', ['except' => 'index']);
            Route::post('/software-assets-category-ajax', [SoftwareLicenseCategoryController::class, 'ajax']);
        });

        Route::group(['middleware' => ['permission:Software Assets Manufacturer Manage']], function () {
            Route::resource('/software-assets-manufacturers', '\App\Http\Controllers\SoftwareLicense\SoftwareLicenseManufacturerController', ['only' => 'index']);
            Route::post('/software-assets-manufacturer-search', [SoftwareLicenseManufacturerController::class, 'search'])->name('software-assets-manufacturer-search');
        });

        Route::group(['middleware' => ['permission:Software Assets Manufacturer Manage']], function () {
            Route::resource('/software-assets-manufacturers', '\App\Http\Controllers\SoftwareLicense\SoftwareLicenseManufacturerController', ['except' => 'index']);
            Route::post('/software-assets-manufacturer-ajax', [SoftwareLicenseManufacturerController::class, 'ajax']);
        });

        Route::group(['middleware' => ['permission:Software Assets Subscription Manage']], function () {
            Route::resource('/software-assets-subscription', '\App\Http\Controllers\SoftwareLicense\SoftwareLicenseSubscriptionController', ['only' => 'index']);
            Route::post('/software-assets-subscription-search', [SoftwareLicenseSubscriptionController::class, 'search'])->name('software-assets-subscription-search');
            Route::resource('/software-assets-subscription', '\App\Http\Controllers\SoftwareLicense\SoftwareLicenseSubscriptionController', ['except' => 'index']);
            Route::post('/software-assets-subscription-ajax', [SoftwareLicenseSubscriptionController::class, 'ajax']);
        });

        Route::group(['middleware' => ['permission:Software Assets View']], function () {
            Route::resource('/software-assets', '\App\Http\Controllers\SoftwareLicense\SoftwareLicenseController', ['only' => 'index']);
            Route::post('/software-assets-data', [SoftwareLicenseController::class, 'data'])->name('software-assets.data');
            Route::post('/software-assets-delete', [SoftwareLicenseController::class, 'delete'])->name('software-assets.delete');
        });

        Route::group(['middleware' => ['permission:Software Assets Manage']], function () {
            Route::resource('/software-assets', '\App\Http\Controllers\SoftwareLicense\SoftwareLicenseController', ['except' => 'index']);
            Route::group(['prefix' => 'software-assets'], function () {
                Route::post('/users', [SoftwareLicenseUserController::class, 'list'])->name('software-assets.users');
                Route::post('/non-teq-users', [SoftwareLicenseUserController::class, 'nonTeqtivityUsers'])->name('software-assets.non-teq-users');
                Route::post('/add-users', [SoftwareLicenseUserController::class, 'add'])->name('software-assets.users.add');
                Route::post('/remove-user', [SoftwareLicenseUserController::class, 'remove'])->name('software-license.users.remove');
                Route::post('/users/export', [SoftwareLicenseUserController::class, 'export'])->name('software-assets.users.export');
                Route::post('/non-teq-users/export', [SoftwareLicenseUserController::class, 'nonTeqUsersExport'])->name('software-assets.non-teq-users.export');

                Route::post('/documents', [SoftwareLicenseDocumentController::class, 'list'])->name('software-assets.documents');
                Route::post('/remove-document', [SoftwareLicenseDocumentController::class, 'remove'])->name('software-assets.document.remove');
                Route::get('/{id}/download-document', [SoftwareLicenseDocumentController::class, 'download'])->name('software-assets.document.download');
                Route::post('/add-documents', [SoftwareLicenseDocumentController::class, 'add'])->name('software-assets.documents.add');

                Route::post('/keys', [SoftwareLicenseKeyController::class, 'list'])->name('software-assets.keys');
                Route::post('/remove-key', [SoftwareLicenseKeyController::class, 'remove'])->name('software-assets.key.remove');
                Route::get('/{id}/download-key-document', [SoftwareLicenseKeyController::class, 'download'])->name('software-assets.key.download');
                Route::post('/add-keys', [SoftwareLicenseKeyController::class, 'add'])->name('software-assets.key.add');
                Route::post('/edit-keys', [SoftwareLicenseKeyController::class, 'editIndividual'])->name('software-assets.key.edit');
                Route::post('/edit-keys-store', [SoftwareLicenseKeyController::class, 'updateIndividual'])->name('software-assets.key.edit-store');

                Route::post('/bulk-upload', [SoftwareLicenseBulkUploadController::class, 'bulkUpload'])->name('software-assets.bulk-upload');
                Route::post('/bulk-insert', [SoftwareLicenseBulkUploadController::class, 'store'])->name('software-assets.bulk.store');
            });


            Route::group(['prefix' => 'zoom-meetings'], function () {
                Route::get('/member-hosted-meetings/{userId}', [ZoomMeetingController::class, 'getMonthlyUserMeetings'])->name('member-hosted-meetings');
                Route::post('/member-hosted-meetings-data', [ZoomMeetingController::class, 'getMonthlyUserMeetingsData'])->name('member-hosted-meetings-data');
            });
        });

        Route::group(['middleware' => ['permission:Settings View']], function () {

            Route::view('/settings', 'settings.index')->name('settings');

            Route::group(['prefix' => 'settings'], function () {
                Route::get('/system-history', [SystemHistoryController::class, 'index'])->name('system-history.index');
                Route::post('/system-history', [SystemHistoryController::class, 'data'])->name('system-history.data');
                Route::get('/user-history', [UserHistoryController::class, 'index'])->name('user-history.index');
                Route::post('/user-history-data', [UserHistoryController::class, 'data'])->name('user-history.data');
                Route::get('/location-history', [LocationHistoryController::class, 'index'])->name('location-history.index');
                Route::post('/location-history-data', [LocationHistoryController::class, 'data'])->name('location-history.data');
                Route::get('/api-request-history', [ApiRequestHistoryController::class, 'index'])->name('api-request-history.index');
                Route::post('/api-request-history-data', [ApiRequestHistoryController::class, 'data'])->name('api-request-history.data');

                Route::get('/software-asset-history', [SoftwareAssetHistoryController::class, 'index'])->name('software-asset-history.index');
                Route::post('/software-asset-history-data', [SoftwareAssetHistoryController::class, 'data'])->name('software-asset-history.data');

                Route::group(['middleware' => ['permission:User Login History']], function () {
                    Route::get('/user-login-history', [UserLoginHistoryController::class, 'index'])->name('user-login-history.index');
                    Route::post('/user-login-history', [UserLoginHistoryController::class, 'data'])->name('user-login-history.data');
                    Route::post('/user-login-history-export', [UserLoginHistoryController::class, 'export'])->name('user-login-history.export');
                });

                Route::group(['middleware' => ['permission:API Users View']], function () {
                    Route::get('/api-history-blocked-ip-addresses', [ApiBlockedIpsController::class, 'index'])->name('api-blocked-ips.index');
                    Route::post('/api-history-blocked-ip-addresses', [ApiBlockedIpsController::class, 'data'])->name('api-blocked-ips.data');
                });

                Route::group(['middleware' => ['permission:API Users Manage']], function () {
                    Route::post('/api-history-unblock-ip', [ApiBlockedIpsController::class, 'unblock'])->name('api-blocked-ips.unblock');
                });

                Route::get('/user-role-change-history', [UserRoleChangeHistoryController::class, 'index'])->name('user-role-change-history.index');
                Route::post('/user-role-change-history-data', [UserRoleChangeHistoryController::class, 'data'])->name('user-role-change-history.data');
                Route::post('/user-role-change-history-export', [UserRoleChangeHistoryController::class, 'export'])->name('user-role-change-history.export');

                Route::group(['middleware' => ['permission:Purge Assets']], function () {
                    Route::get('/purged-assets-history', [PurgedAssetHistoryController::class, 'index'])->name('purged-assets-history.index');
                    Route::post('/purged-assets-history-data', [PurgedAssetHistoryController::class, 'data'])->name('purged-assets-history.data');
                });
            });

            Route::group(['middleware' => ['permission:ASN History']], function () {
                Route::get('/asn-history', [\App\Http\Controllers\Asn\AsnHistoryController::class, 'index']);
                Route::get('/asn-history/get-data', [\App\Http\Controllers\Asn\AsnHistoryController::class, 'getData']);
                Route::post('/asn-history/resync-file', [\App\Http\Controllers\Asn\AsnHistoryController::class, 'reSyncFile']);
                Route::get('/asn-history/download-file', [\App\Http\Controllers\Asn\AsnHistoryController::class, 'downloadFile'])->name('asn-history.download-file');
            });

            Route::group(['middleware' => ['permission:Hardware Kits View']], function () {
                Route::get('/hardware-kits', [HardwarekitController::class, 'index'])->name('hardware-kits');
                Route::post('/hardware-kits', [HardwarekitController::class, 'addHardwareKits'])->name('add-hardware-kits');
                Route::post('/hardware-kits-search', [HardwarekitController::class, 'search'])->name('hardware-kits-search');
                Route::get('/hardware-kits-edit-data/{departmentid}', [HardwarekitController::class, 'getHarwareKitsByDepartment']);
            });

            Route::group(['middleware' => ['permission:Mobile Carrier View']], function () {
                Route::resource('/carrier', '\App\Http\Controllers\Assets\Settings\CarrierController', ['only' => 'index']);
            });

            Route::group(['middleware' => ['permission:Mobile Carrier Edit']], function () {
                Route::resource('/carrier', '\App\Http\Controllers\Assets\Settings\CarrierController', ['except' => 'index']);
                Route::post('/carrier-ajax', [CarrierController::class, 'ajax']);
            });

            Route::group(['middleware' => ['permission:Location Type View']], function () {
                Route::resource('/location-type', '\App\Http\Controllers\Assets\Settings\LocationTypeController', ['only' => 'index']);
            });

            Route::group(['middleware' => ['permission:Location Type Edit']], function () {
                Route::resource('/location-type', '\App\Http\Controllers\Assets\Settings\LocationTypeController', ['except' => 'index']);
                Route::post('/location-type-ajax', [LocationTypeController::class, 'ajax']);
            });

            Route::group(['middleware' => ['permission:Region View']], function () {
                Route::resource('/region', '\App\Http\Controllers\Assets\Settings\RegionController', ['only' => 'index']);
            });

            Route::group(['middleware' => ['permission:Region Edit']], function () {
                Route::resource('/region', '\App\Http\Controllers\Assets\Settings\RegionController', ['except' => 'index']);
                Route::post('/region-ajax', [RegionController::class, 'ajax']);
            });

            Route::group(['middleware' => ['permission:State View']], function () {
                Route::resource('/state', '\App\Http\Controllers\Assets\Settings\StateController', ['only' => 'index']);
            });

            Route::group(['middleware' => ['permission:State Edit']], function () {
                Route::resource('/state', '\App\Http\Controllers\Assets\Settings\StateController', ['except' => 'index']);
                Route::post('/state-ajax', [StateController::class, 'ajax']);
            });

            Route::group(['middleware' => ['permission:Asset Type View']], function () {
                Route::resource('/asset-type', '\App\Http\Controllers\Assets\Settings\AssetTypeController', ['only' => 'index']);
                Route::post('/asset-type/asset-type-export', [AssetTypeController::class, 'export'])->name('asset-type-export');
            });

            Route::group(['middleware' => ['permission:Asset Type Edit']], function () {
                Route::resource('/asset-type', '\App\Http\Controllers\Assets\Settings\AssetTypeController', ['except' => 'index']);
                Route::post('/asset-type-ajax', [AssetTypeController::class, 'ajax']);
            });

            Route::group(['middleware' => ['permission:Asset Tab View']], function () {
                Route::resource('/asset-tabs', '\App\Http\Controllers\Assets\Settings\AssetTabController', ['only' => 'index']);
            });

            Route::group(['middleware' => ['permission:Asset Tab Edit']], function () {
                Route::resource('/asset-tabs', '\App\Http\Controllers\Assets\Settings\AssetTabController', ['except' => 'index']);
            });

            Route::group(['middleware' => ['permission:Site Code View']], function () {
                Route::resource('/site-code', '\App\Http\Controllers\Assets\Settings\SiteCodeController', ['only' => 'index']);
            });

            Route::group(['middleware' => ['permission:Site Code Edit']], function () {
                Route::resource('/site-code', '\App\Http\Controllers\Assets\Settings\SiteCodeController', ['except' => 'index']);
                Route::post('/site-codes-ajax', [SiteCodeController::class, 'ajax']);
                Route::post('/site-code/upload', [SiteCodeController::class, 'upload']);
            });

            Route::group(['middleware' => ['permission:Hardware Standards & Technical Specs View']], function () {
                Route::resource('/hardware-standard', '\App\Http\Controllers\Assets\Settings\HardwareStandardController', ['only' => 'index']);
                Route::post('/manufacturer-ajax', [ManufacturerController::class, 'ajax']);
                Route::resource('/manufacturer', '\App\Http\Controllers\Assets\Settings\ManufacturerController', ['only' => 'index']);
                Route::post('/manufacturer/manufacturer-export', [ManufacturerController::class, 'export'])->name('manufacturer-export');

                Route::resource('/technical-specs', '\App\Http\Controllers\Assets\Settings\TechnicalSpecsController', ['only' => 'index']);
                Route::post('/technical-specs/technical-specs-export', [TechnicalSpecsController::class, 'export'])->name('technical-specs-export');
                Route::post('/technical-specs-search', [TechnicalSpecsController::class, 'search'])->name('technical-specs-search');

                Route::post('/hardware-standard-search', [HardwareStandardController::class, 'search'])->name('hardware-standard-search');
            });

            Route::group(['middleware' => ['permission:Vendor Manage']], function () {
                Route::get('/vendor-listing', [VendorController::class, 'index'])->name('vendor-listing');
                Route::post('/vendor-data', [VendorController::class, 'data'])->name('vendor-data');
                Route::post('/add-vendor', [VendorController::class, 'store'])->name('add-vendor');
                Route::post('/edit-vendor/{id}', [VendorController::class, 'edit'])->name('edit-vendor');
                Route::post('/update-vendor', [VendorController::class, 'update'])->name('update-vendor');
                Route::post('/remove-vendor', [VendorController::class, 'deleteVendor'])->name('remove-vendor');
                Route::get('/get-filter-vendor', [VendorController::class, 'getFilterVendor']);

                Route::resource('vendor-categories', VendorCategoriesController::class);
                Route::post('/vendor-categories-data', [VendorCategoriesController::class, 'data'])->name('vendor-categories-data');
                Route::get('/vendor-category/{id}', [VendorCategoriesController::class, 'edit'])->name('edit-vendor-category');
            });

            Route::group(['middleware' => ['permission:Hardware Standards & Technical Specs Edit']], function () {
                Route::resource('/hardware-standard', '\App\Http\Controllers\Assets\Settings\HardwareStandardController', ['except' => 'index']);
                Route::resource('/manufacturer', '\App\Http\Controllers\Assets\Settings\ManufacturerController', ['except' => 'index']);
                Route::resource('/technical-specs', '\App\Http\Controllers\Assets\Settings\TechnicalSpecsController', ['except' => 'index']);
                Route::post('/hardware-standard-ajax', [HardwareStandardController::class, 'ajax']);
                Route::post('/hardware-standard-export', [HardwareStandardController::class, 'export'])->name('hardware-standard-export');
                Route::post('/technical-specs-ajax', [TechnicalSpecsController::class, 'ajax']);
                Route::post('/technical-specs-bulk-delete', [TechnicalSpecsController::class, 'bulkDestroy']);
                Route::post('/hardware-standard-bulk-delete', [HardwareStandardController::class, 'bulkDestroy']);
            });

            Route::get('/operating-system-compliance', [OperatingSystemComplianceController::class, 'index'])->name('operating-system-compliance.index');
            Route::post('/operating-system-compliance', [OperatingSystemComplianceController::class, 'store']);
        });

        Route::group(['middleware' => ['permission:Assets Health View']], function () {

            Route::resource('/asset-health', '\App\Http\Controllers\AssetsHealth\AssetsHealthController', ['only' => 'index']);

            Route::post('/assets-health-reports-sync', '\App\Http\Controllers\AssetsHealth\AssetsHealthReportController@sync')->name('assets-health-reports-sync');

            Route::get('/asset-health-reports/{category?}', '\App\Http\Controllers\AssetsHealth\AssetsHealthReportController@index')->name('asset-health-reports');


            Route::post('/disable-asset-health-test/{asset_health_test_id}', '\App\Http\Controllers\AssetsHealth\AssetsHealthReportController@disableAssetHealthTest')->name('disable-asset-health-test')->middleware('validate_referer');
            Route::post('/enable-asset-health-test/{asset_health_test_id}', '\App\Http\Controllers\AssetsHealth\AssetsHealthReportController@enableAssetHealthTest')->name('enable-asset-health-test')->middleware('validate_referer');

            Route::get('/asset-health-test-detail/{asset_health_report_id}', '\App\Http\Controllers\AssetsHealth\AssetsHealthController@getTestDetail')->name('assets-health-test-detail');

            Route::get('/asset-health-ignored-test-detail/{asset_health_report_id}', '\App\Http\Controllers\AssetsHealth\AssetsHealthController@getIgnoredTestDetail')->name('assets-health-ignored-test-detail');

            Route::post('assets-health-test-detail/{asset_health_report_id}', '\App\Http\Controllers\AssetsHealth\AssetsHealthController@getTestDetailData')->name('assets-health-test-detail-data');

            Route::post('assets-health-ignored-test-detail/{asset_health_report_id}', '\App\Http\Controllers\AssetsHealth\AssetsHealthController@getIgnoredTestDetailData')->name('assets-health-ignored-test-detail-data');

            Route::post('assets-health-test-detail-ignore/{asset_health_report_id}', '\App\Http\Controllers\AssetsHealth\AssetsHealthController@ignoreTestDetail')->name('assets-health-test-detail-ignore')->middleware('validate_referer');
            Route::post('assets-health-test-detail-undo-ignore/{asset_health_report_id}', '\App\Http\Controllers\AssetsHealth\AssetsHealthController@undoIgnoreTestDetail')->name('assets-health-test-detail-undo-ignore')->middleware('validate_referer');

            Route::post('assets-health-test-detail-export/{asset_health_report_id}', '\App\Http\Controllers\AssetsHealth\AssetsHealthController@getTestDetailExport')->name('assets-health-test-detail-export');

            Route::get('/asset-health-history', '\App\Http\Controllers\AssetsHealth\AssetsHealthHistoryController@index')->name('asset-health-history');

            Route::post('/assets-health-history-data', '\App\Http\Controllers\AssetsHealth\AssetsHealthHistoryController@data')->name('assets-health-history-data');
            Route::post('/assets-health-history-data-filter', '\App\Http\Controllers\AssetsHealth\AssetsHealthHistoryController@filterData')->name('assets-health-history-data-filter');

            Route::get('/assets-health-asset-type', '\App\Http\Controllers\AssetsHealth\AssetsHealthAssetTypeController@index')->name('assets-health-asset-type');

            Route::post('/assets-health-asset-type', '\App\Http\Controllers\AssetsHealth\AssetsHealthAssetTypeController@store')->name('assets-health-asset-type.store');
            Route::post('/set-assets-health-asset-type', '\App\Http\Controllers\AssetsHealth\AssetsHealthAssetTypeController@setReportAssetType')->name('set-assets-health-asset-type');

            Route::get('/assets-health-tests-create-ticket', '\App\Http\Controllers\AssetsHealth\AssetsHealthReportController@createTicket')->name('assets-health-tests-create-ticket');

            Route::post('/assets-health-tests-create-ticket', '\App\Http\Controllers\AssetsHealth\AssetsHealthReportController@createJiraTicket')->name('assets-health-tests-create-ticket-store')->middleware('validate_referer');

            Route::get('/asset-health-report-export', '\App\Http\Controllers\AssetsHealth\AssetsHealthReportExportController@index')->name('asset-health-report-export');

            Route::post('/assets-health-report-download-csv', '\App\Http\Controllers\AssetsHealth\AssetsHealthReportExportController@download')->name('assets-health-report-download-csv');

            Route::get('/asset-health-report-download-excel', '\App\Http\Controllers\AssetsHealth\AssetsHealthReportExcelExportController@download')->name('asset-health-report-download-excel');

            Route::get('/asset-health-report-download-pdf', '\App\Http\Controllers\AssetsHealth\AssetsHealthReportExportController@downloadReport')->name('assets-health-report-download-pdf');

            Route::post('/send-email-asset-health-pdf-report', '\App\Http\Controllers\AssetsHealth\SendEmailPdfReportController@sendEmail')->name('send-email-asset-health-pdf-report');
            Route::post('/schedule-asset-health-report', '\App\Http\Controllers\AssetsHealth\ScheduleAssetHealthReportController@scheduleReport')->name('schedule-asset-health-report');
        });

        Route::group(['prefix' => 'new-hire'], function () {
            Route::group(['middleware' => ['permission:New Hire']], function () {
                Route::get('', [NewHireEmployeesController::class, 'index'])->name('new-hire');
                Route::post('/new-hire-data', [NewHireEmployeesController::class, 'data'])->name('new-hire-data');
                Route::post('/save-search', [NewHireEmployeesController::class, 'saveSearch'])->name('new-hire-save-search');
                Route::post('/update-save-search', [NewHireEmployeesController::class, 'updateSearch'])->name('new-hire-update-save-search');
                Route::post('/delete-save-search', [NewHireEmployeesController::class, 'deleteSearch'])->name('new-hire-delete-save-search');
                Route::post('/new-hire-export', [NewHireEmployeesController::class, 'export'])->name('new-hire-export');
                Route::post('/get-assets/{id}', [NewHireEmployeesController::class, 'viewAssets'])->name('viewAssets');
                Route::post('/jira-manual-sync', [NewHireEmployeesController::class, 'syncJiraUsers']);

                Route::get('/forecasting', [NewHireForecastingController::class, 'index']);
                Route::post('/forecasting-data', [NewHireForecastingController::class, 'data'])->name('new-hire-forecasting-data');

                Route::get('/forecasting-tool', [NewHireForecastingToolController::class, 'index']);
                Route::post('/forecasting-tool-data', [NewHireForecastingToolController::class, 'data'])->name('forecasting-tool-data');
                Route::post('/forecasting-tool-export', [NewHireForecastingToolController::class, 'export'])->name('forecasting-tool-export');

                Route::get('/average-deployment-time', [AverageDeploymentTimeController::class, 'index'])->name('average-deployment-time');
                Route::post('/average-deployment-time-data', [AverageDeploymentTimeController::class, 'data'])->name('average-deployment-time-data');
                Route::post('/average-deployment-time-export', [AverageDeploymentTimeController::class, 'export'])->name('average-deployment-time-export');
                Route::post('/average-deployment-widget-data', [AverageDeploymentTimeController::class, 'widgetData'])->name('average-deployment-widget-data');
            });
        });

        Route::group(['middleware' => ['permission:Terminations']], function () {
            Route::group(['prefix' => 'terms-report'], function () {
                Route::get('', [TermsReportController::class, 'index'])->name('terms-report');
                Route::post('/data', [TermsReportController::class, 'data'])->name('terms-report-data');
                Route::post('/export', [TermsReportController::class, 'export'])->name('terms-report-export');
                Route::post('/get-term-assets/{id}', [TermsReportController::class, 'viewTermAsset'])->name('viewTermAsset');
                Route::post('/update-comment/{id}', [TermsReportController::class, 'updateComment'])->name('termAssetUpdateComment');
                Route::post('/get-comment/{id}', [TermsReportController::class, 'getComment'])->name('TermAssetgetComment');
                Route::post('/save-search', [TermsReportController::class, 'saveSearch'])->name('terms-report-save-search');
                Route::post('/update-search', [TermsReportController::class, 'updateSearch'])->name('terms-report-update-search');
                Route::post('/delete-search', [TermsReportController::class, 'deleteSearch'])->name('terms-report-delete-search');
            });
            /*
            Route::group(['middleware' => ['permission:Retriever Report']], function () {
                Route::group(['prefix' => 'terminations'], function () {
                    Route::get('/retriever-report', [RetrieverReportController::class, 'index'])->name('retriever-report.index');
                    Route::post('/retriever-report-data', [RetrieverReportController::class, 'data'])->name('retriever-report-data');
                    Route::post('/retriever-report-export', [RetrieverReportController::class, 'export'])->name('retriever-report-export');
                    Route::get('/get-filter-retriever-fields', [RetrieverReportController::class, 'getFilterFields']);
                    Route::get('/retriever-user-assets/{id}', [RetrieverReportController::class, 'getUserAssets']);
                    Route::post('/retriever/create-shipment-request', [RetrieverShipmentController::class, 'createShipmentRequest'])->name('retriever-create-shipment-request')->middleware('validate_referer');
                });
            });
            */
        });


        Route::group(['prefix' => 'shipment-trackings'], function () {
            Route::post('/update-tracking-number', [AssetTrackingController::class, 'updateTrackingNumber'])->name('update-tracking-number')->middleware('validate_referer');
            Route::post('/shipment-status-sync', [AssetTrackingController::class, 'manualSync'])->name('shipment-status-sync');
        });

        Route::group(['prefix' => 'report'], function () {
            Route::group(['middleware' => ['permission:Reports View']], function () {
                Route::get('/', [ReportIndexController::class, 'index'])->name('report.index');

                Route::post('/add-favourite', '\App\Http\Controllers\Reports\FavouriteReportController')->name('favourite-report');

                //assets created report
                Route::get('/assets-created', [AssetsCreatedController::class, 'index'])->name('assets-created-report');
                Route::post('/assets-created-graph-data', [AssetsCreatedController::class, 'graphData'])->name('assets-created-graph-data');
                Route::post('/assets-created-data', [AssetsCreatedController::class, 'data'])->name('assets-created-data');
                Route::post('/assets-created-data/export', [AssetsCreatedController::class, 'export'])->name('assets-created-export');

                Route::get('/depreciation-value', [DepreciationValueController::class, 'index'])->name('depreciation-value');
                Route::post('/depreciation-value', [DepreciationValueController::class, 'chart'])->name('depreciation-value-search');
                Route::post('/depreciation-value-data', [DepreciationValueController::class, 'data'])->name('depreciation-value-data');
                Route::post('/depreciation-value-export-with-data', [DepreciationValueController::class, 'exportGraphWithListData'])->name('depreciation-value-graph-export-with-data');

                Route::get('/damaged-trends', [DamagedTrendsController::class, 'index'])->name('damaged-trends');
                Route::post('/damaged-trends', [DamagedTrendsController::class, 'graphData']);
                Route::post('/damaged-trends-data', [DamagedTrendsController::class, 'data'])->name('damaged-trends-report-data');
                Route::post('/damaged-trends-excel-export', [DamagedTrendsController::class, 'exportGraphWithListData'])->name('damaged-trends-export');

                Route::get('/linked-devices', [LinkedDevicesController::class, 'index'])->name('linked-devices');

                // Department Spend
                Route::get('/assets-by-department', [AssetsByDepartmentController::class, 'index'])->name('assets-by-department');
                Route::post('/assets-by-department-data', [AssetsByDepartmentController::class, 'data'])->name('assets-by-department-data');
                Route::post('/assets-by-department-export', [AssetsByDepartmentController::class, 'export'])->name('assets-by-department-export');


                // Active Users with No Assets Assigned
                Route::get('/active-users-with-no-asset', [ActiveUsersController::class, 'index'])->name('users-without-asset');
                Route::post('/active-users-with-no-asset-data', [ActiveUsersController::class, 'data'])->name('active-users-with-no-asset-data');
                Route::post('/user-with-no-asset-export', [ActiveUsersController::class, 'export'])->name('user-with-no-asset-export');

                Route::get('/warranty-expiration-date', [WarrantyExpirationDateController::class, 'index']);
                Route::post('/warranty-expiration-date-data', [WarrantyExpirationDateController::class, 'data'])->name('warranty-expiration-date-data');
                Route::post('/warranty-expiration-date-export', [WarrantyExpirationDateController::class, 'export'])->name('warranty-expiration-date-export');

                Route::get('/duplicate-assets', [DuplicateAssetsController::class, 'index']);
                Route::post('/duplicate-assets-data', [DuplicateAssetsController::class, 'data'])->name('duplicate-assets-data');
                Route::post('/remove-duplicated-asset', [DuplicateAssetsController::class, 'removeDuplicatedAsset'])->name('delete-duplicated-asset');
                Route::post('/export-duplicate-assets-data', [DuplicateAssetsController::class, 'exportDuplicatedAsset'])->name('export-duplicated-asset');
                Route::post('/get-asset-data-for-merge', [DuplicateAssetsController::class, 'getAssetDataForMerge'])->name('get-asset-data-for-merge');
                Route::post('/merge-duplicate-assets', [DuplicateAssetsController::class, 'mergeDuplicateAssets'])->name('merge-duplicate-assets');
                Route::post('/update-duplicate-assets', [DuplicateAssetsController::class, 'updateDuplicateAssets'])->name('update-duplicate-assets');

                Route::group(['prefix' => 'os-compliance-report'], function () {
                    Route::get('/windows', [WindowsComplianceReportController::class, 'index'])->name('windows-compliance-report');
                    Route::post('/windows', [WindowsComplianceReportController::class, 'data'])->name('windows-compliance-report-data');
                    Route::post('/windows/export', [WindowsComplianceReportController::class, 'export'])->name('windows-compliance-report-export');

                    Route::get('/apple', [AppleComplianceReportController::class, 'index'])->name('apple-compliance-report');
                    Route::post('/apple', [AppleComplianceReportController::class, 'data'])->name('apple-compliance-report-data');
                    Route::post('/apple/export', [AppleComplianceReportController::class, 'export'])->name('apple-compliance-report-export');

                    Route::get('/chrome', [ChromeComplianceReportController::class, 'index'])->name('chrome-compliance-report');
                    Route::post('/chrome', [ChromeComplianceReportController::class, 'data'])->name('chrome-compliance-report-data');
                    Route::post('/chrome/export', [ChromeComplianceReportController::class, 'export'])->name('chrome-compliance-report-export');

                    Route::get('/android', [AndroidComplianceReportController::class, 'index'])->name('android-compliance-report');
                    Route::post('/android', [AndroidComplianceReportController::class, 'data'])->name('android-compliance-report-data');
                    Route::post('/android/export', [AndroidComplianceReportController::class, 'export'])->name('android-compliance-report-export');

                    Route::get('/apple-mobile', [AppleMobileComplianceReportController::class, 'index'])->name('apple-mobile-compliance-report');
                    Route::post('/apple-mobile', [AppleMobileComplianceReportController::class, 'data'])->name('apple-mobile-compliance-report-data');
                    Route::post('/apple-mobile/export', [AppleMobileComplianceReportController::class, 'export'])->name('apple-mobile-compliance-report-export');
                });

                Route::get('/use-tax', [UseTaxController::class, 'index'])->name('use-tax-report');
                Route::post('/use-tax', [UseTaxController::class, 'data'])->name('use-tax-report-data');
                Route::post('/use-tax/export', [UseTaxController::class, 'export'])->name('use-tax-report-export');


                //Deployment Report
                Route::get('/computers-deployed', [ComputerDeployedController::class, 'index'])->name('deployment');
                Route::post('/computers-deployed', [ComputerDeployedController::class, 'data'])->name('deployment-data');
                Route::post('/computers-deployed-export', [ComputerDeployedController::class, 'export'])->name('deployment-export');

                //Assets assigned by month
                Route::get('/assets-assigned-by-month', [AssetsAssignedByMonthController::class, 'index'])->name('assets-assigned-by-month');
                Route::post('/assets-assigned-by-month-graph-data', [AssetsAssignedByMonthController::class, 'graphData'])->name('assets-assigned-by-month-graph-data');
                Route::post('/assets-assigned-by-month-data', [AssetsAssignedByMonthController::class, 'data'])->name('assets-assigned-by-month-data');
                Route::post('/assets-assigned-by-month-export', [AssetsAssignedByMonthController::class, 'exportGraphWithListData'])->name('assets-assigned-by-month-export');

                //Average time in brand new
                Route::get('/average-time-in-brand-new', [AverageTimeInBrandNewController::class, 'index'])->name('average-time-in-brand-new');
                Route::post('/average-time-in-brand-new-graph-data', [AverageTimeInBrandNewController::class, 'graphData'])->name('average-time-in-brand-new-graph-data');

                // Brand New to Assigned
                Route::get('/brandnew-to-assigned', [BrandNewToAssignedController::class, 'index']);
                Route::post('/brandnew-to-assigned-graph-data', [BrandNewToAssignedController::class, 'graphData'])->name('brandnew-to-assigned-graph-data');
                Route::post('/brand-new-to-assigned-data', [BrandNewToAssignedController::class, 'data'])->name('brand-new-to-assigned-data');
                Route::post('/brandnew-to-assigned-export', [BrandNewToAssignedController::class, 'exportGraphWithListData'])->name('brandnew-to-assigned-export');


                // Brand New to Assigned to Contractor
                Route::get('/brandnew-assigned-to-contractor', [BrandNewAssignedToContractorController::class, 'index']);
                Route::post('/brandnew-assigned-to-contractor-graph-data', [BrandNewAssignedToContractorController::class, 'graphData'])->name('brandnew-assigned-to-contractor-graph-data');
                Route::post('/brandnew-assigned-to-contractor-data', [BrandNewAssignedToContractorController::class, 'data'])->name('brandnew-assigned-contractor-data');
                Route::post('/brandnew-assigned-to-contractor-export', [BrandNewAssignedToContractorController::class, 'exportGraphWithListData'])->name('brandnew-assigned-contractor-export');

                //Asset Recovery
                Route::get('/asset-recovery', [AssetRecoveryController::class, 'index']);
                Route::post('/asset-recovery', [AssetRecoveryController::class, 'data'])->name('asset-recovery-data');
                Route::post('/asset-recovery-data-export', [AssetRecoveryController::class, 'export'])->name('asset-recovery-data-export');

                Route::get('/assigned-devices', 'Reports\AssetsAssignedController@index')->name('assigned-devices');
                Route::post('/assigned-devices', 'Reports\AssetsAssignedController@data')->name('assigned-devices-data');
                Route::post('/assigned-devices-export', 'Reports\AssetsAssignedController@export')->name('assigned-devices-export');

                Route::get('/reused-devices', 'Reports\AssetsReusedController@index')->name('reused-devices');
                Route::post('/reused-devices', 'Reports\AssetsReusedController@data')->name('reused-devices-data');
                Route::post('/reused-devices-export', 'Reports\AssetsReusedController@export')->name('reused-devices-export');
                Route::get('/reused-devices-piechart', 'Reports\AssetsReusedController@pieChart')->name('reused-devices-pie-chart');

                Route::get('/computers-by-age', 'Reports\ComputerByAgeController@index')->name('computer-by-age');
                Route::post('/computers-by-age-data', 'Reports\ComputerByAgeController@data')->name('computer-by-age-data');
                Route::post('/computers-by-age-export', 'Reports\ComputerByAgeController@export')->name('computer-by-age-export');

                Route::get('/computers', 'Reports\ComputerByStatusController@index')->name('computers-report');
                Route::post('/computers', 'Reports\ComputerByStatusController@data')->name('computers-report-data');
                Route::post('/computers/export', 'Reports\ComputerByStatusController@export')->name('computer-by-status-export');

                //Unrepairable Report
                Route::get('/unrepairable', [UnrepairableController::class, 'index'])->name('unrepairable');
                Route::post('/unrepairable', [UnrepairableController::class, 'data'])->name('unrepairable-data');
                Route::post('/unrepairable-export', [UnrepairableController::class, 'export'])->name('unrepairable-export');
                Route::post('/unrepairable/get-widget-count', [UnrepairableController::class, 'getWidgetCount'])->name('unrepairable-widget-count');

                //Asset recovery
                Route::get('/asset-recovery-value', [AssetRecoveryValueController::class, 'index'])->name('asset-recovery-value-report');
                Route::post('/asset-recovery-value', [AssetRecoveryValueController::class, 'data'])->name('asset-recovery-value-report-data');
                Route::post('/asset-recovery-value/export', [AssetRecoveryValueController::class, 'export'])->name('asset-recovery-value-export');
                Route::post('/asset-recovery-value/get-widget-count', [AssetRecoveryValueController::class, 'getWidgetCount'])->name('asset-recovery-value-widget-count');

                //Upcoming refresh
                Route::get('/upcoming-refresh', [UpcomingRefreshController::class, 'index'])->name('upcoming-refresh-report');
                Route::post('/upcoming-refresh', [UpcomingRefreshController::class, 'data'])->name('upcoming-refresh-report-data');
                Route::post('/upcoming-refresh/export', [UpcomingRefreshController::class, 'export'])->name('upcoming-refresh-export');

                //Repair and recovery
                Route::get('/repair-and-recovery', [RepairAndRecoveryController::class, 'index'])->name('repair-and-recovery-report');
                Route::post('/repair-and-recovery', [RepairAndRecoveryController::class, 'data'])->name('repair-and-recovery-report-data');
                Route::post('/repair-and-recovery/export', [RepairAndRecoveryController::class, 'export'])->name('repair-and-recovery-export');
                Route::post('/repair-and-recovery/get-widget-count', [RepairAndRecoveryController::class, 'getWidgetCount'])->name('repair-and-recovery-widget-count');

                //Lost or stolen value
                Route::get('/lost-or-stolen-value', [LostOrStolenValueController::class, 'index'])->name('lost-or-stolen-value-report');
                Route::post('/lost-or-stolen-value', [LostOrStolenValueController::class, 'data'])->name('lost-or-stolen-value-report-data');
                Route::post('/lost-or-stolen-value/export', [LostOrStolenValueController::class, 'export'])->name('lost-or-stolen-value-export');
                Route::post('/lost-or-stolen-value/get-widget-count', [LostOrStolenValueController::class, 'getWidgetCount'])->name('lost-or-stolen-value-widget-count');
            });

            Route::group(['middleware' => ['permission:Report Generator View']], function () {
                Route::get('/generator', [GeneratorController::class, 'index'])->name('reports-generator');
                Route::post('/generator-data', [GeneratorController::class, 'data'])->name('reports-generator-data');
            });



            Route::group(['middleware' => ['permission:Report Generator Edit']], function () {
                Route::post('/generator', [GeneratorController::class, 'saveSearch'])->name('reports-generator-store');
                Route::post('/generator-update', [GeneratorController::class, 'updateSearch'])->name('reports-generator-update');
                Route::post('/generator-delete', [GeneratorController::class, 'deleteSearch'])->name('reports-generator-delete');
                Route::view('/generator-guide', 'reports.generator-guide')->name('reports-generator-guide');
                Route::post('/generator-export', [GeneratorController::class, 'export'])->name('reports-generator-export');
                Route::post('/generator-export-create/{saveExport}', [GeneratorController::class, 'export'])->name('reports-generator-export-create');
            });
            Route::post('/share-report', [ShareReportController::class, 'mail'])->name('share-report-data')->middleware('validate_referer');
            Route::get('/share-report-users', [ShareReportController::class, 'getUsers'])->name('share-report-users')->middleware('validate_referer');
        });

        Route::group(['middleware' => ['permission:HR Collections Report']], function () {
            Route::group(['prefix' => 'collection-statistics'], function () {
                Route::get('/', [CollectionStatisticsReportController::class, 'index'])->name('collection-statistics');
                Route::get('single-bar-report', [CollectionStatisticsReportController::class, 'viewSingleBarReport']);
                Route::post('bar-data', [CollectionStatisticsReportController::class, 'data'])->name('collection-statistics-bar-data');
                Route::post('export', [CollectionStatisticsReportController::class, 'export'])->name('collection-statistics-export');
                Route::post('sync', [CollectionStatisticsReportController::class, 'manualSync'])->name('collection-statistics-sync');
            });

            Route::group(['prefix' => 'user-statistics'], function () {
                Route::get('/', [UserStatisticsGraphController::class, 'index'])->name('user-statistics');
            });

            Route::group(['prefix' => 'retrieval-statistics'], function () {
                Route::get('/', [RetrievalStatisticsReportController::class, 'index'])->name('retrieval-statistics');
                Route::get('/graph-single-report', [RetrievalStatisticsReportController::class, 'viewSingleBarReport'])->name('retrieval-statistics.graph-single-report');
                Route::post('/graph-single-report-data', [RetrievalStatisticsReportController::class, 'data'])->name('retrieval-statistics.graph-single-report-data');
                Route::post('/graph-single-report-export', [RetrievalStatisticsReportController::class, 'export'])->name('retrieval-statistics.graph-single-report-export');
                Route::get('/widget-data', [RetrievalStatisticsReportController::class, 'widgetData'])->name('retrieval-statistics.widget-data');
            });
        });

        Route::get('/generated-exports/{report_type}', [ExportManagementController::class, 'fileExports'])->name('generated-exports');
        Route::get('/generated-exports-downloaded/{reportId}', [ExportManagementController::class, 'markAsDownloaded']);

        Route::group(['prefix' => 'validate'], function () {
            Route::post('/move', [ValidationsController::class, 'canBeMoved'])->name('validate.move');
            Route::post('/link', [ValidationsController::class, 'canBeLinked'])->name('validate.link');
            Route::post('/return', [ValidationsController::class, 'canBeReturned'])->name('validate.return');
            Route::post('/typecheck', [ValidationsController::class, 'typeChecked'])->name('validate.typecheck');
            Route::post('/ticket-exist', [ValidationsController::class, 'ticketExist'])->name('validate.ticket-exist');
            Route::post('/update', [ValidationsController::class, 'canBeUpdated'])->name('validate.update');
            Route::post('/check-freeze-location', [ValidationsController::class, 'checkFreezeLocation'])->name('validate.check-freeze-location');
        });

        Route::group(['middleware' => ['permission:Access Levels View']], function () {
            Route::get('/manage-userrole', [AccessLevelsController::class, 'index'])->name('manage-userrole');
        });

        Route::middleware(['role:Super Admin'])->group(function () {

            Route::get('/teqtivity-users', [TeqtivityUserController::class, 'index'])->name('teqtivity-users.index');
            Route::get('/reset-teqtivity-user-password/{id}', [TeqtivityUserController::class, 'resetPassword'])->name('teqtivity-users.reset-password');
            Route::post('/teqtivity-users', [TeqtivityUserController::class, 'store'])->name('teqtivity-users.store');
            Route::post('/update-teqtivity-users', [TeqtivityUserController::class, 'update'])->name('teqtivity-users.update');
            Route::post('/check-teqtivity-user-history-exists', [TeqtivityUserController::class, 'checkUserHistoryExists'])->name('teqtivity-users.check-history-exists');
            Route::post('/delete-teqtivity-users', [TeqtivityUserController::class, 'delete'])->name('teqtivity-users.delete');
            Route::resource('/teqtivity-slack-notification-app', '\App\Http\Controllers\Settings\SystemSettings\TeqtivitySlackNotificationAppController');

            Route::group(['prefix' => 'system-settings'], function () {
                Route::get('/documentation', [DocumentationController::class, 'index'])->name('documentation.index');
                Route::post('/documentation', [DocumentationController::class, 'store']);
                Route::get('/support-page', [SupportSettingsController::class, 'index'])->name('support-page.index');
                Route::post('/support-page', [SupportSettingsController::class, 'store']);
            });
        });

        Route::group(['middleware' => ['permission:Access Levels Edit']], function () {
            Route::post('/manage-userrole', [AccessLevelsController::class, 'store']);
            Route::post('/manage-userrole-create', [AccessLevelsController::class, 'create'])->name('manage-userrole-create');
            Route::post('/manage-userrole-add', [AccessLevelsController::class, 'add'])->name('manage-userrole-add');
            Route::post('/manage-userrole-deactivate', [AccessLevelsController::class, 'delete'])->name('manage-userrole-delete');
            Route::post('/permission-group-add', [AccessLevelsController::class, 'permissionGroupStore'])->name('permission-group-add');
            Route::post('/access-levels-deactivate', [AccessLevelsController::class, 'delete'])->name('access-levels-delete');
        });

        Route::group(['middleware' => ['permission:Administrators View']], function () {
            Route::resource('/adminusers', '\App\Http\Controllers\AdminUserController', ['only' => 'index']);
        });

        Route::group(['middleware' => ['permission:Administrators Edit']], function () {
            Route::resource('/adminusers', '\App\Http\Controllers\AdminUserController', ['except' => 'index']);
            Route::post('/adminusers-ajax', [AdminUserController::class, 'ajax']);
        });

        Route::group(['middleware' => ['permission:Attributes View']], function () {
            Route::resource('/asset-attributes', '\App\Http\Controllers\Assets\Settings\AttributesController', ['only' => 'index']);
        });

        Route::group(['middleware' => ['permission:Attributes Edit']], function () {
            Route::resource('/asset-attributes', '\App\Http\Controllers\Assets\Settings\AttributesController', ['except' => 'index']);
            Route::post('/attribute-ajax', [AttributesController::class, 'ajax']);
        });

        Route::group(['middleware' => ['permission:API Credentials View']], function () {
            Route::resource('/jira-credentials', '\App\Http\Controllers\Assets\Settings\JiraCredentialsController', ['only' => 'index']);
            Route::get('/jira-credentials/connect', [JiraCredentialsController::class, 'connect'])->name('jira-credentials.connect');
            Route::get('/jira-credentials/callback', [JiraCredentialsController::class, 'callback'])->name('jira-credentials.callback');

            Route::get('/gsuite-locations', [GsuiteLocationsController::class, 'index'])->name('gsuite-locations.index');
            Route::get('/google-directory', [GoogleDirectoryController::class, 'index'])->name('google-directory.index');

            Route::resource('/workspace-one', '\App\Http\Controllers\Assets\Settings\DiscoveryTools\WorkspaceOneController', ['only' => 'index']);
            Route::get('/chrome-devices', [ChromeBookController::class, 'index'])->name('chrome-devices.index');
            Route::resource('/intune', '\App\Http\Controllers\Assets\Settings\DiscoveryTools\IntuneController', ['only' => 'index']);
            Route::resource('/jamf', '\App\Http\Controllers\Assets\Settings\DiscoveryTools\JamfController');

            Route::resource('/aws-cloud-assets', AwsCloudAssetsController::class);
            Route::get('/aws-cloud-assets-connect', [AwsCloudAssetsController::class, 'connect'])->name('aws-cloud-assets.connect');
            Route::post('/aws-cloud-assets-sync', [AwsCloudAssetsController::class, 'manualSync'])->name('aws-cloud-assets.sync');

            Route::post('/generate-secure-token', [OktaScimController::class, 'generateToken']);

            Route::resource('/okta-scim', '\App\Http\Controllers\Assets\Settings\OktaScimController', [['only' => ['index', 'update']]]);
            Route::resource('/okta-sso', '\App\Http\Controllers\Assets\Settings\OktaSsoController');
            Route::resource('/okta-directory', '\App\Http\Controllers\Assets\Settings\OktaDirectoryController', ['only' => 'index']);
            Route::resource('/asn-shi-api-settings', '\App\Http\Controllers\Assets\Settings\ShiController', ['only' => 'index']);

            // Route::resource('/azure-directory', '\App\Http\Controllers\Settings\AzureDirectoryCredentialController', ['only' => 'index']);
            Route::resource('/azure-sso', '\App\Http\Controllers\Settings\AzureSsoController');

            Route::resource('/mobile-iron', '\App\Http\Controllers\Assets\Settings\DiscoveryTools\MobileIronController', ['only' => 'index']);
            Route::resource('/kandji', '\App\Http\Controllers\Assets\Settings\DiscoveryTools\KandjiController', ['only' => 'index']);

            Route::resource('/ups-tracking', '\App\Http\Controllers\Assets\Settings\UpsTrackingController', ['only' => 'index']);
            Route::post('/ups-tracking/manual-sync', [UpsTrackingController::class, 'manualSync']);
            Route::resource('/fedex-tracking-api', 'Assets\Settings\FedexTrackingController', ['only' => 'index']);
            Route::post('/fedex-tracking-api/manual-sync', [FedexTrackingController::class, 'manualSync']);

            Route::resource('/zendesk', '\App\Http\Controllers\Assets\Settings\ZendeskApiCredentialsController', ['only' => 'index']);
            Route::resource('/spoke', '\App\Http\Controllers\Assets\Settings\SpokeApiCredentialsController', ['only' => 'index']);
            Route::resource('/freshservice', '\App\Http\Controllers\Assets\Settings\FreshServiceController', ['only' => 'index']);

            Route::resource('/dropbox', '\App\Http\Controllers\Assets\Settings\DropboxCredentialsController', ['except' => 'show']);
            Route::get('/dropbox/connect', [DropboxCredentialsController::class, 'connect']);
            Route::get('/dropbox/callback', [DropboxCredentialsController::class, 'callback']);
            Route::get('/dropbox/refresh-token', [DropboxCredentialsController::class, 'refreshToken']);
            Route::post('/dropbox/manual-sync', [DropboxCredentialsController::class, 'manualSync'])->name('dropbox.manual-sync');
            Route::post('/dropbox/integration-status-change', [DropboxCredentialsController::class, 'integrationStatusChange']);

            Route::resource('/slack', '\App\Http\Controllers\Assets\Settings\SlackCredentialsController', ['except' => 'show']);
            Route::get('/slack/connect', [SlackCredentialsController::class, 'connect']);
            Route::get('/slack/callback', [SlackCredentialsController::class, 'callback']);
            Route::post('/slack/integration-status-change', [SlackCredentialsController::class, 'integrationStatusChange']);
            Route::get('/slack/manual-sync', [SlackCredentialsController::class, 'manualSync']);

            // Route::resource('/slack-notification-credentials', 'Assets\Settings\SlackNotificationCredentialsController', ['only' => 'index']);
            // Route::get('slack-notification-credentials/notify-manually', [SlackNotificationCredentialsController::class, 'manualNotify']);

            Route::resource('/zoom', '\App\Http\Controllers\Assets\Settings\ZoomCredentialsController', ['except' => 'show']);
            Route::get('/zoom/connect', [ZoomCredentialsController::class, 'connect']);
            Route::post('/zoom/integration-status-change', [ZoomCredentialsController::class, 'integrationStatusChange']);
            Route::post('/zoom/manual-sync', [ZoomCredentialsController::class, 'manualSync'])->name('zoom.manual-sync');

            Route::resource('/crowdstrike', '\App\Http\Controllers\Security\Crowdstrike\CrowdstrikeCredentialsController', ['only' => 'index']);

            Route::get('/retriever-credentials', [RetrieverCredentialsController::class, 'index'])->name('retriever-credentials.index');
            Route::resource('/revivn', 'Assets\Settings\RevivnController', ['only' => 'index']);

            Route::resource('/slack-notifications', 'Settings\SlackNotifications\SlackNotificationsController', ['only' => 'index']);
            Route::get('/slack-notifications-config/test/{slack_notifications_config}', [SlackChannelsConfigController::class, 'testNotification'])->name('slack-notifications-config.test');
            Route::post('/slack-notifications-config/slack-notification-channels-data', [SlackChannelsConfigController::class, 'data'])->name('slack-notification-channels-data');
            Route::resource('/jumpcloud', '\App\Http\Controllers\Settings\DiscoveryTools\JumpCloudCredentialsController', ['only' => 'index']);

            Route::get('/asn-presidio-settings', [PresidioController::class, 'index'])->name('presidio-settings');

            Route::resource('/hibob', 'Assets\Settings\HiBobController', ['only' => 'index']);

            // Zoom hardware credentials
            Route::get('/zoom-hardware', 'Settings\Integrations\ZoomHardwareCredentialsController@index')->name('zoom-hardware.index');
        });

        Route::group(['middleware' => ['permission:API Credentials Edit']], function () {
            Route::resource('/jira-credentials', '\App\Http\Controllers\Assets\Settings\JiraCredentialsController', ['except' => 'index']);

            Route::get('/gsuite-locations/edit', [GsuiteLocationsController::class, 'editCredentials'])->name('gsuite-locations-edit');
            Route::post('/gsuite-locations/save', [GsuiteLocationsController::class, 'saveCredentials'])->name('gsuite-locations-save')->middleware('validate_referer');
            Route::post('/gsuite-locations/manual-sync', [GsuiteLocationsController::class, 'manualSync'])->name('gsuite-locations-manual-sync');

            Route::get('/google-directory/edit', [GoogleDirectoryController::class, 'editCredentials'])->name('google-directory-edit');
            Route::post('/google-directory/save', [GoogleDirectoryController::class, 'saveCredentials'])->name('google-directory-save')->middleware('validate_referer');
            Route::post('/google-directory/manual-sync', [GoogleDirectoryController::class, 'manualSync'])->name('google-directory-manual-sync');

            Route::get('/chrome-devices/edit', [ChromeBookController::class, 'editCredentials'])->name('chrome-devices-edit');
            Route::post('/chrome-devices/save', [ChromeBookController::class, 'saveCredentials'])->name('chrome-devices-save')->middleware('validate_referer');
            Route::post('/chrome-devices/manual-sync', [ChromeBookController::class, 'manualSync'])->name('chrome-devices-manual-sync');

            Route::resource('/workspace-one', '\App\Http\Controllers\Assets\Settings\DiscoveryTools\WorkspaceOneController', ['except' => 'index']);

            Route::resource('/intune', '\App\Http\Controllers\Assets\Settings\DiscoveryTools\IntuneController', ['except' => 'index']);
            Route::get('/intune-connect', [IntuneController::class, 'connect'])->name('intune-connect');
            Route::get('/intune-callback', [IntuneController::class, 'callback']);
            Route::get('/intune-signout', [IntuneController::class, 'signout'])->name('intune-signout');
            Route::get('/intune-test', [IntuneController::class, 'test'])->name('intune-test');
            Route::post('/intune-manual-sync', [IntuneController::class, 'manualSync'])->name('intune-manual-sync');

            Route::get('/jamf-connect', [JamfController::class, 'connect'])->name('jamf.connect');
            Route::post('/jamf-sync', [JamfController::class, 'manualSync'])->name('jamf.sync');
            Route::post('/okta-directory/manual-sync', [OktaDirectoryController::class, 'manualSync']);
            Route::resource('/okta-directory', '\App\Http\Controllers\Assets\Settings\OktaDirectoryController', ['except' => 'index']);
            Route::resource('/asn-shi-api-settings', '\App\Http\Controllers\Assets\Settings\ShiController', ['except' => 'index']);

            // Route::resource('/azure-directory', '\App\Http\Controllers\Settings\AzureDirectoryCredentialController', ['except' => 'index']);
            // Route::get('/azure-directory-connect', [AzureDirectoryCredentialController::class, 'connect'])->name('azure-directory-connect');
            // Route::get('/azure-directory-callback', [AzureDirectoryCredentialController::class, 'callback']);
            // Route::get('/azure-directory-signout', [AzureDirectoryCredentialController::class, 'signout'])->name('azure-directory-signout');
            // Route::get('/azure-directory-test', [AzureDirectoryCredentialController::class, 'test'])->name('azure-directory-test');
            // Route::post('/azure-directory-manual-sync', [AzureDirectoryCredentialController::class, 'manualSync'])->name('azure-directory-manual-sync');

            Route::resource('/mobile-iron', '\App\Http\Controllers\Assets\Settings\DiscoveryTools\MobileIronController', ['except' => ['index']]);
            Route::post('/mobile-iron-manual-sync', [MobileIronController::class, 'manualSync'])->name('mobile-iron-manual-sync');

            Route::resource('/kandji', '\App\Http\Controllers\Assets\Settings\DiscoveryTools\KandjiController', ['except' => ['index']]);
            Route::post('/kandji-manual-sync', [KandjiController::class, 'manualSync'])->name('kandji-manual-sync');

            Route::resource('/ups-tracking', '\App\Http\Controllers\Assets\Settings\UpsTrackingController', ['except' => ['index']]);
            Route::resource('/fedex-tracking-api', 'Assets\Settings\FedexTrackingController', ['except' => ['index']]);

            Route::resource('/zendesk', '\App\Http\Controllers\Assets\Settings\ZendeskApiCredentialsController', ['except' => 'index']);
            Route::resource('/spoke', '\App\Http\Controllers\Assets\Settings\SpokeApiCredentialsController', ['except' => 'index']);
            Route::resource('/freshservice', '\App\Http\Controllers\Assets\Settings\FreshServiceController', ['except' => 'index']);

            // Route::resource('/slack-notification-credentials', 'Assets\Settings\SlackNotificationCredentialsController', ['except' => 'index']);

            Route::resource('/crowdstrike', '\App\Http\Controllers\Security\Crowdstrike\CrowdstrikeCredentialsController', ['except' => 'index']);

            Route::resource('/retriever-credentials', 'Assets\Settings\RetrieverCredentialsController', ['except' => 'index']);
            Route::post('/retriever-manual-sync', 'Assets\Settings\RetrieverCredentialsController@manualSync')->name('retriever-manual-sync');
            Route::resource('/revivn', 'Assets\Settings\RevivnController', ['except' => 'index']);

            Route::get('/slack-notifications-connect', [SlackNotificationsController::class, 'connect'])->name('slack-notifications.connect');
            Route::get('/slack-notifications-callback', [SlackNotificationsController::class, 'callback']);
            Route::get('/slack-notifications/{slack_api_credential}/reset', [SlackNotificationsController::class, 'resetAccessToken'])->name('slack-notifications.reset');

            Route::resource('/slack-notifications-config', 'Settings\SlackNotifications\SlackChannelsConfigController', ['except' => 'index']);
            Route::post('/update-slack-notifications-status', [SlackChannelsConfigController::class, 'updateSlackNotificationsStatus'])->name('update-slack-notifications-status');
            Route::get('/search-slack-channel', [SlackChannelsConfigController::class, 'searchChannels'])->name('search-slack-channel');
            Route::resource('/jumpcloud', '\App\Http\Controllers\Settings\DiscoveryTools\JumpCloudCredentialsController', ['except' => ['index']]);
            Route::get('/download-public-key/{file}', [JiraCredentialsController::class, 'downloadPublicKey'])->name('download-public-key');

            Route::resource('/asn-presidio-settings', 'Assets\Settings\PresidioController', ['except' => ['index']]);

            Route::resource('/hibob', 'Assets\Settings\HiBobController', ['except' => 'index']);
            Route::get('/hibob-connect', 'Assets\Settings\HiBobController@connect')->name('hibob.connect');
            Route::post('/hibob-sync', 'Assets\Settings\HiBobController@manualSync');

            // Zoom hardware credentials
            Route::resource('/zoom-hardware', 'Settings\Integrations\ZoomHardwareCredentialsController', ['except' => 'index']);
            Route::get('/zoom-hardware-connect', 'Settings\Integrations\ZoomHardwareCredentialsController@connect')->name('zoom-hardware-connect');
            Route::get('/zoom-hardware-callback', 'Settings\Integrations\ZoomHardwareCredentialsController@callback');
            Route::post('/zoom-hardware-download-data', 'Settings\Integrations\ZoomHardwareCredentialsController@downloadZoomRoomsData')->name('zoom-hardware-download-data');
            Route::post('/zoom-hardware-download-locations', 'Settings\Integrations\ZoomHardwareCredentialsController@downloadZoomRoomsLocations')->name('zoom-hardware-download-locations');
            Route::get('/zoom-hardware-disconnect', 'Settings\Integrations\ZoomHardwareCredentialsController@resetConnection')->name('zoom-hardware-disconnect');
            Route::post('/zoom-hardware-test-connection', 'Settings\Integrations\ZoomHardwareCredentialsController@test')->name('zoom-hardware-test-connection');
            Route::post('/zoom-hardware-manual-sync', 'Settings\Integrations\ZoomHardwareCredentialsController@manualSync')->name('zoom-hardware-manual-sync');
        });

        Route::group(['middleware' => ['permission:Bulk Status Update']], function () {
            Route::post('bulk-status-update/upload', [BulkStatusUpdateController::class, 'upload']);
            Route::post('bulk-status-update/special-upload', [BulkStatusUpdateController::class, 'specialUpload']);
            Route::resource('/bulk-status-update', '\App\Http\Controllers\Assets\Settings\BulkStatusUpdateController');
        });

        Route::group(['middleware' => ['permission:Bulk Assign']], function () {
            Route::post('bulk-assign/upload', [BulkAssignController::class, 'upload']);
            Route::resource('/bulk-assign', '\App\Http\Controllers\Assets\Settings\BulkAssignController');
            Route::post('bulk-assign/special-upload', [BulkAssignController::class, 'specialUpload']);
        });

        Route::group(['middleware' => ['permission:Bulk Install']], function () {
            Route::post('bulk-install/upload', [BulkInstallController::class, 'upload']);
            Route::post('bulk-install/special-upload', [BulkInstallController::class, 'specialUpload']);
            Route::resource('/bulk-install', '\App\Http\Controllers\Assets\Settings\BulkInstallController');
        });

        Route::group(['middleware' => ['permission:Bulk Loans']], function () {
            Route::post('bulk-loans/upload', [BulkLoansController::class, 'upload']);
            Route::post('bulk-loans/special-upload', [BulkLoansController::class, 'specialUpload']);
            Route::resource('/bulk-loans', '\App\Http\Controllers\Assets\Settings\BulkLoansController');
        });

        Route::group(['middleware' => ['permission:Bulk Lost Stolen']], function () {
            Route::post('bulk-lost-stolen/upload', [BulkLostStolenController::class, 'upload']);
            Route::post('bulk-lost-stolen/special-upload', [BulkLostStolenController::class, 'specialUpload']);
            Route::resource('/bulk-lost-stolen', '\App\Http\Controllers\Assets\Settings\BulkLostStolenController');
        });

        Route::group(['middleware' => ['permission:On Hand Statuses']], function () {
            Route::post('on-hand-statuses/upload', [BulkDamageController::class, 'upload']);
            Route::post('on-hand-statuses/special-upload', [BulkDamageController::class, 'specialUpload']);
            Route::resource('/on-hand-statuses', '\App\Http\Controllers\Assets\Settings\BulkDamageController');
        });

        Route::group(['middleware' => ['permission:Bulk Hold']], function () {
            Route::post('bulk-hold/upload', [BulkHoldController::class, 'upload']);
            Route::post('bulk-hold/special-upload', [BulkHoldController::class, 'specialUpload']);
            Route::resource('/bulk-hold', '\App\Http\Controllers\Assets\Settings\BulkHoldController');
        });

        Route::group(['middleware' => ['permission:Bulk Return']], function () {
            Route::post('bulk-return/upload', [BulkReturnController::class, 'upload']);
            Route::get('/bulk-return', [BulkReturnController::class, 'index'])->name('bulk-return.index');
            Route::post('/bulk-return/store', [BulkReturnController::class, 'store'])->name('bulk-return.store');
            Route::post('bulk-return/special-upload', [BulkReturnController::class, 'specialUpload']);
        });

        Route::group(['middleware' => ['permission:Bulk Move']], function () {
            Route::get('/bulk-move', [BulkMoveController::class, 'index'])->name('bulk-move.index');
            Route::post('bulk-move/upload', [BulkMoveController::class, 'upload']);
            Route::post('bulk-move/special-upload', [BulkMoveController::class, 'specialUpload']);
            Route::post('/bulk-move/store', [BulkMoveController::class, 'store'])->name('bulk-move.store');
        });

        Route::group(['middleware' => ['permission:Bulk Link']], function () {
            Route::post('bulk-link/upload', [BulkLinkController::class, 'upload']);
            Route::get('/bulk-link', [BulkLinkController::class, 'index'])->name('bulk-link.index');
            Route::post('/bulk-link/store', [BulkLinkController::class, 'store'])->name('bulk-link.store');
            Route::post('bulk-link/special-upload', [BulkLinkController::class, 'specialUpload']);
        });

        Route::group(['middleware' => ['permission:Bulk Create Link Mobile']], function () {
            Route::post('bulk-create-link/upload', [BulkCreateLinkMobileController::class, 'upload']);
            Route::resource('/bulk-create-link', '\App\Http\Controllers\Assets\Settings\BulkCreateLinkMobileController');
        });

        Route::group(['middleware' => ['permission:Bulk Create Hardware and Specs']], function () {
            Route::post('bulk-hardware-standards/upload', [BulkHardwareStandardsController::class, 'upload']);
            Route::resource('/bulk-hardware-standards', '\App\Http\Controllers\Assets\Settings\BulkHardwareStandardsController');
            Route::post('bulk-technical-specs/upload', [BulkTechnicalSpecsController::class, 'upload']);
            Route::resource('/bulk-technical-specs', '\App\Http\Controllers\Assets\Settings\BulkTechnicalSpecsController');
        });

        Route::group(['middleware' => ['permission:Bulk Asset Attribute Update']], function () {
            Route::post('bulk-asset-attribute-update/upload', [BulkAssetAttributeUpdateController::class, 'upload']);
            Route::post('bulk-asset-attribute-update/special-upload', [BulkAssetAttributeUpdateController::class, 'specialUpload']);
            Route::get('/bulk-asset-attribute-update', [BulkAssetAttributeUpdateController::class, 'index'])->name('bulk-asset-attribute.index');
            Route::post('/bulk-asset-attribute-update', [BulkAssetAttributeUpdateController::class, 'store']);
        });

        Route::group(['middleware' => ['permission:EOL Certificates Upload']], function () {
            Route::post('bulk-certificates-upload/upload', [BulkCertificatesUploadController::class, 'upload']);
            Route::resource('/eol-certificates-consolidated', '\App\Http\Controllers\Assets\Settings\BulkCertificatesUploadController');

            Route::get('/eol-certificates-individual', [EolCertificatesController::class, 'index'])->name('eol-certificates-upload.index');
            Route::post('/eol-certificates-upload', [EolCertificatesController::class, 'upload']);
        });

        Route::get('/download/{file}', [FileController::class, 'download'])->name('download');
        Route::get('/downloadcertificate/{file}', [FileController::class, 'downloadEndOfFile'])->name('downloadcertificate')->middleware('validate_referer');
        Route::get('/download-eol-certificate/{id}', [FileController::class, 'downloadEOLFile'])->name('download-eol-certificate')->middleware('validate_referer');
        Route::post('/save-image', [FileController::class, 'saveImage'])->name('upload');
        Route::get('/graph-export', [FileController::class, 'graphExport'])->name('graph-export')->middleware('permission:Inventory Control View|Reports View');

        Route::post('assets-filter/listHardware', [SearchController::class, 'listHardware'])->name('assets-filter.listhardware');
        Route::post('assets-filter/listtechnics', [SearchController::class, 'listTechnicalSpec'])->name('assets-filter.listtechnics');
        Route::post('assets-filter/list-hardware-with-manufacturer', [SearchController::class, 'listHardwareWithManufacturer']);
        Route::post('assets-filter/list-manufacturer', [SearchController::class, 'listManufacturer']);
        Route::get('/list-asset-statuses', [SearchAssetController::class, 'listAssetStatuses'])->name('assets-filter.liststatuses');
        Route::get('/get-filter-fields', [FilterFieldController::class, 'getAssetFilterFields']);
        Route::get('/get-filter-fields-server', [FilterFieldController::class, 'getFilterServerFields']);
        Route::get('/get-filter-fields-user', [UserFilterFieldController::class, 'getFilterUserFields']);
        Route::get('/get-filter-fields-user-department', [UserFilterFieldController::class, 'getFilterUserDepartmentFields']);
        Route::get('/get-filter-fields-all-user', [UserFilterFieldController::class, 'getFilterAllUserFields']);
        Route::get('/get-filter-fields-assigned-user', [UserFilterFieldController::class, 'getFilterAssignedUserFields']);
        Route::get('/get-filter-fields-chrome-devices', [FilterFieldController::class, 'getFilterFieldsChromebook']);
        Route::get('/get-filter-fields-workspace-one', [FilterFieldController::class, 'getFilterFieldsWorkspaceOne']);
        Route::get('/get-filter-fields-assign-assets', [FilterFieldController::class, 'getFilterAssetsForAssignFields']);

        Route::post('/filter-field/get-technical-spec', [FilterFieldController::class, 'getTechnicalSpecs'])->name('filter-field.get-technical-specs');
        Route::post('/filter-field/get-hardware-standards', [FilterFieldController::class, 'getHardwareStandards'])->name('filter-field.get-hardware-standards');
        Route::get('/filter-field/get-users-with-teq-users', [FilterFieldController::class, 'getUsersWithTeqtivityUsersFields'])->name('filter-field.get-users-with-teq-users');
        Route::post('/list-career', [FilterFieldController::class, 'listCarrier'])->name('list-carrier');
        Route::post('/list-additional-search-attribute', [FilterFieldController::class, 'listAdditionalSearchAttribute'])->name('list-additional-search-attribute');

        Route::get('/get-filter-fields-vulnerability', [CrowdstrikeReportController::class, 'getFilterVulnerabilityFields']);

        Route::get('/get-country-list', [FilterFieldController::class, 'getCountryList']);
        Route::get('/get-filter-fields-location', [LocationFilterFieldsController::class, 'getFilterLocationFields']);
        Route::get('/get-filter-fields-location-relation', [LocationFilterFieldsController::class, 'getFilterLocationFieldsWithRelation']);
        Route::get('/get-filter-storage-location', [LocationFilterFieldsController::class, 'getFilterStorageLocation']);
        Route::get('/get-filter-install-location', [LocationFilterFieldsController::class, 'getFilterInstallLocation']);
        Route::get('/get-filter-install-building-location', [LocationFilterFieldsController::class, 'getFilterInstallAndBuildingLocations']);
        Route::get('/get-filter-installed-location', [LocationFilterFieldsController::class, 'getFilterInstalledLocations']);
        Route::get('/get-single-location-info/{id}', [LocationController::class, 'getSingleLocationInfo']);

        Route::get('/get-filter-teqtivity-user', [FilterFieldController::class, 'getFilterTeqtivityUser']);

        Route::group(['middleware' => ['permission:Purge Assets']], function () {
            Route::delete('/purge-assets/{purge_asset}', [PurgeAssetController::class, 'destroy'])
                ->name('purge-assets.destroy')
                ->middleware('validate_referer');
            Route::post('/purge-assets/destroyAll', [PurgeAssetController::class, 'destroyAll'])->name('purge-assets.destroyAll');
            Route::resource('/purge-assets', '\App\Http\Controllers\Assets\Settings\PurgeAssetController')->except(['destroy']);
        });

        Route::group(['middleware' => ['permission:Research Assets View']], function () {
            Route::resource('research-assets', '\App\Http\Controllers\Assets\ResearchAssetController', ['only' => 'index', 'show']);
            Route::get('research-assets/search', [ResearchAssetController::class, 'search'])->name('search-research-assets');
            Route::post('/assets-research-data', [ResearchAssetController::class, 'data'])->name('assets-research-data');
        });

        Route::group(['middleware' => ['permission:Research Assets Create']], function () {
            Route::resource('research-assets', '\App\Http\Controllers\Assets\ResearchAssetController', ['except' => 'index', 'show']);
            Route::post('research-assets/add', [ResearchAssetController::class, 'add'])->name('research-assets.updateRows');
            Route::post('research-assets/upload', [ResearchAssetController::class, 'upload']);
            Route::post('research-assets/special-upload', [ResearchAssetController::class, 'specialUpload']);
        });

        Route::group(['middleware' => ['permission:Research Assets Edit']], function () {
            Route::get('assets-link/research', [LinkController::class, 'research'])->name('assets-link.research');
            Route::get('assets-move/research', [MoveController::class, 'research'])->name('assets-move.research');
            Route::get('assets-return/research', [ReturnController::class, 'research'])->name('assets-return.research');
        });

        Route::group(['middleware' => ['permission:Failed Ticket Logs View']], function () {
            Route::get('/failed-tickets', [FailedTicketController::class, 'index'])->name('failed-tickets.index');
            Route::post('/failed-tickets-data', [FailedTicketController::class, 'data'])->name('failed-tickets-data');
            Route::post('/failed-ticket-history-export', [FailedTicketController::class, 'export'])->name('failed-ticket-history-export');
        });

        Route::group(['middleware' => ['permission:Discovery Tools Hardware Mapping']], function () {
            Route::resource('/discovery-tools-hardware-mapping', 'Assets\Settings\DiscoveryToolsHardwareMappingController');
            Route::post('/discovery-tools-hardware-mapping-data', [DiscoveryToolsHardwareMappingController::class, 'data']);
            Route::post('/discovery-tools-hardware-mapping-ajax', [DiscoveryToolsHardwareMappingController::class, 'ajax']);
            Route::get('/hardware-resync', [DiscoveryToolsHardwareMappingController::class, 'mapping']);
            Route::get('/get-filter-fields-discovery-mappings', [DiscoveryToolsHardwareMappingController::class, 'getFilterHardwareMappingFields']);
        });



        Route::group(['middleware' => ['permission:Cloud Assets View']], function () {
            Route::group(['prefix' => 'cloud-assets'], function () {
                Route::get('/', [CloudAssetsController::class, 'index'])->name('cloud-assets.index');
                Route::post('/data', [CloudAssetsController::class, 'data'])->name('cloud-assets.data');
                Route::post('/export', [CloudAssetsController::class, 'export'])->name('cloud-assets.export');
                Route::get('/filter-field-values', [CloudAssetsController::class, 'filterFieldValues'])->name('cloud-assets.filter-field-values');
            });
        });

        Route::group(['middleware' => ['permission:Support Page View']], function () {
            Route::get('/support-page', [SupportPageController::class, 'index']);
        });
        Route::get('help-link', [HelpController::class, 'helpLink'])->name('help-link');
        Route::get('/gitbook-auth-callback', [ApiUserController::class, 'gitBookAuthCallback']);
    });

    Route::view('/forgot-password', 'auth.forgot-password');
});


Auth::routes(['register' => false]);

Route::group(['middleware' => 'validate_referer'], function () {
    Route::post('password/email', [ForgotPasswordController::class, 'sendResetLinkEmail'])->name('password.email');
    Route::post('password/reset', [ResetPasswordController::class, 'reset'])->name('password.update');
});

Route::view('login', 'auth.login');
Route::post('/login', [LoginController::class, 'authenticate'])->name('login');
Route::post('/verify', [LoginController::class, 'emailVerify'])->name('email-verify');
Route::get('logout', [LoginController::class, 'logout']);

Route::post('switch-theme', [ThemeSwitchController::class, 'toggle'])->name('switch-theme');

Route::get('login/okta', [OktaLoginController::class, 'redirectToProvider'])->name('login-okta');
Route::get('login/okta/callback', [OktaLoginController::class, 'handleProviderCallback']);

if (config('app.env') == 'production') {
    Route::view('e6db566c-8ab3-40f2-a6fc-7ae81bf52374', 'admin.login');
    Route::post('/e6db566c-8ab3-40f2-a6fc-7ae81bf52374', [AdminLoginController::class, 'authenticate'])->name('admin-login');
} else {
    Route::view('dc7c2640-01b7-417f-a59c-c4814da3ff96', 'admin.login');
    Route::post('/dc7c2640-01b7-417f-a59c-c4814da3ff96', [AdminLoginController::class, 'authenticate'])->name('admin-login');
}
