<?php

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;

/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| is assigned the "api" middleware group. Enjoy building your API!
|
*/

Route::post('authenticate', [\App\Http\Controllers\Api\AuthenticateController::class, 'authenticate'])->middleware('throttle:api-throttle');
Route::post('refresh-token', [\App\Http\Controllers\Api\AuthenticateController::class, 'refreshToken'])->middleware(['throttle:api-throttle', 'api_request_log']);

Route::group(['middleware' => ['untrusted_ips']], function ($api) {

    Route::group(['middleware' => ['auth_client:view-assets', 'api_request_log']], function ($api) {

        Route::get('find-assets', [\App\Http\Controllers\Api\AssetSearchApiController::class, 'getAllAssets']);
        Route::get('search-asset', [\App\Http\Controllers\Api\AssetSearchApiController::class, 'searchAsset']);
        Route::get('terminated-assets', [\App\Http\Controllers\Api\AssetSearchApiController::class, 'getTerminatedUserAssets']);
    });
    Route::group(['middleware' => ['auth_client:create-asset', 'api_request_log']], function ($api) {
        Route::post('create-asset', [\App\Http\Controllers\Api\CreateAssetApiController::class, 'index']);
    });

    Route::group(['middleware' => ['auth_client:update-asset', 'api_request_log']], function ($api) {
        Route::post('update-asset', [\App\Http\Controllers\Api\UpdateAssetApiController::class, 'update']);
    });

    Route::group(['middleware' => ['auth_client:create-location', 'api_request_log']], function ($api) {
        Route::post('create-location', [\App\Http\Controllers\Api\CreateLocationApiController::class, 'index']);
    });

    Route::group(['middleware' => ['auth_client:create-user', 'api_request_log']], function ($api) {
        Route::post('create-user', [\App\Http\Controllers\Api\CreateUserApiController::class, 'index']);
    });

    Route::group(['middleware' => ['auth_client:update-user', 'api_request_log']], function ($api) {
        Route::post('update-user', [\App\Http\Controllers\Api\UpdateUserApiController::class, 'index']);
    });

    Route::group(['middleware' => 'auth_client'], function ($api) {
        Route::group(['middleware' => 'api_request_log'], function ($api) {
            Route::get('find-users', [\App\Http\Controllers\Api\UserApiController::class, 'findUsers']);
            Route::get('search-user', [\App\Http\Controllers\Api\UserApiController::class, 'searchUser']);
            Route::get('find-locations', [\App\Http\Controllers\Api\LocationApiController::class, 'getLocations']);
            Route::get('search-location', [\App\Http\Controllers\Api\LocationApiController::class, 'searchLocation']);
            Route::get('find-hardwares', [\App\Http\Controllers\Api\HardwareStandardApiController::class, 'getHardwares']);
            Route::get('search-hardwares', [\App\Http\Controllers\Api\HardwareStandardApiController::class, 'searchHardwares']);
            Route::get('find-techspecs', [\App\Http\Controllers\Api\TechSpecApiController::class, 'getTechSpecs']);
            Route::get('search-techspecs', [\App\Http\Controllers\Api\TechSpecApiController::class, 'searchTechSpecs']);
            Route::get('get-asset-types', [\App\Http\Controllers\Api\AssetTypesApiController::class, 'getAssetTypes']);
            Route::get('get-manufacturers', [\App\Http\Controllers\Api\ManufacturerApiController::class, 'index']);
            Route::get('get-asset-statuses', [\App\Http\Controllers\Api\AssetStatusApiController::class, 'index']);
            Route::get('get-vendors', [\App\Http\Controllers\Api\VendorApiController::class, 'index']);
            Route::get('get-mobile-carriers', [\App\Http\Controllers\Api\MobileCarrierApiController::class, 'index']);
            Route::get('get-location-types', [\App\Http\Controllers\Api\LocationTypeApiController::class, 'index']);
            Route::get('get-site-codes', [\App\Http\Controllers\Api\SiteCodeApiController::class, 'index']);
        });

        Route::group(['middleware' => 'api_request_log'], function ($api) {
            //Discovery tools
            Route::group(['prefix' => 'mdm'], function ($api) {
                Route::get('devices-not-created', [\App\Http\Controllers\Api\MdmController::class, 'index']);
            });
        });
    });

    Route::group(['middleware' => 'auth_client:view-assets,update-asset'], function ($api) {
        //JIra Plugin Routes
        Route::group(['prefix' => 'jira'], function ($api) {
            Route::get('reporter-assets/{email}', [\App\Http\Controllers\Api\Jira\ReporterAssetsController::class, 'index']);
            Route::get('users', [\App\Http\Controllers\Api\Jira\TeqtivityUsersController::class, 'index']);
            Route::get('users/search', [\App\Http\Controllers\Api\Jira\TeqtivityUsersSearchController::class, 'index']);
            Route::get('locations', [\App\Http\Controllers\Api\Jira\TeqtivityLocationsController::class, 'index']);
            Route::get('locations/search', [\App\Http\Controllers\Api\Jira\TeqtivityLocationsSearchController::class, 'index']);
            Route::post('asset-status/update', [\App\Http\Controllers\Api\Jira\TeqtivityAssetStatusController::class, 'update']);
            Route::get('teqtivity-user/{email}', [\App\Http\Controllers\Api\Jira\TeqtivityUsersController::class, 'findByEmail']);
            Route::get('assets/search', [\App\Http\Controllers\Api\Jira\TeqtivityAssetsSearchController::class, 'index']);
            Route::get('status-details', [\App\Http\Controllers\Api\Jira\TeqtivityAssetStatusDetailsController::class, 'index']);
        });

        //Zendesk Plugin Routes
        Route::group(['prefix' => 'zendesk'], function ($api) {
            Route::get('reporter-assets/{email}', [\App\Http\Controllers\Api\Jira\ReporterAssetsController::class, 'index']);
            Route::post('asset-status/update', [\App\Http\Controllers\Api\Jira\TeqtivityAssetStatusController::class, 'update']);
            Route::get('users/search', [\App\Http\Controllers\Api\Jira\TeqtivityUsersSearchController::class, 'index']);
            Route::get('locations/search', [\App\Http\Controllers\Api\Jira\TeqtivityLocationsSearchController::class, 'index']);
            //special search case - separate function for Zendesk app
            Route::get('assets/search', [\App\Http\Controllers\Api\Zendesk\TeqtivityAssetsSearchController::class, 'index']);
            Route::get('status-details', [\App\Http\Controllers\Api\Jira\TeqtivityAssetStatusDetailsController::class, 'index']);
        });

        Route::group(['prefix' => 'slackbot'], function ($api) {
            Route::get('my-assets', [\App\Http\Controllers\Api\Slackbot\MyAssetsController::class, 'index']);
            Route::get('other-user-assets', [\App\Http\Controllers\Api\Slackbot\OtherUserAssetsController::class, 'index']);
            Route::get('update-loaner-return-date-asset', [\App\Http\Controllers\Api\Slackbot\LoanerReturnDateController::class, 'getAssetToUpdate']);
            Route::post('update-loaner-return-date', [\App\Http\Controllers\Api\Slackbot\LoanerReturnDateController::class, 'updateLoanerReturnDate']);
            Route::get('update-asset-tag-asset', [\App\Http\Controllers\Api\Slackbot\AssetTagController::class, 'getAssetToUpdate']);
            Route::post('update-asset-tag', [\App\Http\Controllers\Api\Slackbot\AssetTagController::class, 'updateAssetTag']);

            Route::get('assign-asset-details', [\App\Http\Controllers\Api\Slackbot\AssignAssetController::class, 'getAssetDetails']);
            Route::post('assign-asset', [\App\Http\Controllers\Api\Slackbot\AssignAssetController::class, 'updateAssetStatus']);

            Route::get('loan-asset-details', [\App\Http\Controllers\Api\Slackbot\LoanAssetController::class, 'getAssetDetails']);
            Route::post('loan-asset', [\App\Http\Controllers\Api\Slackbot\LoanAssetController::class, 'updateAssetStatus']);

            Route::get('install-asset-details', [\App\Http\Controllers\Api\Slackbot\InstallAssetController::class, 'getAssetDetails']);
            Route::post('install-asset', [\App\Http\Controllers\Api\Slackbot\InstallAssetController::class, 'updateAssetStatus']);
        });
    });
});

Route::middleware('scim_auth')->group(function () {
    Route::get('/scim/v2/Users', [\App\Http\Controllers\Api\Scim\UserController::class, 'index']);
    Route::post('/scim/v2/Users', [\App\Http\Controllers\Api\Scim\UserController::class, 'create']);
    Route::put('/scim/v2/Users/{id}', [\App\Http\Controllers\Api\Scim\UserController::class, 'update']);
    Route::delete('/scim/v2/Users/{id}', [\App\Http\Controllers\Api\Scim\UserController::class, 'delete']);
    Route::get('/scim/v2/Users/{id}', [\App\Http\Controllers\Api\Scim\UserController::class, 'getUser'])->name('api.scim.user.detail');
    Route::patch('/scim/v2/Users/{id}', [\App\Http\Controllers\Api\Scim\UserController::class, 'updateUser'])->name('api.scim.users.update');

    Route::get('/scim/v2/Groups', [\App\Http\Controllers\Api\Scim\GroupController::class, 'index']);
    Route::post('/scim/v2/Groups', [\App\Http\Controllers\Api\Scim\GroupController::class, 'create']);
    Route::put('/scim/v2/Groups/{id}', [\App\Http\Controllers\Api\Scim\GroupController::class, 'update']);
    Route::patch('/scim/v2/Groups/{id}', [\App\Http\Controllers\Api\Scim\GroupController::class, 'updateGroup']);
    Route::get('/scim/v2/Groups/{id}', [\App\Http\Controllers\Api\Scim\GroupController::class, 'getGroup'])->name('api.scim.group.detail');
});
