<script src="/js/plugins/jquery-validation/jquery.validate.min.js"></script>
<script src="/js/validator-methods.js"></script>
<script src="/js/plugins/jquery-validation/additional-methods.min.js"></script>
<script>
	$(document).ready(function () {
		var options2 = {};
		options2.ui = {
			container: "#pwd-container",
			showStatus: true,
			showProgressBar: false,
			viewports: {
				verdict: ".pwstrength_viewport_verdict"
			}
		};
		$('.example2').pwstrength(options2);

		$(".select2").select2();

		$('#data_1 .input-group.date').datepicker({
			todayBtn: "linked",
			clearBtn: true,
			keyboardNavigation: false,
			forceParse: false,
			calendarWeeks: false,
			autoclose: true
		});

		$('#user-type').on('change', function () {
			if (this.value === '4') {
				$("#pwd-container").hide();
			} else {
				$("#pwd-container").show();
			}
		});
	});

	$("#upload-asset-form").validate({
		rules: {
			bulk_upload_asset: {
				extension: "csv",
				required: true,
			}
		},
		messages: {
			bulk_upload_asset: {
				extension: "Please upload a csv file"
			}
		},
		errorPlacement: function (error, element) {
			$('.user-bulk-upload-error-div').html(error);   	    
    	},
	});

	$('#upload-asset-form').submit(function (e) {

		e.preventDefault();

		if($('#bulk_upload_asset')[0].files[0]==undefined){

			$('.user-bulk-upload-error-div').html('');
			// Create a new element to hold the error message
			$('.user-bulk-upload-error-div').html('<label for="bulk_upload_asset" class="error">This field is required.</label>');
			return;
		}

		var formData = new FormData();
		formData.append('file', $('#bulk_upload_asset')[0].files[0]);

		$.ajax({
			type: "POST",
			url: $(this).attr('action'),
			data: formData,
			async: false,
			success: function (value) {
				$('#asset_count').html(value.count);
				$('tbody').append(value.data);
				$('#upload-asset-form').append(value.errors);
				$('#upload-asset-form')[0].reset();
			},
			cache: false,
			contentType: false,
			processData: false
		});


	});
	function deleteUserRow(id) {
		$("#tblview #" + id).remove();
		var count = $('#count_add').val();
		count--;
		$('#count_add').val(count);
		$('#asset_count').html(count);
	}
	$("#create-user-form").validate({
		rules: {
			first_name: {
				required: true,
			},
			last_name: {
				required: true,
			},
			employee_id: {
				required: true,
				//unique: true,
				minlength: 2,
				unique_fields: [3, 'employee_id'],
			},
			email: {
				required: true,
				//unique: true,
				minlength: 2,
				unique_fields: [2, 'email'],
			},

			// business_title: {
			// 	required: true
			// },
			user_type_id: {
				required: true
			},
			// employee_type: {
			// 	required: true,
			// }
			hire_date: {
				required: true,
			},

		},
		errorPlacement: function (error, element) {
			element.closest('.user-field').find('.user-validator').html(error);
		},
	});
	$("#create-user-form").on('submit', function (e) {
		var isvalid = $("#create-user-form").valid();
		if (isvalid) {
			e.preventDefault();
		}
	});

	$("#upload-asset-form").validate({
		rules: {
			bulk_upload_asset: {
				extension: "csv",
				required: true,
			}
		},
		messages: {
			bulk_upload_asset: {
				extension: "Please upload a csv file"
			}
		}
	});
</script>