<script src="/js/plugins/chosen/chosen.jquery.js"></script>
<script src="/js/plugins/dataTables/datatables.min.js"></script>
<script src="/js/plugins/chosen/chosen.ajaxaddition.jquery.js"></script>
<script src="/js/plugins/dataTables/dataTables.fixedColumns.min.js"></script>

<link href="/css/plugins/dataTables/fixedHeader.dataTables.min.css" rel="stylesheet">

<script>

    $(document).ready(function () {
        $('.chosen-select').chosen({ width: "100%" }).change(function () {
            $(this).closest('.form-group').next().find('input').focus();
        });


        $.fn.serializeObject = function () {
            var obj = {};

            $.each(this.serializeArray(), function (i, o) {
                var n = o.name, v = o.value;

                obj[n] = obj[n] === undefined ? v
                    : $.isArray(obj[n]) ? obj[n].concat(v)
                        : [obj[n], v];
            });

            return obj;
        };

        var table = $('.footable').DataTable({
           	fixedHeader:true,
			"scrollX": true,
            scrollY: '400px',
            scrollCollapse: true,
		   	fixedColumns: true,
            
			fixedColumns: {
            left: 3
        },
            "processing": true,
            "serverSide": true,
            "ajax": {
                "url": "{{ route('users-data') }}",
                "dataType": "json",
                "type": "POST",
                "data": function (result) {
                    result.form = $('#search-form').serializeObject();
                }
            },
            "columns": [
                { "data": "id" },
                { "data": "first_name" },
                { "data": "last_name" },
                { "data": "user_email" },
                { "data": "title" },
                { "data": "employee_id" },
                { "data": "user_type" },
                { "data": "user_role" },
                { "data": "hire_date" },
                { "data": "department" },
                { "data": "work_location" },
                { "data": "country" },
                { "data": "status" },
                { "data": "termination_date" },
                { "data": "of_assets" },
                { "data": "action" },
            ],
            lengthMenu: [
                [50, 100, 200],
                ['50', '100', '200']
            ],
            "ordering": false,
            "aaSorting": [],
            "dom": '<"top"i>rt<"bottom"flp><"clear">',
            "bAutoWidth": false,
            "bFilter": true,
            "bLengthChange": false,
            "searching": false,
            "fnDrawCallback": function (oSettings) {
                if (table.page.info().recordsTotal == 0) {
                    $("#export-user-csv").hide();
                } else {
                    $("#export-user-csv").show();
                }
                
                // Add or update the Last Sync text
                if (!$("#DataTables_Table_0_paginate").find('.last-sync-text').length) {
                    $("#DataTables_Table_0_paginate").children().before('<p class="last-sync-text" style="float:left; margin-top: 8px">Last Sync: {{ $lastSyncDate ?? "" }}</p>');
                }
            },

        });

        var delay = (function () {
            var timer = 0;
            return function (callback, ms) {
                clearTimeout(timer);
                timer = setTimeout(callback, ms);
            };
        })();

        $('#search-form').submit(function (e) {
            e.preventDefault();
            table.draw();
        });

        $("#searchUser").on('keyup change', function () {
            delay(function () {
                $('#search-form').submit();
            }, 200);
        });


        $(".filter-field-user").each(function () {
            var name = $(this).attr('key');
            $(this).select2({
                minimumInputLength: 1,
                multiple: true,
                ajax: {
                    url: '/get-filter-fields',
                    dataType: "json",
                    data: function (params) {
                        var query = {
                            search: params.term,
                            type: name
                        }

                        // Query parameters will be ?search=[term]&type=public
                        return query;
                    },
                    processResults: function (data) {
                        // Tranforms the top-level key of the response object from 'items' to 'results'
                        return {
                            results: data
                        };
                    },

                }
            });
        });

        $("#status, #legalhold, #employee_type, #work_location, #system_role, #has_mobile_phone_assigned,#employee_id, #country_id").on('change', function () {
            $('#search-form').submit();
        });

        $("#have_assets").on('change', function () {
            if ($("#have_assets").val() == 2) {
                $('#countDiv').hide();
                $('#no_of_assets').val('');
            } else if ($("#have_assets").val() == 1) {
                $('#countDiv').show();
            }

            $('#search-form').submit();
        });

        $('#no_of_assets').on('keyup change', function () {
            $('#search-form').submit();
        });

        $('#export-user-csv').on('click', function (e) {
            e.preventDefault();
            $('.ajax-loader').show();
            $.ajax({
                type: "POST",
                url: "/user-export",
                data: $('#search-form').serializeObject(),
                dataType: 'text',
                success: function (result) {
                    var checkPortion = 'Your report will be generated in the background.';
					if (checkPortion == result.substring(0, 48)) {
						$("#sync-success-msg").html(result);
            			$("#sync-success").show();
						$('.ajax-loader').hide();
					} else {
                        var blob = new Blob([result]);
                        if (window.navigator.msSaveOrOpenBlob)  // IE hack; see http://msdn.microsoft.com/en-us/library/ie/hh779016.aspx
                            window.navigator.msSaveBlob(blob, "user.csv");
                        else {
                            var a = window.document.createElement("a");
                            a.href = window.URL.createObjectURL(blob, { type: "text/plain" });
                            a.download = "user.csv";
                            document.body.appendChild(a);
                            a.click();  // IE: "Access is denied"; see: https://connect.microsoft.com/IE/feedback/details/797361/ie-10-treats-blob-url-as-cross-origin-and-denies-access
                            document.body.removeChild(a);
                        }
                        $('.ajax-loader').hide();
                    }
                }
            })
        });
    });

    $('.input-group.date').datepicker({

        todayBtn: "linked",

        clearBtn: true,

        keyboardNavigation: false,

        forceParse: false,

        calendarWeeks: false,

        autoclose: true

    }).on('change', function (e) {
        $('#search-form').submit();
    });

    $(".filter-field-location").each(function () {
        var name = $(this).attr('key');
        $(this).select2({
            minimumInputLength: 1,
            multiple: true,
            ajax: {
                url: '/get-filter-fields-location',
                dataType: "json",
                data: function (params) {
                    var query = {
                        search: params.term,
                        type: name
                    }

                    // Query parameters will be ?search=[term]&type=public
                    return query;
                },
                processResults: function (data) {
                    // Tranforms the top-level key of the response object from 'items' to 'results'
                    return {
                        results: data
                    };
                },

            }
        });
    });

    $(".filter-field-country").select2({
        minimumInputLength: 1,
        multiple: true,
        ajax: {
            url: '/get-country-list',
            dataType: "json",
            delay: 250, // adds slight delay to reduce API calls during typing
            data: function(params) {
                return {
                    search: params.term
                };
            },
            processResults: function(data) {
                // Transform each item to Select2 expected format {id, text}
                return {
                    results: data.map(function(item) {
                        return {
                            id: item.id,
                            text: item.name || item.text // fallback to item.text if name doesn't exist
                        };
                    })
                };
            },
            cache: true // caches requests to avoid duplicate API calls
        }
    });

</script>