@extends('layouts.main')
@section('content')
@include('partials.breadcrumb', ['breadcrumbTitle' => 'User'])
@include('file-exports.partials.file-exports-submenu',['report_type' => 'user_report'])
<div class="wrapper-content">
    <div class="container-fluid">

        @include('users.partials.filters')


        <div class="ibox">

            <div class="ibox-title">
                <div class="ibox-tools">

                    <a href="{{route('users.create')}}" class="btn btn-primary pull-right">Add New User</a>
                    <a href="#" id="export-user-csv" class="btn btn-primary">Export to CSV</a>
                </div>
            </div>

            <div class="ibox-content">


                @include('partials.success')
                @include('partials.error')
                @include('partials.error-message')
                @include('partials.sync-messages')

                <div class="ajax-loader"><img src="/img/ajax-loader-full-width.gif"></div>


                <table class="footable table table-stripped table-hover nowrap" data-page-size="50" data-filter=#filter>

                    <thead>

                        <tr>

                            <th>#</th>

                            <th>First Name</th>

                            <th>Last Name</th>

                            <th>Email</th>

                            <th>Title</th>

                            <th>Employee Id</th>

                            <th>User Type</th>

                            <th>Teqtivity Role</th>

                            <th>Start Date</th>

                            <th>Department</th>

                            <th>Work Location</th>

                            <th>Country</th>

                            <th>Employment Status</th>

                            <th>Termination date</th>

                            <th># of assets</th>

                            <th data-sort-ignore="true"></th>

                        </tr>

                    </thead>

                    <tbody>


                    </tbody>

                </table>

            </div>

        </div>

    </div>

</div>
@stop

@section('help-links')
@include('help.help-links',['helpLink'=>config('help-links.help_links.users'),'helpTitle'=>config('help-links.help_titles.users')])
@endsection

@section('after_scripts')

@include('users.scripts')

@stop
