@extends('layouts.main')
@section('content')
@include('partials.breadcrumb', ['breadcrumbTitle' => 'Edit User', 'parentUrl' => '/users', 'parentTitle' => 'Users'])

<div class="wrapper-content">
	<div class="container-fluid">
		<form class="form-horizontal" method="post" action="{{route('users.update', ['user' => $user->id])}}">
			{{csrf_field()}}
			<input type="hidden" name="_method" value="PUT">
			<div class="ibox">
				<div class="ibox-content">
					<div class="row">
						@include('partials.error')
						@include('partials.error-message')
						<div class="col-lg-6">
							
							<div class="form-group">
								<label class="col-lg-3 control-label">Name</label>
								<div class="col-lg-9">
									<input type="text" class="form-control" name="first_name" value="{{ $user->first_name." ".$user->last_name }}" readonly="readonly">
								</div>
							</div>
							
							<div class="form-group">
								<label class="col-lg-3 control-label"> Email </label>
								<div class="col-lg-9">
									<input type="email" class="form-control" name="email" value="{{ $user->email }}" readonly="readonly">
								</div>
							</div>
							
							<div class="form-group">
								<label class="col-lg-3 control-label">Teqtivity Role</label>
								<div class="col-lg-9">
									@if ($userType == 'Super User')
									<input type="user_type_id" class="form-control" name="user_type_id" value="{{ $userType }}" readonly="readonly">
									@else
									@include('partials.dropdowns.user-roles', ['selected_id' => $user->user_type_id] )
									@endif
								</div>
							</div>
							
							<div class="form-group">
								<label class="col-lg-3 control-label">Status</label>
								<div class="col-lg-9">
									<input type="text" class="form-control" name="status" value="{{ $user->status == 0 ? 'Terminated' : 'Active' }}" readonly="readonly">
								</div>
							</div>
							
							@if ($userType != 'Super User')
							<div class="form-group">
								<div class="col-lg-offset-3 col-lg-9">
									<button class="btn btn-primary" type="submit">Save</button>
								</div>
							</div>
							@endif
							
						</div>
					</div>
				</div>
			</div>
		</form>
		<div class="ibox">
			<div class="ibox-title">
				<h3>Assets ({{$user->assets->count()}})</h3>
			</div>
			<div class="ibox-content">
				@include('users.assets-in-user')
			</div>
		</div>
	</div>
</div>
@stop
@section('help-links')
@include('help.help-links',['helpLink'=>config('help-links.help_links.users'),'helpTitle'=>config('help-links.help_titles.users')])
@endsection
@section('after_scripts')
@include('users.scripts.filter')
<script>
	$('#data_1 .input-group.date').datepicker({
		todayBtn:"linked",
		clearBtn:true,
		keyboardNavigation: false,
		forceParse: false,
		calendarWeeks: false,
		autoclose: true
	});
	$(".select2").select2();
</script>
@stop
