@extends('layouts.main')
@section('content')
@include('partials.breadcrumb', ['breadcrumbTitle' => 'User Detail', 'parentUrl' => '/users', 'parentTitle' => 'Users'])

<div class="wrapper-content">
    @if($user!=null)
    <div class="container-fluid">
        <div class="row">
            <div class="col-lg-6">
                <div class="ibox">
                    <div class="ibox-content">
                        <dl class="dl-horizontal">
                            <dt>Name</dt>
                            <dd>{{ $user->userName }}</dd>
                            <dt>Email</dt>
                            <dd>{{ $user->email }}</dd>
                            <dt>Employee ID</dt>
                            <dd>{{ $user->employee_id }}</dd>
                            <dt>Hire Date</dt>
                            <dd>{{ $user->hire_date }}</dd>
                            <dt>Terminated Date</dt>
                            <dd>{{$user->terminated_date}}</dd>
                            <dt>Status</dt>
                            <dd>{{ $user->status == 1 ? 'Active' : 'Terminated' }}</dd>
                            <dt>Legal Hold</dt>
                            <dd>{{ $user->legalhold== 1 ? 'Yes' : 'No' }}</dd>
                        </dl>
                    </div>
                </div>
            </div>
            <div class="col-lg-6">
                <div class="ibox">
                    <div class="ibox-content">
                        <dl class="dl-horizontal">
                            <dt>User Type</dt>
                            <dd>{{ $user->employeeType->name ?? '' }}</dd>
                            <dt>Teqtivity Role</dt>
                            <dd>{{ $user->userType->name ?? '' }}</dd>
                            <dt>Title</dt>
                            <dd>{{ $user->position->name ?? '' }}</dd>
                            <dt>Department</dt>
                            <dd>{{$user->department->name ?? ''}}</dd>
                            <dt>Work Location</dt>
                            <dd>{{ $user->city}}</dd>
                            <dt>Country</dt>
                            <dd>{{ $user->country->name ?? ''}}</dd>
                            <dt>Created Date</dt>
                            <dd>{{parse_date_from_db_datetime($user->created_at)}}</dd>
                            <dt>Modified Date</dt>
                            <dd>{{parse_date_from_db_datetime($user->updated_at)}}</dd>
                        </dl>
                    </div>
                </div>
            </div>
        </div>
        <div class="ibox">
            <div class="ibox-title">
                <h3>Assigned Assets</h3>
            </div>
            <div class="ibox-content">
                @include('users.assets-in-user')
            </div>
        </div>
        <div class="ibox">
            <div class="ibox-title">
                <h3>Assigned Software Assets</h3>
            </div>
            <div class="ibox-content">
                @include('users.licenses-in-user')
            </div>
        </div>
        <div class="ibox">
            <div class="ibox-title">
                <h3>Person History</h3>
            </div>
            <div class="ibox-content">
                @include('users.person-history')
            </div>
            </div>
        <div class="ibox">
            <div class="ibox-title">

                <h3>License History (<span id="asset_count">{{ is_countable($softwareLicenceHistory) ?
                count($softwareLicenceHistory) : 0}}</span>) </h3>

            </div>
            <div class="ibox-content">
            @include('software-license.license.license-history')
            </div>

        </div>

    </div>
    @else
    <div class="row">
        <div class="col-sm-12">
            <h2>User Not Found</h2>
        </div>
    </div>

    @endif
    @stop

    @section('help-links')
    @include('help.help-links',['helpLink'=>config('help-links.help_links.users'),'helpTitle'=>config('help-links.help_titles.users')])
    @endsection

    @section('after_scripts')
    @include('reports.scripts.common')
    @include('reports.scripts.datatable')
    @include('users.scripts.filter')
    @endsection