@extends('layouts.main')
@section('content')
@include('partials.breadcrumb', ['breadcrumbTitle' => 'Create User', 'parentUrl' => '/users', 'parentTitle' => 'Users'])

<div class="wrapper-content">
	<div class="container-fluid">
		<div class="row">
			<div class="col-lg-12">
				<div class="ibox">
					<div class="ibox-content">
						<form class="form-horizontal" id="create-user-form" method="post"
							action="{{route('users.store')}}">
							{{csrf_field()}}
							<input type="hidden" id="count_add" name="count_add" value="0">
							<div class="row">
								@include('partials.success')
								@include('partials.error')
								@include('partials.error-message')
								<div id="error_div"></div>
								<div class="col-sm-12">
									<div class="row">
										<div class="col-lg-6">
											<div class="form-group">
												<label class="col-lg-4 control-label">First Name<span
												class="text-danger">*</span></label>
												<div class="col-lg-8 user-field">
													<input type="text" class="form-control" name="first_name"
														value="{{old('first_name')}}" required>
													<span class="user-validator text-danger"></span>
												</div>
											</div>
										</div>
										<div class="col-lg-6">
											<div class="form-group">
												<label class="col-lg-4 control-label">Last Name<span
												class="text-danger">*</span></label>
												<div class="col-lg-8 user-field">
													<input type="text" class="form-control" name="last_name"
														value="{{old('last_name')}}" required>
													<span class="user-validator text-danger"></span>
												</div>
											</div>
										</div>
									</div>
									<div class="row">
										<div class="col-lg-6">
											<div class="form-group">
												<label class="col-lg-4 control-label">Work Email<span
												class="text-danger">*</span></label>
												<div class="col-lg-8 user-field">
													<input type="email" required class="form-control" name="email"
														value="{{old('email')}}" id="email">
													<span class="user-validator text-danger"
														id="emailIdValidator"></span>
												</div>
											</div>
										</div>
										<div class="col-lg-6">
											<div class="form-group">
												<label class="col-lg-4 control-label">Employee ID #<span
												class="text-danger">*</span></label>
												<div class="col-lg-8 user-field">
													<input type="text" class="form-control" name="employee_id"
														value="{{old('employee_id')}}" required id="employee_id">
													<span class="user-validator text-danger"
														id="employeeIdValidator"></span>
												</div>
											</div>
										</div>
									</div>
									<div class="row">

										<div class="col-lg-6">
											<div class="form-group" id="data_1">
												<label class="col-lg-4 control-label">Hire Date<span
												class="text-danger">*</span></label>
												<div class="col-lg-8 user-field">
													<div class="input-group date">
														<span class="input-group-addon"><i
																class="icon icon-calendar-2"></i></span><input type="text"
															class="form-control" name="hire_date"
															value="{{old('hire_date')}}" readonly>
													</div>
													<span class="user-validator text-danger"></span>
												</div>
											</div>
										</div>

										<div class="col-lg-6">
											<div class="form-group" id="data_1">
												<label class="col-lg-4 control-label">Terminated Date</label>
												<div class="col-lg-8 user-field">
													<div class="input-group date">
														<span class="input-group-addon"><i
																class="icon icon-calendar-2"></i></span><input type="text"
															class="form-control" name="terminated_date"
															value="{{old('terminated_date')}}" readonly>
														<span class="user-validator text-danger"></span>
													</div>
												</div>
											</div>
										</div>
									</div>

									<div class="row">
										<div class="col-lg-6">
											<div class="form-group">
												<label class="col-lg-4 control-label">Teqtivity Role<span
												class="text-danger">*</span></label>
												<div class="col-lg-8 user-field">
													<select name="user_type_id" class="form-control select2"
														required="required">
														<option value="">--Select--</option>
														@foreach($userRoles as $type)
														<option value="{{$type->id}}" {{isset($selected_id) ?
															($selected_id==$type->id ? 'selected' : '') :
															''}}>{{$type->name}}
														</option>
														@endforeach
													</select>
													<span class="user-validator text-danger"></span>
												</div>
											</div>
										</div>
										<div class="col-lg-6">
											<div class="form-group">
												<label class="col-lg-4 control-label">User Type</label>
												<div class="col-lg-8 user-field">
													<input type="text" class="form-control" name="employee_type"
														value="{{old('employee_type')}}">
													<span class="user-validator text-danger"></span>
												</div>
											</div>
											{{-- <div class="form-group">
												<label class="col-lg-4 control-label">User Type</label>
												<div class="col-lg-8">
													<select name="employee_type_id" class="form-control select2"
														required="required">
														<option value="">--Select--</option>
														@foreach(\App\Models\EmployeeType::orderBy('name')->get() as $type)
														<option value="{{$type->id}}" {{isset($selected_id) ?
															($selected_id==$type->id ? 'selected' : '') : ''}}>{{$type->name}}
														</option>
														@endforeach
													</select>
												</div>
											</div>   --}}
										</div>

									</div>


									<div class="row">
										<div class="col-lg-6">
											<div class="form-group">
												<label class="col-lg-4 control-label">Title</label>
												<div class="col-lg-8 user-field">
													<input type="text" class="form-control" name="business_title"
														value="{{old('business_title')}}">
													<span class="user-validator text-danger"></span>
												</div>
											</div>
										</div>
										<div class="col-lg-6">
											<div class="form-group">
												<label class="col-lg-4 control-label">Department</label>
												<div class="col-lg-8 user-field">
													<input type="text" class="form-control" name="department"
														value="{{old('department')}}">
													<span class="user-validator text-danger"></span>
												</div>
											</div>
										</div>
									</div>
									<div class="row">

										<div class="col-lg-6">
											<div class="form-group">
												<label class="col-lg-4 control-label">Work Location</label>
												<div class="col-lg-8 user-field">
													<input type="text" class="form-control" name="city"
														value="{{old('city')}}">
													<span class="user-validator text-danger"></span>
												</div>
											</div>
										</div>
									</div>


									{{-- <div class="col-lg-6">
											<div class="form-group">
												<label class="col-lg-4 control-label">Department</label>
												<div class="col-lg-8">
													@include('partials.dropdowns.department')
													<span class="user-validator text-danger"></span>
												</div>
											</div>
										</div>

										<div class="col-lg-6">
											<div class="form-group">
												<label class="col-lg-4 control-label">Position</label>
												<div class="col-lg-8">
													<select name="position_id" class="form-control select2"
														required="required">
														<option value="">--Select--</option>
														@foreach(\App\Models\EmployeePosition::orderBy('name')->get() as $position)
														<option value="{{$position->id}}" {{isset($selected_id) ?
															($selected_id==$position->id ? 'selected' : '') :
															''}}>{{$position->name}}
														</option>
														@endforeach
													</select>
												</div>
											</div>
										</div>


										<div class="row">
											<div class="col-lg-6">
												<div class="form-group">
													<label class="col-lg-4 control-label">Work Location</label>
													<div class="col-lg-8">
														<select name="location_id" class="form-control select2"
															required="required">
															<option value="">--Select--</option>
															@foreach(\App\Models\Location::orderBy('room_name')->get() as $location)
															<option value="{{$location->id}}" {{isset($selected_id) ?
																($selected_id==$location->id ? 'selected' : '') : ''}}>{{$location->room_name}}
															</option>
															@endforeach
														</select>
													</div>
												</div>
											</div>
										</div> --}}


									<p class="text-right">
										<input type="submit" class="btn btn-primary" value="Add & Scroll Down to Confirm"
											id="add-button">
									</p>
								</div>
							</div>
						</form>
					</div>
				</div>
			</div>
		</div>

		<div class="row">
			<div class="col-lg-12">
				<div class="ibox">
					<div class="ibox-content">
						<form class="form-horizontal" action="{{ '/users/create/upload' }}" method="post"
							id="upload-asset-form" enctype="multipart/form-data">
							{{csrf_field()}}
							<div class="row">
								<div class="col-lg-8">
									<div class="form-group">
										<label class="col-lg-4 control-label">Bulk Upload</label>
										<div class="col-lg-8">
											<div class="fileinput fileinput-new input-group" data-provides="fileinput">
												<div class="form-control" data-trigger="fileinput">
													<i class="glyphicon glyphicon-file fileinput-exists"></i>
													<span class="fileinput-filename"></span>
												</div>
												<span class="input-group-addon btn btn-primary btn-file">
													<span class="fileinput-new">Select file</span>
													<span class="fileinput-exists">Change</span>
													<input type="file" name="bulk_upload_asset"
														id="bulk_upload_asset" />
												</span>
												<a href="#" class="input-group-addon btn btn-primary fileinput-exists"
													data-dismiss="fileinput">Remove</a>
											</div>
											<div class="user-bulk-upload-error-div"></div>
										</div>
									</div>
								</div>
								<div class="col-lg-4">
									<input type="submit" class="btn btn-primary" value="Add" id="upload-button">
									<a href="{{ '/template/user-template.csv' }}" class="pull-right">Download Template
										File</a>
								</div>
							</div>
						</form>
					</div>
				</div>
			</div>
		</div>

 		{{-- <div class="row">
			<div class="col-lg-12">
				<div class="ibox">
					<div class="ibox-content">
						<form class="form-horizontal" action="{{ '/users/active-directory-upload' }}"
							method="post" enctype="multipart/form-data">
							{{csrf_field()}}
							<div class="row">
								<div class="col-lg-8">
									<div class="form-group">
										<label class="col-lg-4 control-label">Bulk Upload Active Directory Users</label>
										<div class="col-lg-8">
											<div class="fileinput fileinput-new input-group" data-provides="fileinput">
												<div class="form-control" data-trigger="fileinput">
													<i class="glyphicon glyphicon-file fileinput-exists"></i>
													<span class="fileinput-filename"></span>
												</div>
												<span class="input-group-addon btn btn-primary btn-file">
													<span class="fileinput-new">Select file</span>
													<span class="fileinput-exists">Change</span>
													<input type="file" name="bulk_upload_users" />
												</span>
												<a href="#" class="input-group-addon btn btn-primary fileinput-exists"
													data-dismiss="fileinput">Remove</a>
											</div>
											@if($errors->has('bulk_upload_users'))
											<div class="error text-danger">{{ $errors->first('bulk_upload_users') }}
											</div>
											@endif
										</div>
									</div>
								</div>
								<div class="col-lg-4">
									<input type="submit" class="btn btn-primary" value="Upload">
								</div>
							</div>
						</form>
					</div>
				</div>
			</div>
		</div> --}}

		<div class="row">
			<div class="col-lg-12">
				<div class="ibox">
					<div class="ibox-title">
						<h5>Users (<span id="asset_count"></span>) </h5>
					</div>
					<div class="ibox-content">
						<form method="post" action="{{route('users.store')}}">
							{{csrf_field()}}
							<table id="tblview" class="footable table table-stripped table-hover" data-page-size="50"
								data-filter=#filter>
								<input type="hidden" id="category" name="category" value="">
								<thead>
									<tr>
										<th>Name</th>
										<th>Email</th>
										<th>Employee ID</th>
										<th>Title</th>
										<th>User Type</th>
										<th>Work Location</th>
										<th></th>
									</tr>
								</thead>
								<tbody>
								</tbody>
								<tfoot>
									<tr>
										<td colspan="7">
											<ul class="pagination pull-right"></ul>
										</td>
									</tr>
								</tfoot>
							</table>
							<p class="text-right">
								<button type="submit" name="commit" class="btn btn-primary">Save</button>
							</p>
						</form>
					</div>
				</div>
			</div>
		</div>
	</div>
</div>
@stop

@section('help-links')
@include('help.help-links',['helpLink'=>config('help-links.help_links.create_users'),'helpTitle'=>config('help-links.help_titles.create_users')])
@endsection

@section('after_scripts')
@include('users.scripts.create')
@include('users.partials.form-submit-ajax', [
'form_id' => 'create-user-form',
'route_name' => 'user-create.updateRows'
])
@stop

