@extends('layouts.settings')
@section('content')
@include('partials.breadcrumb', ['breadcrumbTitle' => 'Toolbox'])
<div class="wrapper-content">
    <div class="container-fluid">
        <div class="ibox mb-0  bg-white">
            <div class="ibox-content">
                <div class="row d-flex-sm">
                    <div class="col-sm-6 col-md-4 col-md-offset-0 ">
                        <div class="bbox mb-0  bg-white match-height-block">
                            <h4 class="bbox-title">Bulk Updates</h4>
                            <div class="bbox-content">
                                @include('toolbox.partials.links.bulkupload')
                            </div>
                        </div>
                    </div>

                    <div class="col-sm-6 col-md-4 col-md-offset-0">
                        <div class="bbox mb-0  bg-white match-height-block">
                            <h4 class="bbox-title">ITAD</h4>
                            <div class="bbox-content">
                                @include('toolbox.partials.links.itad')
                            </div>
                        </div>
                    </div>

                    <div class="col-sm-6 col-md-4 col-md-offset-0">
                        <div class="bbox mb-0  bg-white match-height-block">
                            <h4 class="bbox-title">Developers</h4>
                            <div class="bbox-content">
                                @include('toolbox.partials.links.developers')
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@stop

@section('help-links')
@include('help.help-links',['helpLink'=>config('help-links.help_links.toolbox'),'helpTitle'=>config('help-links.help_titles.toolbox')])
@endsection

@section('after_scripts')
<script src="/js/plugins/jasny/jasny-bootstrap.min.js"></script>
<script src="/js/plugins/match-height/jquery.matchHeight.min.js"></script>
<script>

    $(document).ready(function () {

        $('.match-height-block').matchHeight({ property: 'height' });
    })
</script>
@endsection