@extends('layouts.settings')
@section('content')
@include('partials.breadcrumb', ['breadcrumbTitle' => 'API Users','parentTitle'=>'Toolbox','parentUrl'=>'/toolbox'])
<div class="wrapper-content">
    <div class="container-fluid">
        <div class="row">
            <div class="col-lg-3">
                @include('toolbox.partials.side-nav')
            </div>
            <div class="col-lg-9">

                <div class="ibox">
                    @include('settings.partials.success-message')
                    @include('settings.partials.success')
                    <div class="ibox-content">
                        <div class="faq-item">

                            <h3>API Introduction & Documentation</h3>

                            <p>Teqtivity uses OAuth2.0 API to allow programmatic access to view and manage resources.
                                Bearer Tokens generated for API users is necessary to access the resources.</p><br>
                            <p class="font-bold">The Teqtivity API endpoint is</p>
                            <pre>{{url('/api')}}</pre>
                            </br>

                            <p class="text-center">
                                <a target="_blank" href="{{optional(\App\Models\SystemSetting::where('slug', 'api_guide_url')->first())->value}}?jwt={{$jwtToken}}" class="btn btn-w-m btn-primary" style="position:absolute;"> Read Docs <i class="fa fa-arrow-circle-right" aria-hidden="true"></i></a>
                                <i style="color:#0049B0;font-size:20px;padding:7px 5px;position:relative;top:3px;right:35px" class="fa fa-info-circle" aria-hidden="true" data-toggle="tooltip" data-placement="top" title="If Gitbook shows token expired then go back to API users page and refresh the same page and follow the Read Docs link"></i>
                            </p>
                        </div>

                        <div class="faq-item">
                            <h3>API Permissions</h3>
                            <p @if(auth()->user()->userType->name == "Super Admin") style="margin:0;" @endif>You have the option to choose from the following permissions when creating a new API user.</p>
                            @if(auth()->user()->userType->name == "Super Admin")
                                <a href="#" class="btn btn-primary m-t m-b" data-toggle="modal" href="remote.html" data-target="#addApiPermission">Add New Permission</a>
                            @endif
                            <div class="row">
                                @foreach(\App\Models\OauthScope::all() as $scope)
                                    <div class="col-sm-6 col-md-3"><pre>{{$scope->name}}</pre></div>
                                @endforeach
                            </div>
                        </div>

                        <hr>
                        <p><a href="#" class="btn btn-primary pull-right m-b" data-toggle="modal" href="remote.html" data-target="#addApiUser">Add New User</a></p>

                        <h3>API Users</h3>
                        
                        <table class="footable table table-stripped table-hover" data-page-size="25" data-filter=#filter
                            id="admin-user-table">

                            <thead>

                                <tr>
                                    <th style="display: none;" data-visible="false"></th>
                                    <th>#</th>

                                    <th>Name</th>

                                    <th>Created By</th>

                                    <th>Expiring On</th>
                                    <th>Notes</th>
                                    <th>Permissions</th>
                                    @can('API Users Manage')<th></th>@endcan
                                </tr>

                            </thead>



                            <tbody>
                                @forelse($clients as $client)
                                <tr>
                                    <td style="display: none;" data-visible="false">{{$client->id}}</td>

                                    <td>{{$loop->iteration}}</td>

                                    <td>{{$client->name}}</td>
                                    <td>{{$client->addedBy->userName ?? ''}}</td>

                                    <td>{{($client->tokens->count() > 0) ?
                                        $client->tokens->last()->expires_at->format('m/d/Y') : ''}}</td>

                                    <td>{{$client->notes}}</td>

                                    <td>
                                        <span title="View Granted Permissions" class="label label-success scope-list" data-scopes='@json($client->oAuthscopes->pluck("name")->toArray())' style="margin-bottom:5px;display:inline-block;cursor:pointer;">{{$client->oAuthscopes->count()}}</span>
                                        <a style="margin-left:5px;" data-id="{{$client->id}}" class="scope-update" data-scopes='@json($client->oAuthscopes->pluck("id")->toArray())'><i class="icon icon-configuration"></i></a>
                                    </td>
                                    @can('API Users Manage')<td><button data-id="{{$client->id}}" type="button"
                                            class="btn btn-sm btn-primary generate-token"><i
                                                class="icon icon-reload"></i> Generate New Token</button></td>@endcan
                                </tr>
                                @empty
                                <tr>
                                    <td>No api clients in the system.</td>
                                </tr>
                                @endforelse

                            </tbody>

                            <tfoot>

                                <tr>

                                    <td colspan="8">

                                        <ul class="pagination"></ul>

                                    </td>

                                </tr>

                            </tfoot>

                        </table>

                    </div>

                </div>

            </div>

        </div>

    </div>

</div>


@stop

@section('help-links')
@include('help.help-links',['helpLink'=>config('help-links.help_links.developers'),'helpTitle'=>config('help-links.help_titles.developers')])
@endsection

@section('after_scripts')

<div class="modal inmodal" id="userScopes" tabindex="-1" role="dialog">

    <div class="modal-dialog">

        <div class="modal-content animated fadeIn">

            <div class="modal-header">

                <button type="button" class="close" data-dismiss="modal"><span>×</span><span
                    class="sr-only">Close</span></button>

                <h4 class="modal-title">User Permissions</h4>

            </div>
            <div class="modal-body">
                <div class="row" id="scope_modal_list">
                </div>
            </div>
        </div>
    </div>
</div>

<div class="modal inmodal" id="userScopeUpdate" tabindex="-1" role="dialog">

    <div class="modal-dialog">

        <div class="modal-content animated fadeIn">

            <div class="modal-header">

                <button type="button" class="close" data-dismiss="modal"><span>×</span><span
                    class="sr-only">Close</span></button>

                <h4 class="modal-title">User Permissions</h4>

            </div>
            <form class="form-horizontal" action="{{route('set-apiuser-scopes')}}" method="post" id="user_scope_form">
                @csrf
                <input type="hidden" name="client_id" id="scope_client_id" value="">
                <div class="modal-body">
                        <div class="form-group">
                            <label class="col-lg-4 control-label">Permissions</label>
                            <div class="col-lg-8">
                                @foreach(\App\Models\OauthScope::all() as $scope)
                                    <label style="display: block;"><input type="checkbox" value="{{$scope->id}}" name="permissions[]"> {{$scope->name}}</label>
                                @endforeach
                            </div>
                        </div>
                </div>
                <div class="modal-footer">

                    <button type="button" class="btn btn-link" data-dismiss="modal">Cancel</button>

                    <button type="submit" class="btn btn-primary">Save</button>

                </div>
            </form>
        </div>
    </div>
</div>

<div class="modal inmodal" id="addApiPermission" tabindex="-1" role="dialog">

    <div class="modal-dialog">

        <div class="modal-content animated fadeIn">

            <div class="modal-header">

                <button type="button" class="close" data-dismiss="modal"><span>×</span><span
                        class="sr-only">Close</span></button>

                <h4 class="modal-title">Add New API Permission</h4>

            </div>
            <form class="form-horizontal" action="" method="post" id="admin-permission-form">

                <div class="modal-body">

                <div class="alert alert-danger" id="permission_error_div" style="display:none;">
                    <a href="#" class="close" data-dismiss="alert" aria-label="close">×</a>
                    <div id="errorContainer"></div>
                </div>
                        @csrf
                        <div class="form-group">
                            <label class="col-lg-4 control-label">Name</label>
                            <div class="col-lg-8">
                                <input type="text" class="form-control" name="name" required
                                    autocomplete="off">
                            </div>
                        </div>

                        <div class="form-group">
                            <label class="col-lg-4 control-label">Description</label>
                            <div class="col-lg-8">
                                <textarea class="form-control" name="description" required>{{old('description')}}</textarea>
                            </div>
                        </div>
                </div>

                <div class="modal-footer">

                    <button type="button" class="btn btn-link" data-dismiss="modal">Cancel</button>

                    <button type="submit" class="btn btn-primary" id="scope-submit">Save</button>

                </div>
            </form>

        </div>

    </div>

</div>

<div class="modal inmodal" id="addApiUser" tabindex="-1" role="dialog">

    <div class="modal-dialog">

        <div class="modal-content animated fadeIn">

            <div class="modal-header">

                <button type="button" class="close" data-dismiss="modal"><span>×</span><span
                        class="sr-only">Close</span></button>

                <h4 class="modal-title">Add New API User</h4>

            </div>

            <div class="modal-body">

                @include('partials.error')

                <form class="form-horizontal" action="" method="post" id="admin-user-form">
                    @csrf
                    <div class="form-group">
                        <label class="col-lg-4 control-label">Name</label>
                        <div class="col-lg-8">
                            <input type="text" class="form-control" name="name" value="{{old('name')}}" required
                                autocomplete="off">
                        </div>
                    </div>

                    <div class="form-group">
                        <label class="col-lg-4 control-label">Validity</label>
                        <div class="col-lg-8">
                            <select class="form-control" name="validity">
                                <option value="7 days">7 days</option>
                                <option value="1 months">1 Month</option>
                                <option value="1 years">1 Year</option>
                                <option value="5 years">5 Years</option>
                            </select>
                        </div>
                    </div>

                    <div class="form-group">
                        <label class="col-lg-4 control-label">Permissions</label>
                        <div class="col-lg-8">
                            @foreach(\App\Models\OauthScope::all() as $scope)
                                <label style="display: block;"><input type="checkbox" value="{{$scope->id}}" name="permissions[]"> {{$scope->name}}</label>
                            @endforeach
                        </div>
                    </div>

                    <div class="form-group">
                        <label class="col-lg-4 control-label">Notes</label>
                        <div class="col-lg-8">
                            <textarea class="form-control" name="notes">{{old('notes')}}</textarea>
                        </div>
                    </div>

                </form>

            </div>

            <div class="modal-footer">

                <button type="button" class="btn btn-link" data-dismiss="modal">Cancel</button>

                <button type="button" class="btn btn-primary" id="pw-submit">Save</button>

            </div>

        </div>

    </div>

</div>

<div class="modal inmodal" id="generateToken" tabindex="-1" role="dialog">
    <div class="modal-dialog">
        <div class="modal-content animated fadeIn">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal"><span>×</span><span
                        class="sr-only">Close</span></button>

                <h4 class="modal-title">Generate New Token</h4>

            </div>
            <div class="modal-body">
                <p>By generating a new token, all the existing tokens of this client will be revoked. Do you want to
                    continue?</p>

            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-link" data-dismiss="modal">Close</button>
                <button type="button" id="generate_token" class="btn btn-primary">Generate</button>
            </div>
        </div>
    </div>
</div>
@if(Session::get( 'status' ))
@php
$client = Session::get('client');
$token = Session::get('token');
@endphp
<div class="modal inmodal" id="apiCredentialsModal" tabindex="-1" role="dialog">

    <div class="modal-dialog modal-lg">

        <div class="modal-content animated fadeIn">

            <div class="modal-header">

                <button type="button" class="close" data-dismiss="modal"><span>×</span><span
                        class="sr-only">Close</span></button>

                <h4 class="modal-title">Teqtivity API Credentials</h4>

            </div>

            <div class="modal-body">
                <form class="form-horizontal">
                    <div class="form-group">
                        <label class="col-lg-12 control-label">Client ID</label>
                        <div class="col-lg-10">
                            <input type="text" id="client_id" class="form-control" value="{{$client->uuid}}" readonly>
                        </div>
                        <div class="col-lg-2">
                            <span class="copy-element" data-id="client_id" style="font-size: 25px; cursor: pointer;"><i
                                    class="icon icon-receipt-list-43"></i></span>
                        </div>
                    </div>
                    <div class="form-group">
                        <label class="col-lg-12 control-label">Client Secret</label>
                        <div class="col-lg-10">
                            <input id="client_secret" class="form-control" readonly value="{{$client->secret}}">
                        </div>
                        <div class="col-lg-2">
                            <span class="copy-element" data-id="client_secret"
                                style="font-size: 25px; cursor: pointer;"><i class="icon icon-receipt-list-43"
                                   ></i></span>
                        </div>
                    </div>
                    <div class="form-group">
                        <label class="col-lg-12 control-label">Access Token</label>
                        <div class="col-lg-10">
                            <textarea id="access_token" class="form-control text-content" readonly>{{$token}}</textarea>
                        </div>
                        <div class="col-lg-2">
                            <span class="copy-element" data-id="access_token"
                                style="font-size: 25px; cursor: pointer;"><i class="icon icon-receipt-list-43"
                                   ></i></span>
                        </div>
                    </div>
                </form>
                <h5>This is the only copy you have access to. If you lose it, delete the account and create new one.
                </h5>
            </div>
            <div class="modal-footer">

                <button type="button" class="btn btn-primary" data-dismiss="modal">Done</button>

            </div>
        </div>

    </div>

</div>
@endif
<link href="/css/plugins/dataTables/fixedHeader.dataTables.min.css" rel="stylesheet">
<script src="/js/plugins/tabledit/tabledit.js"></script>

<script>

    @if($errors->count() > 0)
        $("#addApiUser").modal({ show: true });
    @endif
    @if(Session::get('status'))
    $("#apiCredentialsModal").modal({ show: true });
    {{-- var filename = "Teqtivity API Credentials -" + "{{strtolower($client->name)}}" + ".txt";
    var content = {!! json_encode(Session::get('content')) !!};
    download(filename, content); --}} // removed downlod TQT-356
    @endif

    $(document).ready(function () {

        $('#admin-permission-form').on('submit', function (e) {
            e.preventDefault();

            $.ajax({
                type: 'POST',
                url: '/create-apiuser-scopes',
                data: $(this).serialize(),
                success: function (response) {
                    $('#permission_error_div').hide();
                    $('#errorContainer').html('');

                    if (response.success) {
                        $(".message-div").show();
                        $(".message-div").find('p').html(response.success);
                        $('#admin-permission-form')[0].reset();
                        $("#addApiPermission").modal('hide');
                        $('html, body').animate({ scrollTop: 0 }, 'slow');
                        location.reload();
                    } else {
                        var errorList = $('<ul></ul>');

                        $.each(response.errors, function (key, value) {
                            errorList.append('<li>' + value[0] + '</li>');
                        });

                        $('#errorContainer').html(errorList);
                        $("#permission_error_div").show();

                    }
                },
            });
        });

        $("body").on('click', '.scope-update', function(e){
            e.preventDefault();

            $('#userScopeUpdate input[type="checkbox"]').prop("checked", false);

            var scopesArray = $(this).attr('data-scopes');

            var scopesArray = JSON.parse(scopesArray);

            if (scopesArray.length) {
                $.each(scopesArray, function(index, item) {
                    $("#userScopeUpdate input[type='checkbox'][value='" + item + "']").prop("checked", true);
                });
            }

            var id = $(this).attr('data-id');

            $("#scope_client_id").val(id);

            $("#userScopeUpdate").modal('show');
        });

        $("body").on('click', '.scope-list', function(e){
            e.preventDefault();

            $("#scope_modal_list").html('');

            var scopesArray = $(this).attr('data-scopes');

            var scopesArray = JSON.parse(scopesArray);

            if (scopesArray.length) {
                $.each(scopesArray, function(index, item) {
                    var div = $('<div class="col-md-6">').html("<pre>"+item+"</pre>");

                    $("#scope_modal_list").append(div);
                });
            } else {
                var div = $('<div class="col-md-12">').html("<pre>No Permissions Assigned.</pre>");

                    $("#scope_modal_list").append(div);
            }

            $("#userScopes").modal('show');

        })

        $('.footable').footable();

        $('#pw-submit').click(function () {
            $('#admin-user-form').submit();
        });

        $('#admin-user-table').Tabledit({
            url: '/apiusers-ajax',
            hideIdentifier: true,
            columns: {
                identifier: [0, 'id'],
                editable: [[2, 'name'], [5, 'notes']],
            },
            warningClass: 'success',
            mutedClass: 'danger',
            restoreButton: false,
        });

        $('.text-content').each(function () {
            $(this).height($(this).prop('scrollHeight'));
        });

        $(".copy-element").on('click', function (e) {
            e.preventDefault();
            copyToClipboard(document.getElementById($(this).attr('data-id')));
            setTooltip($(this), 'Copied!');
            hideTooltip($(this));
        });

        $('.copy-element').tooltip({
            trigger: 'click',
            placement: 'bottom'
        });

        $("body").on('click', '.generate-token', function (e) {
            e.preventDefault();
            var id = $(this).attr('data-id');
            $("#generate_token").attr('data-id', id);
            $("#generateToken").modal({ show: true });
        });

        $("body").on('click', '#generate_token', function (e) {
            e.preventDefault();
            var id = $(this).attr('data-id');
            var url = "{{url('/api-users/refresh-token/')}}/" + id;
            
            // Create a form dynamically.
            var form = $('<form>', {
                'method': 'POST',
                'action': url
            });

            // Add CSRF token as hidden input.
            form.append($('<input>', {
                'type': 'hidden',
                'name': '_token',
                'value': '{{ csrf_token() }}'  // CSRF token from Laravel.
            }));
            
            // Append the form to the body and submit it.
            $('body').append(form);
            form.submit();
        });

    });

    function setTooltip(element, message) {
        element.tooltip('hide')
            .attr('data-original-title', message)
            .tooltip('show');
    }

    function hideTooltip(element) {
        setTimeout(function () {
            element.tooltip('hide');
        }, 1000);
    }
    function copyToClipboard(elem) {
        // create hidden text element, if it doesn't already exist
        var targetId = "_hiddenCopyText_";
        var isInput = elem.tagName === "INPUT" || elem.tagName === "TEXTAREA";
        var origSelectionStart, origSelectionEnd;
        if (isInput) {
            // can just use the original source element for the selection and copy
            target = elem;
            origSelectionStart = elem.selectionStart;
            origSelectionEnd = elem.selectionEnd;
        } else {
            // must use a temporary form element for the selection and copy
            target = document.getElementById(targetId);
            if (!target) {
                var target = document.createElement("textarea");
                target.style.position = "absolute";
                target.style.left = "-9999px";
                target.style.top = "0";
                target.id = targetId;
                document.body.appendChild(target);
            }
            target.textContent = elem.textContent;
        }
        // select the content
        var currentFocus = document.activeElement;
        target.focus();
        target.setSelectionRange(0, target.value.length);

        // copy the selection
        var succeed;
        try {
            succeed = document.execCommand("copy");
        } catch (e) {
            succeed = false;
        }
        // restore original focus
        if (currentFocus && typeof currentFocus.focus === "function") {
            currentFocus.focus();
        }

        if (isInput) {
            // restore prior selection
            elem.setSelectionRange(origSelectionStart, origSelectionEnd);
        } else {
            // clear temporary content
            target.textContent = "";
        }
        return succeed;
    }

    function download(filename, text) {
        var element = document.createElement('a');
        element.setAttribute('href', 'data:text/plain;charset=utf-8,' + encodeURIComponent(text));
        element.setAttribute('download', filename);

        element.style.display = 'none';
        document.body.appendChild(element);

        element.click();

        document.body.removeChild(element);
    }
</script>
<!-- Password meter -->


@stop
