@extends('layouts.main')
@section('content')
@include('partials.breadcrumb', ['breadcrumbTitle' => 'Terminations'])
@php $editPermission = 'IT Assets Edit'; @endphp

<div class="wrapper-content">

	<div class="container-fluid ">

		@include('partials.success')
		@include('partials.error-message')
		@include('settings.partials.success-message')
		@include('settings.partials.delete-message')

		@include('reports.partials.saved-searchs')

		@include('terminations.terms-report.filter.terms-report-filter')

		<div class="ibox">

			<div class="ibox-title">

				<div class="ibox-tools">

					@include('partials.sync-messages')

					<a class="btn btn-primary" id="shipment-status-sync">Shipment Status Sync</a>
					<a href="#" id="export-user-csv" class="btn btn-primary"
						title="Export Uncollected assets details to CSV">Export to CSV</a>

				</div>

			</div>

			<div class="ibox-content">
				<div class="ajax-loader"><img src="/img/ajax-loader-full-width.gif"></div>

				<div class="dt-coltoggler-wrapper ">
					<p>Click to toggle table columns: </p>
					<span class="col-toggle" data-column="0">ID</span>
					<span class="col-toggle" data-column="1">Employee ID</span>
					<span class="col-toggle" data-column="2">Name</span>
					<span class="col-toggle" data-column="3">Email</span>
					<span class="col-toggle" data-column="4">Employee Type</span>
					<span class="col-toggle" data-column="5">Department</span>
					<span class="col-toggle" data-column="6">Work Location</span>
					<span class="col-toggle" data-column="7">Legal Hold</span>

					<span class="col-toggle" data-column="8">Terminated Date</span>
					<span class="col-toggle" data-column="9">Outstanding Days</span>

					<span class="col-toggle" data-column="10">Assets Uncollected</span>

					<span class="col-toggle" data-column="11">Ticket #</span>
					<span class="col-toggle" data-column="12">Ticket Status</span>
					<span class="col-toggle" data-column="13">Tracking Number</span>
					<span class="col-toggle" data-column="14">Shipment Status</span>
					<span class="col-toggle" data-column="15">Comment</span>
				</div>
				<table class="footable table table-stripped table-hover nowrap" data-page-size="50"
					data-filter=#filter id="table-report-generator" width="80%">

					<thead>
						<tr>
							<th>#</th>
							<th>Employee ID</th>
							<th>User Name</th>
							<th>Email</th>
							<th>Employee Type</th>
							<th>Department</th>
							<th>Work Location</th>
							<th>Legal Hold</th>

							<th>Termination Date</th>
							<th>Outstanding Days</th>
							<th>Assets Uncollected</th>
							<th>Ticket Number</th>
							<th>Ticket Status</th>
							<th>Tracking Number</th>
							<th>Shipment Status</th>
							<th>Comment</th>
						</tr>

					</thead>
					<tfoot>
						<tr>
							<td>
								<ul class="pagination pull-right"></ul>

							</td>

						</tr>

					</tfoot>

				</table>
			</div>
		</div>
	</div>
</div>

@include('terminations.terms-report.modals.add-comment')
@include('terminations.terms-report.modals.view-comment')
@include('terminations.terms-report.modals.view-asset')
@include('terminations.terms-report.modals.tracking-number')
@include('assets.partials.status-update-modals')
@include('terminations.terms-report.modals.update-asset')
@stop

@section('help-links')
@include('help.help-links',['helpLink'=>config('help-links.help_links.terminations'),'helpTitle'=>config('help-links.help_titles.terminations')])
@endsection

@section('after_scripts')
@include('terminations.terms-report.scripts.terms-report-script')
@include('assets.partials.scripts.search')
@include('assets.partials.scripts.dropdown-script')
<script src="/js/plugins/tabledit/tabledit-modified.js"></script>


@stop