<script src="/js/plugins/acollaptable/jquery.aCollapTable.min.js"></script>
<script>
$(document).ready(function(){
	$('.collaptable').aCollapTable({
		startCollapsed: false,
		addColumn: false,
		plusButton: '<span class="i">+</span>',
		minusButton: '<span class="i">-</span>'
	});
});

$(function () {
	var barData = {
	@if(isset($months))
		labels: {!! json_encode($months) !!},
		datasets: [
			{
				label: "This Year - Terminated Users",
				backgroundColor: "#4d73be",
				pointBorderColor: "#fff",
				data: {!! json_encode($currentYearGraphData['terminatedUsers']) !!},
			},
			{
				label: "This Year - Users with Assets Recovered",
				backgroundColor: "#4d7334",
				pointBorderColor: "#fff",
				data: {!! json_encode($currentYearGraphData['receivedAssets']) !!},
			},
			{
				label: "Last Year - Terminated Users",
				backgroundColor: 'rgba(26,179,148,0.5)',
				pointBorderColor: 'rgba(26,179,148,0.5)',
				data: {!! json_encode($lastYearGraphData['terminatedUsers']) !!},
			},
			{
				label: "Last Year - Users with Assets Recovered",
				backgroundColor: 'rgba(26,179,50,0.5)',
				pointBorderColor: 'rgba(26,179,50,0.5)',
				data: {!! json_encode($lastYearGraphData['receivedAssets']) !!},
			},
		]
	@endif
	};

	var barOptions = {
		responsive: true,
		legend: {
			position: 'right'
		},
		scales: {
			yAxes: [{
				ticks: {
					beginAtZero:true,
					maxTicksLimit: 5,
					userCallback: function(label, index, labels) {
						if (Math.floor(label) === label) {
							return label;
						}
					}
				}
			}],
			xAxes: [{
				barPercentage: 0.8,
			}]
		}
	};
	var canvas = document.getElementById("barChart");
	var ctx2 = canvas.getContext("2d");
	newChart = new Chart(ctx2, {type: 'bar', data: barData, options:barOptions});
});
</script>