<script src="/js/plugins/dataTables/datatables.min.js"></script>
<script src="/js/plugins/jquery-validation/jquery.validate.min.js"></script>
<link href="/css/plugins/dataTables/fixedHeader.dataTables.min.css" rel="stylesheet">
<script src="/js/plugins/chosen/chosen.jquery.js"></script>
<script src="/js/plugins/chosen/chosen.ajaxaddition.jquery.js"></script>
<script src="/js/sweetalert2.all.min.js"></script>


<script>

    $(document).ready(function () {
        $("#shipment-status-sync").click(function (e) {
            e.preventDefault();
            $('#shipment-status-sync').hide();
            $(".sync-msg").hide();
            $("#sync-success").css('text-align', 'left').show().find('span').html('Shipment status sync started. Please wait. It may take a while.');
            $.ajax({
                type: "post",
                url: "{{ route('shipment-status-sync') }}",
                success: function (data) {
                    if (data.status == 'success') {
                        $("#sync-success span").html(data.message);
                    } else {
                        $("#sync-error").css('text-align', 'left').show().find('span').html(data.message);
                    }

                    $('#shipment-status-sync').show();
                }
            });
        });

        $(document).on("click", ".asset-tracking-btn", function (e) {
            $('#asset-tracking-modal').modal('show');
            $('#asset-tracking-modal').find('select').next().addClass('chosen-with-drop').find('input').focus();
            var userId = $(this).attr('data-user');
            var trackingNumber = $(this).attr('data-tracking-number');
            $('#asset-tracking-modal').find('#user_id').val(userId);
            $('#asset-tracking-modal').find('#tracking_number').val(trackingNumber);
        });

        $("#tracking-number-submit").on('click', function () {
            $("#tracking-number-form").submit();
        });

        $('.chosen-select').chosen({ width: "100%" }).change(function () {
            $(this).closest('.form-group').next().find('input').focus();
        });

        $.fn.serializeObject = function () {
            var obj = {};

            $.each(this.serializeArray(), function (i, o) {
                var n = o.name, v = o.value;

                obj[n] = obj[n] === undefined ? v
                    : $.isArray(obj[n]) ? obj[n].concat(v)
                        : [obj[n], v];
            });

            return obj;
        };

        var table = $('.footable').DataTable({
            scrollX: true,
            scrollY: false,
            "processing": true,
            "serverSide": true,
            "ajax": {
                "url": "{{ route('terms-report-data') }}",
                "dataType": "json",
                "type": "POST",
                "data": function (result) {
                    result.form = $('#search-form').serializeObject();
                }
            },
            "columns": [
                { "data": "id" },
                { "data": "employee_id" },
                { "data": "name" },
                { "data": "email" },
                { "data": "employee_type" },
                { "data": "department" },
                { "data": "work_location" },
                { "data": "legal_hold" },

                { "data": "terminated_date" },
                { "data": "difference" },
                { "data": "uncollected" },
                { "data": "ticket_no" },
                { "data": "ticket_status" },
                { "data": "tracking_number" },
                { "data": "shipment_status" },
                { "data": "comment" },
            ],
            lengthMenu: [
                [50, 100, 200],
                ['50', '100', '200']
            ],
            columnDefs: [
                { orderable: false, targets: '_all' }
            ],
            "aaSorting": [],
            "dom": '<"top"i>rt<"bottom"flp><"clear">',
            "bAutoWidth": true,
            "bFilter": true,
            "bLengthChange": true,
            "searching": false,
            "createdRow": function (row, data, dataIndex) {
                $(row).attr('data-id', data.dataId);
                $(row).attr('data-parent', data.dataParent);
                $(row).addClass(data.dataLast ? 'last' : '');
            },
            "fnDrawCallback": function(oSettings) {
                $('[data-tooltip="tooltip"]').tooltip({
                    container: "body"
                });

                if (oSettings._iRecordsDisplay == 0) {
                    $("#export-user-csv").hide();
                } else {
                    $("#export-user-csv").show();
                }
            },
            fixedHeader: {
                header: true,
            },
        });


        // $(".dataTables_scrollHead").delay(2000)
        //     .queue(function (next) {
        //         $(this).css({ 'position': 'sticky', 'z-index': '1000' }); next();
        //     });

        var delay = (function () {
            var timer = 0;
            return function (callback, ms) {
                clearTimeout(timer);
                timer = setTimeout(callback, ms);
            };
        })();


        $('#search-form').submit(function (e) {
            e.preventDefault();
            table.draw();
        });

        $("#search-form select").on('change', function () {
            $('#search-form').submit();
        });


        $("#search-form .input-data").on('keyup change', function () {
            delay(function () {
                $('#search-form').submit();
            }, 200);
        });


        $('.date-change').on('show', function (e) {
            $("th.clear").attr('colspan', 8)
        }).datepicker({
            clearBtn: true,
            autoclose: true,
        }).on('change', function (e) {
            $('#search-form').submit();
        });

        $(".filter-field-location").each(function () {
            var name = $(this).attr('key');
            $(this).select2({
                minimumInputLength: 1,
                multiple: true,
                ajax: {
                    url: '/get-filter-fields-location',
                    dataType: "json",
                    data: function (params) {
                        var query = {
                            search: params.term,
                            type: name
                        }

                        // Query parameters will be ?search=[term]&type=public
                        return query;
                    },
                    processResults: function (data) {
                        // Tranforms the top-level key of the response object from 'items' to 'results'
                        return {
                            results: data
                        };
                    },

                }
            });
        });


        $(".filter-field-user-name").each(function () {
            $(this).select2({
                minimumInputLength: 1,
                multiple: true,
                ajax: {
                    url: '/get-filter-fields-all-user',
                    dataType: "json",
                    data: function (params) {
                        var query = {
                            search: params.term
                        }

                        // Query parameters will be ?search=[term]&type=public
                        return query;
                    },
                    processResults: function (data) {
                        // Tranforms the top-level key of the response object from 'items' to 'results'
                        return {
                            results: data
                        };
                    },

                }
            });
        });
        $(".filter-field-user").each(function () {
            var name = $(this).attr('key');
            $(this).select2({
                minimumInputLength: 1,
                multiple: true,
                ajax: {
                    url: '/get-filter-fields',
                    dataType: "json",
                    data: function (params) {
                        var query = {
                            search: params.term,
                            type: name
                        }

                        // Query parameters will be ?search=[term]&type=public
                        return query;
                    },
                    processResults: function (data) {
                        // Tranforms the top-level key of the response object from 'items' to 'results'
                        return {
                            results: data
                        };
                    },

                }
            });
        });


        $('#export-user-csv').on('click', function (e) {
            e.preventDefault();
            $('.ajax-loader').show();
            $.ajax({
                type: "POST",
                url: "{{route('terms-report-export')}}",
                data: $('#search-form').serializeObject(),
                dataType: 'text',
                success: function (result) {
                    var blob = new Blob([result]);
                    if (window.navigator.msSaveOrOpenBlob)  // IE hack; see http://msdn.microsoft.com/en-us/library/ie/hh779016.aspx
                        window.navigator.msSaveBlob(blob, "terminated-users-report.csv");
                    else {
                        var a = window.document.createElement("a");
                        a.href = window.URL.createObjectURL(blob, { type: "text/plain" });
                        a.download = "terminated-users-report.csv";
                        document.body.appendChild(a);
                        a.click();  // IE: "Access is denied"; see: https://connect.microsoft.com/IE/feedback/details/797361/ie-10-treats-blob-url-as-cross-origin-and-denies-access
                        document.body.removeChild(a);
                    }
                    $('.ajax-loader').hide();
                }
            })
        });

        $('#addModal').on('show.bs.modal', function (e) {
            $(this).find('form #addId').val($(e.relatedTarget).data('term-asset-id'));
        });

        $('#commentModel').on('show.bs.modal', function (e) {
            var id = $(e.relatedTarget).data('term-asset-id');
            $.ajax({
                type: "POST",
                url: "terms-report/get-comment/" + id,
                success: function (value) {
                    $('#comment-body').html(value);
                }
            });
        });

        $('#viewAssetModal').on('show.bs.modal', function (e) {
            var id = $(e.relatedTarget).data('term-asset-id');
            $.ajax({
                type: "POST",
                url: "terms-report/get-term-assets/" + id,
                success: function (value) {
                    $('#asset-table-body').html(value);
                }
            });
        });



        $('#add').on('click', function (e) {
            e.preventDefault();

            if ($('#add-form').valid()) {
                var formData = $('#add-form').serialize();
                var id = $('#addId').val();
                $.ajax({
                    type: "POST",
                    url: "terms-report/update-comment/" + id,
                    data: formData,
                    success: function (value) {
                        $('#addModal').modal('hide');
                        $('#add-form')[0].reset();
                        table.draw();
                    }
                });
            }
        });



        //Datatable column toggler
        $('span.col-toggle').on('click', function (e) {
            e.preventDefault();
            $(this).toggleClass('col-hidden');
            // Get the column API object
            var column = table.column($(this).attr('data-column'));

            // Toggle the visibility
            column.visible(!column.visible());
        });


        //Update Asset Section
        $(document).on("click", ".update-terminated-user-asset", function (e) {
            $('#update-terminated-user-asset form').trigger("reset");
            $('.modal form').trigger("reset");
            $('.modal .error').html("");
            $('.modal .form-control').removeClass("error");
            $('#available-status-list').val(null).trigger('chosen:updated');
            $('.chosen-select').val('').trigger('chosen:updated');
            $('.assigned-user-ajax').val(null).trigger('chosen:updated');

            assetId = $(this).attr('data-asset');
            serial = $(this).attr('data-asset-serial');
            currentStatus = $(this).attr('data-asset-current-status');
            parentAsset = $(this).attr('parent_asset_id');

            $('#update-terminated-user-asset-serial').html(serial);
            $('#update-terminated-user-asset').modal('show');
            $('#available-status-list').val(null);
            $('#available-status-list').attr('data-id', assetId);
            $('#available-status-list').attr('data-parent', parentAsset);
            $('#update_assignee').find('#asset_id').val(assetId);

            //List the proper statuses for the status update
            $.ajax({
                type: "GET",
                data: { status: currentStatus, id: assetId },
                url: "/list-asset-statuses",
                success: function (data) {
                    $('#available-status-list').empty();
                    $('#available-status-list').append($('<option>', {
                        value: null,
                        text: "--Select--"
                    }));
                    $.each(data, function (key, value) {
                        if (value) {
                            $('#available-status-list').append($('<option>', {
                                value: value.id,
                                text: value.name
                            }));
                        }
                    });
                    $("#available-status-list").chosen({ width: "100%" });
                },
                error: function (value) {
                }
            });

        });
        $("#available-status-list").change(function () {
            $('#update-terminated-user-asset').modal('hide');
            var modalId = $('#available_status_list_chosen span').html().split(' ').join('-').toLowerCase();
            $("#" + modalId).addClass('modal-bg');

        });
        $('.assigned-user-ajax').each(function () {
            $(this).ajaxChosen({
                dataType: 'json',
            }, {
                processItems: function (data) { return data },
                generateUrl: function (q) { return '/get-filter-fields-assigned-user?search=' + q; },
            },
                {
                    width: "100%"
                }).change(function () {
                    $(this).closest('.form-group').next().find('input').focus();
                });
        });
    });


    $('#save_search').on('click', function (e) {

        e.preventDefault();
        var formData = $('#search-form').serializeObject();
        var view_all = $('#view_all').val() ? ($('#view_all').prop('checked') == true ? 1 : '') : '';
        formData = { ...formData, name: $('#name').val(), view_all: view_all }; //Adding report name and view all inputs to formdata

        $.ajax({
            type: "POST",
            url: "{{route('terms-report-save-search')}}",
            data: formData,
            success: function (result) {
                if (result.status=='success'){
                    $('.alert').hide();
                    $('#success').show();
                    $('#success p').text(result.message);
                    if(view_all) {
                        $("#adminSavedSearch").append(result.dropdown);
                    }else{
                        $("#userSavedSearch").append(result.dropdown);
                    }
                }else{
                    $('#error').show();
                    $('#error p').text(result.message);
                }
            }
        }).done(function () {
            $('html, body').animate({
                scrollTop: $("#error").offset().top
            }, 1000);
        });

    });

    $('#update_search').on('click', function (e) {
        e.preventDefault();
        $('.ajax-loader').show();
        var formData = $('#search-form').serializeObject();
        var view_all = $('#view_all').val() ? ($('#view_all').prop('checked') == true ? 1 : '') : '';
        formData = { ...formData, report_id: $('#report_id').val(), name: $('#name').val(), view_all: view_all }; //Adding report name and view all inputs to formdata

        $.ajax({
            type: "POST",
            url: "{{route('terms-report-update-search')}}",
            data: formData,
            success: function (data) {
                if(data.status=='error'){
                        $('#error').show();
                        $('#error p').text(data.message);
                }else{
                    if(data.url) {
                        location.href = "/terms-report"+data.url;
                    }else{
                        location.reload();
                    }
                }
            }
        });

    });

    $('#delete_search').on('click', function (e) {
        e.preventDefault();
        Swal.fire({
			title: 'Are you sure?',
			text: "You won't be able to revert this!",
			icon: 'warning',
			showCancelButton: true,
			confirmButtonColor: '#3085d6',
			cancelButtonColor: '#d33',
			confirmButtonText: 'Yes, delete search!'
        }).then((result) => {
            if (result.isConfirmed) {
                $('.ajax-loader').show();
                $.ajax({
                    type: "POST",
                    url: "{{route('terms-report-delete-search')}}",
                    data: { report_id: $('#report_id').val() },
                    success: function (value) {
                    }
                }).done(function () {
                    location.href = "/terms-report";
                });
            }
        });

    });




</script>