<script src="/js/plugins/acollaptable/jquery.aCollapTable.min.js"></script>
<script>
$(document).ready(function(){
	$('.collaptable').aCollapTable({
		startCollapsed: false,
		addColumn: false,
		plusButton: '<span class="i">+</span>',
		minusButton: '<span class="i">-</span>'
	});
});
$('.footable').footable();

$(function () {
	var barData = {
		@if(isset($months))
			labels: {!! json_encode($months) !!},
			datasets: [
			{
				label: "This Year - Assets to Recover",
				backgroundColor: "#4d73be",
				pointBorderColor: "#fff",
				data: {!! json_encode($currentYearGraphData['toCollect']) !!},
			},
			{
				label: "This Year - Assets Recovered",
				backgroundColor: "#4d7334",
				pointBorderColor: "#fff",
				data: {!! json_encode($currentYearGraphData['received']) !!},
			},
			{
				label: "Last Year - Assets to Recover",
				backgroundColor: 'rgba(26,179,148,0.5)',
				pointBorderColor: 'rgba(26,179,148,0.5)',
				data: {!! json_encode($lastYearGraphData['toCollect']) !!},
			},
			{
				label: "Last Year - Assets Recovered",
				backgroundColor: 'rgba(26,179,50,0.5)',
				pointBorderColor: 'rgba(26,179,50,0.5)',
				data: {!! json_encode($lastYearGraphData['received']) !!},
			},
			]
		@endif
	};

	var barOptions = {
		responsive: true,
		legend: {
			position: 'right'
		},
		scales: {
			yAxes: [{
				ticks: {
					beginAtZero:true,
					maxTicksLimit: 5,
					userCallback: function(label, index, labels) {
						if (Math.floor(label) === label) {
							return label;
						}
					}
				}
			}],
			xAxes: [{
				barPercentage: 0.8,
			}]
		},
		onClick: function (e) {
			viewCollectionReport(e);
		}
	};
	var canvas = document.getElementById("barChart");
	var ctx2 = canvas.getContext("2d");
	newChart = new Chart(ctx2, {type: 'bar', data: barData, options:barOptions});
});

function viewCollectionReport(event) {
	var activePoint = newChart.getElementAtEvent(event);
	if (activePoint.length) {
		const clickedElement = activePoint[0];
		const type  = clickedElement._datasetIndex + 1;
		const month = clickedElement._model.label;
		url = "/collection-statistics/single-bar-report";
		window.open(url + "?month=" + month + "&type=" + type);
	}
}
</script>