@extends('layouts.main')
@section('content')
@include('terminations.terms-report.submenu')
@include('partials.breadcrumb', ['breadcrumbTitle' => 'Retrieval Statistics'])

<div class="wrapper-content ">
    <div class="container-fluid">

		@include('terminations.terms-report.widget.retrieval-statistics-report-widget')
		@include('terminations.terms-report.filter.retrieval-statistics-report-list-filter')
		<div class="ibox">
			<div class="ibox-title">
				<div class="ibox-tools">
					<a href="#" id="export-csv" class="btn btn-primary" data-url="{{ route('retrieval-statistics.graph-single-report-export') }}" data-file-name="retrieval-statistics-report-export">Export to CSV</a>
				</div>
			</div>
			<div class="ibox-content">
				@include('settings.partials.success-message')
				@include('settings.partials.delete-message')
				<div class="ajax-loader"><img src="/img/ajax-loader-full-width.gif"></div>
				<div class="dt-coltoggler-wrapper ">
					<p>Click to toggle table columns: </p>
				</div>
				<div class="">
					<table class="table fixed_header footable nowrap three-col-fixed has-column-toggler" data-role="ui-data-table" data-page-size="50" data-url="{{ route('retrieval-statistics.graph-single-report-data') }}" data-searching="false" data-ordering="false" data-scroll-x="true" data-fixed-header="true" data-fixed-header-columns-left="3">
						<thead>
							<tr>
								<th data-col-name="id">#</th>
								<th data-col-name="asset_tag">Asset Tag #</th>
								<th data-col-name="serial_no">Serial #</th>
								<th data-col-name="user_name">User Name</th>
								<th data-col-name="termination_date">Termination Date</th>
								<th data-col-name="returned_date">Date Returned</th>
								<th data-col-name="status_changed_to">Status Changed To</th>
								<th data-col-name="no_of_days"># of Days</th>
								<th data-col-name="user_title">Title</th>
								<th data-col-name="department">Department</th>
								<th data-col-name="work_location">Work Location</th>
								<th data-col-name="storage_room">Storage Room</th>
								<th data-col-name="ticket_no">Ticket #</th>
								<th data-col-name="modified_date">Modified Date</th>
								<th data-col-name="modified_by">Modified By</th>
							</tr>
						</thead>
					</table>
				</div>
			</div>
		</div>
	</div>
</div>

@stop
@section('after_scripts')
@include('reports.scripts.common')
@include('reports.scripts.datatable')
@include('reports.scripts.datatable-column-toggle-script');
@include('terminations.terms-report.scripts.retrieval-statistics-detail-report-script')
@stop