@extends('layouts.main')
@section('content')

@include('partials.breadcrumb', ['breadcrumbTitle' => 'Collection Statistics'])
@include('terminations.terms-report.submenu')

<div class="wrapper-content">
	<div class="container-fluid">
		
		
		<div class="ibox">
			
			<div class="ibox-title">
				
				<div class="ibox-tools">
					<form action="" method="post" id="search-form">
						<input type="hidden" name="month" value="{{$filters['month']}}">
						<input type="hidden" name="year" value="{{$filters['year']}}">
						<input type="hidden" name="collection_status" value="{{$filters['collection_status']}}">
						<a href="#" id="manual-sync" class="btn btn-primary">Refresh</a>
						<a href="#" id="export-csv" class="btn btn-primary" data-url="{{ route('collection-statistics-export') }}" data-file-name="collection-statistics-report-export">Export to CSV</a>
					</form>
					
				</div>
				
			</div>
			
			<div class="ibox-content">
				@include('settings.partials.success-message')
				@include('settings.partials.delete-message')
				<div class="ajax-loader"><img src="/img/ajax-loader-full-width.gif"></div>
				<div class="dt-coltoggler-wrapper ">
					<p>Click to toggle table columns: </p>
				</div>
				<div class="">
					
					<table class="table table-stripped table-hover nowrap footable thee-col-fixed has-column-toggler" data-role="ui-data-table" data-page-size="50" data-url="{{ route('collection-statistics-bar-data') }}" data-searching="false" data-ordering="false" data-scroll-x="true">
						<thead>
							<tr>
								<th data-col-name="id">#</th>
								<th data-col-name="asset_tag">Asset Tag #</th>
								<th data-col-name="serial_no">Serial #</th>
								<th data-col-name="hardware">Hardware Standard</th>
								<th data-col-name="status">Status</th>
								<th data-col-name="user">User Name</th>
								<th data-col-name="email">Email</th>
								<th data-col-name="ticket_no">Assignment Ticket #</th>
								<th data-col-name="updated_at">Last Modified Date</th>
							</tr>
						</thead>
					</table>
					
				</div>
				
			</div>
			
		</div>
	</div>
</div>

@stop
@section('after_scripts')
@include('reports.scripts.common')
@include('reports.scripts.datatable')
@include('reports.scripts.datatable-column-toggle-script');
@include('terminations.terms-report.scripts.collection-detail-report')
@stop