
<script>
    
    $(document).ready(function() {
        
        $(".filter-field-retriever").each(function() {
            var name = $(this).attr('key');
            $( this ).select2({
                minimumInputLength: 1,
                multiple: true,
                ajax: {
                    url: '/terminations/get-filter-retriever-fields',
                    dataType: "json",
                    data: function (params){
                        var query = {
                            search: params.term,
                            type: name
                        }
                        
                        // Query parameters will be ?search=[term]&type=public
                        return query;
                    },
                    processResults: function (data) {
                        // Tranforms the top-level key of the response object from 'items' to 'results'
                        return {
                            results: data
                        };
                    },
                    
                }
            });
        });
        
        
        $(".filter-field-all-user").each(function() {
            $( this ).select2({
                minimumInputLength: 1,
                multiple: true,
                ajax: {
                    url: '/get-filter-fields-all-user',
                    dataType: "json",
                    data: function (params){
                        var query = {
                            search: params.term
                        }
                        
                        // Query parameters will be ?search=[term]&type=public
                        return query;
                    },
                    processResults: function (data) {
                        // Tranforms the top-level key of the response object from 'items' to 'results'
                        return {
                            results: data
                        };
                    },
                    
                }
            });
        });
        
        $('#viewAssetModal').on('show.bs.modal', function (e) {
            var action = $(e.relatedTarget).data('action');
            $.ajax({
                type: "get",
                url: action,
                success: function (value) {
                    $('#asset-table-body').html(value);
                }
            });
        });
        
        $('#viewDeactivatedReasonModal').on('show.bs.modal', function (e) {
            $('#viewDeactivateReasonBody').html('');
            var id = $(e.relatedTarget).data('id');
            $.ajax({
                type: "get",
                url: "retriever-report/get-deactivated-reason/"+id,              
                success: function (value) {
                    $('#viewDeactivateReasonBody').html('<p>'+value+'</p>');
                }
            });
        });

        $("#retriever-sync").click(function (e) {
            e.preventDefault();
            $('#retriever-sync').hide();
            $("#sync-success").html('Retriever sync started. Please wait. It may take a while.').show();
            $.ajax({
                type: "post",
                url: "/retriever-manual-sync",
                success: function(data) {
                    $('.footable').DataTable().draw();
                    if(data.status== 'success'){
                        $("#sync-success").html(data.message);
                    }else{
                        $("#sync-success").html('').hide();
                        $("#sync-error").html(data.message).show();
                    }

                    $('#retriever-sync').show();
                },
                error: function() {
                    $("#sync-success").html('').hide();
                    $("#sync-error").html('Error while syncing. Please try again.').show();
                    $('#retriever-sync').show();
                }
            });
        });
        
    });
    
    
</script>