<div class="col-lg-12">
    <div class="ibox">
        <div class="ibox-title">
			<div class="ibox-tools">
				<h5>Filters</h5>
				<a data-toggle="collapse" href="#collapseFilter" class="collapse-link"> <i class="icon icon-e-delete"></i></a>
			</div>
		</div>
        <div class="collapse in" id="collapseFilter">
            <div class="ibox-content">
                <form method="post" id="search-form" action="">
                    {{ csrf_field() }}
                    <div class="row">
                        <div class="col-md-3">
                            <div class="form-group">
                                <label class="control-label">User</label>
                                <select class="filter-field  filter-field-retriever form-control" multiple name="user_name"
                                    id="user_name" key="user_name" data-placeholder="Select">
                                </select>
                            </div>
                        </div>

                        <div class="col-md-3">
                            <div class="form-group">
                                <label class="control-label">Work Email</label>
                                <select class="filter-field  filter-field-common form-control" multiple name="work_email"
                                    id="work_email" key="email" data-placeholder="Select">
                                </select>
                            </div>
                        </div>

                        <div class="col-md-3">
                            <div class="form-group">
                                <label class="control-label">City</label>
                                <select class="filter-field  filter-field-retriever form-control" multiple name="city"
                                    id="city" key="city" data-placeholder="Select">
                                </select>
                            </div>
                        </div>

                        <div class="col-md-3">
                            <div class="form-group">
                                <label class="control-label">Shipment Status</label>
                                <select class="chosen-select filter-input" multiple name="shipment_status"
                                    id="shipment_status" data-placeholder="Select">
                                    @foreach(config('retriever.shipment_statuses') as $key => $status)
                                    <option value="{{$key}}" @if(request('status') == $key) selected @endif>{{$status}}</option>
                                    @endforeach
                                </select>
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-3">
                            <div class="form-group">
                                <label class="control-label">Device Type</label>
                                <select class="chosen-select filter-input" multiple name="device_type"
                                    id="device_type" data-placeholder="Select">
                                    @foreach(\App\Models\RetrieverDevice::distinct()->select('device_type')->orderBy('device_type')->get() as $type)
                                    <option value="{{$type->device_type}}">{{ config('retriever.device_types.'.$type->device_type,$type->device_type) }}</option>
                                    @endforeach
                                </select>
                            </div>
                        </div>

                        <div class="col-md-3">
                            <div class="form-group">
                                <label class="control-label">Request Charger</label>
                                <select class="form-control select2 filter-input" multiple
                                    name="request_charger" id="request_charger" data-placeholder="Select">
                                    <option value="1">Yes</option>
                                    <option value="2">No</option>
                                </select>
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="form-group">
                                <label class="control-label">Outbound Tracking</label>
                                <select class="filter-field  filter-field-retriever form-control" multiple name="outbound_tracking"
                                    id="outbound_tracking" key="outbound_tracking" data-placeholder="Select">
                                </select>
                            </div>
                        </div>

                        <div class="col-md-3">
                            <div class="form-group">
                                <label class="control-label">Return Tracking</label>
                                <select class="filter-field  filter-field-retriever form-control" multiple name="return_tracking"
                                    id="return_tracking" key="return_tracking" data-placeholder="Select">
                                </select>
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-3">
                            <div class="form-group">
                                <label>Box Shipped Date Range</label>
                                <div class="form-group">
                                    <div class="input-group date">
                                        <span class="input-group-addon"><i
                                                class="icon icon-calendar-2"></i></span><input type="text"
                                            name="box_shipped_at_from" id="box_shipped_at_from"
                                            class="form-control date-picker-input" placeholder="From"
                                            value="">
                                    </div>
                                </div>

                                <div class="form-group">
                                    <div class="input-group date">
                                        <span class="input-group-addon"><i
                                                class="icon icon-calendar-2"></i></span><input type="text"
                                            class="form-control date-picker-input"
                                            id="box_shipped_at_to" placeholder="To"
                                            name="box_shipped_at_to" value="">
                                    </div>
                                </div>
                            </div>
                        </div>
                    

                        <div class="col-md-3">
                            <div class="form-group">
                                <label>Box Delivered Date Range</label>
                                <div class="form-group">
                                    <div class="input-group date">
                                        <span class="input-group-addon"><i
                                                class="icon icon-calendar-2"></i></span><input type="text"
                                            name="box_delivered_at_from" id="box_delivered_at_from"
                                            class="form-control date-picker-input" placeholder="From"
                                            value="">
                                    </div>
                                </div>

                                <div class="form-group">
                                    <div class="input-group date">
                                        <span class="input-group-addon"><i
                                                class="icon icon-calendar-2"></i></span><input type="text"
                                            class="form-control date-picker-input"
                                            id="box_delivered_at_to" placeholder="To"
                                            name="box_delivered_at_to" value="">
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="col-md-3">
                            <div class="form-group">
                                <label>Device Shipped Date Range</label>
                                <div class="form-group">
                                    <div class="input-group date">
                                        <span class="input-group-addon"><i
                                                class="icon icon-calendar-2"></i></span><input type="text"
                                            name="device_shipped_at_from" id="device_shipped_at_from"
                                            class="form-control date-picker-input" placeholder="From"
                                            value="">
                                    </div>
                                </div>

                                <div class="form-group">
                                    <div class="input-group date">
                                        <span class="input-group-addon"><i
                                                class="icon icon-calendar-2"></i></span><input type="text"
                                            class="form-control date-picker-input"
                                            id="device_shipped_at_to" placeholder="To"
                                            name="device_shipped_at_to" value="">
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="col-md-3">
                            <div class="form-group">
                                <label>Device Delivered Date Range</label>
                                <div class="form-group">
                                    <div class="input-group date">
                                        <span class="input-group-addon"><i
                                                class="icon icon-calendar-2"></i></span><input type="text"
                                            name="device_delivered_at_from" id="device_delivered_at_from"
                                            class="form-control date-picker-input" placeholder="From"
                                            value="">
                                    </div>
                                </div>

                                <div class="form-group">
                                    <div class="input-group date">
                                        <span class="input-group-addon"><i
                                                class="icon icon-calendar-2"></i></span><input type="text"
                                            class="form-control date-picker-input"
                                            id="device_delivered_at_to" placeholder="To"
                                            name="device_delivered_at_to" value="">
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-3">
                            <div class="form-group">
                                <label>Created At Date Range</label>
                                <div class="form-group">
                                    <div class="input-group date">
                                        <span class="input-group-addon"><i
                                                class="icon icon-calendar-2"></i></span><input type="text"
                                            name="created_at_from" id="created_at_from"
                                            class="form-control date-picker-input" placeholder="From"
                                            value="">
                                    </div>
                                </div>

                                <div class="form-group">
                                    <div class="input-group date">
                                        <span class="input-group-addon"><i
                                                class="icon icon-calendar-2"></i></span><input type="text"
                                            class="form-control date-picker-input"
                                            id="created_at_to" placeholder="To"
                                            name="created_at_to" value="">
                                    </div>
                                </div>
                            </div>
                        </div>

                    </div>

                </form>
            </div>
        </div>
    </div>
</div>