
<script src="/js/plugins/jquery-validation/jquery.validate.min.js"></script>
<script src="/js/validator-methods.js"></script>
<script>
    
    var currentPanel = 1;
    var panels = $(".create-order-panel");

    function showPanel(index) {
        panels.hide();
        $("#panel"+index).show();
        $(".previous-button").show();
        $(".next-button").show();
        $(".create-order-submit-button").hide();
        currentPanel = index;
        $('.form-header-tabs').removeClass('active');
        $('.form-header-tabs').eq(index-1).addClass('active');
        if(index == 1){
            $(".previous-button").hide();
        }else if(index == panels.length){
            $(".next-button").hide();
            $(".create-order-submit-button").show();
        }
    }

    $(".next-button").click(function() {
        if ($("#create-return-request-form"+currentPanel).valid()) {
            currentPanel++;
            showPanel(currentPanel);
        }
    });

    $(".previous-button").click(function() {
        currentPanel--;
        showPanel(currentPanel);
    });

    $(document).on("click", ".create-order-submit-button", function() {
        if($("#create-return-request-form3").valid()){
            submitCombinedForm();
        }
    });

    var retrieverDeviceTypes = @json(array_keys(config('retriever.device_types')));
    $("#create-return-request-form1").validate({
        ignore: ":hidden:not(select)",
        onkeyup: false,
        onfocusout: false,
        onclick: false,
        rules: {
            return_charger: {
                required: false
            },
            return_phone: {
                required: false
            },
            device: {
                required: true,
                enum:retrieverDeviceTypes
            },
            request_disposal: {
                required: false
            },
            display_name: {
                required: true,
                maxlength: 64
            },
            notification_email: {
                email: true,
                maxlength: 128
            },
        },
        messages: {
            return_charger: {
                required: "Please specify whether the charger needs to be returned."
            },
            return_phone: {
                required: "Please specify whether the phone needs to be returned."
            },
            device: {
                required:"Please select a valid device type.",
                enum: "Please select a device type."
            },
            display_name:{
                required:"Please enter the display name."
            },
            notification_email: {
                email: "Please enter a valid email address.",
            },
        },errorPlacement: function(error, element) {
            error.appendTo(element.closest('.form-group').find('.error-message'));
        },
        highlight: function(element) {
            $(element).closest('.form-group').addClass('has-error');
        },
        unhighlight: function(element) {
            $(element).closest('.form-group').removeClass('has-error');
        }
    });

    $("#create-return-request-form2").validate({
        ignore: ":hidden:not(select)",
        onkeyup: false,
        onfocusout: false,
        onclick: false,
        rules: {
            name: {
                required: true,
                maxlength: 64
            },
            email: {
                email: true,
                maxlength: 128
            },
            address_line_1: {
                required: true,
                maxlength: 128
            },
            address_line_2: {
                maxlength: 128
            },
            address_city: {
                required: true,
                maxlength: 128,
            },
            address_state: {
                required: true,
                maxlength: 32,
            },
            address_zip: {
                required: true,
                maxlength: 32,
            },
            address_country: {
                required: true,
                maxlength: 32
            },
            
        },
        messages: {
            name: {
                required: "Please enter the employee's name."
            },
            address_line_1: {
                required: "Please enter the the Address 1."
            },
            address_country: {
                required: "Please select a country."
            },
            address_state: {
                required: "Please select a state."
            },
            address_city: {
                required: "Please enter the city."
            },
            address_zip: {
                required: "Please enter the zip code."
            },
            email: {
                email: "Please enter a valid email address.",
            }, 
        },errorPlacement: function(error, element) {
            error.appendTo(element.closest('.form-group').find('.error-message'));
        },
        highlight: function(element) {
            $(element).closest('.form-group').addClass('has-error');
        },
        unhighlight: function(element) {
            $(element).closest('.form-group').removeClass('has-error');
        }
    });

    $("#create-return-request-form3").validate({
        ignore: ":hidden:not(select)",
        onkeyup: false,
        onfocusout: false,
        onclick: false,
        rules: {
            return_recipient_name: {
                required: true,
                maxlength: 64
            },
            return_address_company: {
                maxlength: 64
            },
            return_address_line_1: {
                required: true,
                maxlength: 128
            },
            return_address_line_2: {
                maxlength: 128
            },
            return_address_city: {
                required: true,
                maxlength: 128,
            },
            return_address_state: {
                required: true,
                maxlength: 32,
            },
            return_address_zip: {
                required: true,
                maxlength: 32,
            },
            return_address_country: {
                required: true,
                maxlength: 32
            },
        },
        messages: {
            return_recipient_name: {
                required: "Please enter the return recipient's name."
            },
            return_address_line_1:{
                required: "Please enter the Address 1."
            },
            return_address_country: {
                required: "Please select a country."
            },
            return_address_state: {
                required: "Please select a state."
            },
            return_address_city: {
                required: "Please enter the city."
            },
            return_address_zip: {
                required: "Please enter the zip."
            },
        },errorPlacement: function(error, element) {
            error.appendTo(element.closest('.form-group').find('.error-message'));
        },
        highlight: function(element) {
            $(element).closest('.form-group').addClass('has-error');
        },
        unhighlight: function(element) {
            $(element).closest('.form-group').removeClass('has-error');
        }
    });

    function submitCombinedForm() {
        // Create a new form
        var combinedForm = $("<form>", {
            method: "post",
            action: "/terminations/retriever/create-shipment-request"
        });

        // Append all fields from form1
        $("#create-return-request-form1").find("input, select, textarea").each(function() {
            var clonedElement = $(this).clone();
            if ($(this).is("select")) {
                clonedElement.val($(this).val()); // Ensure the value is set correctly
            }
            combinedForm.append(clonedElement);
        });

        // Append all fields from form2
        $("#create-return-request-form2").find("input, select, textarea").each(function() {
            var clonedElement = $(this).clone();
            if ($(this).is("select")) {
                clonedElement.val($(this).val()); // Ensure the value is set correctly
            }
            combinedForm.append(clonedElement);
        });

        // Append all fields from form3
        $("#create-return-request-form3").find("input, select, textarea").each(function() {
            var clonedElement = $(this).clone();
            if ($(this).is("select")) {
                clonedElement.val($(this).val()); // Ensure the value is set correctly
            }
            combinedForm.append(clonedElement);
        });

        // Append the combined form to the body and submit it
        combinedForm.appendTo("body").submit();
    }


    $(document).ready(function() {

        $("#shipment-destination").change(function() {

        var selectedDestination = $(this).val();

        if (selectedDestination) {
            // Make an AJAX request to get the address details
            $.ajax({
                url: '/get-single-location-info/'+selectedDestination, // Change this URL to your actual endpoint
                method: 'GET',
                success: function(response) {
                    // Assuming the response is a JSON object with the address details
                    $("#return_recipient_name").val(response.room_name);
                    $("#return_address_line_1").val(response.address);
                    $("#return_address_line_2").val(response.building);
                    $("#return_address_city").val(response.city);
                    if(response.state){
                        $("#return_address_state").val(response.state.name);
                    }
                    $("#return_address_zip").val(response.zip);

                    if(response.country) {
                        var countryName = response.country.name;
                        if (countryName.toLowerCase() === "united states") {
                            countryName = "USA";
                        } else if (countryName.toLowerCase() === "united kingdom") {
                            countryName = "UK";
                        } else {
                            countryName = countryName.toUpperCase();
                        }
                        $("#return_address_country").val(countryName).trigger('change');
                    }
                },
                error: function(xhr, status, error) {
                    console.error("Error fetching address details:", error);
                    // Handle the error (e.g., display an error message)
                }
            });
        }
    });
});

        
    
    
</script>