<div id="create-order-modal" class="create-order-modal modal fade" role="dialog">
	<div class="modal-dialog modal-lg">
  
	  <div class="modal-content">
		<div class="modal-header">
		  <button type="button" class="close" data-dismiss="modal">&times;</button>
		  <h3 class="modal-title text-center">Create Device Return Request</h3>
		</div>

        <ul class="nav nav-tabs">
            <li class="form-header-tabs active col-md-4" id="form-header-tab1"><a href="javascript:void(0);">Device Return Preferences</a></li>
            <li class="form-header-tabs col-md-4" id="form-header-tab2"><a href="javascript:void(0);">Employee Information</a></li>
            <li class="form-header-tabs col-md-4" id="form-header-tab3"><a href="javascript:void(0);">Company Destination Information</a></li>
        </ul>
		<div class="modal-body">
            <div class="ibox-content">
                
                <div class="form-container panel create-order-panel" id="panel1">
                    <h2>Device Return Preferences</h2>

                    <form method="post" id="create-return-request-form1" action="">
                        {{ csrf_field() }}

                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="device">Device <span class="text-danger">*</span></label>
                                    <select id="device" class="form-control" name="device" >
                                        <option value="device">Select Device Type</option>
                                        @foreach (config('retriever.device_types') as $key => $deviceType)
                                            <option value="{{ $key }}">{{ $deviceType }}</option>
                                        @endforeach
                                    </select>
                                    <div class="error-message text-danger"></div>
                                </div>
                            </div>
                        </div>
    
                        <div class="form-group">
                            <p><label>What do you want to do with this device<span class="text-danger">*</span></label><p>
                            <input type="radio" id="returnDevice" name="request_disposal" value="0" checked >
                            <label for="returnDevice">Return it to the address supplied below</label>
                        </div>
                        <div class="form-group">
                            <input type="radio" id="sendToRetriever" name="request_disposal" value="1" >
                            <label for="sendToRetriever">Send it to Retriever to perform a secure data wipe and disposal and issue a Certificate of Data Destruction</label>
                        </div>

                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="display_name">Display Name<span class="text-danger">*</span></label>
                                    <input type="text" class="form-control" id="display_name" name="display_name">
                                    <div class="error-message text-danger"></div>
                                    <small>Company name *This will be shown to your employee in email communications. You can use the name of your organization, your name, or anything else that tells your employee who is requesting the device.</small>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="notification_email">Notification E-mail</label>
                                    <input type="text" class="form-control" id="notification_email" name="notification_email">
                                    <div class="error-message text-danger"></div>
                                    <small>We'll send tracking updates here, as well as information about any delivery issues that come up. Please make sure it's an inbox that you regularly check.</small>
                                </div>
                            </div>
                        </div>

                        <div class="form-group">
                            <input type="checkbox" id="return_charger" name="return_charger">
                            <label for="return_charger">Ask employee to return charger</label>
                            <p>We'll include a reminder in the packing/shipping instructions.</p>
                        </div>
                        <div class="form-group">
                            <input type="checkbox" id="return_phone"  name="return_phone">
                            <label for="return_phone">Ask the employee to return cell phone <span style="text-decoration: line-through;">($9 additional fee)</span> <span>(waived for Enterprise customers)</span></label>
                            <p>We'll include a self-seal bubble bag and packing instructions.</p>
                        </div>
                    </form>
                </div>

                <div class="form-container panel create-order-panel" id="panel2" style="display: none;">
                    <h2>Employee Information</h2>
                    <p>This is where we'll send the padded device box, packing/shipping instructions, and prepaid return shipping label.</p>
                    <form method="post" id="create-return-request-form2" action="">
                        {{ csrf_field() }}
                            
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="name">Name <span class="text-danger">*</span></label>
                                    <input type="text" class="form-control" name="name" id="name">
                                    <div class="error-message text-danger"></div>
                                </div>
                            </div>

                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="email">Email address</label>
                                    <input type="email" class="form-control" id="email" name="email">
                                    <div class="error-message text-danger"></div>
                                    <small>We'll send your employee a tracking link and reminders (if they delay returning their device). If they no longer have access to their work account, use a personal email address.</small>
                                </div>
                            </div>
                        </div>
                        <div class="row">

                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="address_line_1">Address 1 <span class="text-danger">*</span></label>
                                    <input type="text" class="form-control" id="address_line_1" name="address_line_1" >
                                    <div class="error-message text-danger"></div>
                                </div>
                            </div>
                        
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="address_line_2">Address 2</label>
                                    <input type="text" class="form-control" id="address_line_2" name="address_line_2">
                                    <div class="error-message text-danger"></div>
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="address_city">City <span class="text-danger">*</span></label>
                                    <input type="text" class="form-control" id="address_city" name="address_city">
                                    <div class="error-message text-danger"></div>
                                </div>
                            </div>

                            <div class="col-md-6">    
                                <div class="form-group">
                                    <label for="address_state">State <span class="text-danger">*</span></label>
                                    <input type="text" class="form-control" id="address_state" name="address_state">
                                    <div class="error-message text-danger"></div>
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-6">    
                                <div class="form-group">
                                    <label for="address_country">Choose a country<span class="text-danger">*</span></label>
                                    <select id="address_country" class="form-control" name="address_country" >
                                        <option value="">Select Country</option>
                                        @foreach (config('retriever.countries') as $country)
                                            <option value="{{ $country }}">{{ $country }}</option>  
                                        @endforeach
                                    </select>
                                    <div class="error-message text-danger"></div>
                                </div>
                            </div>

                            <div class="col-md-6">    
                                <div class="form-group">
                                    <label for="address_zip">ZIP code<span class="text-danger">*</span> </label>
                                    <input type="text" class="form-control" id="address_zip" name="address_zip">
                                    <div class="error-message text-danger"></div>
                                </div>
                            </div>
                        </div>
                    </form>
                </div>

                <div class="form-container panel create-order-panel" id="panel3" style="display: none;">
                    <h2>Company Destination Information</h2>
                    <p>This is where employee will ship the device.</p>
                    <form method="post" id="create-return-request-form3" action="">
                        {{ csrf_field() }}
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="location">Location<span class="text-danger"></span></label>
                                    <select class="filter-field-all-active-location form-control" name="location" id="shipment-destination" data-placeholder="Select" key="room_name">
                                    </select>
                                    <small>Select the location where employee will ship the device.</small>
                                    <div class="error-message text-danger"></div>
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="return_recipient_name">Name<span class="text-danger">*</span></label>
                                    <input type="text" class="form-control" id="return_recipient_name" name="return_recipient_name" >
                                    <div class="error-message text-danger"></div>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="return_address_company">Company</label>
                                    <input type="text" class="form-control" id="return_address_company" name="return_address_company">
                                    <div class="error-message text-danger"></div>
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="return_address_line_1">Address 1<span class="text-danger">*</span></label>
                                    <input type="text" class="form-control" id="return_address_line_1" name="return_address_line_1" >
                                    <div class="error-message text-danger"></div>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="return_address_line_2">Address 2</label>
                                    <input type="text" class="form-control" id="return_address_line_2" name="return_address_line_2">
                                    <div class="error-message text-danger"></div>
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="return_address_city">City<span class="text-danger">*</span></label>
                                    <input type="text" class="form-control" id="return_address_city" name="return_address_city">
                                    <div class="error-message text-danger"></div>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="return_address_state">State<span class="text-danger">*</span></label>
                                    <input type="text" class="form-control" id="return_address_state" name="return_address_state">
                                    <div class="error-message text-danger"></div>
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="return_address_country">Choose a country<span class="text-danger">*</span></label>
                                    <select class="form-control" id="return_address_country" name="return_address_country" >
                                        <option value="">Select Country</option>
                                        @foreach (config('retriever.countries') as $country)
                                            <option value="{{ $country }}">{{ $country }}</option>  
                                        @endforeach
                                        </select>
                                    <div class="error-message text-danger"></div>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="return_address_zip">ZIP code<span class="text-danger">*</span></label>
                                    <input type="text" class="form-control" id="return_address_zip" name="return_address_zip">
                                    <div class="error-message text-danger"></div>
                                </div>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
		</div>
		<div class="modal-footer">
            <button type="button" class="btn btn-default float-left previous-button" style="display: none">Previous</button>
		    <button type="button" class="btn btn-default next-button" >Next</button>
            <button type="submit" class="btn btn-primary create-order-submit-button" style="display: none">Submit</button>
		</div>
	  </div>
  
	</div>
</div>