@extends('layouts.main')
@section('content')
@include('partials.breadcrumb', ['breadcrumbTitle' => 'Retriever Report', 'parentUrl' => '#', 'parentTitle' =>'Terminations'])
<div class="wrapper-content">
    <div class="container-fluid">
        
        @include('terminations.retriever.partials.retriever-report-filter')
            
        <div class="ibox">

            <div class="ibox-title">
                <div class="ibox-tools">
                    <button type="button" id="export-csv" class="btn btn-primary" data-url="{{ route('retriever-report-export') }}" data-file-name="retriever-report-export">Export to CSV</button>
                    @if($connectionStatus)
                    <button type="button" id="create-order-button" class="btn btn-primary" data-toggle="modal" data-target="#create-order-modal" onclick="showPanel(1)">Create Order</button>
                    <button class="btn btn-primary " id="retriever-sync">Manual Sync</a>
                    @endif
                </div>
            </div>

            <div class="ibox-content">
                @include('partials.success')
                @include('partials.error-message')

                <div class="ajax-loader"><img src="/img/ajax-loader-full-width.gif"></div>
                <div class="alert alert-danger" id="sync-error" style="display: none;">
                    <a href="#" class="close" data-dismiss="alert" aria-label="close">&times;</a>
                </div>
                <div class="alert alert-success" id="sync-success" style="display: none;">
                    <a href="#" class="close" data-dismiss="alert" aria-label="close">&times;</a>
                </div>

                <div class="dt-coltoggler-wrapper ">
					<p>Click to toggle table columns: </p>
                </div>

                <table class="footable table table-stripped table-hover nowrap three-col-fixed has-column-toggler" data-role="ui-data-table" data-url="{{ route('retriever-report-data') }}" data-searching="false" data-ordering="false" data-page-size="50" data-fixed-header="true" data-fixed-header-columns-left="3">

                    <thead>

                        <tr>

                            <th data-col-name="id">#</th>

                            <th data-col-name="user_name">User</th>

                            <th data-col-name="work_email">Work Email</th>

                            <th data-col-name="city">City</th>

                            <th data-col-name="shipment_status">Shipment Status</th>

                            <th data-col-name="device_type">Device Type</th>

                            <th data-col-name="request_charger">Request Charger</th>

                            <th data-col-name="outbound_tracking">Outbound Tracking</th>

                            <th data-col-name="return_tracking">Return Tracking</th>

                            <th data-col-name="box_shipped_at">Box Shipped At</th>

                            <th data-col-name="box_delivered_at">Box Delivered At</th>

                            <th data-col-name="device_shipped_at">Device Shipped At</th>

                            <th data-col-name="device_delivered_at">Device Delivered At</th>

                            <th data-col-name="created_at">Created At</th>

                            <th data-col-name="view_asset_button">Assets Assigned</th>

                        </tr>

                    </thead>

                    <tbody>


                    </tbody>

                </table>


            </div>

        </div>

            

    </div>

</div>
@include('terminations.retriever.modals.create-order')
@include('terminations.retriever.modals.view-asset')
@include('terminations.retriever.modals.view-deactivated-reason')
@stop

@section('after_scripts')

@include('reports.scripts.common')
@include('reports.scripts.datatable')
@include('assets.partials.scripts.dropdown-script')
@include('reports.scripts.datatable-column-toggle-script')

@include('terminations.retriever.partials.retriever-report-scripts')

@include('terminations.retriever.partials.create-order-scripts')

@stop