@extends('layouts.main')
@section('content')
@include('partials.breadcrumb', ['breadcrumbTitle' => 'Software Assets Subscriptions','parentTitle'=>'Settings','parentUrl'=>'/settings'])
<div class="wrapper-content">
    <div class="container-fluid">
        
        <div class="ibox">
            
            <div class="ibox-content">
                @include('settings.partials.success-message')
                @include('settings.partials.delete-message')
                @can('Software Assets Subscription Manage')
                <p><a href="#" class="btn btn-primary" data-toggle="modal"
                    data-target="#addLicenseSubscription">Add New</a></p>
                    @endcan
                    
                    @include('software-license.partials.subscription-filters')
                    
                    <table class="footable table table-stripped table-hover" data-page-size="50" data-filter=#filter
                    id="license-subscription-table">
                    
                    <thead>
                        
                        <tr>
                            <th style="display: none;"></th>
                            <th>#</th>
                            <th>Name</th>
                            <th>Duration</th>
                            <th>Duration Type</th>
                            
                        </tr>
                        
                    </thead>
                    
                    <tbody>
                        @include('software-license.subscription.list')
                    </tbody>
                    
                    <tfoot>
                        
                        <tr>
                            
                            <td colspan="5">
                                
                                <ul class="pagination pull-right"></ul>
                                
                            </td>
                            
                        </tr>
                        
                    </tfoot>
                    
                </table>
                
            </div>
            
        </div>
        
    </div>
    
</div>


@stop

@section('help-links')
@include('help.help-links',['helpLink'=>config('help-links.help_links.software_asset_settings_subscription_types'),'helpTitle'=>config('help-links.help_titles.software_asset_settings_subscription_types')])
@endsection

@section('after_scripts')
@include('software-license.modals.add-subscription')
@include('software-license.scripts.subscription')
@stop