@extends('layouts.main')
@section('content')
@include('partials.breadcrumb', ['breadcrumbTitle' => 'Add new Subscriptions', 'parentUrl' => '#', 'parentTitle'
=> 'Software License'])

<div class="wrapper-content">

	<div class="container-fluid">

		<form class="form-horizontal" method="post" action="{{route('software-license-subscriptions.store')}}">

			{{csrf_field()}}

            <div class="row">

				@include('partials.error')

				<div class="col-lg-12">

					<div class="ibox-content">
                        <input type="hidden" name="id" value="{{ isset($subscription) ? $subscription->id : '' }}">
						<div class="form-group">
							<label class="col-lg-3 control-label">Subscription Name</label>
							<div class="col-lg-6">
								<input type="text" class="form-control" name="name" value="{{ isset($subscription) ? $subscription->name : old('name') }}">
							</div>
						</div>

						

						<div class="form-group">
							<div class="col-lg-offset-3 col-lg-1">
								<input class="btn btn-primary" type="submit" value="{{ isset($subscription) ? 'Update' : 'Save' }}">
							</div>
						</div>

					</div>


				</div>
			</div>
		</form>

	</div>
</div>
@stop

@section('after_scripts')
@stop