
<script>

    $(document).ready(function() {

        $('.chosen-select').chosen({width: "100%"}).change(function() {
		    $(this).closest('.form-group').next().find('input').focus();
        });
        $.fn.serializeObject = function(){
           var obj = {};
            
           $.each( this.serializeArray(), function(i,o){
              var n = o.name, v = o.value;
                
              obj[n] = obj[n] === undefined ? v
                 : $.isArray( obj[n] ) ? obj[n].concat( v )
                 : [ obj[n], v ];
           });
            
           return obj;
        };
       
        var usersTable = $('.license-users-tbl').DataTable({              
			"processing": true,
            "serverSide": true,
            scrollCollapse: false,
            scrollX: false,
            scrollY: false,
            fixedHeader: true,
            "ajax": {
                "url": "{{ route('software-assets.users') }}",
                "dataType": "json",
                "type": "POST",
                "data": function (result) {
                    result.form = $('#search-form').serializeObject();
                }
            },
            "columns": [
                { "data": "id" },
                { "data": "user" },
                { "data": "email" },
                { "data": "license_key" },
                { "data": "date_added" },
                { "data": "user_status" },
                { "data": "status" },
                { "data": "avg_meeting_length"},
                { "data": "action"},
            ],
            lengthMenu: [
                [50, 100, 200],
                ['50', '100', '200']
            ],
            columnDefs: [
                { orderable: false, targets: "_all" },
            ],
            "aaSorting": [],
            "dom": '<"top"i>rt<"bottom"flp><"clear">',
            "bAutoWidth": false,
            "bFilter": true,
            "bLengthChange": false,
            "searching": false,
        });


        $('#export-csv').on('click', function(e) {
            e.preventDefault();
            $('.ajax-loader').show();
            $.ajax({  
                type: "POST",  
                url: "{{ route('software-assets.users.export') }}",  
                data: $('#search-form').serializeObject(),
                dataType: 'text',
                success: function(result) {
                    var blob = new Blob([result]);
                    var filename = "{{$license->name}}TeqtivityUsersList.csv"
                    if (window.navigator.msSaveOrOpenBlob)  // IE hack; see http://msdn.microsoft.com/en-us/library/ie/hh779016.aspx
                        window.navigator.msSaveBlob(blob, filename);
                    else
                    {
                        var a = window.document.createElement("a");
                        a.href = window.URL.createObjectURL(blob, {type: "text/plain"});
                        a.download = filename;
                        document.body.appendChild(a);
                        a.click();  // IE: "Access is denied"; see: https://connect.microsoft.com/IE/feedback/details/797361/ie-10-treats-blob-url-as-cross-origin-and-denies-access
                        document.body.removeChild(a);
                    }
                    $('.ajax-loader').hide();
                }
            })
        });

        $('#search-form').submit(function (e) {
            e.preventDefault();
            usersTable.draw();
        });

        $('.input-group.date').datepicker({
            todayBtn:"linked",
            clearBtn:true,
            keyboardNavigation: false,
            forceParse: true,
            autoclose: true
        }).on('change', function (e) {
            $('#search-form').submit();
        });
        $('.select-filter').on('change', function (e) {
            $('#search-form').submit();
        });


        $(".filter-field-user").each(function () {
			$(this).select2({
				minimumInputLength: 1,
				multiple: true,
				ajax: {
					url: '/get-filter-fields-all-user',
					dataType: "json",
					data: function (params) {
						var query = {
							search: params.term
						}

						// Query parameters will be ?search=[term]&type=public
						return query;
					},
					processResults: function (data) {
						// Tranforms the top-level key of the response object from 'items' to 'results'
						return {
							results: data
						};
					},

				}
			});
		});

    });
    </script>