<script>
    $(document).ready(function() {


        var nonTeqUsersTable = $('.license-non-teq-users').DataTable({              
                           
                "scrollX": true,               
                "processing": true,
                "serverSide": true,
                "ajax":{
                "url": "{{route('software-assets.non-teq-users')}}",
                "dataType": "json",
                "type": "POST",
                "data": function( result ) {
                    result.form = $('#search-nonteq-form').serializeObject();
                }
            },
            "columns": [
                { "data": "id" },
                { "data": "user" },
                { "data": "email" },
                { "data": "date_added" },
                { "data": "role" },
                { "data": "user_status" },
                { "data": "avg_meeting_length" },
            ],
            
            lengthMenu: [
                [ 50, 100, 200],
                [ '50', '100', '200']
            ],
            columnDefs: [
                {  orderable: false, targets: "_all" }
            ],
            "aaSorting": [],
            "bAutoWidth": false,
            "bFilter": true,
            "bLengthChange": false,
            "searching": false
        });
        


        $('#export-nonteq-csv').on('click', function(e) {
            e.preventDefault();
            $('.ajax-loader').show();
            $.ajax({  
                type: "POST",  
                url: "{{ route('software-assets.non-teq-users.export') }}",  
                data: $('#search-nonteq-form').serializeObject(),
                dataType: 'text',
                success: function(result) {
                    var blob = new Blob([result]);
                    var filename = "{{$license->name}}NonTeqtivityUsersList.csv"
                    if (window.navigator.msSaveOrOpenBlob)  // IE hack; see http://msdn.microsoft.com/en-us/library/ie/hh779016.aspx
                        window.navigator.msSaveBlob(blob, filename);
                    else
                    {
                        var a = window.document.createElement("a");
                        a.href = window.URL.createObjectURL(blob, {type: "text/plain"});
                        a.download = filename;
                        document.body.appendChild(a);
                        a.click();  // IE: "Access is denied"; see: https://connect.microsoft.com/IE/feedback/details/797361/ie-10-treats-blob-url-as-cross-origin-and-denies-access
                        document.body.removeChild(a);
                    }
                    $('.ajax-loader').hide();
                }
            })
        });

        $('#search-nonteq-form').submit(function (e) {
            e.preventDefault();
            nonTeqUsersTable.draw();
        });

        $('.nonteq-date.date').datepicker({
            todayBtn:"linked",
            clearBtn:true,
            keyboardNavigation: false,
            forceParse: true,
            autoclose: true
        }).on('change', function (e) {
            $('#search-nonteq-form').submit();
        });
        $('.select-nonteq-filter').on('change', function (e) {
            $('#search-nonteq-form').submit();
        });

        $(".search-text").on('keyup change', function (e)  {
           
                $('#search-nonteq-form').submit();
            
        });

    });
    </script>