<script src="/js/plugins/chosen/chosen.jquery.js"></script>
<script src="/js/plugins/dataTables/datatables.min.js"></script>
<script src="/js/plugins/chosen/chosen.ajaxaddition.jquery.js"></script>
<link href="/css/plugins/dataTables/fixedHeader.dataTables.min.css" rel="stylesheet">

<script>

    $(document).ready(function () {

        $('.chosen-select').chosen({ width: "100%" }).change(function () {
            $(this).closest('.form-group').next().find('input').focus();
        });


        $.fn.serializeObject = function () {
            var obj = {};

            $.each(this.serializeArray(), function (i, o) {
                var n = o.name, v = o.value;

                obj[n] = obj[n] === undefined ? v
                    : $.isArray(obj[n]) ? obj[n].concat(v)
                        : [obj[n], v];
            });

            return obj;
        };


        let tableColumns = [
                { "data": "id" },
                { "data": "category" },
                { "data": "name" },
                { "data": "manufacturer" },
                { "data": "vendor" },
                { "data": "type" },
                { "data": "renewal_date" },
                { "data": "licenses" },
                { "data": "licenses_used" },
            ];
        
        @can('Software Assets Manage')
        tableColumns.push({ "data": "action" });
        @endcan

            var table = $('.footable').DataTable({

                responsive: true,
                scrollY: '400px',
            scrollCollapse: true,
                scrollX: true,
                fixedHeader: true,
                "processing": true,
                "serverSide": true,
                "ajax": {
                    "url": "{{ route('software-assets.data') }}",
                    "dataType": "json",
                    "type": "POST",
                    "data": function (result) {
                        result.form = $('#search-form').serializeObject();
                    }
                },
                "columns": tableColumns,
                lengthMenu: [
                    [50, 100, 200],
                    ['50', '100', '200']
                ],
                columnDefs: [
                    { orderable: false, targets: "_all" }
                ],
                "aaSorting": [],
                "dom": '<"top"i>rt<"bottom"flp><"clear">',
                "bAutoWidth": false,
                "bFilter": true,
                "bLengthChange": false,
                "searching": false,

            });

        $('.date-fields').datepicker({
            todayBtn: "linked",
            clearBtn: true,
            keyboardNavigation: false,
            forceParse: false,
            calendarWeeks: false,
            autoclose: true
        });

        $('#deleteLicenseModal').on('show.bs.modal', function (e) {
            var id = $(e.relatedTarget).data('id');
            $('#delete-license-id').val(id);
        });

        var delay = (function () {
            var timer = 0;
            return function (callback, ms) {
                clearTimeout(timer);
                timer = setTimeout(callback, ms);
            };
        })();

        $('#search-form').submit(function (e) {
            e.preventDefault();
            table.draw();
        });

        $(".searchText").on('keyup change', function () {
            delay(function () {
                $('#search-form').submit();
            }, 200);
        });

        $(".searchCount").on('keyup change', function () {
            delay(function () {
                $('#search-form').submit();
            }, 200);
        });

        $('.date-fields').on('change', function (e) {
            $('#search-form').submit();
        });

        $("#license_category, #license_manufacturer, #vendor_id, #type, #license_key_type, #key_usage_type, .licenses_used,#license_type, #status").on('change', function() {
            $('#search-form').submit();
        });

    });

</script>