<script src="/js/plugins/dataTables/datatables.min.js"></script>
<script src="/js/plugins/match-height/jquery.matchHeight.min.js"></script>
<link href="/css/plugins/dataTables/fixedHeader.dataTables.min.css" rel="stylesheet">
<script src="/js/plugins/chosen/chosen.jquery.js"></script>
<script src="/js/plugins/chosen/chosen.ajaxaddition.jquery.js"></script>
<script>

    $(document).ready(function () {
        $('.match-height-block').matchHeight({ property: 'height' });

        var documentTable = $('.license-documents-tbl').DataTable({
                       
			"scrollX": true,          
            "processing": true,
            "serverSide": true,
            "ajax": {
                "url": "{{ route('software-assets.documents') }}",
                "dataType": "json",
                "type": "POST",
                "data": function (result) {
                    result.form = {
                        'id': "{{ $license->id }}"
                    };
                }
            },
            "columns": [
                { "data": "id" },
                { "data": "file_name" },
                { "data": "date_added" },
                { "data": "action_download_only" }
            ],
            lengthMenu: [
                [50, 100, 200],
                ['50', '100', '200']
            ],
            columnDefs: [
                { orderable: false, targets: "_all" }
            ],
            "aaSorting": [],
            "dom": '<"top"i>rt<"bottom"flp><"clear">',
            "bAutoWidth": false,
            "bFilter": true,
            "bLengthChange": false,
            "searching": false
        });

        var keyTable = $('.license-keys-tbl').DataTable({
                       
			"scrollX": true,           
            "processing": true,
            "serverSide": true,
            "ajax": {
                "url": "{{ route('software-assets.keys') }}",
                "dataType": "json",
                "type": "POST",
                "data": function (result) {
                    result.form = {
                        'id': "{{ $license->id }}"
                    };
                }
            },
            "columns": [
                { "data": "id" },
                { "data": "license_key" },
                { "data": "key_usage_type" },
                { "data": "users_allowed_for_key" },
                { "data": "keys_used" },
                { "data": "keys_remaining" },
                { "data": "date_added" },
            ],
            lengthMenu: [
                [50, 100, 200],
                ['50', '100', '200']
            ],
            columnDefs: [
                { orderable: false, targets: "_all" }
            ],
            "aaSorting": [],
            "dom": '<"top"i>rt<"bottom"flp><"clear">',
            "bAutoWidth": false,
            "bFilter": true,
            "bLengthChange": false,
            "searching": false
        });
    })
</script>