<script src="/js/plugins/chosen/chosen.jquery.js"></script>
<script src="/js/plugins/dataTables/datatables.min.js"></script>
<script src="/js/plugins/chosen/chosen.ajaxaddition.jquery.js"></script>
<script src="/js/plugins/jquery-validation/jquery.validate.min.js"></script>
<script src="/js/sweetalert2.all.min.js"></script>
<script src="/js/plugins/tabledit/tabledit.js"></script>
<script src="/js/plugins/jquery-validation/additional-methods.min.js"></script>
<script src="/js/validator-methods.js"></script>
<link rel="stylesheet" href="/css/plugins/dataTables/responsive.dataTables.min.css">
<link href="/css/plugins/dataTables/fixedHeader.dataTables.min.css" rel="stylesheet">
<script src="/js/plugins/dataTables/dataTables.responsive.min.js"></script>
<style>
    #edit-license-form .col-lg-4 {
        height: 55px;
    }
</style>
<script>

    @if (Session:: has('license-user-popup-error'))
    $("#addUserModal").modal({ show: true });
    @endif

    $(document).ready(function () {
        $(".select2").select2();

        // set manufacture and type read only for imported software assets
        @if (in_array($license->name,config('software-license.imported_softwares')))
            $('#software_license_manufacturer_id').select2('destroy');
            $('#software_license_manufacturer_id').css('pointer-events', 'none');
            $('#type').select2('destroy');
            $('#type').css('pointer-events', 'none');
            $('#license_type').select2('destroy');
            $('#license_type').css('pointer-events', 'none');
        @endif
        
        $('.licence-form-dates').datepicker({
            todayBtn: "linked",
            clearBtn: true,
            keyboardNavigation: false,
            forceParse: false,
            calendarWeeks: false,
            autoclose: true
        });

        $("#start_date").datepicker("update", "{{ $license->start_date }}");
        $("#renewal_date").datepicker("update", "{{ $license->renewal_date }}");

        @if ($license->license_type == 'perpetual')
            $("#renewal_date_container").hide();
        $("#subscription_length").val("");
        $('#subscription_length').select2().trigger('change');
        $("#subscription_length_container").find(".select2-selection--single").css("background-color", "#eee");
        $("#subscription_length_container").css("pointer-events", "none");
        $("#auto_renewal").val("n/a");
        $("#auto_renewal").select2().trigger("change");
        $("#auto_renewal_container").find(".select2-selection--single").css("background-color", "#eee");
        $("#auto_renewal_container").css("pointer-events", "none");
        $("#subscription_expiration").attr("disabled", true).addClass('subscription-expiration-disabled');
        $(".sub-star").text("");
        @endif

        $("#license_type").on('change', function (e) {
            var licenseType = $(this).val();

            if (licenseType == 'perpetual') {
                $("#renewal_date_container").hide();
                $("#subscription_length").val("");
                $('#subscription_length').select2().trigger('change');
                $("#subscription_length_container").find(".select2-selection--single").css("background-color", "#eee");
                $("#subscription_length_container").css("pointer-events", "none");
                $("#auto_renewal").val("n/a");
                $("#auto_renewal").select2().trigger("change");
                $("#auto_renewal_container").find(".select2-selection--single").css("background-color", "#eee");
                $("#auto_renewal_container").css("pointer-events", "none");
                $("#subscription_expiration").attr("disabled", true).addClass('subscription-expiration-disabled');
                $(".sub-star").text("");
            } else {
                $("#renewal_date_container").show();
                $("#subscription_length").val("");
                $('#subscription_length').select2().trigger('change');
                $("#subscription_length_container").find(".select2-selection--single").css("background-color", "#fff");
                $("#subscription_length_container").css("pointer-events", "auto");
                $("#auto_renewal").val("yes");
                $("#auto_renewal").select2().trigger("change");
                $("#auto_renewal_container").find(".select2-selection--single").css("background-color", "#fff");
                $("#auto_renewal_container").css("pointer-events", "auto");
                $("#subscription_expiration").attr("disabled", false).removeClass('subscription-expiration-disabled');
                $(".sub-star").text("*");
            }

        });


        var usersTable = $('.license-users-tbl').DataTable({
                       
			"scrollX": true,
            "processing": true,
            "serverSide": true,
            "ajax": {
                "url": "{{ route('software-assets.users') }}",
                "dataType": "json",
                "type": "POST",
                "data": function (result) {
                    result.form = {
                        'id': "{{ $license->id }}"
                    };
                }
            },
            "columns": [
                { "data": "id" },
                { "data": "user" },
                { "data": "email" },
                { "data": "license_key" },
                { "data": "date_added" },
                { "data": "user_status" },
                { "data": "status" },
                { "data": "avg_meeting_length"},
                { "data": "action" }
                
            ],
            lengthMenu: [
                [50, 100, 200],
                ['50', '100', '200']
            ],
            columnDefs: [
                { orderable: false, targets: "_all" }
            ],
            "aaSorting": [],
            "dom": '<"top"i>rt<"bottom"flp><"clear">',
            "bAutoWidth": false,
            "bFilter": true,
            "bLengthChange": false,
            "searching": false
        });

        $('.assigned-user-ajax').each(function () {
            $(this).ajaxChosen({
                dataType: 'json',
            }, {
                processItems: function (data) { return data },
                generateUrl: function (q) { return '/get-filter-fields-assigned-user?search=' + q; },
            },
                {
                    width: "100%"
                }).change(function () {
                    $(this).closest('.form-group').next().find('input').focus();
                });
        });

        $('#deleteLicenseUserModal').on('show.bs.modal', function (e) {
            var id = $(e.relatedTarget).data('id');
            $('#remove-license-user-id').val(id);

        });


        $('#deleteLicenseDocumentModal').on('show.bs.modal', function (e) {
            var id = $(e.relatedTarget).data('id');
            $('#remove-license-document-id').val(id);

        });


        // $('#deleteLicenseDocumentModal').submit(function (e) {
        //     e.preventDefault();
        //     $("#delete-document-form").submit();
        // });



        $.validator.setDefaults({ ignore: ":hidden:not(select)" })

        $("#license-user-add").validate({
            onkeyup: false,
            excluded: ':disabled',
        });

        $("#license-user-add-submit").on('click', function (e) {
            e.preventDefault();
            $("#license-user-add").submit();
        });

        var documentTable = $('.license-documents-tbl').DataTable({
                       
			"scrollX": true,
            "processing": true,
            "serverSide": true,
            "ajax": {
                "url": "{{ route('software-assets.documents') }}",
                "dataType": "json",
                "type": "POST",
                "data": function (result) {
                    result.form = {
                        'id': "{{ $license->id }}"
                    };
                }
            },
            "columns": [
                { "data": "id" },
                { "data": "file_name" },
                { "data": "date_added" },
                { "data": "action" },
            ],
            lengthMenu: [
                [50, 100, 200],
                ['50', '100', '200']
            ],
            columnDefs: [
                { orderable: false, targets: "_all" }
            ],
            "aaSorting": [],
            "dom": '<"top"i>rt<"bottom"flp><"clear">',
            "bAutoWidth": false,
            "bFilter": true,
            "bLengthChange": false,
            "searching": false
        });

        $("#license-documents-add").validate({
            onkeyup: false,
            excluded: ':disabled',
            excluded: ':disabled',errorPlacement: function (error, element) {
                error.insertAfter($('.add-document-error'));
            },
        });

        $("#license-documents-add-submit").on('click', function (e) {
            e.preventDefault();
            $("#license-documents-add").submit();
        });

        $("#license_key_type").on('focus', function () {
            previous = $(this).val();
        }).change(function () {
            $(".license-key-add").hide();
            if ($(this).val() == 'single_license') {
                @if ($license->licenseKey -> count() > 1)
                    Swal.fire('Because more than one licence key has been added, the licence key type cannot be changed to Single / Concurrent License. ', '', 'warning');
                $(this).val(previous).trigger('change');
                @endif
                $("#license_key_usage_type").show();
                $("#key_usage_type").change();
                $("#license_key_single").show();
            }
            else if ($(this).val() == 'user_license') {
                $("#license_key_usage_type").show();
                $("#key_usage_type").change();
                $("#license_key_choice").show();
                $("#license_purchased").show();
            }
            else {
                @if ($license->licenseKey->count() > 0)
                    Swal.fire({
                        title: 'Changing to No License Key Required will remove existing license keys.',
                        icon: 'warning',
                        allowOutsideClick: false,
                        showDenyButton: true,
                        confirmButtonText: 'Remove',
                        denyButtonText: `Cancel`,
                    }).then((result) => {
                        if (result.isDenied) {
                            $(this).val(previous).trigger('change');
                        }
                    })
                @endif
            }
        })

        $("#key_usage_type").change(function () {
            $("#no_users_allowed").hide();
            if ($(this).val() == 'limited_usage') {
                $("#no_users_allowed").show();
            }
        })

        $('input[name=license-key-choice]').change(function () {
            $(".license-key-add-inputs").hide();
            var value = $(this).val();
            $("#" + value).show();
        });


        var keyTable = $('.license-keys-tbl').DataTable({
                       
			"scrollX": true,
            "processing": true,
            "serverSide": true,
            "ajax": {
                "url": "{{ route('software-assets.keys') }}",
                "dataType": "json",
                "type": "POST",
                "data": function (result) {
                    result.form = {
                        'id': "{{ $license->id }}"
                    };
                }
            },
            "columns": [
                { "data": "id" },
                { "data": "license_key" },
                { "data": "key_usage_type" },
                { "data": "users_allowed_for_key" },
                { "data": "keys_used" },
                { "data": "keys_remaining" },
                { "data": "date_added" },
                { "data": "action" },
            ],
            lengthMenu: [
                [50, 100, 200],
                ['50', '100', '200']
            ],
            columnDefs: [
                { orderable: false, targets: "_all" }
            ],
            "aaSorting": [],
            "dom": '<"top"i>rt<"bottom"flp><"clear">',
            "bAutoWidth": false,
            "bFilter": true,
            "bLengthChange": false,
            "searching": false
        });


        $("#edit-license-form").validate({
            onkeyup: false,
            // errorElement: "span",
            // errorClass: 'text-danger',
            ignore: ":hidden:not(select)",
            rules: {

                name: {
                    required: true
                },
                software_license_category_id: {
                    required: true
                },
                software_license_manufacturer_id: {
                    required: true
                },
                type: {
                    required: true
                },
                license_type: {
                    required: true
                },

                software_license_subscription_id: {
                    required: function (element) {
                        return $("select[name='license_type']").val() == 'subscription';
                    },
                },
               
                subscription_expiration: {
                    after_or_equal: start_date
                },               
                status: {
                    required: true
                },

                license_key_type: {
                    required: true

                },
                key_usage_type: {
                    required: function (element) {
                        return $("select[name='license_key_type']").val() != 'no_license';
                    },
                },
                licenses_purchased: {
                    required: function (element) {
                        return $("select[name='license_key_type']").val() == 'user_license';
                    },
                }
            },
            messages: {
                license_key: {
                    required: "Enter the license key",
                    keylength: "Please enter key of  6 to 20 characters in length"
                },
                license_keys: {
                    required: "Please enter the license keys line by line",
                    keylength: "Please enter keys of  6 to 20 characters in length"
                },
                software_liceneses_keys: {
                    required: "Please select a file to upload",
                    accept: "Please upload a csv file."
                },
                subscription_expiration: {
                    after_or_equal: "Subscription expiration date must be a date after or equal to start date."
                }
            },
            errorPlacement: function (error, element) {
                if (element.attr("type") == "file") {
                    error.insertAfter('#bulkLicenseError');
                }
                else if (element.attr("name") == "start_date") {
                    error.insertAfter('#startDateError');
                }
                else if (element.attr("name") == "subscription_expiration") {
                    error.insertAfter('#expiryDateError');
                }
                else {
                    error.appendTo($(element).next($('.errorText')));
                }
            },
        });




        // $('#deleteLicenseKeyModal').on('show.bs.modal', function (e) {
        //     var id = $(e.relatedTarget).data('id');
        //     $('#remove-license-key-id').val(id);

        // });


        // $('#deleteLicenseKeyModal').submit(function (e) {
        //     e.preventDefault();
        //     $("#delete-key-form").submit();
        // });



        $(document).on('click', '.delete-key-inline', function (e) {
            e.preventDefault();
            Swal.fire({
                title: 'Do you want to remove the key?',
                icon: 'warning',
                allowOutsideClick: false,
                showCancelButton: true,
                confirmButtonText: 'Remove',
            }).then((result) => {

                if (result.isConfirmed) {
                    $.ajax({
                        type: "POST",
                        data: { id: $(this).data('id') },
                        url: "{{ route('software-assets.key.remove') }}",
                        success: function (data) {
                            if (data >= 0) {
                                Swal.fire('Key removed successfully', '', 'success');
                                $("#licenses_purchased").attr({ "min": data });
                                $("#addKeyBtn").html('<a href="#" data-toggle="modal" data-target="#addKeyModal" class="btn btn-primary pull-right"><i class="icon icon-e-add"></i> Add / Edit Keys</a>');
                                keyTable.draw();
                                location.reload();
                            } else {
                                Swal.fire('Operation failed', '', 'warning');
                            }
                        }
                    });
                } else if (result.isDenied) {
                    Swal.fire('Some error occured', '', 'warning')
                }
            })
        })


        $("#license_key").on('keyup', function () {
            if (/^[a-zA-Z0-9_,\r\n -]+$/i.test($(this).val())) {
                $("#license_key-error").text('');
            } else {
                $("#license_key-error").text("Only letters, numbers, new line, underscores and hyphen are allowed");
            }
        });

        $(document).on('keyup', '#individualKey', function () {
            if (/^[a-zA-Z0-9_,\r\n -]+$/i.test($(this).val())) {
                $("#individualKey-error").text('');
            } else {
                $("#individualKey-error").text("Only letters, numbers, new line, underscores and hyphen are allowed");
            }
        });



        $("#license-keys-add-form").validate({

            onkeyup: false,
            excluded: ':disabled',
            rules: {
                software_license_id: {
                    required: true,
                },
                name: {
                    required: true

                },
                key_usage_type: {
                    required: true
                },
                license_key: {
                    required: function (element) {
                        return $("#license_key_typeM").val() == 'single_license';
                    },
                    lkey_alphanumeric: true,
                },
                license_keys: {
                    required: function (element) {
                        return $("input[name='license-key-choice']:checked").val() == 'license_key_text_area' && $("#license_key_typeM").val() == 'user_license';
                    },
                    lkey_alphanumeric: true,
                },
                software_liceneses_keys: {
                    required: function (element) {
                        return $("input[name='license-key-choice']:checked").val() == 'license_key_upload' && $("#license_key_typeM").val() == 'user_license';
                    },
                    accept: 'csv'
                }
            },
            messages: {
                license_key: {
                    required: "Enter the license key",
                    keylength: "Please enter key of  6 to 20 characters in length"
                },
                license_keys: {
                    required: "Please enter the license keys comma separated",
                    keylength: "Please enter keys of  6 to 20 characters in length"
                },
                software_liceneses_keys: {
                    required: "Please select a file to upload",
                    accept: "Please upload a csv file."
                },
            },
            errorPlacement: function (error, element) {
                if (element.is('select')) {
                    error.appendTo($('#error_message'));
                    $('.chosen-single.chosen-default').css('border', '1px dotted #cc5965');
                } else {
                    error.insertAfter(element);
                }
            },
        });

        $("#license-keys-add").on('click', function (e) {
            e.preventDefault();
            $("#license-keys-add-form").submit();
        });




        $(document).on('click', '.edit-key-inline', function () {
            $.ajax({
                type: "POST",
                url: "{{ route('software-assets.key.edit') }}",
                data: { id: $(this).data('id') },
                success: function (data) {
                    $('#editKeyModal').modal({
                        backdrop: 'static',
                        keyboard: false
                    });
                    $("#individualKeyEditModalBody").html(data);
                }
            });

        })



        $(document).on('click', '#update-key', function (e) {
            e.preventDefault();
            $("#license-keys-edit-form").validate({
                onkeyup: false,
                excluded: ':disabled',
                rules: {
                    license_key: {
                        required: true,
                        lkey_alphanumeric: true,
                    },
                    users_allowed_for_key: {
                        required: function (element) {
                            return $("#key_usage_typeM").val() == 'limited_usage';
                        },

                    },
                },
                messages: {
                    license_key: {
                        required: "Enter the license key",
                        keylength: "Please enter key of  6 to 20 characters in length"
                    },
                },
                errorPlacement: function (error, element) {
                    error.insertAfter(element);
                },
            });
            $("#license-keys-edit-form").submit();
        });






    })
</script>