<script src="/js/plugins/jquery-validation/jquery.validate.min.js"></script>
<script src="/js/validator-methods.js"></script>
<script src="/js/plugins/chosen/chosen.jquery.js"></script>
<script src="/js/plugins/chosen/chosen.ajaxaddition.jquery.js"></script>
<script src="/js/plugins/jquery-validation/additional-methods.min.js"></script>
<link href="/css/plugins/dataTables/fixedHeader.dataTables.min.css" rel="stylesheet">

<script>
    $(document).ready(function () {

        

        $('.footable').footable();

        $(".select2").select2();
        $('.assigned-user-ajax').each(function () {
            $(this).ajaxChosen({
                dataType: 'json',
            }, {
                processItems: function (data) { return data },
                generateUrl: function (q) { return '/get-filter-fields-assigned-user?search=' + q; },
            },
                {
                    width: "100%"
                }).change(function () {
                    $(this).closest('.form-group').next().find('input').focus();
                });
        });

        $('.licence-form-dates').datepicker({
            todayBtn: "linked",
            clearBtn: true,
            keyboardNavigation: false,
            forceParse: false,
            calendarWeeks: false,
            autoclose: true
        });

        $("#start_date").datepicker("update", "{{ old('start_date') }}");

        if ($("#license_type").val() == 'perpetual') {
            $("#subscription_length").val("");
            $("#subscription_length").select2().trigger("change");
            $("#auto_renewal").val("n/a");
            $("#auto_renewal").select2().trigger("change");
            $("#auto_renewal_container").find(".select2-selection--single").css("background-color", "#eee !important");
            $("#auto_renewal_container").css("pointer-events", "none");
            $("#subscription_length_container").find(".select2-selection--single").css("background-color", "#eee !important");
            $("#subscription_length_container").css("pointer-events", "none");
            $("#subscription_expiration").attr("disabled", true).addClass('subscription-expiration-disabled');
            $(".sub-star").text("");
        }

        $("#license_type").on('change', function (e) {
            var licenseType = $(this).val();
            if (licenseType == 'perpetual') {
                $("#subscription_length").val("");
                $("#subscription_length").select2().trigger("change");
                $("#auto_renewal").val("n/a");
                $("#auto_renewal").select2().trigger("change");
                $("#auto_renewal_container").find(".select2-selection--single").css("background-color", "#eee");
                $("#auto_renewal_container").css("pointer-events", "none");
                $("#subscription_length_container").find(".select2-selection--single").css("background-color", "#eee");
                $("#subscription_length_container").css("pointer-events", "none");
                $("#subscription_expiration").attr("disabled", true).addClass('subscription-expiration-disabled');
                $(".sub-star").text("");
            } else {
                $("#subscription_length").val("");
                $("#subscription_length").select2().trigger("change");
                $("#auto_renewal").val("yes");
                $("#auto_renewal").select2().trigger("change");
                $("#auto_renewal_container").find(".select2-selection--single").css("background-color", "#fff");
                $("#auto_renewal_container").css("pointer-events", "auto");
                $("#subscription_length_container").find(".select2-selection--single").css("background-color", "#fff");
                $("#subscription_length_container").css("pointer-events", "auto");
                $("#subscription_expiration").attr("disabled", false).removeClass('subscription-expiration-disabled');
                $(".sub-star").text("*");
            }

        });


        // Bulk asset upload
        $("#bulk-upload-software-asset-form").validate({
            rules: {
                bulk_upload_software_asset: {
                    extension: "csv",
                    required: true,
                }
            },
            messages: {
                bulk_upload_software_asset: {
                    extension: "Please upload a csv file"
                }
            }, errorPlacement: function (error, element) {
                if (element.attr("type") == "file") {
                    error.insertAfter('#bulkUploadSoftwareAssetValidator');
                }
                else {
                    error.insertAfter($(element).next($('.errorText')));
                }
            },
        });

        $('#bulk-upload-software-asset-form').submit(function (e) {
            e.preventDefault();

            if ($('#bulk-upload-software-asset-form').valid()) {
                $('.ajax-loader').show();
                $('.alert-danger').hide();
                setTimeout(function () {
                    var formData = new FormData();
                    formData.append('file', $('#bulk_upload_software_asset')[0].files[0]);
                    $.ajax({
                        type: "POST",
                        url: $('#bulk-upload-software-asset-form').attr('action'),
                        data: formData,
                        async: false,
                        success: function (value) {
                            var count = 0;
                            if ($('#tblview tbody tr').length !== 0) {
                                count = $('#tblview tbody tr').length;
                            }
                            count = parseInt(count) + parseInt(value.countVal)

                            if (count > 0) {
                                $("#createSoftwareAssetBtn").prop('disabled', false);
                            } else {
                                $("#createSoftwareAssetBtn").prop('disabled', true);
                            }
                            $('tbody').append(value.data);

                            $('#bulk-upload-software-asset-form').append(value.errors);
                            $('#software-asset-count').text(count);
                            $('#bulk-upload-software-asset-form')[0].reset();
                            $('.ajax-loader').hide();
                        },
                        cache: false,
                        contentType: false,
                        processData: false
                    });
                }, 50);
            }
        });

        $("#license_key_type").change(function () {
            $(".license-key-add").hide();
            if ($(this).val() == 'single_license') {
                $("#license_key_usage_type").show();
                $("#key_usage_type").change();
                $("#license_key_single").show();
            }
            else if ($(this).val() == 'user_license') {
                $("#license_key_usage_type").show();
                $("#key_usage_type").change();
                $("#license_key_choice").show();
                $("#license_purchased").show();

            }
        })

        $("#key_usage_type").change(function () {
            $("#no_users_allowed").hide();
            if ($(this).val() == 'limited_usage') {
                $("#no_users_allowed").show();
            }
        })

        $('input[name=license-key-choice]').change(function () {
            $(".license-key-add-inputs").hide();
            var value = $(this).val();
            $("#" + value).show();
        });

        $("#create-software-asset-form").validate({
            onkeyup: false,
            // errorElement: "span",
            // errorClass: 'text-danger',
            ignore: ":hidden:not(select)",
            rules: {

                name: {
                    required: true
                },
                software_license_category_id: {
                    required: true
                },
                software_license_manufacturer_id: {
                    required: true
                },
                type: {
                    required: true
                },
                license_type: {
                    required: true
                },
                users_allowed_for_key: {
                    required: function (element) {
                        return $("select[name='license_key_type']").val() != 'no_license' && $("select[name='key_usage_type']").val() == 'limited_usage';
                    },
                },
                'license-key-choice': {
                    required: function (element) {
                        return $("select[name='license_key_type']").val() == 'user_license';
                    },
                },
                start_date: {
                    required: true
                },
                payment_method_id: {
                    required: true
                },
                billing_cycle: {
                    required: true
                },
                status: {
                    required: true
                },

                license_key_type: {
                    required: true

                },
                subscription_expiration: {
                    after_or_equal: start_date
                },
                key_usage_type: {
                    required: function (element) {
                        return $("select[name='license_key_type']").val() != 'no_license';
                    },
                },
                licenses_purchased: {
                    required: function (element) {
                        return $("select[name='license_key_type']").val() == 'user_license';
                    },
                },
                license_key: {
                    required: function (element) {
                        return $("select[name='license_key_type']").val() == 'single_license';
                    },
                    lkey_alphanumeric: true,
                },
                license_keys: {
                    required: function (element) {
                        return $("input[name='license-key-choice']:checked").val() == 'license_key_text_area' && $("#license_key_type").val() == 'user_license';
                    },
                    lkey_alphanumeric: true,
                },
                software_liceneses_keys: {
                    required: function (element) {
                        return $("input[name='license-key-choice']:checked").val() == 'license_key_upload' && $("#license_key_type").val() == 'user_license';
                    },
                    accept: 'csv'
                },
                software_license_subscription_id: {
                    required: function (element) {
                        return $("select[name='license_type']").val() == 'subscription';
                    },
                }
            },
            messages: {
                license_key: {
                    keylength: "Please enter key of  6 to 20 characters in length"
                },
                license_keys: {
                    required: "Please enter the license keys comma separated",
                    keylength: "Please enter keys of  6 to 20 characters in length"
                },
                software_liceneses_keys: {
                    required: "Please select a file to upload",
                    accept: "Please upload a csv file."
                },
                subscription_expiration: {
                    after_or_equal: "Subscription expiration date must be a date after or equal to start date."
                },
            },
            errorPlacement: function (error, element) {
                if (element.attr("type") == "file") {
                    error.insertAfter('#bulkLicenseError');
                }
                else if (element.attr("type") == "radio") {
                    error.insertAfter('#uploadLicenseViaError');
                }
                else if (element.attr("name") == "start_date") {
                    error.insertAfter('#startDateError');
                }
                else if (element.attr("name") == "subscription_expiration") {
                    error.insertAfter('#expiryDateError');
                }
                else {
                    error.appendTo($(element).next($('.errorText')));
                }
            },
        });




    })

    function deleteBulkUploadedRow(id) {
        $('#' + id).remove();

        count = $('#tblview tbody tr').length;
        count = parseInt(count)
        $('#software-asset-count').text(count);
    }
</script>