<script src="/js/plugins/tabledit/tabledit.js"></script>
<script src="/js/plugins/jquery-validation/jquery.validate.min.js"></script>
<script src="/js/plugins/dataTables/datatables.min.js"></script>
<link href="/css/plugins/dataTables/fixedHeader.dataTables.min.css" rel="stylesheet">
<script src="/js/plugins/dataTables/dataTables.fixedHeader.min.js"></script>

<script>

    @if ($errors -> count() > 0)
        $("#addLicenseCategory").modal({ show: true });
    @endif

    $(document).ready(function () {

        $('.modal').on('show.bs.modal', function (e) {
            $(".alert-danger").hide();
        });

        $('.footable').DataTable({
            scrollCollapse: false,
            lengthMenu: [
                [50, 100, 200],
                ['50', '100', '200']
            ],
            fixedHeader: {
                header: true,
            },
            columnDefs: [
                { orderable: true, targets: "_all" }
            ],
            "bFilter": false,
            "bLengthChange": false,
            "bInfo": false,
            "order": [],
        })

        var delay = (function () {
            var timer = 0;
            return function (callback, ms) {
                clearTimeout(timer);
                timer = setTimeout(callback, ms);
            };
        })();

        $("#searchText").on('keyup change', function () {
            delay(function () {
                $('#search-form').submit();
            }, 200);
        });

        $('#submit').click(function () {
            $('#license-category-form').submit();
        });


        $('#search-form').submit(function (e) {
            e.preventDefault();
            $('.ajax-loader').show();
            var formData = $(this).serializeArray();

            $.ajax({
                type: "POST",
                url: "/software-assets-category-search",
                data: formData,
                success: function (value) {
                    $('.ajax-loader').hide();
                    $('#license-category-table tbody').remove();
                    $('#license-category-table tfoot').remove();
                    $('#license-category-table').append(value.categories);
                    $('#license-category-table').Tabledit({
                        url: '/software-assets-category-ajax',
                        columns: {
                            identifier: [0, 'category_id'],
                            editable: [[2, 'name']]
                        },
                        onDraw: function (data) { },
                        onSuccess: function (data) { },
                        restoreButton: false
                    });
                    $('.footable').data('page-size', 50);
                    $('.footable').trigger('footable_initialized');

                },
                error: function (value) {

                }
            }).done(function () {
                $('.ajax-loader').hide();
            });

        });


        @can('Software Assets Category Manage')
        @if($categories->count() > 0)
        $('#license-category-table').Tabledit({
            url: '/software-assets-category-ajax',
            columns: {
                identifier: [0, 'category_id'],
                editable: [[2, 'name']]
            },
            warningClass: 'success',
            mutedClass: 'danger',

            onSuccess: function (data) {
                $('.alert').hide();
                if (data['status'] == 'error') {
                    $('#error').show();
                    $('#error p').text(data['message']);
                    $('html, body').animate({
                        scrollTop: $("#error").offset().top
                    }, 1000);
                }

                if (data['status'] == 'success') {
                    $('#success').show();
                    $('#success p').text(data['message']);
                    $('html, body').animate({
                        scrollTop: $("#success").offset().top
                    }, 1000);
                }
                $('#license-category-table').trigger('footable_redraw');
            },
            onFail: function (xhr, ajaxOptions, thrownError) {
                    $('.alert').hide();
                    var errors = JSON.parse(xhr.responseText);
                    $('#error').show();
                    $('#error p').text(errors.errors.name);
                    $('html, body').animate({
                        scrollTop: $("#error").offset().top
                    }, 1000);
                },
            restoreButton: false
        });
        @endif
        @endcan

    });

</script>
<style>
    .empty-tr .tabledit-toolbar.btn-toolbar {
        display: none;
    }
</style>