@forelse($csvData as $csvData)
<tr id="added-count-{{$csvData['assetData']['count_add']}}">
	<td>
		@if($csvData['assetData']['software_license_category_id'])
		{{\App\Models\SoftwareLicense\SoftwareLicenseCategory::find($csvData['assetData']['software_license_category_id'])->name}}
		@endif
	</td>
	<td>
		@if($csvData['assetData']['software_license_category_id'])
		{{\App\Models\SoftwareLicense\SoftwareLicenseManufacturer::find($csvData['assetData']['software_license_manufacturer_id'])->name}}
		@endif
	</td>
	<td>
		@if($csvData['assetData']['vendor_id'])
		{{\App\Models\Vendor::find($csvData['assetData']['vendor_id'])->name}}
		@endif
	</td>
	<td>{{ $csvData['assetData']['name'] }}</td>
	<td>{{ $csvData['assetData']['po_number'] }}</td>
	<td>{{ $csvData['assetData']['order_number'] }}</td>
	<td>{{ config('software-license.types.'.$csvData['assetData']['type']) }}</td>
	<td>{{ $csvData['assetData']['license_type'] }}</td>
	<td>
		@if($csvData['assetData']['license_type'] == "Subscription")
		@if($csvData['assetData']['software_license_subscription_id'])
		{{\App\Models\SoftwareLicense\SoftwareLicenseSubscription::find($csvData['assetData']['software_license_subscription_id'])->name}}
		@endif
		@endif
	</td>
	<td>
		@if($csvData['assetData']['license_type'] == "Subscription")
		{{ $csvData['assetData']['subscription_expiration'] }}
		@endif
	</td>
	<td>{{ $csvData['assetData']['license_type'] == "Perpetual" ? "N/A" :
		config('software-license.auto_renewal')[$csvData['assetData']['auto_renewal']] ?? '' }}</td>
	<td>{{ config('software-license.license_key_types.'.$csvData['assetData']['license_key_type']) }}</td>
	<td>@if($csvData['assetData']['license_key_type'] != "no_license")
		{{ config('software-license.key_usage_types.'.$csvData['assetData']['key_usage_type']) }}
		@endif
	</td>
	<td>
		@if($csvData['assetData']['license_key_type'] != "no_license")
		{{ $csvData['assetData']['license_key'] }}
		@endif
	</td>
	<td>
		@if($csvData['assetData']['license_key_type'] != "no_license" && $csvData['assetData']['key_usage_type'] ==
		"limited_usage")
		{{ $csvData['assetData']['users_allowed_for_key'] }}
		@endif
	</td>
	<td>{{ $csvData['assetData']['start_date'] }}</td>
	<td>{{ $csvData['assetData']['billing_cycle'] }}</td>
	<td>{{ $csvData['assetData']['cost'] }}</td>
	<td>
		@if($csvData['assetData']['payment_method_id'])
		{{\App\Models\SoftwareLicense\PaymentMethod::find($csvData['assetData']['payment_method_id'])->name}}
		@endif
	</td>
	<td>
		@if($csvData['assetData']['license_key_type'] == "user_license")
		{{ $csvData['assetData']['licenses_purchased'] }}
		@endif
	</td>
	<td>{{ $csvData['assetData']['notes'] }}</td>
	<td>{{ $csvData['assetData']['status'] }}</td>


	<td onclick="deleteBulkUploadedRow('added-count-{{$csvData['assetData']['count_add']}}')"><i
			class="icon icon-delete-forever"></i></td>

	<input type="hidden" name="software_assets_data[]" value="{{ json_encode($csvData) }}">
</tr>
@empty
@endforelse