	<div class="ibox">
		<div class="ibox-title">
			<div class="ibox-tools">
				<h5>Filters</h5>
				<a data-toggle="collapse" href="#collapseFilter" class="collapse-link"> <i class="icon icon-e-delete"></i></a>
			</div>
			
		</div>
		<div class="collapse in" id="collapseFilter">
			<div class="ibox-content">
				<form method="post" id="search-form" action="">
					{{ csrf_field() }}
					<div class="row">
						
						<div class="col-md-3">
							<div class="form-group">
								<label class="control-label">Category</label>
								<select class="chosen-select" id="license_category" multiple name="software_license_category_id" data-placeholder="Select">
									@foreach(\App\Models\SoftwareLicense\SoftwareLicenseCategory::orderBy('name','ASC')->get() as $category)
									<option value="{{$category->id}}">{{$category->name}}</option>
									@endforeach
								</select>
							</div>	
						</div>
						
						<div class="col-md-3">
							<div class="form-group">
								<label class="control-label">Name</label>
								<input type="text" class="form-control searchText" name="name" placeholder="Search by Name" autocomplete="off">
							</div>	
						</div>
						
						<div class="col-md-3">
							<div class="form-group">
								<label class="control-label">Manufacturer</label>
								<select class="chosen-select" id="license_manufacturer" multiple name="software_license_manufacturer_id" data-placeholder="Select">
									@foreach(\App\Models\SoftwareLicense\SoftwareLicenseManufacturer::orderBy('name','ASC')->get() as $vendor)
									<option value="{{$vendor->id}}">{{$vendor->name}}</option>
									@endforeach
								</select>
							</div>	
						</div>
						
						<div class="col-md-3">
							<div class="form-group">
								<label class="control-label">Vendor</label>
								<select class="chosen-select" id="vendor_id" multiple name="vendor_id" data-placeholder="Select">
									<option value="">Select</option>
									@foreach(\App\Models\Vendor::orderBy('name','ASC')->get() as $vendor)
									<option value="{{$vendor->id}}">{{$vendor->name}}</option>
									@endforeach
								</select>
							</div>	
						</div>
						
					</div>
					<div class="row">
						
						<div class="col-md-3">
							<div class="form-group">
								<label class="control-label">Order #</label>
								<input type="text" class="form-control searchText" name="order_number" placeholder="Search by Order #" autocomplete="off">
							</div>	
						</div>
						
						<div class="col-lg-3">
							<div class="form-group">
								<label class="control-label">Type</label>
								<select name="type" id="type" class="form-control chosen-select" data-placeholder="Select">
									<option value="">Select</option>
									@foreach (config('software-license.types') as $key => $value)
									<option value="{{ $key }}" @if(old('type') == $key) selected @endif>{{ $value }}</option>
									@endforeach
								</select>
							</div>
						</div>
						
						<div class="col-lg-3">
							<div class="form-group">
								<label class="control-label">License Key (type)</label>
								<select name="license_key_type" id="license_key_type" class="form-control chosen-select" data-placeholder="Select">
									<option value="">Select</option>
									@foreach (config('software-license.license_key_types') as $key => $value)
									<option value="{{ $key }}" @if(old('license_key_type') == $key) selected @endif>{{ $value }}</option>
									@endforeach
								</select>
							</div>
						</div>
						
						<div class="col-lg-3 " >
							<div class="form-group">
								<label class="control-label">Key Usage Type</label>
								<select name="key_usage_type" id="key_usage_type" class="form-control chosen-select" data-placeholder="Select">
									<option value="">Select</option>
									@foreach (config('software-license.key_usage_types') as $key => $value)
									<option value="{{ $key }}" @if(old('key_usage_type') == $key) selected @endif>{{ $value }}</option>
									@endforeach
								</select>
							</div>
						</div>
					</div>
					<div class="row">
						
						<div class="col-md-3">
							<div class="form-group">
								<label class="control-label">Licenses Purchased</label>
								<input type="number" min=0 oninput="validity.valid||(value='');" class="form-control searchText" name="licenses_purchased"  placeholder="Search by Licenses Purchased" autocomplete="off">
							</div>	
						</div>
						
						<div class="col-md-3">
							<div class="form-group">
								<label class="control-label">Licenses Used</label>
								<input type="number" min=0 oninput="validity.valid||(value='');" class="form-control searchText" name="licenses_used"  placeholder="Search by Licenses Used" autocomplete="off">
							</div>	
						</div>
						
						<div class="col-md-3">
							<div class="form-group">
								<label class="control-label">License Type</label>
								
								<select name="license_type" id="license_type" class="form-control chosen-select">
									<option value="">--Select--</option>
									@foreach (config('software-license.license_types') as $key => $value)
									<option value="{{ $key }}">{{ $value }}</option>
									@endforeach
								</select>
							</div>
						</div>
						
						<div class="col-md-3">
							<div class="form-group">
								<label class="control-label">Status</label>
								
								<select name="status" id="status" class="form-control chosen-select">
									<option>--Select--</option>
									<option value="1" selected>Active</option>
									<option value="0">Inactive</option>									
								</select>
							</div>
						</div>
						
						<div class="col-sm-3">
							<div class="form-group">
								<label class="control-label">Renewal Date Range</label>
								<div  id="data_1" style="margin-bottom:10px">
									<div class="input-group date">
										<span class="input-group-addon"><i class="icon icon-calendar-2"></i></span><input
										type="text" name="renewal_date_from" class="form-control date-fields licence-form-dates" readonly data-mask="99/99/9999"
										id="renewal_date_from" placeholder="From" autocomplete="off">
									</div>
								</div>
								
								<div  id="data_1">
									<div class="input-group date">
										<span class="input-group-addon"><i class="icon icon-calendar-2"></i></span><input
										type="text" class="form-control date-fields licence-form-dates" data-mask="99/99/9999" readonly placeholder="To"
										name="renewal_date_to" id="renewal_date_to" autocomplete="off">
									</div>
								</div>
							</div>
						</div>
					</div>
					
				</div>
			</form>
		</div>
	</div>
