<div class="modal inmodal" id="addKeyModal" tabindex="-1" role="dialog">

    <div class="modal-dialog">

        <div class="modal-content animated fadeIn">

            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal" aria-label="Close" style="margin-top: 8px;">
                    <span>×</span>
                </button>
                <h4 class="modal-title">Add new license keys</h4>
            </div>
            <div class="modal-body">

                <form class="form-horizontal" enctype="multipart/form-data" method="POST" action="{{route('software-assets.key.add')}}" id="license-keys-add-form">
                    {{csrf_field()}}
                    <input type="hidden" name="software_license_id" value="{{ $license->id }}">
                    <input type="hidden" name="name" value="{{ $license->name }}" required>
                    <input type="hidden" name="license_key_type" id="license_key_typeM" value="{{ $license->license_key_type }}">
                    <input type="hidden" name="key_usage_type" id="key_usage_type" value="{{ $license->key_usage_type }}">
                    <input type="hidden" name="users_allowed_for_key" value="{{ !empty($license->licenseKey->pluck('users_allowed_for_key')->toArray())?$license->licenseKey->pluck('users_allowed_for_key')->toArray()[0]:'' }}">

                    @if($license->license_key_type == 'single_license')
                    <div class="row" >
                        <div class="col-lg-12 form-group" id="license_key_single" <?= ($errors->has('license_key') || old('license_key_type',$license->license_key_type)=='single_license')?'style="display:block"':'' ?>>
                            <label class="control-label">License Key</label>
                            <input type="text" class="form-control" id="license_key" name="license_key"
                                value="{{old('license_key',!empty($license->licenseKey->pluck('license_key')->toArray())?$license->licenseKey->pluck('license_key')->toArray()[0]:'')}}">
                            <span class="text-danger errorText">{{ $errors->first('license_key') }}</span>  
                        </div>
                        @if($license->key_usage_type == 'limited_usage')

                        <div class="col-lg-12 form-group" id="">
                            <label class="control-label"># of Users Allowed</label>
                            <input type="number" class="form-control" id="usersAllowedForKey" name="users_allowed_for_key"
                                value="" required min=1 oninput="validity.valid||(value='');">
                            <span class="text-danger errorText"></span>
                        </div>
                        @endif
                    </div>
                    
                    @endif


                    @if($license->license_key_type == 'user_license')
                    <div class="row" >
                        <div class="col-sm-12 form-group" license-key-add" id="license_key_choice">
                            <label class="control-label">Upload Licenses via:</label>
                            
                            <div >
                                <div class="form-check-inline">
                                    <label class="form-check-label">
                                    <input type="radio" class="form-check-input" name="license-key-choice" value="license_key_text_area" checked>Enter as text
                                    </label>
                                </div>
                                <div class="form-check-inline">
                                    <label class="form-check-label">
                                    <input type="radio" class="form-check-input" name="license-key-choice" value="license_key_upload" >Upload
                                    </label>
                                </div>
                            </div>
                            <span class="text-danger errorText">{{ $errors->first('license-key-choice') }}</span>
                        </div>
                    

                    
                        <div class="form-group upload-file-text-wrap col-lg-12 license-key-addt license-key-add-inputs"  id="license_key_upload" style="display:none;">
                            <label class="control-label">License Keys Upload</label>
                            
                            <div class="fileinput fileinput-new input-group" data-provides="fileinput">
                                <div class="form-control" data-trigger="fileinput">
                                    <i class="glyphicon glyphicon-file fileinput-exists"></i>
                                    <span class="fileinput-filename"></span>
                                </div>
                                <span class="input-group-addon btn btn-primary btn-file">
                                    <span class="fileinput-new">Select file</span>
                                    <span class="fileinput-exists">Change</span>
                                    <input type="file" name="software_liceneses_keys"
                                            id="software_liceneses_keys" required>
                                </span>
                                <a href="#" class="input-group-addon btn btn-primary fileinput-exists"
                                    data-dismiss="fileinput">Remove</a>
                            </div>

                            <span class="text-danger errorText">{{ $errors->first('software_liceneses_keys') }}</span>
                            <a href="/template/software-license-keys-template.csv" class="pull-right">Download Template File</a>
                            
                        </div>

                        @if($license->key_usage_type == 'limited_usage')

                        <div class="col-lg-12 form-group" id="">
                            <label class="control-label"># of Users Allowed</label>
                            <input type="number" class="form-control" id="usersAllowedForKey" name="users_allowed_for_key"
                                value="" required min=1 oninput="validity.valid||(value='');">
                            <span class="text-danger errorText"></span>
                        </div>
                        @endif
                    
                        <div class="col-lg-12 form-group license-key-addx license-key-add-inputs" id="license_key_text_area" >
                            
                            <label class="control-label">License Keys</label>
                            
                            <textarea class="form-control" name="license_keys" id="license_key" required>{{old('license_keys')}}</textarea><br>
                            <span class="text-danger errorText">{{ $errors->first('license_key_text_area') }}</span>
                                
                        </div>
                    </div>
                    @endif
                    <div class="modal-footer">

                        <button type="button" class="btn btn-link" data-dismiss="modal">Cancel</button>

                        <button type="button" class="btn btn-primary" id="license-keys-add">Save</button>

                    </div>

                </form>

            </div>

        </div>

    </div>

</div>


<div class="modal fade" id="editKeyModal" tabindex="-1" role="dialog" aria-labelledby="reserveModalLabel"
       >
    <div class="modal-dialog modal-dialog-centered" role="document">
        <div class="modal-content">
            <div class="modal-body" id="individualKeyEditModalBody">
                
            </div>
        </div>
    </div>
</div>