@extends('layouts.main')
@section('content')
@include('partials.breadcrumb', ['breadcrumbTitle' => 'Software Assets Manufacturers','parentTitle'=>'Settings','parentUrl'=>'/settings'])
<div class="wrapper-content">
    <div class="container-fluid">
        
        <div class="ibox">
            
            <div class="ibox-content">
                @include('settings.partials.success-message')
                @include('settings.partials.delete-message')
                @can('Software Assets Manufacturer Manage')
                <p><a href="#" class="btn btn-primary" data-toggle="modal"
                    data-target="#addLicenseManufacturer">Add New</a></p>
                    @endcan
                    
                    @include('software-license.partials.manufacturer-filters')
                    
                    <table class="footable table table-stripped table-hover" data-page-size="50" data-filter=#filter
                    id="license-manufacturer-table">
                    
                    <thead>
                        
                        <tr>
                            <th style="display: none;"></th>
                            <th>#</th>
                            <th>Name</th>
                            
                        </tr>
                        
                    </thead>
                    
                    @include('software-license.manufacturer.list')
                    
                </table>
                
            </div>
            
        </div>
        
    </div>
    
</div>


@stop

@section('help-links')
@include('help.help-links',['helpLink'=>config('help-links.help_links.software_asset_settings_manufacturers'),'helpTitle'=>config('help-links.help_titles.software_asset_settings_manufacturers')])
@endsection


@section('after_scripts')
@include('software-license.modals.add-manufacturer')
@include('software-license.scripts.manufacturer')
@stop