@extends('layouts.main')
@section('content')
@include('partials.breadcrumb', ['breadcrumbTitle' => 'Asset Detail', 'parentUrl' => '/software-assets', 'parentTitle'
=> 'Software Assets'])
<div class="wrapper-content">
	<div class="container-fluid">

    <div class="row">

        <div class="col-lg-4">

            <div class="ibox">

                <div class="ibox-content match-height-block">

                    <dl class="dl-horizontal license-view-dl">

                        <dt>Status</dt>
                        <dd>{{ $license->status == 1 ? 'Active' : 'Inactive' }}</dd>

                        <dt>Category</dt>
                        <dd>{{ $license->category ? $license->category->name : '' }}</dd>

                        <dt>Manufacturer</dt>
                        <dd>{{ $license->softwareLicenseManufacturer ? $license->softwareLicenseManufacturer->name : '' }}</dd>

                        <dt>Vendor</dt>
                        <dd>{{ optional($license->vendor)->name }}</dd>

                        <dt>Product Name</dt>
                        <dd>{{ $license->name }}</dd>

                        <dt>Owner</dt>
                        <dd><a href="/users/{{ optional($license->owner)->id }}" target="_blank">{{ optional($license->owner)->first_name ? optional($license->owner)->user_name : optional($license->owner)->email }}</a></dd>


                        <dt>PO #</dt>
                        <dd>{{ $license->po_number }}</dd>

                        <dt>Order #</dt>
                        <dd>{{ $license->order_number }}</dd>

                        <dt>Notes</dt>
                        <dd>{{ $license->notes }}</dd>
                    </dl>
                </div>
            </div>

        </div>

        <div class="col-lg-4">

            <div class="ibox">

                <div class="ibox-content match-height-block">

                    <dl class="dl-horizontal license-view-dl">

                        <dt>Type</dt>
                        <dd>{{ $license->type?config('software-license.types.'.$license->type):''; }}</dd>

                        <dt>License Type</dt>
                        <dd>{{ $license->license_type ? (isset(config('software-license.license_types')[$license->license_type])?config('software-license.license_types')[$license->license_type]:'') : '' }}</dd>

                        @if ($license->license_type == 'subscription')
                        <dt>Subscription Length</dt>
                        <dd>{{ optional($license->subscriptionLength)->name }}</dd>
                        @endif

                        <dt>Auto Renewal</dt>
                        <dd>{{ $license->auto_renewal }}</dd>

                        <dt>License Key Type</dt>
                        <dd>{{  $license->license_key_type?config('software-license.license_key_types.'.$license->license_key_type):'' }}</dd>

                        @if ($license->license_key_type != 'no_license')
                        <dt>Key Usage Type</dt>
                        <dd>{{ $license->key_usage_type?config('software-license.key_usage_types.'.$license->key_usage_type):'' }}</dd>
                        @endif

                        <dt>Contract Start Date</dt>
                        <dd>{{ $license->start_date }}</dd>
                        @if ($license->license_type != 'perpetual' && !empty($license->software_license_subscription_id))
                            <dt>Renewal Date</dt>
                            <dd>{{ $license->renewal_date }}</dd>
                        @endif
                    </dl>

                </div>

            </div>

        </div>

        <div class="col-lg-4">

            <div class="ibox">

                <div class="ibox-content match-height-block">

                    <dl class="dl-horizontal license-view-dl">

                        <dt>Billing Cycle</dt>
                        <dd>{{ $license->billing_cycle ? config('software-license.billing_cycles')[$license->billing_cycle] : '' }}</dd>

                        <dt>Cost</dt>
                        <dd>{{ $license->cost }}</dd>

                        <dt>Payment Method</dt>
                        <dd>{{ $license->paymentmethod ? $license->paymentmethod->name : '' }}</dd>

                        @if($license->license_key_type == 'user_license')

                        <dt>Licenses Purchased</dt>
                        <dd>{{ $license->licenses_purchased }}</dd>

                        <dt>Licenses Used</dt>
                        <dd>{{ $license->licenses_used }}</dd>

                        @if(in_array($license->name,config('software-license.imported_softwares')))
                        <dt>Unused Licenses</dt>
                        <dd>{{ $license->licenses_purchased - $license->licenses_used }}</dd>
                        @endif

                        @endif

                    </dl>
                </div>
            </div>
        </div>

    </div>


    <div class="ibox">
        @include('software-license.license.license-used', ['action' => 'view'])
    </div>

    @if(in_array($license->name,config('software-license.imported_softwares')) && $nonTeqtivityUserCount > 0)

    <div class="ibox">
        @include('software-license.license.license-used-by-non-teqtivity-users', ['action' => 'view'])
    </div>
    @endif

            <div class="ibox">
                <div class="ibox-content">
                    @include('software-license.license.documents', ['action' => 'view'])
                </div>
            </div>


    @if($license->license_key_type !='no_license' && !in_array($license->name,config('software-license.imported_softwares')))
		<div class="row">
			<div class="col-lg-12">
				<div class="ibox">
					<div class="ibox-content">
            			@include('software-license.license.keys', ['action' => 'view','license_key_type' => $license->license_key_type,'licenseKeys'=>$license->licenseKey->count()])
					</div>
				</div>
			</div>
        </div>
	@endif
    @if (array_sum(array_column($graphData, 'user_count')) > 0)
    <div class="row">
        @include('software-license.license.user-month-graph')
    </div>
    @endif
    <div class="row">

        <div class="col-lg-12">

            <div class="ibox">

                <div class="ibox-title">

                    <h5>License History (<span id="asset_count">{{ is_countable($license->history) ?
                        count($license->history) : 0}}</span>) </h5>

                </div>

                @include('software-license.license.license-history')


            </div>
        </div>
    </div>

	</div>
</div>

@include('software-license.modals.add-license-user')
@include('software-license.modals.delete-license-user')
@include('software-license.modals.delete-license-document')
@stop
@section('after_scripts')
@include('software-license.scripts.license-view')
@include('software-license.scripts.user-month-graph-script')

@include('software-license.scripts.licenses-used')

@include('reports.scripts.common')
@include('reports.scripts.datatable')

@if(in_array($license->name,config('software-license.imported_softwares')))
    @include('software-license.scripts.licenses-used-by-nonteq-users')
@endif


@endsection