@extends('layouts.main')
@section('content')
@include('partials.breadcrumb', ['breadcrumbTitle' => 'Software Assets'])
<div class="wrapper-content">
    
    <div class="container-fluid">
        
        <!--- Filters -->
        @include('software-license.partials.license-filters')

        <div class="ibox">
            
            <div class="ibox-content">
                
                @include('partials.success')
                @include('partials.error-message')
                @include('partials.sync-messages')
                
                <div class="ibox-tools">
                    
                    @can('Software Assets Manage')
                    <a href="{{route('software-assets.create')}}" class="btn btn-w-m btn-primary pull-right">Add New Assets</a>
                    @endcan
                </div>
                
                
                <table class="footable table table-stripped table-hover nowrap" data-page-size="50" data-filter=#filter>
                    
                    <thead>
                        
                        <tr>
                            
                            <th>#</th>
                            
                            <th>Category</th>
                            
                            <th>Name</th>
                            
                            <th>Manufacturer</th>
                            
                            <th>Vendor</th>
                            
                            
                            <th>Type</th>
                            
                            <th>Renewal Date</th>
                            
                            <th>Licenses</th>
                            
                            <th>Licenses Used</th>
                            
                            @can('Software Assets Manage')
                            
                            <th></th>
                            
                            @endcan
                            
                        </tr>
                        
                    </thead>
                    
                    <tbody>
                        
                    </tbody>
                    
                </table>
                
            </div>
            
        </div>
            
    </div>
</div>
@include('software-license.modals.delete-license')
@section('help-links')
@include('help.help-links',['helpLink'=>config('help-links.help_links.software_assets'),'helpTitle'=>config('help-links.help_titles.software_assets')])
@endsection
@stop
@section('after_scripts')
@include('software-license.scripts.license')
@stop