@extends('layouts.main')
@section('content')
@include('partials.breadcrumb', ['breadcrumbTitle' => 'Edit Asset', 'parentUrl' => '/software-assets', 'parentTitle'
=> 'Software Assets'])
<div class="wrapper-content">
	<div class="container-fluid">
		<div class="row">
			<div class="col-lg-12">
				<div class="ibox">
					<div class="ibox-content">
						<form class="form-horizontal" action="{{ route('software-assets.update', ['software_asset' => $license->id]) }}"
							method="post" id="edit-license-form" enctype="multipart/form-data">
							{{csrf_field()}}
							@method('PUT')
							<div class="row">
								<div class="col-lg-12">
									@include('partials.error')
									@include('partials.success')
									@include('partials.sync-messages')
									@include('partials.error-message')
								</div>
							</div>
							<input type="hidden" name="id" id="license_id" value="{{ $license->id }}">
							<div class="row">

								<div class="col-lg-4">
									<div class="form-group">
										<label class="col-lg-4 control-label">Category<span
												class="text-danger">*</span></label>
										<div class="col-lg-8">
											<select name="software_license_category_id"
												id="software_license_category_id" class="form-control select2">
												<option value="">--Select--</option>
												@foreach($categories as $category)
												<option value="{{ $category->id }}" @if($license->
													software_license_category_id == $category->id)
													selected @endif>{{ $category->name }}</option>
												@endforeach
											</select>
											<span class="text-danger errorText">{{
												$errors->first('software_license_category_id') }}</span>
										</div>
									</div>
								</div>

								<div class="col-lg-4">
									<div class="form-group">
										<label class="col-lg-4 control-label">Manufacturer<span
												class="text-danger">*</span></label>
										<div class="col-lg-8">
											<select name="software_license_manufacturer_id"
												id="software_license_manufacturer_id" class="form-control select2" @if (in_array($license->name,config('software-license.imported_softwares'))) readonly @endif>
												<option value="">--Select--</option>
												@foreach($softwareLicenceManufacturers as $vendor)
												<option value="{{ $vendor->id }}"
													@if(old('software_license_manufacturer_id',$license->
													software_license_manufacturer_id) == $vendor->id ) selected
													@endif>{{ $vendor->name }}</option>
												@endforeach
											</select>
											<span class="text-danger errorText">{{
												$errors->first('software_license_manufacturer_id') }}</span>
										</div>
									</div>
								</div>

								<div class="col-lg-4">
									<div class="form-group">
										<label class="col-lg-4 control-label">Vendor</label>
										<div class="col-lg-8">
											<select name="vendor_id" id="vendor_id" class="form-control select2">
												<option value="">--Select--</option>
												@foreach($vendors as $vendor)
												<option value="{{ $vendor->id }}" @if($license->vendor_id ==
													$vendor->id)
													selected @endif>{{ $vendor->name }}</option>
												@endforeach
											</select>
											<span class="text-danger errorText">{{ $errors->first('vendor_id') }}</span>
										</div>
									</div>
								</div>
								<div class="col-lg-4">
									<div class="form-group">
										<label class="col-lg-4 control-label">Owner</label>
										<div class="col-lg-8">
										<select name="owner_id" class="form-control assigned-user-ajax">
											<option value="{{ $license->owner_id }}" selected>{{ optional($license->owner)->user_name }}</option>
                						</select>
											<span class="text-danger errorText">{{ $errors->first('owner_id') }}</span>
										</div>
									</div>
								</div>
								<div class="col-lg-4">
									<div class=" form-group">
										<label class="col-lg-4 control-label">Product Name<span
												class="text-danger">*</span></label>
										<div class="col-lg-8">
											<input type="text" class="form-control" id="name" name="name"
												value="{{ $license->name }}" @if (in_array($license->name,config('software-license.imported_softwares'))) readonly @endif>
											<span class="text-danger errorText">{{ $errors->first('name') }}</span>
										</div>
									</div>
								</div>
							</div>
							<hr class="license-hr">
							<div class="row">
								<div class="col-lg-4">
									<div class=" form-group">
										<label class="col-lg-4 control-label">PO #</label>
										<div class="col-lg-8">
											<input type="text" class="form-control" id="po_number" name="po_number"
												value="{{ old('po_number',$license->po_number) }}">
											<span class="text-danger errorText">{{ $errors->first('po_number') }}</span>
										</div>
									</div>
								</div>

								<div class="col-lg-4">
									<div class=" form-group">
										<label class="col-lg-4 control-label">Order #</label>
										<div class="col-lg-8">
											<input type="text" class="form-control" id="order_number"
												name="order_number"
												value="{{ old('order_number',$license->order_number) }}">
											<span class="text-danger errorText">{{ $errors->first('order_number')
												}}</span>
										</div>
									</div>
								</div>
								<div class="col-lg-4">
									<div class="form-group">
										<label class="col-lg-4 control-label">Type<span
												class="text-danger">*</span></label>
										<div class="col-lg-8">
											<select name="type" id="type" class="form-control select2" @if (in_array($license->name,config('software-license.imported_softwares'))) readonly @endif>
												<option value="">--Select--</option>
												@foreach (config('software-license.types') as $key => $value)
												<option value="{{ $key }}" @if(old('type',$license->type) == $key)
													selected @endif>{{ $value }}</option>
												@endforeach
											</select>
											<span class="text-danger errorText">{{ $errors->first('type') }}</span>
										</div>
									</div>
								</div>
							</div>
							<hr class="license-hr">
							<div class="row">
								<div class="col-lg-4">
									<div class="form-group">
										<label class="col-lg-4 control-label">License Type<span
												class="text-danger">*</span></label>
										<div class="col-lg-8">
											<select name="license_type" id="license_type" class="form-control select2" @if (in_array($license->name,config('software-license.imported_softwares'))) readonly @endif>
												@foreach (config('software-license.license_types') as $key => $value)
												<option value="{{ $key }}" @if($license->license_type == $key)
													selected @endif>{{ $value }}</option>
												@endforeach
											</select>
											<span class="text-danger errorText">{{ $errors->first('name') }}</span>
										</div>
									</div>
								</div>

								<div class="col-lg-4">
									<div class="form-group" id="subscription_length_container">
										<label class="col-lg-4 control-label">Subscription Length</label>
										<div class="col-lg-8">
											<select name="software_license_subscription_id" id="subscription_length"
												class="form-control select2">
												<option value="">--Select--</option>
												@foreach ($subscriptionLengths as $key)
												<option value="{{ $key->id }}"
													@if(old('software_license_subscription_id',$license->
													software_license_subscription_id) == $key->id) selected @endif>{{
													$key->name }}</option>
												@endforeach
											</select>
											<span class="text-danger errorText">{{
												$errors->first('software_license_subscription_id') }}</span>
										</div>
									</div>
								</div>

								<div class="col-lg-4">
									<div class="form-group">
										<label class="col-lg-4 control-label">Subscription Expiration Date</label>
										<div class="col-lg-8">
											<div class="input-group date">
												<span class="input-group-addon"><i class="icon icon-calendar-2"></i></span>
												<input type="text" class="form-control licence-form-dates"
													name="subscription_expiration"
													value="{{old('subscription_expiration',$license->renewal_date)}}"
													id="subscription_expiration" readonly data-mask="99/99/9999"
													autocomplete="off" style="background-color: #ffffff00;">
											</div>
											<span class="text-danger errorText" id="expiryDateError">{{
												$errors->first('subscription_expiration') }}</span>
										</div>
									</div>
								</div>

								<div class="col-lg-4">
									<div class="form-group" id="auto_renewal_container">
										<label class="col-lg-4 control-label">Auto Renewal</label>
										<div class="col-lg-8">
											<select name="auto_renewal" id="auto_renewal" class="form-control select2">
												<option value="yes" @if($license->getRaworiginal('auto_renewal') ==
													'yes')
													selected @endif>Yes</option>
												<option value="no" @if($license->getRaworiginal('auto_renewal') == 'no')
													selected @endif>No</option>
												<option value="n/a" @if($license->getRaworiginal('auto_renewal') ==
													'n/a')
													selected @endif>N/A</option>
											</select>
											<span class="text-danger errorText">{{ $errors->first('name') }}</span>
										</div>
									</div>
								</div>
							</div>

							<div class="row">
								<div class="col-lg-4">
									<div class="form-group">
										<label class="col-lg-4 control-label">License Key (type)<span
												class="text-danger">*</span></label>
										<div class="col-lg-8">
											<select name="license_key_type" id="license_key_type" class="form-control ">

												@if($license->licenses_used != '0')
												<option value="{{ $license->license_key_type }}" selected>{{
													config('software-license.license_key_types.'.$license->license_key_type)
													}}</option>
												@else
												@foreach (config('software-license.license_key_types') as $key => $value)
												<option value="{{ $key }}" @if(old('license_key_type',$license->
													license_key_type) == $key) selected @endif>{{ $value }}</option>
												@endforeach
												@endif
											</select>
											<span class="text-danger errorText">{{ $errors->first('license_key_type')
												}}</span>
										</div>
									</div>
								</div>
								<div class="col-lg-4 license-key-add" id="license_key_usage_type" <?=($errors->
                                    has('key_usage_type') || $errors->has('users_allowed_for_key') ||
                                    in_array(old('license_key_type', $license->license_key_type), ['single_license','user_license'])) ? 'style="display:block"' : ''
								?>>
									<div class="form-group">
										<label class="col-lg-4 control-label">Key Usage Type<span
												class="text-danger">*</span></label>
										<div class="col-lg-8">
											<select name="key_usage_type" id="key_usage_type" class="form-control " title= "<?= ($license->licenseKey->count() == 0) ? '' : ('Because more than one licence key has been added, the licence key usage type cannot be changed.') ?>">
												@if($license->licenses_used != '0' || $license->licenseKey->count() > 0)
												<option value="{{ $license->key_usage_type }}" selected>{{
													config('software-license.key_usage_types.'.$license->key_usage_type)
													}}</option>
												@else
												@foreach (config('software-license.key_usage_types') as $key => $value)
												<option value="{{ $key }}" @if(old('key_usage_type',$license->
													key_usage_type) == $key)) selected @endif>{{ $value }}</option>
												@endforeach
												@endif
											</select>
											<span class="text-danger errorText">{{ $errors->first('key_usage_type')
												}}</span>
										</div>
									</div>
								</div>

								<div class="col-lg-4 license-key-add" id="license_purchased" <?=$errors->
								has('licenses_purchased') ||
								(old('license_key_type', $license->license_key_type)=='user_license') ? 'style="display:block"' : ''
								?>>
									<div class="form-group">
										<label class="col-lg-4 control-label">Licenses Purchased<span
												class="text-danger">*</span></label>
										<div class="col-lg-8">
											<input type="number" oninput="validity.valid||(value='');"
												class="form-control" id="licenses_purchased" name="licenses_purchased"
												value="{{old('licenses_purchased',$license->licenses_purchased)}}"
												min="{{ optional($license->licenseKey)->count() }}" @if (in_array($license->name,config('software-license.imported_softwares'))) readonly @endif>
											<span class="text-danger errorText">{{ $errors->first('licenses_purchased')
												}}</span>
										</div>
									</div>
								</div>

								{{-- <div class="col-lg-4 license-key-add" id="no_users_allowed" <?=($errors->
								has('users_allowed_for_key') || (
								    $errors->has('key_usage_type') ||
                                old('key_usage_type', $license->key_usage_type)=='limited_usage'
								)) ? 'style="display:block"' : '' ?>>
									<div class="form-group">
										<label class="col-lg-4 control-label"># of Users Allowed</label>
										<div class="col-lg-8">
											<input type="number" class="form-control" id="users_allowed_for_key"
												name="users_allowed_for_key"
												value="{{old('users_allowed_for_key',$license->users_allowed_for_key)}}">
											<span class="text-danger errorText">{{
												$errors->first('users_allowed_for_key') }}</span>
										</div>
									</div>
								</div>

								<div class="col-lg-4 license-key-add license-key-add-inputs" id="license_key_single"
									<?=($errors->has('license_key') ||
								old('license_key_type', $license->license_key_type)=='single_license') ? 'style="display:block"' : ''
								?>>
									<div class="form-group">
										<label class="col-lg-4 control-label">License Key<span
												class="text-danger">*</span></label>
										<div class="col-lg-8">
											<input type="text" class="form-control" id="license_key" name="license_key"
												value="{{old('license_key',!empty($license->licenseKey->pluck('license_key')->toArray()?$license->licenseKey->pluck('license_key')->toArray()[0]:'')}}">
											<span class="text-danger errorText">{{ $errors->first('license_key')
												}}</span>
										</div>
									</div>
								</div>


								<div class="col-lg-4 license-key-add" id="license_key_choice"
									<?=(old('license_key_type', $license->
								license_key_type)=='user_license') ? 'style="display:block"' : '' ?>>
									<div class="form-group">
										<label class="col-lg-4 control-label">How to add ?</label>
										<div class="col-lg-8">
											<div>
												<div class="form-check-inline">
													<label class="form-check-label">
														<input type="radio" class="form-check-input"
															name="license-key-choice" value="license_key_text_area"
															<?=(
								    old('license-key-choice')=='license_key_text_area'
								) ? 'checked' : '' ?>>Enter as text
													</label>
												</div>
												<div class="form-check-inline">
													<label class="form-check-label">
														<input type="radio" class="form-check-input"
															name="license-key-choice" value="license_key_upload"
															<?=(
															    old('license-key-choice')=='license_key_upload'
															) ? 'checked' : '' ?>>Upload
													</label>
												</div>
											</div>
											<span class="text-danger errorText">{{ $errors->first('license-key-choice')
												}}</span>
										</div>
									</div>
								</div>

								<div class="col-lg-4 license-key-add license-key-add-inputs" id="license_key_upload"
									<?=(old('license-key-choice')=='license_key_upload' &&
                                    old('license_key_type')=='user_license') ? 'style="display:block"' : '' ?>>
									<div class="form-group upload-file-text-wrap">
										<label class="col-lg-4 control-label">License Keys Upload<span class="text-danger">*</span></label>
										<div class="col-lg-8">
											<div class="fileinput fileinput-new input-group" data-provides="fileinput">
												<div class="form-control" data-trigger="fileinput">
													<i class="glyphicon glyphicon-file fileinput-exists"></i>
													<span class="fileinput-filename"></span>
												</div>
												<span class="input-group-addon btn btn-primary btn-file">
													<span class="fileinput-new">Select file</span>
													<span class="fileinput-exists">Change</span>
													<input type="file" name="software_liceneses_keys"
														 id="software_liceneses_keys"/>
												</span>
												<a href="#" class="input-group-addon btn btn-primary fileinput-exists"
													data-dismiss="fileinput">Remove</a>
											</div>

											<span class="text-danger errorText">{{ $errors->first(' software_liceneses_keys') }}</span>
									<a href="/template/software-license-keys-template.csv" class="pull-right">Download
										Template File</a>
								</div>
							</div>
						</div>
					<div class="col-lg-4 license-key-add license-key-add-inputs" id="license_key_text_area"
						<?=(old('license-key-choice')=='license_key_text_area' &&
                        old('license_key_type')=='user_license') ? 'style="display:block"' : '' ?>>
                                    <div class="form-group">
										<label class="col-lg-4 control-label">License Keys<span class="text-danger">*</span></label>
										<div class="col-lg-8">
											<textarea class="form-control" name="license_keys">{{old(' license_keys')}}</textarea>
						<span class="text-danger errorText">{{ $errors->first('license_key_text_area') }}</span>
					</div>
				</div>
			</div>--}}
		</div>
		<hr class="license-hr">
		<div class="row">

			<div class="col-lg-4">
				<div class="form-group">
					<label class="col-lg-4 control-label">Contract Start Date</label>
					<div class="col-lg-8">
						<div class="input-group date">
							<span class="input-group-addon"><i class="icon icon-calendar-2"></i></span>
							<input type="text" class="form-control licence-form-dates" name="start_date"
								value="{{ old('start_date') }}" id="start_date" readonly>
							<span class="text-danger errorText" id="startDateError">{{ $errors->first('start_date')
								}}</span>
						</div>
					</div>
				</div>
			</div>
		</div>
		<div class="row">

			<input type="hidden" class="form-control licence-form-dates" value="{{old('renewal_date')}}"
				id="renewal_date" readonly>

			{{-- <div class="col-lg-4">
				<div class="form-group" style="pointer-events:none" id="renewal_date_container">
					<label class="col-lg-4 control-label">Renewal Date</label>
					<div class="col-lg-8">
						<div class="input-group date">
							<span class="input-group-addon"><i class="icon icon-calendar-2"></i></span>
							<input type="hidden" class="form-control licence-form-dates" value="{{old('renewal_date')}}"
								id="renewal_date" readonly>
							<span class="text-danger errorText">{{ $errors->first('renewal_date') }}</span>
						</div>
					</div>
				</div>
			</div> --}}


			<div class="col-lg-4">
				<div class="form-group">
					<label class="col-lg-4 control-label">Billing Cycle</label>
					<div class="col-lg-8">
						<select name="billing_cycle" id="billing_cycle" class="form-control select2">
							<option value="">--Select--</option>
							@foreach (config('software-license.billing_cycles') as $key => $value)
							<option value="{{ $key }}" @if(old('billing_cycle',$license->billing_cycle) == $key)
								selected @endif>{{ $value }}</option>
							@endforeach
						</select>
						<span class="text-danger errorText">{{ $errors->first('billing_cycle') }}</span>
					</div>
				</div>
			</div>



			<div class="col-lg-4">
				<div class="form-group">
					<label class="col-lg-4 control-label">Cost</label>
					<div class="col-lg-8">
						<input type="number" min=0 oninput="validity.valid||(value='');" class="form-control" id="cost"
							name="cost" value="{{ old('cost',$license->cost) }}">
						<span class="text-danger errorText">{{ $errors->first('cost') }}</span>
					</div>
				</div>
			</div>



			<div class="col-lg-4">
				<div class="form-group">
					<label class="col-lg-4 control-label">Payment Method</label>
					<div class="col-lg-8">
						<select name="payment_method_id" id="payment_method_id" class="form-control select2">
							<option value="">--Select--</option>
							@foreach ($paymentMethods as $paymentMethod)
							<option value="{{ $paymentMethod->id }}" @if(old('payment_method_id',$license->
								payment_method_id) == $paymentMethod->id)
								selected @endif>{{ $paymentMethod->name }}</option>
							@endforeach
						</select>
						<span class="text-danger errorText">{{ $errors->first('payment_method_id') }}</span>
					</div>
				</div>
			</div>
		</div>
		<hr class="license-hr">
		<div class="row">

			<div class="col-lg-4">
				<div class="form-group">
					<label class="col-lg-4 control-label">Notes</label>
					<div class="col-lg-8">
						<textarea class="form-control" name="notes">{{ old('notes',$license->notes) }}</textarea>
						<span class="text-danger errorText">{{ $errors->first('notes') }}</span>
					</div>
				</div>
			</div>

		</div>
		<div class="row">

			<div class="col-lg-4" style="margin-top: 15px;">
				<div class="form-group">
					<label class="col-lg-4 control-label">Status<span class="text-danger">*</span></label>
					<div class="col-lg-8">
						<select name="status" id="status" class="form-control select2" @if (in_array($license->name,config('software-license.imported_softwares'))) disabled @endif>

							<option value="1" @if(old('status',$license->status) == '1') selected @endif>Active</option>
							<option value="0" @if(old('status',$license->status) == '0') selected @endif>Inactive
							</option>
						</select>
						<span class="text-danger errorText">{{ $errors->first('status') }}</span>
					</div>
				</div>
			</div>
		</div>
		<p class="text-right">
			<input type="submit" class="btn btn-primary" id="submit-licence-button" value="Submit">
		</p>
		</form>
	</div>
</div>
</div>
</div>

@if(!in_array($license->name,config('software-license.imported_softwares')))
<div class="row">
	<div class="col-lg-12">
		@include('software-license.license.license-used', ['action' => 'edit'])

	</div>
</div>
@endif
<div class="row">
	<div class="col-lg-12">
		<div class="ibox">
			<div class="ibox-content">
				@include('software-license.license.documents', ['action' => 'edit'])
			</div>
		</div>
	</div>
</div>

@if($license->license_key_type !='no_license' && !in_array($license->name,config('software-license.imported_softwares')))

<div class="row">
	<div class="col-lg-12">
		<div class="ibox">
			<div class="ibox-content">
				@include('software-license.license.keys', ['action' => 'edit','licensePurchased' =>
				$license->licenses_purchased,'license_key_type' =>
				$license->license_key_type,'licenseKeys'=>$license->licenseKey->count()])
			</div>
		</div>
	</div>
</div>
@endif

</div>
</div>

@include('software-license.modals.add-license-user')
@include('software-license.modals.add-license-document')
@include('software-license.modals.delete-license-user')
@include('software-license.modals.delete-license-document')
@include('software-license.modals.add-license-key')
@section('help-links')
@include('help.help-links',['helpLink'=>config('help-links.help_links.software_assets'),'helpTitle'=>config('help-links.help_titles.software_assets')])
@endsection
@stop
@section('after_scripts')
@include('software-license.scripts.license-edit')
@endsection