@extends('layouts.main')
@section('content')
@include('partials.breadcrumb', ['breadcrumbTitle' => 'Add New Assets', 'parentUrl' => '/software-assets', 'parentTitle'
=> 'Software Assets'])
<div class="wrapper-content">
	<div class="container-fluid">

		<div class="ibox">
			<div class="ibox-content">
				<form class="form-horizontal" action="{{ route('software-assets.store') }}" method="post"
					id="create-software-asset-form" enctype="multipart/form-data">
					{{csrf_field()}}
					<div class="row">
						<div class="col-lg-12">@include('partials.error')</div>
						<div class="col-lg-12">@include('partials.error-message')</div>
						<div class="col-lg-12">@include('partials.success')</div>
					</div>
					<div class="row">
						<div class="col-lg-4">
							<div class="form-group">
								<label class="col-lg-4 control-label">Category<span
										class="text-danger">*</span></label>
								<div class="col-lg-8">
									<select name="software_license_category_id"
										id="software_license_category_id" class="form-control select2">
										<option value="">--Select--</option>
										@foreach($categories as $category)
										<option value="{{ $category->id }}"
											@if(old('software_license_category_id')==$category->id) selected
											@endif>{{ $category->name }}</option>
										@endforeach
									</select>
									<span class="text-danger errorText">{{
										$errors->first('software_license_category_id') }}</span>
								</div>
							</div>
						</div>

						<div class="col-lg-4">
							<div class="form-group">
								<label class="col-lg-4 control-label">Manufacturer<span
										class="text-danger">*</span></label>
								<div class="col-lg-8">
									<select name="software_license_manufacturer_id"
										id="software_license_manufacturer_id" class="form-control select2">
										<option value="">--Select--</option>
										@foreach($softwareLicenceManufacturers as $vendor)
										<option value="{{ $vendor->id }}"
											@if(old('software_license_manufacturer_id')==$vendor->id) selected
											@endif>{{ $vendor->name }}</option>
										@endforeach
									</select>
									<span class="text-danger errorText">{{
										$errors->first('software_license_manufacturer_id') }}</span>
								</div>
							</div>
						</div>

						<div class="col-lg-4">
							<div class="form-group">
								<label class="col-lg-4 control-label">Vendor</label>
								<div class="col-lg-8">
									<select name="vendor_id" id="vendor_id" class="form-control select2">
										<option value="">--Select--</option>
										@foreach($vendors as $vendor)
										<option value="{{ $vendor->id }}"
											@if(old('software_license_manufacturer_id')==$vendor->id) selected
											@endif>{{ $vendor->name }}</option>
										@endforeach
									</select>
									<span class="text-danger errorText">{{ $errors->first('vendor_id') }}</span>
								</div>
							</div>
						</div>
					</div>
					<div class="row">
						<div class="col-lg-4">
							<div class="form-group">
								<label class="col-lg-4 control-label">Owner</label>
								<div class="col-lg-8">
								<select name="owner_id" class="form-control assigned-user-ajax">
								</select>
									<span class="text-danger errorText">{{ $errors->first('owner_id') }}</span>
								</div>
							</div>
						</div>
						<div class="col-lg-4">
							<div class=" form-group">
								<label class="col-lg-4 control-label">Product Name<span
										class="text-danger">*</span></label>
								<div class="col-lg-8">
									<input type="text" class="form-control" id="name" name="name"
										value="{{ old('name') }}">
									<span class="text-danger errorText">{{ $errors->first('name') }}</span>
								</div>
							</div>
						</div>
					</div>

					<hr class="license-hr">
					<div class="row">
						<div class="col-lg-4">
							<div class=" form-group">
								<label class="col-lg-4 control-label">PO #</label>
								<div class="col-lg-8">
									<input type="text" class="form-control" id="po_number" name="po_number"
										value="{{ old('po_number') }}">
									<span class="text-danger errorText">{{ $errors->first('po_number') }}</span>
								</div>
							</div>
						</div>

						<div class="col-lg-4">
							<div class=" form-group">
								<label class="col-lg-4 control-label">Order #</label>
								<div class="col-lg-8">
									<input type="text" class="form-control" id="order_number"
										name="order_number" value="{{ old('order_number') }}">
									<span class="text-danger errorText">{{ $errors->first('order_number')
										}}</span>
								</div>
							</div>
						</div>

						<div class="col-lg-4">
							<div class="form-group">
								<label class="col-lg-4 control-label">Type<span
										class="text-danger">*</span></label>
								<div class="col-lg-8">
									<select name="type" id="type" class="form-control select2">
										<option value="">--Select--</option>
										@foreach (config('software-license.types') as $key => $value)
										<option value="{{ $key }}" @if(old('type')==$key) selected @endif>{{
											$value }}</option>
										@endforeach
									</select>
									<span class="text-danger errorText">{{ $errors->first('type') }}</span>
								</div>
							</div>
						</div>
					</div>
					<hr class="license-hr">
					<div class="row">


						<div class="col-lg-4">
							<div class="form-group">
								<label class="col-lg-4 control-label">License Type<span
										class="text-danger">*</span></label>
								<div class="col-lg-8">
									<select name="license_type" id="license_type" class="form-control select2">
										<option value="">--Select--</option>
										@foreach (config('software-license.license_types') as $key => $value)
										<option value="{{ $key }}" @if(old('license_type')==$key) selected
											@endif>{{ $value }}</option>
										@endforeach
									</select>
									<span class="text-danger errorText">{{ $errors->first('license_type')
										}}</span>
								</div>
							</div>
						</div>
						<div class="col-lg-4">
							<div class="form-group" id="subscription_length_container">
								<label class="col-lg-4 control-label">Subscription Length<span class="text-danger sub-star"></span></label>
								<div class="col-lg-8">
									<select name="software_license_subscription_id" id="subscription_length"
										class="form-control select2">
										<option value="">--Select--</option>
										@foreach ($subscriptionLengths as $key)
										<option value="{{ $key->id }}"
											@if(old('software_license_subscription_id')==$key->id) selected
											@endif>{{ $key->name }}</option>
										@endforeach
									</select>
									<span class="text-danger errorText">{{
										$errors->first('software_license_subscription_id') }}</span>
								</div>
							</div>
						</div>

						<div class="col-lg-4">
							<div class="form-group">
								<label class="col-lg-4 control-label">Subscription Expiration Date<span class="text-danger sub-star"></span></label>
								<div class="col-lg-8">
									<div class="input-group date">
										<span class="input-group-addon"><i class="icon icon-calendar-2"></i></span>
										<input type="text" class="form-control licence-form-dates"
											name="subscription_expiration"
											value="{{old('subscription_expiration')}}"
											id="subscription_expiration" readonly data-mask="99/99/9999"
											autocomplete="off">
									</div>
									<span class="text-danger errorText" id="expiryDateError">{{
										$errors->first('subscription_expiration') }}</span>
								</div>
							</div>
						</div>


						<div class="col-lg-4">
							<div class="form-group" id="auto_renewal_container">
								<label class="col-lg-4 control-label">Auto Renewal</label>
								<div class="col-lg-8">
									<select name="auto_renewal" id="auto_renewal" class="form-control select2">
										@foreach (config('software-license.auto_renewal') as $key => $value)
										<option value="{{ $key }}" @if(old('auto_renewal')==$key) selected
											@endif>{{ $value }}</option>
										@endforeach
									</select>
									<span class="text-danger errorText">{{ $errors->first('auto_renewal')
										}}</span>
								</div>
							</div>
						</div>
					</div>

					<div class="row">
						<div class="col-lg-4">
							<div class="form-group">
								<label class="col-lg-4 control-label">License Key (type)<span
										class="text-danger">*</span></label>
								<div class="col-lg-8">
									<select name="license_key_type" id="license_key_type"
										class="form-control select2">
										@foreach (config('software-license.license_key_types') as $key => $value)
										<option value="{{ $key }}" @if(old('license_key_type')==$key) selected
											@endif>{{ $value }}</option>
										@endforeach
									</select>
									<span class="text-danger errorText">{{ $errors->first('license_key_type')
										}}</span>
								</div>
							</div>
						</div>


						<div class="col-lg-4 license-key-add" id="license_key_usage_type" <?=($errors->
							has('key_usage_type') || $errors->has('users_allowed_for_key') ||
							in_array(old('license_key_type'),['single_license','user_license']))?'style="display:block"':''
							?>>
							<div class="form-group">
								<label class="col-lg-4 control-label">Key Usage Type<span
										class="text-danger">*</span></label>
								<div class="col-lg-8">
									<select name="key_usage_type" id="key_usage_type" class="form-control ">
										@foreach (config('software-license.key_usage_types') as $key => $value)
										<option value="{{ $key }}" @if(old('key_usage_type')==$key) selected
											@endif>{{ $value }}</option>
										@endforeach
									</select>
									<span class="text-danger errorText">{{ $errors->first('key_usage_type')
										}}</span>
								</div>
							</div>
						</div>

						<div class="col-lg-4 license-key-add" id="license_purchased" <?=$errors->
							has('licenses_purchased') ||
							(old('license_key_type')=='user_license')?'style="display:block"':'' ?>>
							<div class="form-group">
								<label class="col-lg-4 control-label">Licenses Purchased<span
										class="text-danger">*</span></label>
								<div class="col-lg-8">
									<input type="number" min=0 oninput="validity.valid||(value='');"
										class="form-control" id="licenses_purchased" name="licenses_purchased"
										value="{{old('licenses_purchased')}}">
									<span class="text-danger errorText">{{ $errors->first('licenses_purchased')
										}}</span>
								</div>
							</div>
						</div>

						<div class="col-lg-4 license-key-add" id="no_users_allowed" <?=($errors->
							has('users_allowed_for_key') || old('key_usage_type')=='limited_usage'
							)?'style="display:block"':'' ?>>
							<div class="form-group">
								<label class="col-lg-4 control-label"># of Users Allowed<span
										class="text-danger">*</span></label>
								<div class="col-lg-8">
									<input type="number" min="1" oninput="validity.valid||(value='');"
										class="form-control" id="users_allowed_for_key"
										name="users_allowed_for_key" value="{{old('users_allowed_for_key')}}">
									<span class="text-danger errorText">{{
										$errors->first('users_allowed_for_key') }}</span>
								</div>
							</div>
						</div>

						<div class="col-lg-4 license-key-add license-key-add-inputs" id="license_key_single"
							<?=($errors->has('license_key') ||
							old('license_key_type')=='single_license')?'style="display:block"':'' ?>>
							<div class="form-group">
								<label class="col-lg-4 control-label">License Key<span
										class="text-danger">*</span></label>
								<div class="col-lg-8">
									<input type="text" class="form-control" id="license_key" name="license_key"
										value="{{old('license_key')}}">
									<span class="text-danger errorText">{{ $errors->first('license_key')
										}}</span>
								</div>
							</div>
						</div>


						<div class="col-lg-4 license-key-add" id="license_key_choice"
							<?=(old('license_key_type')=='user_license'
							)?'style="display:block"':'' ?>>
							<div class="form-group">
								<label class="col-lg-4 control-label">Upload Licenses via:<span class="text-danger">*</span></label>
								<div class="col-lg-8">
									<div >
										<div class="form-check-inline">
											<label class="form-check-label">
											<input type="radio" class="form-check-input" name="license-key-choice" value="license_key_text_area" <?= (old('license-key-choice')=='license_key_text_area' )?'checked':'' ?>>Enter as text
											</label>
										</div>
										<div class="form-check-inline">
											<label class="form-check-label">
												<input type="radio" class="form-check-input" name="license-key-choice"
													value="license_key_upload"
													<?=(old('license-key-choice')=='license_key_upload' )?'checked':'' ?>>Upload
											</label>
										</div>
									</div>
									<span class="text-danger errorText" id="uploadLicenseViaError">{{
										$errors->first('license-key-choice') }}</span>
								</div>
							</div>
						</div>

						<div class="col-lg-4 license-key-add license-key-add-inputs" id="license_key_upload"
							<?=(old('license-key-choice')=='license_key_upload' && old('license_key_type')=='user_license'
							)?'style="display:block"':'' ?>>
							<div class="form-group upload-file-text-wrap">
								<label class="col-lg-4 control-label">License Keys Upload<span class="text-danger">*</span></label>
								<div class="col-lg-8">
									<div class="fileinput fileinput-new input-group" data-provides="fileinput">
										<div class="form-control" data-trigger="fileinput">
											<i class="glyphicon glyphicon-file fileinput-exists"></i>
											<span class="fileinput-filename"></span>
										</div>
										<span class="input-group-addon btn btn-primary btn-file">
											<span class="fileinput-new">Select file</span>
											<span class="fileinput-exists">Change</span>
											<input type="file" name="software_liceneses_keys"
													id="software_liceneses_keys"/>
										</span>
										<a href="#" class="input-group-addon btn btn-primary fileinput-exists"
											data-dismiss="fileinput">Remove</a>

									</div>
									<span class="text-danger errorText" id="bulkLicenseError">{{ $errors->first(' software_liceneses_keys') }}</span>
									<a href="/template/software-license-keys-template.csv" class="pull-right">Download Template File</a>
								</div>
							</div>
						</div>
						<div class="col-lg-4 license-key-add license-key-add-inputs" id="license_key_text_area"
							<?=(old('license-key-choice')=='license_key_text_area' && old('license_key_type')=='user_license'
							)?'style="display:block"':'' ?>>
							<div class="form-group">
								<label class="col-lg-4 control-label">License Keys<span class="text-danger">*</span></label>
								<div class="col-lg-8">
									<textarea class="form-control" rows="2" name="license_keys">{{old(' license_keys')}}</textarea>
									<span class="text-danger errorText">{{ $errors->first('license_keys') }}</span>
								</div>
							</div>
						</div>
					</div>
					<hr class="license-hr">
					<div class="row">

						<div class="col-lg-4">
							<div class="form-group">
								<label class="col-lg-4 control-label">Contract Start Date<span class="text-danger">*</span></label>
								<div class="col-lg-8">
									<div class="input-group date">
										<span class="input-group-addon"><i class="icon icon-calendar-2"></i></span>
										<input type="text" class="form-control licence-form-dates" name="start_date"
											value="{{old('start_date')}}" id="start_date" readonly data-mask="99/99/9999"
											autocomplete="off">
									</div>
									<span class="text-danger errorText" id="startDateError">{{ $errors->first('start_date') }}</span>
								</div>
							</div>
						</div>

					</div>
					<div class="row">

						<div class="col-lg-4">
							<div class="form-group">
								<label class="col-lg-4 control-label">Billing Cycle<span class="text-danger">*</span></label>
								<div class="col-lg-8">
									<select name="billing_cycle" id="billing_cycle" class="form-control select2">
										<option value="">--Select--</option>
										@foreach (config('software-license.billing_cycles') as $key => $value)
										<option value="{{ $key }}" @if(old('billing_cycle')==$key) selected @endif>{{ $value }}</option>
										@endforeach
									</select>
									<span class="text-danger errorText">{{ $errors->first('billing_cycle') }}</span>
								</div>
							</div>
						</div>

						<div class="col-lg-4">
							<div class="form-group">
								<label class="col-lg-4 control-label">Cost</label>
								<div class="col-lg-8">
									<input type="number" min=0 oninput="validity.valid||(value='');" class="form-control" id="cost"
										name="cost" value="{{old('cost')}}">
									<span class="text-danger errorText">{{ $errors->first('cost') }}</span>
								</div>
							</div>
						</div>

						<div class="col-lg-4">
							<div class="form-group">
								<label class="col-lg-4 control-label">Payment Method<span class="text-danger">*</span></label>
								<div class="col-lg-8">
									<select name="payment_method_id" id="payment_method_id" class="form-control select2">
										<option value="">--Select--</option>
										@foreach ($paymentMethods as $paymentMethod)
										<option value="{{ $paymentMethod->id }}" @if(old('payment_method_id')==$paymentMethod->id) selected
											@endif>{{ $paymentMethod->name }}</option>
										@endforeach
									</select>
									<span class="text-danger errorText">{{ $errors->first('payment_method_id') }}</span>
								</div>
							</div>
						</div>
					</div>
					<hr class="license-hr">
					<div class="row">


						<div class="col-lg-4">
							<div class="form-group upload-file-text-wrap">
								<label class="col-lg-4 control-label">Documents</label>
								<div class="col-lg-8">
									<div class="fileinput fileinput-new input-group" data-provides="fileinput">
										<div class="form-control" data-trigger="fileinput">
											<i class="glyphicon glyphicon-file fileinput-exists"></i>
											<span class="fileinput-filename"></span>
										</div>
										<span class="input-group-addon btn btn-primary btn-file">
											<span class="fileinput-new">Select file</span>
											<span class="fileinput-exists">Change</span>
											<input type="file" name="software_liceneses_documents[]" multiple
												id="software_liceneses_documents" />
										</span>
										<a href="#" class="input-group-addon btn btn-primary fileinput-exists"
											data-dismiss="fileinput">Remove</a>
									</div>
								</div>
							</div>
						</div>
					</div>
					<div class="row">
						<div class="col-lg-4">
							<div class="form-group">
								<label class="col-lg-4 control-label">Notes</label>
								<div class="col-lg-8">
									<textarea class="form-control" name="notes">{{old('notes')}}</textarea>
									<span class="text-danger errorText">{{ $errors->first('notes') }}</span>
								</div>
							</div>
						</div>
					</div>
					<div class="row">
						<div class="col-lg-4" style="margin-top: 15px;">
							<div class="form-group">
								<label class="col-lg-4 control-label">Status<span class="text-danger">*</span></label>
								<div class="col-lg-8">
									<select name="status" id="status" class="form-control select2">
										<option value="" selected>--Select--</option>
										<option value="1" @if(old('status')=='1' ) selected @endif>Active</option>
										<option value="0" @if(old('status')=='0' ) selected @endif>Inactive</option>
									</select>
									<span class="text-danger errorText">{{ $errors->first('status') }}</span>
								</div>
							</div>
						</div>
					</div>
					<p class="text-right">
						<input type="submit" class="btn btn-primary" id="submit-licence-button" value="Submit">
					</p>
				</form>
			</div>
		</div>

		<!--- Bulk Upload form-->

		@include('software-license.partials.license-bulk-upload')

		<!--- Bulk Upload Preview table-->

		@include('software-license.partials.license-bulk-upload-preview')


	</div>
</div>
@stop

@section('help-links')
@include('help.help-links',['helpLink'=>config('help-links.help_links.software_assets_create'),'helpTitle'=>config('help-links.help_titles.software_assets_create')])
@endsection

@section('after_scripts')
@include('software-license.scripts.license-create')
@endsection