@extends('layouts.main')
@section('content')
@include('partials.breadcrumb', ['breadcrumbTitle' => 'Software Assets Categories','parentTitle'=>'Settings','parentUrl'=>'/settings'])
<div class="wrapper-content">
    <div class="container-fluid">
        
        <div class="ibox">
            
            <div class="ibox-content">
                
                
                @can('Software Assets Category Manage')
                @include('settings.partials.success-message')
                @include('settings.partials.delete-message')
                <p><a href="#" class="btn btn-primary" data-toggle="modal"
                    data-target="#addLicenseCategory">Add New</a></p>
                    @endcan
                    
                    @include('software-license.partials.category-filters')
                    
                    <div class="ajax-loader"><img src="/img/ajax-loader-full-width.gif"></div>
                    <table class="footable table table-stripped table-hover" data-page-size="50" data-filter=#filter
                    id="license-category-table">
                    
                    <thead>
                        
                        <tr>
                            <th style="display: none;"></th>
                            <th>#</th>
                            <th>Name</th>
                            
                        </tr>
                        
                    </thead>
                    
                    
                    @include('software-license.category.list')
                    
                    
                </table>
                
            </div>
            
        </div>
        
    </div>
    
</div>


@stop

@section('help-links')
@include('help.help-links',['helpLink'=>config('help-links.help_links.software_asset_settings_categories'),'helpTitle'=>config('help-links.help_titles.software_asset_settings_categories')])
@endsection


@section('after_scripts')
@include('software-license.modals.add-category')
@include('software-license.scripts.category')
<style>
    .i {
        font-size: 16px;
        font-weight: bold;
        margin-right: 2px;
    }
    
    .last {
        border-bottom: 2px solid black;
    }
    
    .minimum-width {
        min-width: 85px !important;
    }
</style>
@stop