
<script>
    $(document).ready(function() {
        $('#zoom-download-rooms').on('click', function(event) {
            event.preventDefault();
            setAsDisabled(this);

            $.ajax({
                url: "{{ route('zoom-hardware-download-data') }}",
                method: 'POST',
                dataType: 'text',
                success: function (result) {
                    setAsEnabled($('#zoom-download-rooms'), 'Zoom Rooms & Devices');

                    var response = JSON.parse(result);
                    if (response.status == 'success') {
                        $("#sync-success-msg").html(response.message);
                        $("#sync-success").show();
                    } else {
                        $('#sync-error-msg').html(response.message);
                        $("#sync-error").show();
                    }
                },
                error: function() {
                    showErrorMessage();
                    setAsEnabled($('#zoom-download-rooms'), 'Zoom Rooms & Devices');
                }
            });
        });

        $('#zoom-download-locations').on('click', function(event) {
            event.preventDefault();
            setAsDisabled(this);

            $.ajax({
                url: "{{ route('zoom-hardware-download-locations') }}",
                method: 'POST',
                dataType: 'text',
                success: function (result) {
                    setAsEnabled($('#zoom-download-locations'), 'Zoom Locations');

                    var response = JSON.parse(result);
                    if (response.status == 'success') {
                        $("#sync-success-msg").html(response.message);
                        $("#sync-success").show();
                    } else {
                        $('#sync-error-msg').html(response.message);
                        $("#sync-error").show();
                    }
                },
                error: function() {
                    showErrorMessage();
                    setAsEnabled($('#zoom-download-locations'), 'Zoom Locations');
                }
            });
        });

        $('#test-connection').on('click', function(event) {
            event.preventDefault();
            $(this).attr('disabled', true);
            $('.ajax-loader').show();

            $.ajax({
                url: "{{ route('zoom-hardware-test-connection') }}",
                method: 'POST',
                dataType: 'text',
                success: function (result) {
                    var response = JSON.parse(result);
                    if (response.status == 'success') {
                        $("#sync-success-msg").html(response.message);
                        $("#sync-success").show();
                    } else {
                        $('#sync-error-msg').html(response.message);
                        $("#sync-error").show();
                    }
                },
                error: function() {
                    ('#sync-error-msg').html('Something went wrong. Please try again.');
                    $("#sync-error").show();
                },
                complete: function() {
                    $('#test-connection').attr('disabled', false);
                    $('.ajax-loader').hide();
                }
            });

        });

        $("#manualSync").click(function (e) {
            e.preventDefault();
            $('#manualSync').html('<i class="icon icon-explore-user"></i>').attr("disabled", true);
            $("#sync-success-msg").text('Zoom devices sync started. Please wait, it may take a while.')
            $("#sync-success").show();
            $("#sync-error").hide();

            $.ajax({
                type: "post",
                url: "{{ route('zoom-hardware-manual-sync') }}",
                success: function (data) {
                    $('#manualSync').html('Manual Sync').attr("disabled", false);
                    if (data.status == 'success') {
                        $("#sync-success-msg").text(data.message);
                    } else {
                        $("#sync-success").hide();
                        $("#sync-error-msg").text(data.message);
                        $("#sync-error").show();
                    }
                }
            });
        });
    });

    function setAsDisabled(element) {
        $(element).attr('disabled', true);
        $(element).text('Downloading.. ');
        $(element).append('<i class="icon icon-explore-user"></i>');
        $("#sync-success-msg").html('Download started. Please wait, it may take a while.');
        $("#sync-success").show();
    }

    function setAsEnabled(element, label) {
        $(element).attr('disabled', false);
        $(element).find('i').remove();
        $(element).text(label);
        $("#sync-success").hide();
        $("#sync-error").hide();
    }

    function showErrorMessage() {
        $('#sync-error-msg').html('An error occurred while downloading the file.');
        $("#sync-error").show();
        $("#sync-success").hide();
    }
</script>