@extends('layouts.main')
@section('content')
@include('partials.breadcrumb', ['breadcrumbTitle' => 'Zoom Hardware', 'parentTitle'=>'Settings','parentUrl'=>'/settings'])
<div class="wrapper wrapper-content">
    <div class="container-fluid">
        <div class="row">
            <div class="col-lg-12">
                <div class="ibox">

                    <div class="ibox-content">

                        @include('partials.error-message')
                        @include('partials.success')
                        @include('partials.error')
                        @include('partials.sync-messages')
                        <div class="ajax-loader"><img src="/img/ajax-loader.gif"></div>

                        <table class="table table-stripped" data-page-size="50" data-filter=#filter id="api-credential-table">

                            <thead>

                                <tr>
                                    <th>Status</th>
                                    <th>Connect</th>
                                    <th>Test Connection</th>
                                    <th>Manual Sync</th>
                                    @can('API Credentials Edit')
                                    <th>Edit</th>
                                    @endcan
                                </tr>

                            </thead>

                            <tbody>

                            @if($credentials)
                                <tr>
                                    <td>
                                        @if($status)
                                        <a href="#" class="btn btn-primary btn-sm" disabled>Active</a>
                                        @else
                                        <a href="#" class="btn btn-primary btn-sm" disabled>Inactive</a>
                                        @endif
                                    </td>
                                    <td>
                                        @if(!$status)
                                        <a href="{{route('zoom-hardware-connect')}}" class="btn btn-primary btn-sm">Connect</a>
                                        @else
                                        <a href="{{route('zoom-hardware-disconnect')}}" class="btn btn-primary btn-sm">Disconnect</a>
                                        @endif
                                    </td>
                                    <td>@if($credentials->data)<button class="btn btn-info btn-sm" id="test-connection">Test Connection</button>@endif</td>
                                    <td>
                                        @if ($status == 1)
                                        <button class="btn btn-primary btn-sm" id="manualSync">Manual Sync</button>
                                        @endif
                                    </td>
                                    @can('API Credentials Edit')
                                    <td><a href="{{route('zoom-hardware.edit', ['zoom_hardware' => $credentials->id])}}"><i class="icon icon-n-edit"></i></a></td>
                                    @endcan
                                </tr>
                            @else
                                <tr>
                                    <td colspan="5" style="text-align: center;">No credentials in the system.</td>
                                </tr>
                            @endif

                            </tbody>

                            <tfoot>

                                <tr>

                                    <td colspan="5">

                                    </td>

                                </tr>

                            </tfoot>

                        </table>

                        @if($status)
                        {{-- <div class="form-group" style="margin-left: 10px">
                            <label class="control-label">Download</label>
                            <div>
                                <button id="zoom-download-rooms" class="btn btn-primary btn-sm">Zoom Rooms & Devices</button>
                                <button id="zoom-download-locations" class="btn btn-primary btn-sm" style="margin-left: 10px">Zoom Locations</button>
                            </div>
                        </div> --}}
                        @endif
                    </div>

                </div>

            </div>

        </div>

    </div>

</div>


@stop

@section('after_scripts')
    @include('assets.partials.scripts.common')
    @include('settings.zoom-hardware.script')
@stop