@extends('layouts.main')
@section('content')
@include('partials.breadcrumb', ['breadcrumbTitle' => 'Edit Zoom Hardware API Credentials', 'parentTitle'=>'Settings','parentUrl'=>'/settings'])

<div class="wrapper wrapper-content">
	<div class="container-fluid">
    	<div class="row">
	        <div class="col-lg-12">
				@include('partials.error')
				<form class="form-horizontal" method="post" action="{{route('zoom-hardware.update', ['zoom_hardware' => $credential->id])}}">
					<div class="ibox">
						<div class="ibox-content">

				    		{{csrf_field()}}

				    		<input type="hidden" name="_method" value="PUT">

							<div class="form-group">
								<label class="col-lg-3 control-label">Account ID </label>
								<div class="col-lg-6">
									<input type="text" class="form-control" name="app_name" value="{{ $credential->user_name }}">
								</div>
							</div>

							<div class="form-group">
								<label class="col-lg-3 control-label">Client ID</label>
								<div class="col-lg-6">
									<input type="text" class="form-control" name="client_id">
									<span class="help-block m-b-none">To keep the old Client ID, leave this empty</span>
								</div>
							</div>

							<div  class="form-group">
								<label class="col-lg-3 control-label">Client Secret</label>
								<div class="col-lg-6">
									<input type="password" class="form-control" name="client_secret" value="">
									<span class="help-block m-b-none">To keep the old Client Secret, leave this empty</span>
								</div>
							</div>


		                    <div class="form-group">
								<div class="col-lg-offset-3 col-lg-1">
									<button class="btn btn-success" name="commit" type="submit">Save</button>
								</div>
							</div>
						</div>
					</div>
				</form>
		    </div>
		</div>
	</div>
</div>
@stop

@section('after_scripts')
    @include('assets.partials.scripts.common')
@stop
